/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ti_storg.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:22:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_TI_STORG_HXX
#define ARY_STORE_TI_STORG_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tpltools.hxx>


template <class XY> class Manipulator;

namespace ary
{
namespace store
{


/** This is the standard storage structure for all data saved within the
    autodoc repository.
*/
template <class RE>
class ReStorage
{
  public:
    typedef UINT32      KEY;

	virtual				~ReStorage() {}

    const RE &          operator[](             /// @precond Find(i_rKey) != 0 .
                            const KEY &         i_rKey ) const;

    RE &                Add(                    /// @return false, if i_rKey already exists.
                            const KEY &         i_rKey,
                            DYN RE &            let_drElement );
    uintt               ForEach(
                            const Manipulator< RE > &
                                                i_rManip );
    const RE *          Find(
                            const KEY &         i_rKey ) const;

	RE *          		Find(
							const KEY &         i_rKey );
  private:
	virtual RE &        do_Add(
							const KEY &         i_rKey,
							DYN RE &            let_drElement ) = 0;
    virtual uintt       do_ForEach(
                            const Manipulator< RE > &
                                                i_rManip ) = 0;
	virtual RE *  		access_Find(
							const KEY &         i_rKey ) = 0;
};




// IMPLEMENTATION


template <class RE>
inline const RE &
ReStorage<RE>::operator[]( const KEY & i_rKey ) const
    { const RE * ret = this->inq_Find(i_rKey);
      csv_assert(ret != 0);
      return *ret;
    }
template <class RE>
RE &
ReStorage<RE>::Add( const KEY &         i_rKey,
                    DYN RE &            let_drElement )
    { return do_Add( i_rKey, let_drElement ); }
template <class RE>
uintt
ReStorage<RE>::ForEach( const Manipulator< RE > & i_rManip )
    { return do_ForEach( i_rManip ); }
template <class RE>
const RE *
ReStorage<RE>::Find( const KEY & i_rKey ) const
    { return const_cast< ReStorage<RE> & >(*this).access_Find( i_rKey ); }
template <class RE>
inline RE *
ReStorage<RE>::Find( const KEY & i_rKey )
    { return access_Find( i_rKey ); }



}   // namespace store
}   // namespace ary



#endif

