/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: c_stgifc.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:35:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include <store/c_stgifc.hxx>


// NOT FULLY DEFINED SERVICES
#include <store/ifcc_ce.hxx>
#include <store/ifcc_ty.hxx>
#include <store/ifcc_df.hxx>
#include <store/g_stgifc.hxx>
#include <store/storage.hxx>



namespace ary
{
namespace store
{

const Tid C_nFirstTid_BuiltInTypes = 32;

Interface_Cpp::Interface_Cpp( Storage & io_rStorage )
    :   pIfc_Ces( new cpp::CodeEntity_Ifc(io_rStorage.TheCpp()) ),
        pIfc_Types( new cpp::Type_Ifc(io_rStorage.TheCpp(), C_nFirstTid_BuiltInTypes) ),
        pIfc_Defs( new cpp::Defs_Ifc(io_rStorage.TheCpp()) ),
        pIfc_Groups( new Groups_Ifc(io_rStorage.TheIndependentGroups()) )
{
}

Interface_Cpp::~Interface_Cpp()
{
}


} // namespace store
} // namespace ary


