/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ids.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:52:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDS_HXX
#define ARY_IDS_HXX

// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS

namespace ary
{

/*  Because, CodeEntities can be types or groups themselves,
    Cid, Tid, Did and Gid all come from the same stock, so they
    are disjunct with each other.
*/

typedef UINT32          Rid;
typedef UINT32          RCid;       /** Repository Class Id. Each class, that can be
                                        stored in ARY, has a unique RCid. */

inline  Rid Rid_Null_()     { return Rid(0); }
inline  RCid RCid_Null_()   { return RCid(0); }


// Obsolete, but for compability
typedef Rid             Cid;        /// Code Entity Id
typedef Rid             Gid;        /// Group Id. Id of a group.
typedef Rid             Tid;        /// Type Id. Id of any used type.

typedef UINT8           SlotAccessId;   /// Access to a Slot


typedef Rid             OSid;       /// Operation signature Id. Id of an operation's signature.
typedef Rid             Lid;        /// Location Id


namespace cpp
{
typedef ary::Rid        Did;        /// Value Id. Id of a define, macro or constant
}


inline  Cid Cid_Null_()         { return Cid(0); }
inline  Tid Tid_Null_()         { return Tid(0); }
inline  Gid Gid_Null_()         { return Gid(0); }
inline  OSid OSid_Null_()       { return OSid(0); }
inline  Lid Lid_Null_()         { return Lid(0); }

inline  cpp::Did Did_Null_()    { return cpp::Did(0); }
// ... end of obsolete.


/** This is a typed repository id. It allows to get
    an object of a specific type.
*/

template <class IFC>
class TypedId
{
  public:
    typedef TypedId<IFC>                        self;


    explicit            TypedId(
                            Rid                 i_nId = 0 )
                                                : nId(i_nId) {}
    TypedId<IFC> &      operator=(
                            Rid                 i_nId )
                                                { nId = i_nId; return *this; }
    bool                operator==(
                            const TypedId<IFC> &
                                                i_nId ) const
                                                { return nId == i_nId.nId; }
    bool                operator!=(
                            const TypedId<IFC> &
                                                i_nId ) const
                                                { return NOT operator==(i_nId); }
    bool                operator<(
                            const TypedId<IFC> &
                                                i_nId ) const
                                                { return nId < i_nId.nId; }

    bool                IsValid() const         { return nId != 0; }
    Rid                 Value() const           { return nId; }

    static self         Null_()                 { return self(0); }

  private:
    // DATA
    Rid                 nId;
};

namespace logloc
{
    class File;
}

typedef TypedId<logloc::File>     File_id;


}   // namespace ary

#endif

