/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: QueryProcessorImpl.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:00:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.util.StringTokenizer;
import java.rmi.RemoteException;

import org.w3c.dom.*;

import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.qe.LiteMorph;
import com.sun.xmlsearch.qe.LiteMorph_en;
import com.sun.xmlsearch.xml.XmlIndex;

public final class QueryProcessorImpl implements QueryProcessor {
    private static double INFLpenalty = 0.5;
    private XmlIndex _env;
    private LiteMorph _morph = LiteMorph_en.getMorph();
    private Tokenizer _tokenizer = new SimpleTokenizer();
    private String[] _prefixTranslations;
    private String _defaultSearchUnit;
    private String _collectionName;
    private String _collectionClassification;
    private String _docType;
    private String _indexLocation;
    private Element _configuration;
    private String[] _ignoredElements;

    public String getName() {
	return getCollectionName();
    }

    public String getCollectionName() {
	return _collectionName;
    }
  
    public String getClassification() {
	return _collectionClassification;
    }
  
    public String getDocumentType() {
	return _docType;
    }
  
    public boolean init(String indexDir) throws Exception {
	_env = new XmlIndex(indexDir, false);
	return _env.init();
    }
  
    public boolean init(Element config) throws Exception {
	if (config.getTagName().equals("XmlSearchEngine")) {
	    _configuration = config;
	    _collectionName = config.getAttribute("name");
	    System.out.println("collection name: " + _collectionName);
	    _collectionClassification = config.getAttribute("category");
	    _indexLocation = config.getAttribute("indexLocation");
	    System.out.println("index location: " + _indexLocation);
	    _defaultSearchUnit = config.getAttribute("defaultSearchUnit");
	    System.out.println("default search unit: " + _defaultSearchUnit);
	    _docType = config.getAttribute("documentType");
	    System.out.println("document type: " + _docType);
	    _prefixTranslations = Configuration.processPrefixTranslations(config);
      
	    StringTokenizer ignored =
		new StringTokenizer(config.getAttribute("ignoredElements"));
	    int count = ignored.countTokens();
	    if (count > 0) {
		_ignoredElements = new String[count];
		for (int i = 0; i < count; i++) {
		    _ignoredElements[i] = ignored.nextToken();
		    System.out.println("ignore " + _ignoredElements[i]);
		}
	    }
      
	    _env = new XmlIndex(_indexLocation, false);
	    return _env.init();
	}
	else
	    throw new Exception("inappropriate element in init QueryProcessor");
    }

    public QueryResults processQuery(QueryStatement queryStatement)
	throws RemoteException {
	    try {
		Search search = makeSearch();
		queryStatement.defaultSearchUnit(_defaultSearchUnit);
		Query query = processQuery(search, queryStatement);
		query.setIgnoredElements(_ignoredElements);
		search.startSearch();
		return makeQueryResults(query, queryStatement);
	    }
	    catch (Exception e) {
		e.printStackTrace();
		throw new RemoteException("nested exception", e);
	    }
    }

    public QueryResults makeQueryResults(Query query, QueryStatement queryStatement)
	throws Exception {
	    return new QueryResults(_prefixTranslations, _docType,
				    query.getHits(queryStatement
						  .getRequestedNumberOfHits()));
    }
    
    /*
      public String getQueryResultsInXml(QueryStatement queryStatement)
      throws Exception {
      Search search = makeSearch();
      queryStatement.defaultSearchUnit(_defaultSearchUnit);
      Query query = processQuery(search, queryStatement);
      query.setIgnoredElements(_ignoredElements);
      search.startSearch();
      return query.getHitsInXml(queryStatement.getRequestedNumberOfHits());
      }
      */
  
    public synchronized Query processQuery(Search search,
					   QueryStatement queryStatement)
	throws Exception {
	    queryStatement.defaultSearchUnit(_defaultSearchUnit);
	    System.out.println("QueryProcessor.processQuery(\""+queryStatement+"\")");
    
	    // !!! except for META info, Tokenizer needs to be used
	    StringTokenizer terms = new StringTokenizer(queryStatement.getTerms());
	    int nTerms = terms.countTokens();
    
	    IntegerArray[] columns = new IntegerArray[nTerms];
	    IntegerArray missingTerms = new IntegerArray(nTerms);
	    int[] primary = new int[nTerms];
	    int nValidTerms = 0;
	    int nMissingTerms = 0;
	    int nContentTerms = 0;
	    String scope = queryStatement.getScope();
	    double variantPenalty = 0.0;
	    while (terms.hasMoreTokens()) {
		String token = terms.nextToken();
		if (token.startsWith("%")) { // poor man's escape for query control
		    System.err.println("+ not implemented");
		}
		else {
		    ++nContentTerms;
		    String term = token.toLowerCase();
		    int id = 0;		// term id
		    IntegerArray ids = new IntegerArray(); // ids of possible variants	
		    if (term.startsWith("\""))   // exact term
			id = _env.fetch(term.substring(1, term.length() - 1));
		    else if (term.endsWith("*")) {
			ids = _env.withPrefix(term.substring(0, term.length() - 1));
			variantPenalty = 0.0;
		    }
		    else {
			id = _env.fetch(term);
			final String[] variants = _morph.variantsOf(term);
			for (int i = 0; i < variants.length; i++) {
			    final int formID = _env.fetch(variants[i]);
			    if (formID > 0 && formID != id) {
				ids.add(formID);
			    }
			}
			variantPenalty = INFLpenalty;
		    }
	
		    if (ids.cardinality() > 0 || id > 0) {
			columns[nValidTerms] = ids;
			primary[nValidTerms] = id;
			nValidTerms++;
		    }
		    else {
			++nMissingTerms;
			// !!! not used now (intended to fill out appropr missing terms in QueryHits
			missingTerms.add(nContentTerms - 1);
		    }
		}
	    }
	    return search.addQuery(scope, nValidTerms, nMissingTerms,
				   queryStatement.getRequestedNumberOfHits(),
				   primary, columns, variantPenalty);
    }
  
    public void close() throws Exception {
	_env.close();
    }
  
    public Search makeSearch() {
	return new Search(_env);
    }

    public static void main(String[] args) {
	try {
	    final QueryProcessorImpl qp = new QueryProcessorImpl();
	    if (qp.init(args[0])) {
		if (args.length > 1 && args[1].equals("list")) {
		    Search search = qp.makeSearch();
		    search.listPositions();
		}
		else if (args.length > 1 && args[1].equals("words")) {
		    Search search = qp.makeSearch();
		    search.listConcepts(0, 379, 402);
		}
		else { 
		    final LineInput in = new LineInput(System.in);
		    System.out.println("initialized; enter query");
		    while (true) {
			String line = in.readLine();
			if (line.equals(".")) {
			    break;
			}
			else {
			    final int nHits = 25;
			    final long start = System.currentTimeMillis();
	    
			    final Search search = qp.makeSearch();
			    //Query query = qp.processQuery(search, new QueryStatement(line, "class", nHits));
			    Query query = qp.processQuery(search, new QueryStatement(line, "PARA[2]", nHits));
			    search.startSearch();
			    System.out.println(query.getHitsInXml(nHits));
			    //	    query.printHits(System.out, nHits);
	    
			    System.out.println((System.currentTimeMillis()-start)
					       +" msec search");
			}
			System.out.println("enter next query or . to quit");
		    }
		}
		qp.close();
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
