/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.MeterDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.List;

public class MeterPlot
extends Plot {
    public static final int DIALTYPE_PIE = 0;
    public static final int DIALTYPE_CIRCLE = 1;
    public static final int DIALTYPE_CHORD = 2;
    public static final String NORMAL_TEXT = "Normal";
    public static final String WARNING_TEXT = "Warning";
    public static final String CRITICAL_TEXT = "Critical";
    static final Paint DEFAULT_NORMAL_PAINT = Color.green;
    static final Paint DEFAULT_WARNING_PAINT = Color.yellow;
    static final Paint DEFAULT_CRITICAL_PAINT = Color.red;
    static final Paint DEFAULT_DIAL_BACKGROUND_PAINT = Color.black;
    static final Paint DEFAULT_NEEDLE_PAINT = Color.green;
    static final Font DEFAULT_VALUE_FONT = new Font("SansSerif", 1, 12);
    static final Paint DEFAULT_VALUE_PAINT = Color.yellow;
    public static final int DEFAULT_METER_ANGLE = 270;
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.lightGray;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int dialType = 1;
    private Paint dialBackgroundPaint;
    private Paint needlePaint;
    private Font valueFont;
    private Paint valuePaint;
    private int tickLabelType;
    private Font tickLabelFont;
    private Paint normalPaint = DEFAULT_NORMAL_PAINT;
    private Paint warningPaint = DEFAULT_WARNING_PAINT;
    private Paint criticalPaint = DEFAULT_CRITICAL_PAINT;
    private Color dialBorderColor;
    private boolean drawBorder;
    private int meterCalcAngle = -1;
    private double meterRange = -1.0;
    private int meterAngle = 270;
    private double minMeterValue = 0.0;

    public MeterPlot(MeterDataset meterDataset) {
        this(meterDataset, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 1, DEFAULT_LABEL_FONT);
    }

    public MeterPlot(MeterDataset meterDataset, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, int n, Font font) {
        super(meterDataset, insets, paint, image, f, stroke, paint2, f2);
        this.dialBackgroundPaint = DEFAULT_DIAL_BACKGROUND_PAINT;
        this.needlePaint = DEFAULT_NEEDLE_PAINT;
        this.valueFont = DEFAULT_VALUE_FONT;
        this.valuePaint = DEFAULT_VALUE_PAINT;
        this.tickLabelType = n;
        this.tickLabelFont = font;
    }

    public int getDialType() {
        return this.dialType;
    }

    public void setDialType(int n) {
        this.dialType = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDialBackgroundPaint() {
        return this.dialBackgroundPaint;
    }

    public void setDialBackgroundPaint(Paint paint) {
        this.dialBackgroundPaint = paint == null ? DEFAULT_DIAL_BACKGROUND_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNeedlePaint() {
        return this.needlePaint;
    }

    public void setNeedlePaint(Paint paint) {
        this.needlePaint = paint == null ? DEFAULT_NEEDLE_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        this.valueFont = font == null ? DEFAULT_VALUE_FONT : font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        this.valuePaint = paint == null ? DEFAULT_VALUE_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getNormalPaint() {
        return this.normalPaint;
    }

    public void setNormalPaint(Paint paint) {
        this.normalPaint = paint == null ? DEFAULT_NORMAL_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getWarningPaint() {
        return this.warningPaint;
    }

    public void setWarningPaint(Paint paint) {
        this.warningPaint = paint == null ? DEFAULT_WARNING_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getCriticalPaint() {
        return this.criticalPaint;
    }

    public void setCriticalPaint(Paint paint) {
        this.criticalPaint = paint == null ? DEFAULT_CRITICAL_PAINT : paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getTickLabelType() {
        return this.tickLabelType;
    }

    public void setTickLabelType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.tickLabelType != n) {
            this.tickLabelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setTickLabelFont(...): null font not allowed.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n) {
        this.meterAngle = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Color getDialBorderColor() {
        return this.dialBorderColor;
    }

    public void setDialBorderColor(Color color) {
        this.dialBorderColor = color;
    }

    public MeterDataset getMeterDataset() {
        return (MeterDataset)this.dataset;
    }

    public List getLegendItemLabels() {
        return null;
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        rectangle2D.setRect(rectangle2D.getX() + 4.0, rectangle2D.getY() + 4.0, rectangle2D.getWidth() - 8.0, rectangle2D.getHeight() - 8.0);
        if (this.drawBorder) {
            this.drawOutlineAndBackground(graphics2D, rectangle2D);
        }
        double d = 6.0;
        double d2 = 6.0;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2 + (this.meterAngle <= 180 && this.dialType != 1 ? rectangle2D.getHeight() / 1.25 : 0.0);
        double d7 = Math.min(d5, d6) / 2.0;
        d3 = (d3 + d3 + d5) / 2.0 - d7;
        d4 = (d4 + d4 + d6) / 2.0 - d7;
        d5 = 2.0 * d7;
        d6 = 2.0 * d7;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(((RectangularShape)double_).getX() - 4.0, ((RectangularShape)double_).getY() - 4.0, ((RectangularShape)double_).getWidth() + 8.0, ((RectangularShape)double_).getHeight() + 8.0);
        double d8 = double_.getCenterX();
        double d9 = double_.getCenterY();
        MeterDataset meterDataset = this.getMeterDataset();
        if (meterDataset != null) {
            double d10 = meterDataset.getMinimumValue().doubleValue();
            double d11 = meterDataset.getMaximumValue().doubleValue();
            this.minMeterValue = d10;
            this.meterCalcAngle = 180 + (this.meterAngle - 180) / 2;
            this.meterRange = d11 - d10;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(double_2);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            this.drawArc(graphics2D, double_2, d10, d11, this.dialBackgroundPaint, 1);
            this.drawTicks(graphics2D, double_, d10, d11);
            this.drawArcFor(graphics2D, double_, meterDataset, 3);
            this.drawArcFor(graphics2D, double_, meterDataset, 0);
            this.drawArcFor(graphics2D, double_, meterDataset, 1);
            this.drawArcFor(graphics2D, double_, meterDataset, 2);
            if (meterDataset.isValueValid()) {
                double d12 = meterDataset.getValue().doubleValue();
                this.drawTick(graphics2D, double_, d12, true, this.valuePaint, true, meterDataset.getUnits());
                graphics2D.setPaint(this.needlePaint);
                graphics2D.setStroke(new BasicStroke(2.0f));
                double d13 = ((RectangularShape)double_).getWidth() / 2.0 + 3.0 + 15.0;
                double d14 = this.calculateAngle(d12);
                double d15 = d8 + d13 * Math.cos(Math.PI * (d14 / 180.0));
                double d16 = d9 - d13 * Math.sin(Math.PI * (d14 / 180.0));
                Polygon polygon = new Polygon();
                if (d14 > 135.0 && d14 < 225.0 || d14 < 45.0 && d14 > -45.0) {
                    double d17 = d9 - 2.5;
                    double d18 = d9 + 2.5;
                    polygon.addPoint((int)d8, (int)d17);
                    polygon.addPoint((int)d8, (int)d18);
                } else {
                    polygon.addPoint((int)(d8 - 2.5), (int)d9);
                    polygon.addPoint((int)(d8 + 2.5), (int)d9);
                }
                polygon.addPoint((int)d15, (int)d16);
                Ellipse2D.Double double_3 = new Ellipse2D.Double(d8 - 5.0, d9 - 5.0, 10.0, 10.0);
                graphics2D.fill(polygon);
                graphics2D.fill(double_3);
            }
            graphics2D.clip(shape);
            graphics2D.setComposite(composite);
        }
    }

    void drawArcFor(Graphics2D graphics2D, Rectangle2D rectangle2D, MeterDataset meterDataset, int n) {
        Number number = null;
        Number number2 = null;
        Paint paint = null;
        switch (n) {
            case 0: {
                number = meterDataset.getMinimumNormalValue();
                number2 = meterDataset.getMaximumNormalValue();
                paint = this.getNormalPaint();
                break;
            }
            case 1: {
                number = meterDataset.getMinimumWarningValue();
                number2 = meterDataset.getMaximumWarningValue();
                paint = this.getWarningPaint();
                break;
            }
            case 2: {
                number = meterDataset.getMinimumCriticalValue();
                number2 = meterDataset.getMaximumCriticalValue();
                paint = this.getCriticalPaint();
                break;
            }
            case 3: {
                number = meterDataset.getMinimumValue();
                number2 = meterDataset.getMaximumValue();
                paint = DEFAULT_BACKGROUND_PAINT;
                break;
            }
            default: {
                return;
            }
        }
        if (number != null && number2 != null) {
            if (meterDataset.getBorderType() == n) {
                this.drawArc(graphics2D, rectangle2D, number.doubleValue(), meterDataset.getMinimumValue().doubleValue(), paint);
                this.drawArc(graphics2D, rectangle2D, meterDataset.getMaximumValue().doubleValue(), number2.doubleValue(), paint);
            } else {
                this.drawArc(graphics2D, rectangle2D, number.doubleValue(), number2.doubleValue(), paint);
            }
            this.drawTick(graphics2D, rectangle2D, number.doubleValue(), true, paint);
            this.drawTick(graphics2D, rectangle2D, number2.doubleValue(), true, paint);
        }
    }

    void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Paint paint) {
        this.drawArc(graphics2D, rectangle2D, d, d2, paint, 0);
    }

    void drawArc(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2, Paint paint, int n) {
        double d3 = this.calculateAngle(d2);
        double d4 = this.calculateAngle(d);
        double d5 = d4 - d3;
        double d6 = rectangle2D.getX();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getWidth();
        double d9 = rectangle2D.getHeight();
        graphics2D.setPaint(paint);
        if (n > 0) {
            graphics2D.setStroke(new BasicStroke(10.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(3.0f));
        }
        int n2 = 0;
        if (n > 0) {
            switch (this.dialType) {
                case 0: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    if (this.meterAngle > 180) {
                        n2 = 1;
                        break;
                    }
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 2;
                    d5 = 360.0;
                }
            }
        }
        Arc2D.Double double_ = new Arc2D.Double(d6, d7, d8, d9, d3, d5, n2);
        if (n > 0) {
            graphics2D.fill(double_);
        } else {
            graphics2D.draw(double_);
        }
    }

    double calculateAngle(double d) {
        double d2 = (double)this.meterCalcAngle - (d -= this.minMeterValue) / this.meterRange * (double)this.meterAngle;
        return d2;
    }

    void drawTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2) {
        int n = 20;
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        while (d4 <= d2) {
            this.drawTick(graphics2D, rectangle2D, d4);
            d4 += d3;
        }
    }

    void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        this.drawTick(graphics2D, rectangle2D, d, false, null, false, null);
    }

    void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl, Paint paint) {
        this.drawTick(graphics2D, rectangle2D, d, bl, paint, false, null);
    }

    void drawTick(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, boolean bl, Paint paint, boolean bl2, String string) {
        double d2 = this.calculateAngle(d);
        double d3 = rectangle2D.getCenterX();
        double d4 = rectangle2D.getCenterY();
        if (paint == null) {
            paint = Color.white;
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(new BasicStroke(2.0f));
        double d5 = 0.0;
        double d6 = 0.0;
        if (!bl2) {
            double d7 = rectangle2D.getWidth() / 2.0 + 3.0;
            double d8 = d7 - 15.0;
            double d9 = d3 + d7 * Math.cos(Math.PI * (d2 / 180.0));
            double d10 = d4 - d7 * Math.sin(Math.PI * (d2 / 180.0));
            d5 = d3 + d8 * Math.cos(Math.PI * (d2 / 180.0));
            d6 = d4 - d8 * Math.sin(Math.PI * (d2 / 180.0));
            Line2D.Double double_ = new Line2D.Double(d9, d10, d5, d6);
            graphics2D.draw(double_);
        } else {
            d5 = d3;
            d6 = d4;
            d2 = 90.0;
        }
        if (this.tickLabelType == 1 && bl) {
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###,##0.00");
            String string2 = decimalFormat.format(d);
            if (bl2 && string != null) {
                string2 = string2 + " " + string;
            }
            if (bl2) {
                graphics2D.setFont(this.getValueFont());
            } else if (this.tickLabelFont != null) {
                graphics2D.setFont(this.tickLabelFont);
            }
            Rectangle2D rectangle2D2 = graphics2D.getFont().getStringBounds(string2, graphics2D.getFontRenderContext());
            double d11 = d5;
            double d12 = d6;
            if (bl2) {
                d12 += 10.0;
            }
            if (d2 == 90.0 || d2 == 270.0) {
                d11 -= rectangle2D2.getWidth() / 2.0;
            } else if (d2 < 90.0 || d2 > 270.0) {
                d11 -= rectangle2D2.getWidth();
            }
            d12 = d2 > 135.0 && d2 < 225.0 || d2 > 315.0 || d2 < 45.0 ? (d12 -= rectangle2D2.getHeight() / 2.0) : (d12 += rectangle2D2.getHeight() / 2.0);
            graphics2D.drawString(string2, (float)d11, (float)d12);
        }
    }

    public String getPlotType() {
        return "Meter Plot";
    }

    public void zoom(double d) {
    }
}

