/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Alerts;
import com.sun.net.ssl.internal.ssl.AppInputStream;
import com.sun.net.ssl.internal.ssl.AppOutputStream;
import com.sun.net.ssl.internal.ssl.BaseSSLSocketImpl;
import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ClientHandshaker;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.ServerHandshaker;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;

public final class SSLSocketImpl
extends BaseSSLSocketImpl {
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_SENT_CLOSE = 5;
    private static final int cs_CLOSED = 6;
    private static final int cs_APP_CLOSED = 7;
    private int connectionState;
    private boolean expectingFinished;
    private SSLException closeReason;
    private byte doClientAuth;
    private boolean roleIsServer;
    private CipherSuiteList enabledCipherSuites;
    private boolean enableSessionCreation = true;
    private String host;
    private boolean autoClose = true;
    private AccessControlContext acc;
    private String identificationAlg = null;
    private Object handshakeLock;
    Object writeLock;
    private Object readLock;
    private InputRecord inrec;
    private MAC readMAC;
    private MAC writeMAC;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private SSLContextImpl sslContext;
    private SSLSessionImpl sess;
    private Handshaker handshaker;
    private HashMap handshakeListeners;
    private InputStream sockInput;
    private OutputStream sockOutput;
    private AppInputStream input;
    private AppOutputStream output;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n) throws IOException, UnknownHostException {
        this.host = string;
        this.init(sSLContextImpl, false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n) throws IOException {
        this.init(sSLContextImpl, false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        this.host = string;
        this.init(sSLContextImpl, false);
        this.bind(new InetSocketAddress(inetAddress, n2));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.init(sSLContextImpl, false);
        this.bind(new InetSocketAddress(inetAddress2, n2));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, boolean bl, CipherSuiteList cipherSuiteList, byte by, boolean bl2, ProtocolList protocolList) throws IOException {
        this.doClientAuth = by;
        this.enableSessionCreation = bl2;
        this.init(sSLContextImpl, bl);
        this.enabledCipherSuites = cipherSuiteList;
        this.enabledProtocols = protocolList;
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl) {
        this.init(sSLContextImpl, false);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, String string, int n, boolean bl) throws IOException {
        super(socket);
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.host = string;
        this.init(sSLContextImpl, false);
        this.autoClose = bl;
        this.doneConnect();
    }

    private void init(SSLContextImpl sSLContextImpl, boolean bl) {
        this.sslContext = sSLContextImpl;
        this.sess = SSLSessionImpl.nullSession;
        this.roleIsServer = bl;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readMAC = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeMAC = MAC.NULL;
        this.enabledCipherSuites = CipherSuiteList.getDefault();
        this.enabledProtocols = ProtocolList.getDefault();
        this.handshakeLock = new Object();
        this.writeLock = new Object();
        this.readLock = new Object();
        this.inrec = null;
        this.acc = AccessController.getContext();
        this.input = new AppInputStream(this);
        this.output = new AppOutputStream(this);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.self != this) {
            throw new SocketException("Already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        super.connect(socketAddress, n);
        this.doneConnect();
    }

    void doneConnect() throws IOException {
        if (this.self == this) {
            this.sockInput = super.getInputStream();
            this.sockOutput = super.getOutputStream();
        } else {
            this.sockInput = this.self.getInputStream();
            this.sockOutput = this.self.getOutputStream();
        }
        this.initHandshaker();
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int n) {
        this.connectionState = n;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRecord(OutputRecord outputRecord) throws IOException {
        block9: while (outputRecord.contentType() == 23) {
            switch (this.getConnectionState()) {
                case 1: {
                    this.performInitialHandshake();
                    continue block9;
                }
                case 2: 
                case 3: {
                    break block9;
                }
                case 4: {
                    this.fatal((byte)0, "error while writing to socket");
                    continue block9;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.closeReason != null) {
                        throw this.closeReason;
                    }
                    throw new SocketException("Socket closed");
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
            }
        }
        Object object = this.writeLock;
        synchronized (object) {
            if (!outputRecord.isEmpty()) {
                outputRecord.addMAC(this.writeMAC);
                outputRecord.encrypt(this.writeCipher);
                outputRecord.write(this.sockOutput);
            }
        }
    }

    void readDataRecord(InputRecord inputRecord) throws IOException {
        if (this.getConnectionState() == 1) {
            this.performInitialHandshake();
        }
        this.readRecord(inputRecord, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecord(InputRecord inputRecord, boolean bl) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int n;
            block19: while ((n = this.getConnectionState()) != 6 && n != 4 && n != 7) {
                try {
                    inputRecord.setAppDataValid(false);
                    inputRecord.read(this.sockInput, this.sockOutput);
                }
                catch (SSLProtocolException sSLProtocolException) {
                    try {
                        this.fatal((byte)10, sSLProtocolException);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw sSLProtocolException;
                }
                catch (EOFException eOFException) {
                    boolean bl2;
                    boolean bl3 = this.getConnectionState() <= 1;
                    boolean bl4 = bl2 = requireCloseNotify || bl3;
                    if (debug != null && Debug.isOn("ssl")) {
                        System.out.println(SSLSocketImpl.threadName() + ", received EOFException: " + (bl2 ? "error" : "ignored"));
                    }
                    if (bl2) {
                        SSLException sSLException = bl3 ? new SSLHandshakeException("Remote host closed connection during handshake") : new SSLProtocolException("Remote host closed connection incorrectly");
                        sSLException.initCause(eOFException);
                        throw sSLException;
                    }
                    this.closeInternal(false);
                    continue;
                }
                try {
                    inputRecord.decrypt(this.readCipher);
                }
                catch (BadPaddingException badPaddingException) {
                    inputRecord.checkMAC(this.readMAC);
                    byte by = inputRecord.contentType() == 22 ? (byte)40 : 20;
                    this.fatal(by, "Invalid padding", badPaddingException);
                }
                if (!inputRecord.checkMAC(this.readMAC)) {
                    if (inputRecord.contentType() == 22) {
                        this.fatal((byte)40, "bad handshake record MAC");
                    } else {
                        this.fatal((byte)20, "bad record MAC");
                    }
                }
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    switch (inputRecord.contentType()) {
                        case 22: {
                            this.initHandshaker();
                            this.handshaker.process_record(inputRecord, this.expectingFinished);
                            this.expectingFinished = false;
                            if (this.handshaker.isDone()) {
                                this.sess = this.handshaker.getSession();
                                this.handshaker = null;
                                this.connectionState = 2;
                                if (this.handshakeListeners != null) {
                                    HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.sess);
                                    NotifyHandshakeThread notifyHandshakeThread = new NotifyHandshakeThread(this.handshakeListeners.entrySet(), handshakeCompletedEvent);
                                    notifyHandshakeThread.start();
                                }
                            }
                            if (bl || this.connectionState != 2) {
                                continue block19;
                            }
                            return;
                        }
                        case 23: {
                            if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 5) {
                                throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                            }
                            if (this.expectingFinished) {
                                throw new SSLProtocolException("Expecting finished message, received data");
                            }
                            if (!bl) {
                                throw new SSLException("Discarding app data");
                            }
                            inputRecord.setAppDataValid(true);
                            return;
                        }
                        case 21: {
                            this.recvAlert(inputRecord);
                            continue block19;
                        }
                        case 20: {
                            if (this.connectionState != 1 && this.connectionState != 3 || inputRecord.available() != 1 || inputRecord.read() != 1) {
                                this.fatal((byte)10, "illegal change cipher spec msg, state = " + this.connectionState);
                            }
                            this.changeReadCiphers();
                            this.expectingFinished = true;
                            continue block19;
                        }
                    }
                    if (debug != null && Debug.isOn("ssl")) {
                        System.out.println(SSLSocketImpl.threadName() + ", Received record type: " + inputRecord.contentType());
                    }
                }
            }
            inputRecord.close();
            return;
        }
    }

    AppInputStream getAppInputStream() {
        return this.input;
    }

    ServerHandshaker getServerHandshaker() throws SSLException {
        this.initHandshaker();
        return (ServerHandshaker)this.handshaker;
    }

    private void initHandshaker() {
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        this.handshaker = this.roleIsServer ? new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth) : new ClientHandshaker(this, this.sslContext, this.enabledProtocols);
        this.handshaker.enabledCipherSuites = this.enabledCipherSuites;
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        if (this.connectionState == 3) {
            this.handshaker.output.r.setHelloVersion(this.protocolVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialHandshake() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.getConnectionState() == 1) {
                if (this.inrec == null) {
                    this.inrec = new InputRecord();
                    this.inrec.setHandshakeHash(this.input.r.getHandshakeHash());
                    this.inrec.setHelloVersion(this.input.r.getHelloVersion());
                    this.inrec.enableFormatChecks();
                }
                this.kickstartHandshake();
                this.readRecord(this.inrec, false);
                this.inrec = null;
            }
        }
    }

    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    private void startHandshake(boolean bl) throws IOException {
        this.checkWrite();
        try {
            if (this.getConnectionState() == 1) {
                this.performInitialHandshake();
            } else {
                this.kickstartHandshake();
            }
        }
        catch (Exception exception) {
            this.handleException(exception, bl);
        }
    }

    private synchronized void kickstartHandshake() throws IOException {
        switch (this.connectionState) {
            case 1: {
                break;
            }
            case 2: {
                this.initHandshaker();
                break;
            }
            case 3: {
                return;
            }
            case 0: {
                throw new SocketException("handshaking attempted on unconnected socket");
            }
            default: {
                throw new SocketException("connection is closed");
            }
        }
        if (!this.handshaker.started()) {
            if (this.handshaker instanceof ClientHandshaker) {
                this.handshaker.kickstart();
            } else if (this.connectionState != 1) {
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
            }
        }
    }

    public boolean isClosed() {
        return this.getConnectionState() == 7;
    }

    boolean checkEOF() throws IOException {
        switch (this.getConnectionState()) {
            case 0: {
                throw new SocketException("Socket is not connected");
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 7: {
                throw new SocketException("Socket is closed");
            }
        }
        if (this.closeReason == null) {
            return true;
        }
        SSLException sSLException = new SSLException("Connection has been shutdown: " + this.closeReason);
        sSLException.initCause(this.closeReason);
        throw sSLException;
    }

    void checkWrite() throws IOException {
        if (this.checkEOF() || this.getConnectionState() == 5) {
            throw new SocketException("Connection closed by remote host");
        }
    }

    private void closeSocket() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", called closeSocket()");
        }
        if (this.self == this) {
            super.close();
        } else {
            this.self.close();
        }
    }

    public void close() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", called close()");
        }
        this.closeInternal(true);
        this.setConnectionState(7);
    }

    /*
     * Exception decompiling
     */
    private void closeInternal(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForClose(boolean bl) throws IOException {
        block8: {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(SSLSocketImpl.threadName() + ", waiting for close_notify or alert: state " + this.getConnectionState());
            }
            try {
                int n;
                while ((n = this.getConnectionState()) != 6 && n != 4 && n != 7) {
                    if (this.inrec == null) {
                        this.inrec = new InputRecord();
                    }
                    try {
                        this.readRecord(this.inrec, true);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                this.inrec = null;
            }
            catch (IOException iOException) {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(SSLSocketImpl.threadName() + ", Exception while waiting for close " + iOException);
                }
                if (!bl) break block8;
                throw iOException;
            }
        }
    }

    void handleException(Exception exception) throws IOException {
        this.handleException(exception, true);
    }

    private synchronized void handleException(Exception exception, boolean bl) throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", handling exception: " + exception.toString());
        }
        if (exception instanceof InterruptedIOException && bl) {
            throw (IOException)exception;
        }
        if (this.closeReason != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw Alerts.getSSLException((byte)80, exception, "Unexpected exception");
        }
        boolean bl2 = exception instanceof SSLException;
        if (!bl2 && exception instanceof IOException) {
            try {
                this.fatal((byte)10, exception);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (IOException)exception;
        }
        byte by = bl2 ? (exception instanceof SSLHandshakeException ? (byte)40 : 10) : (byte)80;
        this.fatal(by, exception);
    }

    void warning(byte by) {
        this.sendAlert((byte)1, by);
    }

    synchronized void fatal(byte by, String string) throws IOException {
        this.fatal(by, string, null);
    }

    synchronized void fatal(byte by, Throwable throwable) throws IOException {
        this.fatal(by, null, throwable);
    }

    synchronized void fatal(byte by, String string, Throwable throwable) throws IOException {
        if (this.input != null && this.input.r != null) {
            this.input.r.close();
        }
        this.sess.invalidate();
        int n = this.connectionState;
        this.connectionState = 4;
        if (this.closeReason == null) {
            if (n == 1) {
                this.sockInput.skip(this.sockInput.available());
            }
            this.sendAlert((byte)2, by);
            this.closeReason = throwable instanceof SSLException ? (SSLException)throwable : Alerts.getSSLException(by, throwable, string);
        }
        this.closeSocket();
        this.connectionState = n == 7 ? 7 : 6;
        throw this.closeReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recvAlert(InputRecord inputRecord) throws IOException {
        Object object;
        byte by = (byte)inputRecord.read();
        byte by2 = (byte)inputRecord.read();
        if (by2 == -1) {
            this.fatal((byte)47, "Short alert message");
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            object = System.out;
            synchronized (object) {
                System.out.print(SSLSocketImpl.threadName());
                System.out.print(", RECV " + this.protocolVersion + " ALERT:  ");
                if (by == 2) {
                    System.out.print("fatal, ");
                } else if (by == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & by) + ">, ");
                }
                System.out.println(Alerts.alertDescription(by2));
            }
        }
        if (by == 1) {
            if (by2 == 0) {
                if (this.connectionState == 1) {
                    this.fatal((byte)10, "Received close_notify during handshake");
                } else {
                    this.closeInternal(false);
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(by2);
            }
        } else {
            object = "Received fatal alert: " + Alerts.alertDescription(by2);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(by2, (String)object);
            }
            this.fatal((byte)10, (String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlert(byte by, byte by2) {
        block11: {
            boolean bl;
            if (this.connectionState >= 6) {
                return;
            }
            OutputRecord outputRecord = new OutputRecord(21);
            outputRecord.setVersion(this.protocolVersion);
            boolean bl2 = bl = debug != null && Debug.isOn("ssl");
            if (bl) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(SSLSocketImpl.threadName());
                    System.out.print(", SEND " + this.protocolVersion + " ALERT:  ");
                    if (by == 2) {
                        System.out.print("fatal, ");
                    } else if (by == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & by) + ">, ");
                    }
                    System.out.println("description = " + Alerts.alertDescription(by2));
                }
            }
            outputRecord.write(by);
            outputRecord.write(by2);
            try {
                this.writeRecord(outputRecord);
            }
            catch (IOException iOException) {
                if (!bl) break block11;
                System.out.println(SSLSocketImpl.threadName() + ", Exception sending alert: " + iOException);
            }
        }
    }

    private void changeReadCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readMAC = this.handshaker.newReadMAC();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(generalSecurityException);
        }
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeMAC = this.handshaker.newWriteMAC();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(generalSecurityException);
        }
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.output.r.setVersion(protocolVersion);
    }

    synchronized String getHost() {
        if (this.host == null) {
            this.host = this.getInetAddress().getHostName();
        }
        return this.host;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.input;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession() {
        block6: {
            if (this.getConnectionState() == 1) {
                try {
                    this.startHandshake(false);
                }
                catch (IOException iOException) {
                    if (debug == null || !Debug.isOn("handshake")) break block6;
                    System.out.println(SSLSocketImpl.threadName() + ", IOException in getSession():  " + iOException);
                }
            }
        }
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            return this.sess;
        }
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.started()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        byte by = this.doClientAuth = bl ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.started()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public synchronized void setUseClientMode(boolean bl) {
        switch (this.connectionState) {
            case 0: {
                this.roleIsServer = !bl;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.started()) {
                    this.roleIsServer = !bl;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(SSLSocketImpl.threadName() + ", setUseClientMode() invoked in state = " + this.connectionState);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.enabledCipherSuites = this.enabledCipherSuites;
        }
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public String[] getSupportedProtocols() {
        return ProtocolList.getSupported().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public void setSoTimeout(int n) throws SocketException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLSocketImpl.threadName() + ", setSoTimeout(" + n + ") called");
        }
        if (this.self == this) {
            super.setSoTimeout(n);
        } else {
            this.self.setSoTimeout(n);
        }
    }

    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new HashMap(4);
        }
        this.handshakeListeners.put(handshakeCompletedListener, AccessController.getContext());
    }

    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.handshakeListeners.remove(handshakeCompletedListener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    public synchronized boolean trySetHostnameVerification(String string) {
        if (this.sslContext.getX509TrustManager() instanceof X509ExtendedTrustManager) {
            this.identificationAlg = string;
            return true;
        }
        return false;
    }

    public synchronized String getHostnameVerification() {
        return this.identificationAlg;
    }

    private static String threadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        stringBuffer.append(this.sess.getCipherSuite());
        stringBuffer.append(": ");
        if (this.self == this) {
            stringBuffer.append(super.toString());
        } else {
            stringBuffer.append(this.self.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static class NotifyHandshakeThread
    extends Thread {
        private Set targets;
        private HandshakeCompletedEvent event;

        NotifyHandshakeThread(Set set, HandshakeCompletedEvent handshakeCompletedEvent) {
            super("HandshakeCompletedNotify-Thread");
            this.targets = set;
            this.event = handshakeCompletedEvent;
        }

        public void run() {
            for (Map.Entry entry : this.targets) {
                final HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)entry.getKey();
                AccessControlContext accessControlContext = (AccessControlContext)entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        handshakeCompletedListener.handshakeCompleted(NotifyHandshakeThread.this.event);
                        return null;
                    }
                }, accessControlContext);
            }
        }
    }
}

