/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.io.File;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.Panel.InstallationOngoing;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupFrame;
import org.openoffice.setup.Util.InfoDir;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.PackageCollector;
import org.openoffice.setup.Util.SystemManager;

public class InstallationOngoingCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_InstallationOngoing";
    private String nextDialog = new String("InstallationCompleted");
    private String previousDialog = new String("InstallationImminent");

    public InstallationOngoingCtrl() {
        super("InstallationOngoing", new InstallationOngoing());
    }

    public String getNext() {
        return new String("InstallationCompleted");
    }

    public String getPrevious() {
        return new String("InstallationImminent");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    public void beforeShow() {
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonEnabled(false, 2);
        SetupFrame setupFrame2 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame2.setButtonEnabled(false, 1);
        SetupFrame setupFrame3 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame3.setButtonEnabled(false, 3);
        SetupFrame setupFrame4 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame4.setButtonSelected(4);
        InstallationOngoing panel = (InstallationOngoing)this.getPanel();
        this.getSetupFrame();
        panel.setStopButtonActionCommand("ActionStop");
        panel.addStopButtonActionListener(this.getSetupFrame().getSetupActionListener());
        InstallData installData = InstallData.getInstance();
        Vector installPackages = installData.getInstallPackages();
        Vector sortedPackages = new Vector();
        PackageCollector.sortPackages(installPackages, sortedPackages, "install");
        installData.setInstallPackages(sortedPackages);
        Installer installer = InstallerFactory.getInstance();
        installer.preInstallationOngoing();
    }

    public void duringShow() {
        Thread t = new Thread(){
            InstallData installData = InstallData.getInstance();
            InstallationOngoing panel = (InstallationOngoing)InstallationOngoingCtrl.this.getPanel();
            Vector installPackages = this.installData.getInstallPackages();
            private Vector installedPackages = new Vector();

            public void run() {
                int progress;
                PackageDescription packageData;
                int i;
                LogManager.setCommandsHeaderLine("Installation");
                Installer installer = InstallerFactory.getInstance();
                String titleText = ResourceManager.getString("String_InstallationOngoing1");
                this.panel.setTitle(titleText);
                for (i = 0; i < this.installPackages.size(); ++i) {
                    packageData = (PackageDescription)this.installPackages.get(i);
                    progress = Math.round(100 * (i + 1) / this.installPackages.size());
                    this.panel.setProgressValue(progress);
                    this.panel.setProgressText(packageData.getPackageName());
                    installer.installPackage(packageData);
                    this.installedPackages.add(packageData);
                    if (this.installData.isAbortedInstallation()) break;
                }
                if (this.installData.isAbortedInstallation()) {
                    LogManager.setCommandsHeaderLine("Installation aborted!");
                    titleText = ResourceManager.getString("String_UninstallationOngoing1");
                    this.panel.setTitle(titleText);
                    this.panel.setStopButtonEnabled(false);
                    LogManager.setCommandsHeaderLine("Uninstallation");
                    for (i = 0; i < this.installedPackages.size(); ++i) {
                        packageData = (PackageDescription)this.installedPackages.get(i);
                        progress = Math.round(100 / this.installedPackages.size()) * (i + 1);
                        this.panel.setProgressValue(progress);
                        this.panel.setProgressText(packageData.getPackageName());
                        installer.uninstallPackage(packageData);
                    }
                    Vector removeFiles = this.installData.getRemoveFiles();
                    for (int i2 = 0; i2 < removeFiles.size(); ++i2) {
                        File removeFile = new File((String)removeFiles.get(i2));
                        SystemManager.deleteFile(removeFile);
                    }
                }
                installer.postInstallationOngoing();
                String next = InstallationOngoingCtrl.this.getNext();
                InstallationOngoingCtrl.this.getSetupFrame().setCurrentPanel(next, false, true);
            }
        };
        t.start();
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        SetupFrame setupFrame = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame.setButtonEnabled(true, 2);
        SetupFrame setupFrame2 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame2.setButtonEnabled(true, 1);
        SetupFrame setupFrame3 = this.getSetupFrame();
        this.getSetupFrame();
        setupFrame3.setButtonEnabled(true, 3);
        InstallData installData = InstallData.getInstance();
        if (!installData.isAbortedInstallation()) {
            InfoDir.prepareUninstallation();
        }
        return repeatDialog;
    }
}

