/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jitsi.utils.TimeUtils;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="We only add methods, we don't override anything.")
public class DiagnosticContext
extends ConcurrentHashMap<String, Object> {
    Clock clock;

    public DiagnosticContext() {
        this.clock = Clock.systemUTC();
    }

    public DiagnosticContext(Clock clock) {
        this.clock = clock;
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName) {
        return this.makeTimeSeriesPoint(timeSeriesName, this.clock.instant());
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, long tsMs) {
        return new TimeSeriesPoint(this).addField("series", timeSeriesName).addField("time", tsMs);
    }

    public TimeSeriesPoint makeTimeSeriesPoint(String timeSeriesName, Instant ts) {
        return new TimeSeriesPoint(this).addField("series", timeSeriesName).addField("time", TimeUtils.formatTimeAsFullMillis(ts.getEpochSecond(), ts.getNano()));
    }

    public static class TimeSeriesPoint
    extends HashMap<String, Object> {
        public TimeSeriesPoint(Map<String, Object> m4) {
            super(m4);
        }

        public TimeSeriesPoint addField(String key, Object value2) {
            this.put(key, value2);
            return this;
        }
    }
}

