# This file was automatically generated by bifcl from /local/pobj/zeek-8.0.3/zeek-8.0.3/src/analyzer/protocol/ssl/events.bif (plugin mode).

export {
## Generated for an SSL/TLS client's initial *hello* message.  SSL/TLS sessions
## start with an unencrypted handshake, and Zeek extracts as much information out
## of that as it can. This event provides access to the initial information
## sent by the client.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## version: The protocol version as extracted from the client's message.  The
##          values are standardized as part of the SSL/TLS protocol. The
##          :zeek:id:`SSL::version_strings` table maps them to descriptive names.
##
## record_version: TLS version given in the record layer of the message.
##                 Set to 0 for SSLv2.
##
## possible_ts: The current time as sent by the client. Note that SSL/TLS does
##              not require clocks to be set correctly, so treat with care.
##
## session_id: The session ID sent by the client (if any).
##
## client_random: The random value sent by the client. For version 2 connections,
##		  the client challenge is returned.
##
## ciphers: The list of ciphers the client offered to use. The values are
##          standardized as part of the SSL/TLS protocol. The
##          :zeek:id:`SSL::cipher_desc` table maps them to descriptive names.
##
## comp_methods: The list of compression methods that the client offered to use.
##               This value is not sent in TLSv1.3 or SSLv2.
##
## .. zeek:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_handshake_message
##    ssl_change_cipher_spec
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_connection_flipped
global ssl_client_hello: event(c: connection , version: count , record_version: count , possible_ts: time , client_random: string , session_id: string , ciphers: index_vec , comp_methods: index_vec );


## Generated for an SSL/TLS server's initial *hello* message. SSL/TLS sessions
## start with an unencrypted handshake, and Zeek extracts as much information out
## of that as it can. This event provides access to the initial information
## sent by the client.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## version: The protocol version as extracted from the server's message.
##          The values are standardized as part of the SSL/TLS protocol. The
##          :zeek:id:`SSL::version_strings` table maps them to descriptive names.
##
## record_version: TLS version given in the record layer of the message.
##                 Set to 0 for SSLv2.
##
## possible_ts: The current time as sent by the server. Note that SSL/TLS does
##              not require clocks to be set correctly, so treat with care. This value
##              is meaningless in SSLv2 and TLSv1.3.
##
## session_id: The session ID as sent back by the server (if any). This value is not
##             sent in TLSv1.3.
##
## server_random: The random value sent by the server. For version 2 connections,
##		  the connection-id is returned. Note - the full 32 bytes are included in
##		  server_random. This means that the 4 bytes present in possible_ts are repeated;
##		  if you do not want this behavior ignore the first 4 bytes.
##
## cipher: The cipher chosen by the server.  The values are standardized as part
##         of the SSL/TLS protocol. The :zeek:id:`SSL::cipher_desc` table maps
##         them to descriptive names.
##
## comp_method: The compression method chosen by the client. The values are
##              standardized as part of the SSL/TLS protocol. This value is not
##              sent in TLSv1.3 or SSLv2.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_extension
##    ssl_session_ticket_handshake x509_certificate
##    ssl_dh_server_params ssl_handshake_message ssl_change_cipher_spec
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_connection_flipped
global ssl_server_hello: event(c: connection , version: count , record_version: count , possible_ts: time , server_random: string , session_id: string , cipher: count , comp_method: count );


## Generated for SSL/TLS extensions seen in an initial handshake.  SSL/TLS
## sessions start with an unencrypted handshake, and Zeek extracts as much
## information out of that as it can. This event provides access to any
## extensions either side sends as part of an extended *hello* message.
##
## Note that Zeek offers more specialized events for a few extensions.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## code: The numerical code of the extension.  The values are standardized as
##       part of the SSL/TLS protocol. The :zeek:id:`SSL::extensions` table maps
##       them to descriptive names.
##
## val: The raw extension value that was sent in the message.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension_ec_point_formats
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_extension_signature_algorithm ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_connection_flipped ssl_extension_connection_id
global ssl_extension: event(c: connection , is_client: bool , code: count , val: string );


## Generated for an SSL/TLS Elliptic Curves extension. This TLS extension is
## defined in :rfc:`4492` and sent by the client in the initial handshake. It
## gives the list of elliptic curves supported by the client.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## curves: List of supported elliptic curves.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_ec_point_formats ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_extension_signature_algorithm
##    ssl_extension_key_share ssl_rsa_client_pms ssl_server_signature
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_elliptic_curves: event(c: connection , is_client: bool , curves: index_vec );


## Generated for an SSL/TLS Supported Point Formats extension. This TLS extension
## is defined in :rfc:`4492` and sent by the client and/or server in the initial
## handshake. It gives the list of elliptic curve point formats supported by the
## client.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## point_formats: List of supported point formats.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_extension_signature_algorithm
##    ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_server_signature
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_ec_point_formats: event(c: connection , is_client: bool , point_formats: index_vec );


## Generated for an Signature Algorithms extension. This TLS extension
## is defined in :rfc:`5246` and sent by the client in the initial
## handshake. It gives the list of signature and hash algorithms supported by the
## client.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## signature_algorithms: List of supported signature and hash algorithm pairs.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_server_signature
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_signature_algorithm: event(c: connection , is_client: bool , signature_algorithms: signature_and_hashalgorithm_vec );


## Generated for a Key Share extension. This TLS extension is defined in TLS1.3-draft16
## and sent by the client and the server in the initial handshake. It gives the list of
## named groups supported by the client and chosen by the server.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## curves: List of supported/chosen named groups.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_server_signature
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_key_share: event(c: connection , is_client: bool , curves: index_vec );


## Generated for the pre-shared key extension as it is sent in the TLS 1.3 client hello.
##
## The extension lists the identities the client is willing to negotiate with the server;
## they can either be pre-shared or be based on previous handshakes.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## identities: A list of the identities the client is willing to negotiate with the server.
##
## binders: A series of HMAC values; for computation, see the TLS 1.3 RFC.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_server_signature ssl_extension_pre_shared_key_server_hello
##    ssl_extension_connection_id
global ssl_extension_pre_shared_key_client_hello: event(c: connection , is_client: bool , identities: psk_identity_vec , binders: string_vec );


## Generated for the pre-shared key extension as it is sent in the TLS 1.3 server hello.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## selected_identity: The identity the server chose as a 0-based index into the identities
##                    the client sent.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms ssl_server_signature ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_pre_shared_key_server_hello: event(c: connection , is_client: bool , selected_identity: count );


## Generated if a server uses an ECDH-anon or ECDHE cipher suite using a named curve
## This event contains the named curve name and the server ECDH parameters contained
## in the ServerKeyExchange message as defined in :rfc:`4492`.
##
## c: The connection.
##
## curve: The curve parameters.
##
## point: The server's ECDH public key.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_server_signature
##    ssl_dh_client_params ssl_ecdh_client_params ssl_rsa_client_pms
global ssl_ecdh_server_params: event(c: connection , curve: count , point: string );


## Generated if a server uses a DH-anon or DHE cipher suite. This event contains
## the server DH parameters, contained in the ServerKeyExchange message as
## defined in :rfc:`5246`.
##
## c: The connection.
##
## p: The DH prime modulus.
##
## q: The DH generator.
##
## Ys: The server's DH public key.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_server_signature
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
##    ssl_rsa_client_pms
global ssl_dh_server_params: event(c: connection , p: string , q: string , Ys: string );


## Generated if a server uses a non-anonymous DHE or ECDHE cipher suite. This event
## contains the server signature over the key exchange parameters contained in
## the ServerKeyExchange message as defined in :rfc:`4492` and :rfc:`5246`.
##
## c: The connection.
##
## signature_and_hashalgorithm: signature and hash algorithm used for the
##                              digitally_signed struct. This field is only present
##                              starting with TLSv1.2 and DTLSv1.2. Earlier versions
##                              used a hardcoded hash algorithm. For protocol versions
##                              below D(TLS)v1.2 this field is filled with an dummy
##                              value of 256.
##
## signature: Signature part of the digitally_signed struct. The private key
##            corresponding to the certified public key in the server's certificate
##            message is used for signing.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_rsa_client_pms
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
global ssl_server_signature: event(c: connection , signature_and_hashalgorithm: SSL::SignatureAndHashAlgorithm , signature: string );


## Generated if a client uses an ECDH-anon or ECDHE cipher suite. This event
## contains the client ECDH public value contained in the ClientKeyExchange
## message as defined in :rfc:`4492`.
##
## c: The connection.
##
## point: The client's ECDH public key.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_server_signature
##    ssl_dh_client_params ssl_ecdh_server_params ssl_rsa_client_pms
global ssl_ecdh_client_params: event(c: connection , point: string );


## Generated if a client uses a DH-anon or DHE cipher suite. This event contains
## the client DH parameters contained in the ClientKeyExchange message as
## defined in :rfc:`5246`.
##
## c: The connection.
##
## Yc: The client's DH public key.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_server_signature
##    ssl_ecdh_server_params ssl_ecdh_client_params ssl_rsa_client_pms
global ssl_dh_client_params: event(c: connection , Yc: string );


## Generated if a client uses RSA key exchange. This event contains the client
## encrypted pre-master secret which is encrypted using the public key of the
## server's certificate as defined in :rfc:`5246`.
##
## c: The connection.
##
## pms: The encrypted pre-master secret.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_server_signature
##    ssl_dh_client_params ssl_ecdh_server_params ssl_ecdh_client_params
global ssl_rsa_client_pms: event(c: connection , pms: string );


## Generated for an SSL/TLS Application-Layer Protocol Negotiation extension.
## This TLS extension is defined in draft-ietf-tls-applayerprotoneg and sent in
## the initial handshake. It contains the list of client supported application
## protocols by the client or the server, respectively.
##
## At the moment it is mostly used to negotiate the use of SPDY / HTTP2.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## protocols: List of supported application layer protocols.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_server_name ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_extension_signed_certificate_timestamp
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_application_layer_protocol_negotiation: event(c: connection , is_client: bool , protocols: string_vec );


## Generated for an SSL/TLS Server Name extension. This SSL/TLS extension is
## defined in :rfc:`3546` and sent by the client in the initial handshake. It
## contains the name of the server it is contacting. This information can be
## used by the server to choose the correct certificate for the host the client
## wants to contact.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## names: A list of server names (DNS hostnames).
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_extension_signed_certificate_timestamp
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_server_name: event(c: connection , is_client: bool , names: string_vec );


## Generated for the signed_certificate_timestamp TLS extension as defined in
## :rfc:`6962`. The extension is used to transmit signed proofs that are
## used for Certificate Transparency.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## version: the version of the protocol to which the SCT conforms. Always
##          should be 0 (representing version 1)
##
## logid: 32 bit key id
##
## timestamp: the NTP Time when the entry was logged measured since
##            the epoch, ignoring leap seconds, in milliseconds.
##
## signature_and_hashalgorithm: signature and hash algorithm used for the
##                              digitally_signed struct
##
## signature: signature part of the digitally_signed struct
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_server_name ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
##    ssl_extension_application_layer_protocol_negotiation
##    x509_ocsp_ext_signed_certificate_timestamp sct_verify
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_signed_certificate_timestamp: event(c: connection , is_client: bool , version: count , logid: string , timestamp: count , signature_and_hashalgorithm: SSL::SignatureAndHashAlgorithm , signature: string );


## Generated for an TLS Supported Versions extension. This TLS extension
## is defined in the TLS 1.3 rfc and sent by the client in the initial handshake.
## It contains the TLS versions that it supports. This information can be used by
## the server to choose the best TLS version o use.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## versions: List of supported TLS versions.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share ssl_extension_server_name
##    ssl_extension_psk_key_exchange_modes ssl_extension_signed_certificate_timestamp
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_supported_versions: event(c: connection , is_client: bool , versions: index_vec );


## Generated for an TLS Pre-Shared Key Exchange Modes extension. This TLS extension is defined
## in the TLS 1.3 rfc and sent by the client in the initial handshake. It contains the
## list of Pre-Shared Key Exchange Modes that it supports.
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## versions: List of supported Pre-Shared Key Exchange Modes.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share ssl_extension_server_name
##    ssl_extension_supported_versions ssl_extension_signed_certificate_timestamp
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
##    ssl_extension_connection_id
global ssl_extension_psk_key_exchange_modes: event(c: connection , is_client: bool , modes: index_vec );


## Generated for an DTLS Connection ID extension. This TLS extension is defined
## in the RFC 9146 and sent by the client or the server to signify that Connection IDs should
## be used for the connection.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## cid: The connection ID given by the client or the server.
##
## .. zeek:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share ssl_extension_server_name
##    ssl_extension_supported_versions ssl_extension_signed_certificate_timestamp
##    ssl_extension_pre_shared_key_server_hello ssl_extension_pre_shared_key_client_hello
global ssl_extension_connection_id: event(c: connection , is_client: bool , cid: string );


## Generated at the end of an SSL/TLS handshake. SSL/TLS sessions start with
## an unencrypted handshake, and Zeek extracts as much information out of that
## as it can. This event signals the time when an SSL/TLS has finished the
## handshake and its endpoints consider it as fully established. Typically,
## everything from now on will be encrypted.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## .. zeek:see:: ssl_alert ssl_client_hello  ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate
global ssl_established: event(c: connection );


## Generated for SSL/TLS alert records. SSL/TLS sessions start with an
## unencrypted handshake, and Zeek extracts as much information out of that as
## it can. If during that handshake, an endpoint encounters a fatal error, it
## sends an *alert* record, that in turn triggers this event. After an *alert*,
## any endpoint may close the connection immediately.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## level: The severity level, as sent in the *alert*. The values are defined as
##        part of the SSL/TLS protocol.
##
## desc: A numerical value identifying the cause of the *alert*. The values are
##       defined as part of the SSL/TLS protocol.
##
## .. zeek:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake
global ssl_alert: event(c: connection , is_client: bool , level: count , desc: count );


## Generated for SSL/TLS handshake messages that are a part of the
## stateless-server session resumption mechanism. SSL/TLS sessions start with
## an unencrypted handshake, and Zeek extracts as much information out of that
## as it can. This event is raised when an SSL/TLS server passes a session
## ticket to the client that can later be used for resuming the session. The
## mechanism is described in :rfc:`4507`.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## ticket_lifetime_hint: A hint from the server about how long the ticket
##                       should be stored by the client.
##
## ticket: The raw ticket data.
##
## .. zeek:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert
global ssl_session_ticket_handshake: event(c: connection , ticket_lifetime_hint: count , ticket: string );


## Generated for SSL/TLS heartbeat messages that are sent before session
## encryption starts. Generally heartbeat messages should rarely be seen in
## normal TLS traffic. Heartbeats are described in :rfc:`6520`.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## length: length of the entire heartbeat message.
##
## heartbeat_type: type of the heartbeat message. Per RFC, 1 = request, 2 = response.
##
## payload_length: length of the payload of the heartbeat message, according to
##                 packet field.
##
## payload: payload contained in the heartbeat message. Size can differ from
##          payload_length, if payload_length and actual packet length disagree.
##
## .. zeek:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert ssl_encrypted_data
global ssl_heartbeat: event(c: connection , is_client: bool , length: count , heartbeat_type: count , payload_length: count , payload: string );


## Generated for SSL/TLS messages that are sent before full session encryption
## starts. Note that "full encryption" is a bit fuzzy, especially for TLSv1.3;
## here this event will be raised for early packets that are already using
## pre-encryption.  # This event is also used by Zeek internally to determine if
## the connection has been completely setup. This is necessary as TLS 1.3 does
## not have CCS anymore.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## record_version: TLS version given in the record layer of the message.
##                 Set to 0 for SSLv2.
##
## content_type: message type as reported by TLS session layer. Not populated for
##               SSLv2.
##
## length: length of the entire message.
##
## .. zeek:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert ssl_heartbeat
global ssl_plaintext_data: event(c: connection , is_client: bool , record_version: count , content_type: count , length: count );


## Generated for SSL/TLS messages that are sent after session encryption
## started.
##
## Note that :zeek:id:`SSL::disable_analyzer_after_detection` has to be changed
## from its default to false for this event to be generated.
##
## Also note that, for DTLS 1.3, it is not always possible to give an exact length for
## the payload that is transported in the packet. If connection IDs are used, the length
## provided is the length of the entire packet, without the first byte (for the unified header).
## If no connection IDs are used, the length given is the actual payload length. Connection IDs
## are used with the connection ID extension in the client or server hello.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## record_version: TLS version given in the record layer of the message.
##                 Set to 0 for SSLv2.
##
## content_type: message type as reported by TLS session layer. Not populated for
##               SSLv2.
##
## length: length of the encrypted payload in the record.
##
## .. zeek:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert ssl_heartbeat ssl_probable_encrypted_handshake_message
##    ssl_extension_connection_id
global ssl_encrypted_data: event(c: connection , is_client: bool , record_version: count , content_type: count , length: count );


## This event is generated for application data records of TLS 1.3 connections of which
## we suspect that they contain handshake messages.
##
## In TLS 1.3, large parts of the handshake are encrypted; the only cleartext packets
## typically exchanged are the client hello and the server hello. The first few packets
## after the client and server hello, however, are a continuation of the handshake and
## still include handshake data.
##
## This event is raised for these packets of which we suspect that they are handshake records,
## including the finished record.
##
## The heuristic for this is: all application data record after the server hello are
## handshake records until at least one application data record has been received
## from both the server and the client. Typically, the server will send more records
## before the client sends the first application data record; and the first application
## data record of the client will typically include the finished message.
##
## Given the encrypted nature of the protocol, in some cases this determination is
## not correct; the client can send more handshake packets before the finished message, e.g.,
## when client certificates are used.
##
## Note that :zeek:see:`ssl_encrypted_data` is also raised for these messages.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## length: length of the entire message.
##
## .. zeek:see::  ssl_client_hello ssl_established ssl_server_hello
##    ssl_encrypted_data
global ssl_probable_encrypted_handshake_message: event(c: connection , is_client: bool , length: count );


## This event contains the OCSP response contained in a Certificate Status Request
## message, when the client requested OCSP stapling and the server supports it.
## See description in :rfc:`6066`.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## response: OCSP data.
global ssl_stapled_ocsp: event(c: connection , is_client: bool , response: string );


## This event is raised for each unencrypted SSL/TLS handshake message.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## msg_type: Type of the handshake message that was seen.
##
## length: Length of the handshake message that was seen.
##
## .. zeek:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_client_hello
##    ssl_change_cipher_spec ssl_connection_flipped ssl_certificate_request
global ssl_handshake_message: event(c: connection , is_client: bool , msg_type: count , length: count );


## This event is raised when a SSL/TLS ChangeCipherSpec message is encountered
## before encryption begins. Traffic will be encrypted following this message.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## .. zeek:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_client_hello
##    ssl_handshake_message
global ssl_change_cipher_spec: event(c: connection , is_client: bool );


## Zeek typically assumes that the originator of a connection is the client of the SSL/TLS
## session. In some scenarios this does not hold, and the responder of a connection is the
## client, and the initiator is the server.
##
## In these cases, Zeek raises this event. Connection direction is detected by looking at the
## server hello, client hello, and hello request handshake messages.
##
## c: The connection.
##
## .. zeek:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_client_hello
##    ssl_handshake_message
global ssl_connection_flipped: event(c: connection );


## This event is raised, when a Certificate Request handshake message is encountered. This
## Message can be used by a TLS server to request a client certificate.
##
## c: The connection.
##
## is_client: True if event is raised for the client side of the connection
##            (the side that sends the client hello). This is typically equivalent
##            with the originator, but does not have to be in all circumstances.
##
## certificate_types: List of the types of certificates that the client may offer.
##
## supported_signature_algorithms: List of hash/sighature algorithm pairs that the server
##                                 supports, listed in descending order of preferences.
##
## certificate_authorities: List of distinguished names of certificate authorities that are
##                          acceptable to the server. The individual entries are DER encoded.
##                          :zeek:id:`parse_distinguished_name` can be used to decode the strings.
##
## .. zeek:see:: ssl_handshake_message x509_certificate ssl_server_hello ssl_client_hello
##               parse_distinguished_name
global ssl_certificate_request: event(c: connection , is_client: bool , certificate_types: index_vec , supported_signature_algorithms: signature_and_hashalgorithm_vec , certificate_authorities: string_vec );


} # end of export section
module GLOBAL;
