/* SPDX-FileCopyrightText: 2009 - Jesse van den Kieboom
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>
#include <gtksourceview/gtksourcegutterrenderer.h>
#include <gtksourceview/gtksourcetypes.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_GUTTER			(gtk_source_gutter_get_type ())
#define GTK_SOURCE_GUTTER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_GUTTER, GtkSourceGutter))
#define GTK_SOURCE_GUTTER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_GUTTER, GtkSourceGutterClass))
#define GTK_SOURCE_IS_GUTTER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_GUTTER))
#define GTK_SOURCE_IS_GUTTER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_GUTTER))
#define GTK_SOURCE_GUTTER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_GUTTER, GtkSourceGutterClass))

typedef struct _GtkSourceGutter         GtkSourceGutter;
typedef struct _GtkSourceGutterClass    GtkSourceGutterClass;
typedef struct _GtkSourceGutterPrivate  GtkSourceGutterPrivate;

struct _GtkSourceGutter
{
	GObject parent;

	GtkSourceGutterPrivate *priv;
};

struct _GtkSourceGutterClass
{
	GObjectClass parent_class;

	gpointer padding[1];
};

G_MODULE_EXPORT
GType gtk_source_gutter_get_type 		(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceView *
     gtk_source_gutter_get_view			(GtkSourceGutter         *gutter);

G_MODULE_EXPORT
GtkTextWindowType
     gtk_source_gutter_get_window_type		(GtkSourceGutter         *gutter);

G_MODULE_EXPORT
gboolean gtk_source_gutter_insert               (GtkSourceGutter         *gutter,
                                                 GtkSourceGutterRenderer *renderer,
                                                 gint                     position);

G_MODULE_EXPORT
void gtk_source_gutter_reorder			(GtkSourceGutter	 *gutter,
                                                 GtkSourceGutterRenderer *renderer,
                                                 gint                     position);

G_MODULE_EXPORT
void gtk_source_gutter_remove			(GtkSourceGutter         *gutter,
                                                 GtkSourceGutterRenderer *renderer);

G_MODULE_EXPORT
void gtk_source_gutter_queue_draw		(GtkSourceGutter         *gutter);

G_MODULE_EXPORT
GtkSourceGutterRenderer *
     gtk_source_gutter_get_renderer_at_pos      (GtkSourceGutter         *gutter,
                                                 gint                     x,
                                                 gint                     y);

G_END_DECLS
