/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.http.auth.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.AuthenticationManager;
import org.openhab.core.auth.Credentials;
import org.openhab.core.io.http.Handler;
import org.openhab.core.io.http.HandlerContext;
import org.openhab.core.io.http.auth.CredentialsExtractor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.openhab.auth"})
public class AuthenticationHandler
implements Handler {
    private static final String AUTHENTICATION_ENABLED = "enabled";
    private static final String AUTHENTICATION_ENDPOINT = "loginUri";
    private static final String DEFAULT_LOGIN_URI = "/login";
    static final String REDIRECT_PARAM_NAME = "redirect";
    private final Logger logger = LoggerFactory.getLogger(AuthenticationHandler.class);
    private final List<CredentialsExtractor<HttpServletRequest>> extractors = new CopyOnWriteArrayList<CredentialsExtractor<HttpServletRequest>>();
    private AuthenticationManager authenticationManager;
    private boolean enabled = false;
    private String loginUri = "/login";

    public int getPriority() {
        return 100;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerContext context) throws Exception {
        String requestUri = request.getRequestURI();
        if (this.enabled && this.isSecured(requestUri, request.getMethod())) {
            if (this.authenticationManager == null) {
                throw new AuthenticationException("Failed to authenticate request.");
            }
            int found = 0;
            int failed = 0;
            for (CredentialsExtractor<HttpServletRequest> extractor : this.extractors) {
                Optional<Credentials> extracted = extractor.retrieveCredentials(request);
                if (!extracted.isPresent()) continue;
                ++found;
                Credentials credentials = extracted.get();
                try {
                    Authentication authentication = this.authenticationManager.authenticate(credentials);
                    request.setAttribute(Authentication.class.getName(), (Object)authentication);
                    context.execute(request, response);
                    return;
                }
                catch (AuthenticationException e) {
                    ++failed;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Failed to authenticate using credentials {}", (Object)credentials, (Object)e);
                        continue;
                    }
                    this.logger.info("Failed to authenticate using credentials {}", (Object)credentials);
                }
            }
            throw new AuthenticationException("Could not authenticate request. Found " + found + " credentials in request out of which " + failed + " were invalid");
        }
    }

    public void handleError(HttpServletRequest request, HttpServletResponse response, HandlerContext context) {
        Object error = request.getAttribute("handler.error");
        if (response.getStatus() == 403 || response.getStatus() == 401) {
            return;
        }
        if (error instanceof AuthenticationException) {
            String redirectUri = this.loginUri + "?redirect=" + request.getRequestURI();
            response.setHeader("Location", redirectUri);
            try {
                PrintWriter writer = response.getWriter();
                writer.println("<html><head>");
                writer.println("<meta http-equiv=\"refresh\" content=\"0; url=" + redirectUri + "\" />");
                writer.println("</head><body>Redirecting to login page</body></html>");
                writer.flush();
            }
            catch (IOException e) {
                this.logger.warn("Couldn't generate or send client response", (Throwable)e);
            }
        } else {
            context.execute(request, response);
        }
    }

    private boolean isSecured(String requestUri, String method) {
        return !requestUri.startsWith(this.loginUri) || "post".equalsIgnoreCase(method);
    }

    @Activate
    void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    void modified(Map<String, Object> properties) {
        Object loginUri;
        Object authenticationEnabled = properties.get(AUTHENTICATION_ENABLED);
        if (authenticationEnabled != null) {
            this.enabled = Boolean.parseBoolean(authenticationEnabled.toString());
        }
        if ((loginUri = properties.get(AUTHENTICATION_ENDPOINT)) instanceof String) {
            String string;
            this.loginUri = string = (String)loginUri;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void unsetAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(context=javax.servlet.http.HttpServletRequest)")
    public void addCredentialsExtractor(CredentialsExtractor<HttpServletRequest> extractor) {
        this.extractors.add(extractor);
    }

    public void removeCredentialsExtractor(CredentialsExtractor<HttpServletRequest> extractor) {
        this.extractors.remove(extractor);
    }
}

