/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortDirection;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.results.internal.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.internal.InsertHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmInsertStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.jboss.logging.Logger;

public class TableBasedInsertHandler
extends AbstractMutationHandler
implements InsertHandler {
    private static final Logger log = Logger.getLogger(TableBasedInsertHandler.class);
    private final TemporaryTable entityTable;
    private final TemporaryTableStrategy temporaryTableStrategy;
    private final boolean forceDropAfterUse;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> resolvedParameterMappingModelTypes;
    private final @Nullable JdbcParameter sessionUidParameter;
    private final CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> temporaryTableInsert;
    private final RootTableInserter rootTableInserter;
    private final List<JdbcOperationQueryMutation> nonRootTableInserts;

    public TableBasedInsertHandler(SqmInsertStatement<?> sqmInsert, DomainParameterXref domainParameterXref, TemporaryTable entityTable, TemporaryTableStrategy temporaryTableStrategy, boolean forceDropAfterUse, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        super(sqmInsert, context.getSession().getSessionFactory());
        this.temporaryTableStrategy = temporaryTableStrategy;
        this.forceDropAfterUse = forceDropAfterUse;
        this.entityTable = entityTable;
        this.sessionUidAccess = sessionUidAccess;
        TemporaryTableSessionUidColumn sessionUidColumn = entityTable.getSessionUidColumn();
        this.sessionUidParameter = sessionUidColumn == null ? null : new SqlTypedMappingJdbcParameter(sessionUidColumn);
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(this.getEntityDescriptor(), (SqmStatement<?>)sqmInsert, (SqmRoot<?>)sqmInsert.getTarget(), domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.getSessionFactory().getSqlTranslationEngine());
        TableGroup insertingTableGroup = sqmConverter.getMutatingTableGroup();
        ArrayList<Assignment> targetPathColumns = new ArrayList<Assignment>();
        NamedTableReference entityTableReference = new NamedTableReference(entityTable.getTableExpression(), "temptable_", true);
        InsertSelectStatement insertStatement = new InsertSelectStatement(entityTableReference);
        BaseSqmToSqlAstConverter.AdditionalInsertValues additionalInsertValues = sqmConverter.visitInsertionTargetPaths((assignable, columnReferences) -> {
            SqmPathInterpretation pathInterpretation = (SqmPathInterpretation)((Object)assignable);
            List<TemporaryTableColumn> columns = entityTable.findTemporaryTableColumns(this.getEntityDescriptor(), pathInterpretation.getExpressionType());
            for (TemporaryTableColumn column : columns) {
                insertStatement.addTargetColumnReference(new ColumnReference(entityTableReference, column.getColumnName(), column.getJdbcMapping()));
            }
            targetPathColumns.add(new Assignment((Assignable)assignable, (Expression)((Object)assignable)));
        }, sqmInsert, this.getEntityDescriptor(), insertingTableGroup);
        if (sqmInsert instanceof SqmInsertSelectStatement) {
            Object queryPart = sqmConverter.visitQueryPart((SqmQueryPart)((SqmInsertSelectStatement)sqmInsert).getSelectQueryPart());
            ((QueryPart)queryPart).visitQuerySpecs(querySpec -> {
                if (additionalInsertValues.applySelections((QuerySpec)querySpec, this.getSessionFactory())) {
                    TemporaryTableColumn rowNumberColumn = entityTable.getColumns().get(entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping());
                    insertStatement.getTargetColumns().set(insertStatement.getTargetColumns().size() - 1, columnReference);
                    targetPathColumns.set(targetPathColumns.size() - 1, new Assignment(columnReference, columnReference));
                } else {
                    OnExecutionGenerator generator;
                    Generator patt0$temp = this.getEntityDescriptor().getGenerator();
                    if (!(patt0$temp instanceof OnExecutionGenerator && (generator = (OnExecutionGenerator)patt0$temp).generatedOnExecution() || entityTable.isRowNumberGenerated())) {
                        TemporaryTableColumn rowNumberColumn = entityTable.getColumns().get(entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                        ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping());
                        insertStatement.getTargetColumns().add(columnReference);
                        targetPathColumns.add(new Assignment(columnReference, columnReference));
                        querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, SqmInsertStrategyHelper.createRowNumberingExpression(querySpec, this.getSessionFactory())));
                    }
                }
                if (sessionUidColumn != null) {
                    ColumnReference sessionUidColumnReference = new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping());
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(insertStatement.getTargetColumns().size(), this.sessionUidParameter));
                    insertStatement.getTargetColumns().add(sessionUidColumnReference);
                    targetPathColumns.add(new Assignment(sessionUidColumnReference, this.sessionUidParameter));
                }
            });
            insertStatement.setSourceSelectStatement((QueryPart)queryPart);
        } else {
            BasicType rowNumberType;
            OnExecutionGenerator generator;
            Generator generator2 = this.getEntityDescriptor().getGenerator();
            if (!(generator2 instanceof OnExecutionGenerator && (generator = (OnExecutionGenerator)generator2).generatedOnExecution() || entityTable.isRowNumberGenerated())) {
                TemporaryTableColumn rowNumberColumn = entityTable.getColumns().get(entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                rowNumberType = (BasicType)rowNumberColumn.getJdbcMapping();
                ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping());
                insertStatement.getTargetColumns().add(columnReference);
                targetPathColumns.add(new Assignment(columnReference, columnReference));
            } else {
                rowNumberType = null;
            }
            if (sessionUidColumn != null) {
                ColumnReference sessionUidColumnReference = new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping());
                insertStatement.getTargetColumns().add(sessionUidColumnReference);
                targetPathColumns.add(new Assignment(sessionUidColumnReference, this.sessionUidParameter));
            }
            List<SqmValues> sqmValuesList = ((SqmInsertValuesStatement)sqmInsert).getValuesList();
            ArrayList valuesList = new ArrayList(sqmValuesList.size());
            for (int i = 0; i < sqmValuesList.size(); ++i) {
                Values values = sqmConverter.visitValues(sqmValuesList.get(i));
                additionalInsertValues.applyValues(values);
                if (rowNumberType != null) {
                    values.getExpressions().add(new QueryLiteral(rowNumberType.getJavaTypeDescriptor().wrap(i + 1, this.getSessionFactory().getWrapperOptions()), rowNumberType));
                }
                if (this.sessionUidParameter != null) {
                    values.getExpressions().add(this.sessionUidParameter);
                }
                valuesList.add(values);
            }
            insertStatement.setValuesList(valuesList);
        }
        Object conflictClause = sqmConverter.visitConflictClause((SqmConflictClause)sqmInsert.getConflictClause());
        sqmConverter.pruneTableGroupJoins();
        boolean assignsId = false;
        for (Assignment assignment : targetPathColumns) {
            SqmPathInterpretation pathInterpretation;
            Assignable assignable2;
            assignsId = assignsId || (assignable2 = assignment.getAssignable()) instanceof SqmPathInterpretation && SqmMutationStrategyHelper.isId((pathInterpretation = (SqmPathInterpretation)((Object)assignable2)).getExpressionType());
        }
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(insertingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(insertingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < insertingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(insertingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        ModelPartContainer updatingModelPart = insertingTableGroup.getModelPart();
        assert (updatingModelPart instanceof EntityMappingType);
        HashMap<String, List<Assignment>> assignmentsByTable = CollectionHelper.mapOfSize(insertingTableGroup.getTableReferenceJoins().size() + 1);
        this.domainParameterXref = domainParameterXref;
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmConverter);
        this.resolvedParameterMappingModelTypes = sqmConverter.getSqmParameterMappingModelExpressibleResolutions();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedInsertHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(entityTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(sessionUidAccess.apply(context.getSession()))));
        }
        for (int i = 0; i < targetPathColumns.size(); ++i) {
            Assignment assignment = (Assignment)targetPathColumns.get(i);
            Assignable assignable3 = assignment.getAssignable();
            List<ColumnReference> assignmentColumnRefs = assignable3.getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new SemanticException("Assignment referred to columns from multiple tables: " + i);
                }
                assignmentTableReference = tableReference;
            }
            assignmentsByTable.computeIfAbsent(assignmentTableReference == null ? null : assignmentTableReference.getTableId(), k -> new ArrayList()).add(assignment);
        }
        this.temporaryTableInsert = ExecuteWithTemporaryTableHelper.createTemporaryTableInsert(insertStatement, jdbcParameterBindings, executionContext);
        int tableSpan = this.getEntityDescriptor().getTableSpan();
        this.rootTableInserter = this.createRootTableInserter(insertStatement, insertingTableGroup, (ConflictClause)conflictClause, assignsId, this.getEntityDescriptor().getTableName(0), this.getEntityDescriptor().getKeyColumns(0), assignmentsByTable, executionContext);
        ArrayList<JdbcOperationQueryMutation> nonRootTableInserts = new ArrayList<JdbcOperationQueryMutation>(tableSpan);
        if (this.getEntityDescriptor().hasDuplicateTables()) {
            Object[] insertedTables = new String[tableSpan];
            insertedTables[0] = this.getEntityDescriptor().getTableName(0);
            for (int i = 1; i < tableSpan; ++i) {
                JdbcOperationQueryMutation insert;
                String tableName;
                if (this.getEntityDescriptor().isInverseTable(i)) continue;
                insertedTables[i] = tableName = this.getEntityDescriptor().getTableName(i);
                if (ArrayHelper.indexOf(insertedTables, i, tableName) != -1 || (insert = this.createTableInsert(insertStatement, insertingTableGroup, tableName, this.getEntityDescriptor().getKeyColumns(i), this.getEntityDescriptor().isNullableTable(i), assignmentsByTable, executionContext)) == null) continue;
                nonRootTableInserts.add(insert);
            }
        } else {
            for (int i = 1; i < tableSpan; ++i) {
                JdbcOperationQueryMutation insert = this.createTableInsert(insertStatement, insertingTableGroup, this.getEntityDescriptor().getTableName(i), this.getEntityDescriptor().getKeyColumns(i), this.getEntityDescriptor().isNullableTable(i), assignmentsByTable, executionContext);
                if (insert == null) continue;
                nonRootTableInserts.add(insert);
            }
        }
        this.nonRootTableInserts = nonRootTableInserts;
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    private RootTableInserter createRootTableInserter(InsertSelectStatement translatedInsertStatement, TableGroup updatingTableGroup, ConflictClause conflictClause, boolean assignsId, String tableExpression, String[] keyColumns, Map<String, List<Assignment>> assignmentsByTable, ExecutionContext executionContext) {
        JdbcOperationQueryMutation temporaryTableIdentityUpdate;
        String rootTableInsertWithReturningSql;
        ArrayList<Assignment> temporaryTableAssignments;
        SqlTypedMappingJdbcParameter rootIdentity;
        String temporaryTableRowNumberSelectSql;
        JdbcOperationQueryMutation temporaryTableIdUpdate;
        JdbcOperationQuerySelect temporaryTableIdentitySelect;
        TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true);
        Generator generator = this.getEntityDescriptor().getGenerator();
        List<Assignment> assignments = assignmentsByTable.get(tableExpression);
        if (!(assignsId || assignments != null && !assignments.isEmpty() || generator.generatedOnExecution() || generator instanceof BulkInsertionCapableIdentifierGenerator && !((BulkInsertionCapableIdentifierGenerator)generator).supportsBulkInsertionIdentifierGeneration())) {
            throw new IllegalStateException("There must be at least a single root table assignment");
        }
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        QuerySpec querySpec = new QuerySpec(true);
        NamedTableReference temporaryTableReference = new NamedTableReference(translatedInsertStatement.getTargetTable().getTableExpression(), "hte_tmp");
        TableGroupImpl temporaryTableGroup = new TableGroupImpl(updatingTableGroup.getNavigablePath(), null, temporaryTableReference, this.getEntityDescriptor());
        querySpec.getFromClause().addRoot(temporaryTableGroup);
        if (translatedInsertStatement.getValuesList().size() == 1 && conflictClause != null) {
            querySpec.setFetchClauseExpression(new QueryLiteral<Integer>(1, executionContext.getSession().getFactory().getQueryEngine().getCriteriaBuilder().getIntegerType()), FetchClauseType.ROWS_ONLY);
        }
        InsertSelectStatement insertStatement = new InsertSelectStatement(dmlTableReference);
        insertStatement.setConflictClause(conflictClause);
        insertStatement.setSourceSelectStatement(querySpec);
        this.applyAssignments(assignments, insertStatement, temporaryTableReference, this.getEntityDescriptor());
        JdbcServices jdbcServices = this.getSessionFactory().getJdbcServices();
        SharedSessionContractImplementor session = executionContext.getSession();
        if (!assignsId && generator.generatedOnExecution()) {
            identifierMapping = (BasicEntityIdentifierMapping)this.getEntityDescriptor().getIdentifierMapping();
            QuerySpec idSelectQuerySpec = new QuerySpec(true);
            idSelectQuerySpec.getFromClause().addRoot(temporaryTableGroup);
            ColumnReference columnReference = new ColumnReference((String)null, "HTE_IDENTITY", false, null, identifierMapping.getJdbcMapping());
            idSelectQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, columnReference));
            idSelectQuerySpec.addSortSpecification(new SortSpecification(columnReference, SortDirection.ASCENDING));
            if (this.entityTable.getSessionUidColumn() != null) {
                TemporaryTableSessionUidColumn sessionUidColumn = this.entityTable.getSessionUidColumn();
                idSelectQuerySpec.applyPredicate(new ComparisonPredicate(new ColumnReference(temporaryTableReference, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping()), ComparisonOperator.EQUAL, this.sessionUidParameter));
            }
            SelectStatement selectStatement = new SelectStatement(idSelectQuerySpec, Collections.singletonList(new BasicFetch(0, null, null, (BasicValuedModelPart)((Object)identifierMapping), FetchTiming.IMMEDIATE, null, false)));
            temporaryTableIdentitySelect = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), selectStatement).translate(null, executionContext.getQueryOptions());
            temporaryTableIdUpdate = null;
            temporaryTableRowNumberSelectSql = null;
            querySpec.applyPredicate(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, new SqlTypedMappingJdbcParameter((SqlTypedMapping)((Object)identifierMapping))));
        } else {
            temporaryTableIdentitySelect = null;
            if (insertStatement.getTargetColumns().stream().noneMatch(c -> keyColumns[0].equals(c.getColumnExpression()))) {
                ComparisonPredicate sessionUidPredicate;
                identifierMapping = this.getEntityDescriptor().getIdentifierMapping();
                List<TemporaryTableColumn> primaryKeyTableColumns = this.getPrimaryKeyTableColumns(this.getEntityDescriptor(), this.entityTable);
                if (this.entityTable.getSessionUidColumn() == null) {
                    sessionUidColumn = null;
                    sessionUidPredicate = null;
                } else {
                    sessionUidColumn = this.entityTable.getSessionUidColumn();
                    sessionUidPredicate = new ComparisonPredicate(new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping()), ComparisonOperator.EQUAL, this.sessionUidParameter);
                }
                if (this.needsIdentifierGeneration(generator, assignsId)) {
                    BasicEntityIdentifierMapping basicIdentifierMapping = (BasicEntityIdentifierMapping)identifierMapping;
                    rootIdentity = new SqlTypedMappingJdbcParameter(basicIdentifierMapping);
                    temporaryTableAssignments = new ArrayList<Assignment>(1);
                    ColumnReference idColumnReference = new ColumnReference((String)null, (SelectableMapping)basicIdentifierMapping);
                    temporaryTableAssignments.add(new Assignment(idColumnReference, rootIdentity));
                    int rowNumberIndex = this.entityTable.getColumns().size() - (this.entityTable.getSessionUidColumn() == null ? 1 : 2);
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(rowNumberIndex);
                    SqlTypedMappingJdbcParameter rowNumber = new SqlTypedMappingJdbcParameter(rowNumberColumn);
                    UpdateStatement updateStatement = new UpdateStatement(temporaryTableReference, temporaryTableAssignments, Predicate.combinePredicates(new ComparisonPredicate(new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, rowNumberColumn.getJdbcMapping()), ComparisonOperator.EQUAL, rowNumber), sessionUidPredicate));
                    temporaryTableIdUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(this.getSessionFactory(), updateStatement).translate(null, executionContext.getQueryOptions());
                    temporaryTableRowNumberSelectSql = ExecuteWithTemporaryTableHelper.createInsertedRowNumbersSelectSql(this.entityTable, this.sessionUidAccess, executionContext);
                } else {
                    temporaryTableIdUpdate = null;
                    temporaryTableRowNumberSelectSql = null;
                }
                identifierMapping.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                    insertStatement.addTargetColumnReferences(new ColumnReference((String)null, keyColumns[selectionIndex], false, null, selectableMapping.getJdbcMapping()));
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference(temporaryTableReference.getIdentificationVariable(), ((TemporaryTableColumn)primaryKeyTableColumns.get(selectionIndex)).getColumnName(), false, null, selectableMapping.getJdbcMapping())));
                });
            } else {
                temporaryTableIdUpdate = null;
                temporaryTableRowNumberSelectSql = null;
            }
        }
        if (this.entityTable.getSessionUidColumn() != null) {
            TemporaryTableSessionUidColumn sessionUidColumn = this.entityTable.getSessionUidColumn();
            querySpec.applyPredicate(new ComparisonPredicate(new ColumnReference(temporaryTableReference, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping()), ComparisonOperator.EQUAL, this.sessionUidParameter));
        }
        JdbcOperationQueryMutation rootTableInsert = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(this.getSessionFactory(), insertStatement).translate(null, executionContext.getQueryOptions());
        if (!assignsId && generator.generatedOnExecution()) {
            GeneratedValuesMutationDelegate insertDelegate = this.getEntityDescriptor().getInsertDelegate();
            InsertGeneratedIdentifierDelegate identifierDelegate = (InsertGeneratedIdentifierDelegate)insertDelegate;
            rootTableInsertWithReturningSql = identifierDelegate.prepareIdentifierGeneratingInsert(rootTableInsert.getSqlString());
            BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.getEntityDescriptor().getIdentifierMapping();
            List<TemporaryTableColumn> primaryKeyTableColumns = this.getPrimaryKeyTableColumns(this.getEntityDescriptor(), this.entityTable);
            assert (primaryKeyTableColumns.size() == 1);
            SqlTypedMappingJdbcParameter entityIdentity = new SqlTypedMappingJdbcParameter(identifierMapping);
            rootIdentity = new SqlTypedMappingJdbcParameter(identifierMapping);
            temporaryTableAssignments = new ArrayList(1);
            temporaryTableAssignments.add(new Assignment(new ColumnReference((String)null, primaryKeyTableColumns.get(0).getColumnName(), false, null, primaryKeyTableColumns.get(0).getJdbcMapping()), rootIdentity));
            UpdateStatement updateStatement = new UpdateStatement(temporaryTableReference, temporaryTableAssignments, (Predicate)new ComparisonPredicate(new ColumnReference((String)null, "HTE_IDENTITY", false, null, identifierMapping.getJdbcMapping()), ComparisonOperator.EQUAL, entityIdentity));
            temporaryTableIdentityUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(this.getSessionFactory(), updateStatement).translate(null, executionContext.getQueryOptions());
        } else {
            rootTableInsertWithReturningSql = null;
            temporaryTableIdentityUpdate = null;
        }
        return new RootTableInserter(temporaryTableIdentitySelect, temporaryTableIdUpdate, temporaryTableRowNumberSelectSql, rootTableInsert, rootTableInsertWithReturningSql, temporaryTableIdentityUpdate);
    }

    private boolean needsIdentifierGeneration(Generator identifierGenerator, boolean assignsId) {
        if (!assignsId && identifierGenerator instanceof OptimizableGenerator) {
            Optimizer optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer();
            return optimizer != null && optimizer.getIncrementSize() > 1 || identifierGenerator instanceof BulkInsertionCapableIdentifierGenerator && !((BulkInsertionCapableIdentifierGenerator)identifierGenerator).supportsBulkInsertionIdentifierGeneration();
        }
        return false;
    }

    private JdbcOperationQueryMutation createTableInsert(InsertSelectStatement translatedInsertStatement, TableGroup updatingTableGroup, String tableExpression, String[] keyColumns, boolean nullableTable, Map<String, List<Assignment>> assignmentsByTable, ExecutionContext executionContext) {
        TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true);
        List<Assignment> assignments = assignmentsByTable.get(tableExpression);
        if (nullableTable && (assignments == null || assignments.isEmpty())) {
            return null;
        }
        NamedTableReference dmlTargetTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        QuerySpec querySpec = new QuerySpec(true);
        NamedTableReference temporaryTableReference = new NamedTableReference(translatedInsertStatement.getTargetTable().getTableExpression(), "hte_tmp");
        TableGroupImpl temporaryTableGroup = new TableGroupImpl(updatingTableGroup.getNavigablePath(), null, temporaryTableReference, this.getEntityDescriptor());
        querySpec.getFromClause().addRoot(temporaryTableGroup);
        InsertSelectStatement insertStatement = new InsertSelectStatement(dmlTargetTableReference);
        insertStatement.setSourceSelectStatement(querySpec);
        this.applyAssignments(assignments, insertStatement, temporaryTableReference, this.getEntityDescriptor());
        if (insertStatement.getTargetColumns().stream().noneMatch(c -> keyColumns[0].equals(c.getColumnExpression()))) {
            List<TemporaryTableColumn> primaryKeyTableColumns = this.getPrimaryKeyTableColumns(this.getEntityDescriptor().getEntityPersister(), this.entityTable);
            this.getEntityDescriptor().getIdentifierMapping().forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                insertStatement.addTargetColumnReferences(new ColumnReference((String)null, keyColumns[selectionIndex], false, null, selectableMapping.getJdbcMapping()));
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference(temporaryTableReference.getIdentificationVariable(), ((TemporaryTableColumn)primaryKeyTableColumns.get(selectionIndex)).getColumnName(), false, null, selectableMapping.getJdbcMapping())));
            });
        }
        if (this.entityTable.getSessionUidColumn() != null) {
            TemporaryTableSessionUidColumn sessionUidColumn = this.entityTable.getSessionUidColumn();
            querySpec.applyPredicate(new ComparisonPredicate(new ColumnReference(temporaryTableReference, sessionUidColumn.getColumnName(), false, null, sessionUidColumn.getJdbcMapping()), ComparisonOperator.EQUAL, this.sessionUidParameter));
        }
        JdbcServices jdbcServices = this.getSessionFactory().getJdbcServices();
        return jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(this.getSessionFactory(), insertStatement).translate(null, executionContext.getQueryOptions());
    }

    private List<TemporaryTableColumn> getPrimaryKeyTableColumns(EntityPersister entityPersister, TemporaryTable entityTable) {
        boolean identityColumn = entityPersister.getGenerator().generatedOnExecution();
        int startIndex = identityColumn ? 1 : 0;
        int endIndex = startIndex + entityPersister.getIdentifierMapping().getJdbcTypeCount();
        return entityTable.getColumns().subList(startIndex, endIndex);
    }

    private void applyAssignments(List<Assignment> assignments, InsertSelectStatement insertStatement, NamedTableReference temporaryTableReference, EntityPersister entityDescriptor) {
        if (assignments != null && !assignments.isEmpty()) {
            for (Assignment assignment : assignments) {
                Assignable assignable = assignment.getAssignable();
                insertStatement.addTargetColumnReferences(assignable.getColumnReferences());
                List<TemporaryTableColumn> columns = this.entityTable.findTemporaryTableColumns(this.getEntityDescriptor().getEntityPersister(), ((SqmPathInterpretation)((Object)assignable)).getExpressionType());
                for (TemporaryTableColumn temporaryTableColumn : columns) {
                    insertStatement.getSourceSelectStatement().getFirstQuerySpec().getSelectClause().addSqlSelection(new SqlSelectionImpl(new ColumnReference(temporaryTableReference.getIdentificationVariable(), temporaryTableColumn.getColumnName(), false, null, temporaryTableColumn.getJdbcMapping())));
                }
            }
        }
    }

    @Override
    public JdbcParameterBindings createJdbcParameterBindings(DomainQueryExecutionContext context) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedInsertHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.entityTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(context.getSession()))));
        }
        return jdbcParameterBindings;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        if (this.temporaryTableInsert.jdbcOperation().dependsOnParameterBindings()) {
            return true;
        }
        if (this.rootTableInserter.temporaryTableIdentitySelect != null && this.rootTableInserter.temporaryTableIdentitySelect.dependsOnParameterBindings()) {
            return true;
        }
        if (this.rootTableInserter.temporaryTableIdUpdate != null && this.rootTableInserter.temporaryTableIdUpdate.dependsOnParameterBindings()) {
            return true;
        }
        if (this.rootTableInserter.rootTableInsert.dependsOnParameterBindings()) {
            return true;
        }
        if (this.rootTableInserter.temporaryTableIdentityUpdate != null && this.rootTableInserter.temporaryTableIdentityUpdate.dependsOnParameterBindings()) {
            return true;
        }
        for (JdbcOperationQueryMutation delete : this.nonRootTableInserts) {
            if (!delete.dependsOnParameterBindings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (!this.temporaryTableInsert.jdbcOperation().isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return false;
        }
        if (this.rootTableInserter.temporaryTableIdentitySelect != null && this.rootTableInserter.temporaryTableIdentitySelect.isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return true;
        }
        if (this.rootTableInserter.temporaryTableIdUpdate != null && this.rootTableInserter.temporaryTableIdUpdate.isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return true;
        }
        if (this.rootTableInserter.rootTableInsert.isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return true;
        }
        if (this.rootTableInserter.temporaryTableIdentityUpdate != null && this.rootTableInserter.temporaryTableIdentityUpdate.isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return true;
        }
        for (JdbcOperationQueryMutation delete : this.nonRootTableInserts) {
            if (delete.isCompatibleWith(jdbcParameterBindings, queryOptions)) continue;
            return false;
        }
        return true;
    }

    private TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        if (columnReference.getQualifier() == null) {
            return null;
        }
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + String.valueOf(columnReference));
    }

    private NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional());
        }
        return (NamedTableReference)tableReference;
    }

    public SqmInsertStatement<?> getSqmInsertStatement() {
        return (SqmInsertStatement)this.getSqmStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext context) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table insert execution - %s", (Object)((SqmRoot)this.getSqmStatement().getTarget()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        boolean createdTable = ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.entityTable, this.temporaryTableStrategy, (ExecutionContext)executionContext);
        try {
            int rows = ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(this.temporaryTableInsert.jdbcOperation(), jdbcParameterBindings, (ExecutionContext)executionContext);
            if (rows != 0) {
                JdbcParameterBindingsImpl sessionUidBindings = new JdbcParameterBindingsImpl(1);
                if (this.sessionUidParameter != null) {
                    sessionUidBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.sessionUidParameter.getExpressionType().getSingleJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(executionContext.getSession()))));
                }
                int insertedRows = this.insertRootTable(rows, createdTable, sessionUidBindings, executionContext);
                for (JdbcOperationQueryMutation nonRootTableInsert : this.nonRootTableInserts) {
                    this.insertTable(nonRootTableInsert, sessionUidBindings, executionContext);
                }
                int n = insertedRows;
                return n;
            }
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.entityTable, this.sessionUidAccess, this.getAfterUseAction(), executionContext);
        }
    }

    private int insertRootTable(int rows, boolean rowNumberStartsAtOne, final JdbcParameterBindings sessionUidBindings, final SqmJdbcExecutionContextAdapter executionContext) {
        LinkedHashMap entityTableToRootIdentity;
        EntityPersister entityPersister = this.getEntityDescriptor().getEntityPersister();
        Generator generator = entityPersister.getGenerator();
        EntityIdentifierMapping identifierMapping = entityPersister.getIdentifierMapping();
        final SharedSessionContractImplementor session = executionContext.getSession();
        JdbcServices jdbcServices = session.getFactory().getJdbcServices();
        if (this.rootTableInserter.temporaryTableIdentitySelect != null) {
            List list = jdbcServices.getJdbcSelectExecutor().list(this.rootTableInserter.temporaryTableIdentitySelect, sessionUidBindings, executionContext, null, null, ListResultsConsumer.UniqueSemantic.NONE, rows);
            entityTableToRootIdentity = new LinkedHashMap(list.size());
            for (Object o : list) {
                entityTableToRootIdentity.put(o, null);
            }
        } else {
            entityTableToRootIdentity = null;
            if (this.rootTableInserter.temporaryTableIdUpdate != null) {
                BeforeExecutionGenerator beforeExecutionGenerator = (BeforeExecutionGenerator)generator;
                IntStream rowNumberStream = !rowNumberStartsAtOne ? IntStream.of(ExecuteWithTemporaryTableHelper.loadInsertedRowNumbers(this.rootTableInserter.temporaryTableRowNumberSelectSql, this.entityTable, this.sessionUidAccess, rows, executionContext)) : IntStream.range(1, rows + 1);
                JdbcParameterBindingsImpl updateBindings = new JdbcParameterBindingsImpl(3);
                if (this.sessionUidParameter != null) {
                    updateBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.sessionUidParameter.getExpressionType().getSingleJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(session))));
                }
                List<JdbcParameterBinder> parameterBinders = this.rootTableInserter.temporaryTableIdUpdate.getParameterBinders();
                JdbcParameter rootIdentity = (JdbcParameter)((Object)parameterBinders.get(0));
                JdbcParameter jdbcParameter = (JdbcParameter)((Object)parameterBinders.get(1));
                BasicEntityIdentifierMapping basicIdentifierMapping = (BasicEntityIdentifierMapping)identifierMapping;
                rowNumberStream.forEach(rowNumberValue -> {
                    updateBindings.addBinding(rowNumber, new JdbcParameterBindingImpl(rowNumber.getExpressionType().getSingleJdbcMapping(), rowNumberValue));
                    updateBindings.addBinding(rootIdentity, new JdbcParameterBindingImpl(basicIdentifierMapping.getJdbcMapping(), beforeExecutionGenerator.generate(session, null, null, EventType.INSERT)));
                    int updateCount = jdbcServices.getJdbcMutationExecutor().execute(this.rootTableInserter.temporaryTableIdUpdate, updateBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
                    assert (updateCount == 1);
                });
            }
        }
        if (this.rootTableInserter.rootTableInsertWithReturningSql != null) {
            GeneratedValuesMutationDelegate insertDelegate = entityPersister.getEntityPersister().getInsertDelegate();
            BasicEntityIdentifierMapping basicIdentifierMapping = (BasicEntityIdentifierMapping)identifierMapping;
            InsertGeneratedIdentifierDelegate identifierDelegate = (InsertGeneratedIdentifierDelegate)insertDelegate;
            final ValueBinder jdbcValueBinder = basicIdentifierMapping.getJdbcMapping().getJdbcValueBinder();
            for (final Map.Entry entry : entityTableToRootIdentity.entrySet()) {
                GeneratedValues generatedValues = identifierDelegate.performInsertReturning(this.rootTableInserter.rootTableInsertWithReturningSql, session, new Binder(){

                    @Override
                    public void bindValues(PreparedStatement ps) throws SQLException {
                        jdbcValueBinder.bind(ps, entry.getKey(), 1, (WrapperOptions)session);
                        if (TableBasedInsertHandler.this.sessionUidParameter != null) {
                            TableBasedInsertHandler.this.sessionUidParameter.getParameterBinder().bindParameterValue(ps, 2, sessionUidBindings, executionContext);
                        }
                    }

                    @Override
                    public Object getEntity() {
                        return null;
                    }
                });
                Object rootIdentity = generatedValues.getGeneratedValue(identifierMapping);
                entry.setValue(rootIdentity);
            }
            JdbcParameterBindingsImpl updateBindings = new JdbcParameterBindingsImpl(2);
            List<JdbcParameterBinder> list = this.rootTableInserter.temporaryTableIdentityUpdate.getParameterBinders();
            JdbcParameter rootIdentity = (JdbcParameter)((Object)list.get(0));
            JdbcParameter entityIdentity = (JdbcParameter)((Object)list.get(1));
            for (Map.Entry entry : entityTableToRootIdentity.entrySet()) {
                JdbcMapping jdbcMapping = basicIdentifierMapping.getJdbcMapping();
                updateBindings.addBinding(entityIdentity, new JdbcParameterBindingImpl(jdbcMapping, entry.getKey()));
                updateBindings.addBinding(rootIdentity, new JdbcParameterBindingImpl(jdbcMapping, entry.getValue()));
                jdbcServices.getJdbcMutationExecutor().execute(this.rootTableInserter.temporaryTableIdentityUpdate, updateBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
            }
            return entityTableToRootIdentity.size();
        }
        return jdbcServices.getJdbcMutationExecutor().execute(this.rootTableInserter.rootTableInsert, sessionUidBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    private void insertTable(JdbcOperationQueryMutation nonRootTableInsert, JdbcParameterBindings sessionUidBindings, ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        JdbcServices jdbcServices = session.getFactory().getJdbcServices();
        jdbcServices.getJdbcMutationExecutor().execute(nonRootTableInsert, sessionUidBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    protected CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> getTemporaryTableInsert() {
        return this.temporaryTableInsert;
    }

    protected RootTableInserter getRootTableInserter() {
        return this.rootTableInserter;
    }

    protected List<JdbcOperationQueryMutation> getNonRootTableInserts() {
        return this.nonRootTableInserts;
    }

    protected TemporaryTable getEntityTable() {
        return this.entityTable;
    }

    protected TemporaryTableStrategy getTemporaryTableStrategy() {
        return this.temporaryTableStrategy;
    }

    protected Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    protected AfterUseAction getAfterUseAction() {
        return this.forceDropAfterUse ? AfterUseAction.DROP : this.temporaryTableStrategy.getTemporaryTableAfterUseAction();
    }

    protected @Nullable JdbcParameter getSessionUidParameter() {
        return this.sessionUidParameter;
    }

    protected record RootTableInserter(@Nullable JdbcOperationQuerySelect temporaryTableIdentitySelect, @Nullable JdbcOperationQueryMutation temporaryTableIdUpdate, @Nullable String temporaryTableRowNumberSelectSql, JdbcOperationQueryMutation rootTableInsert, @Nullable String rootTableInsertWithReturningSql, @Nullable JdbcOperationQueryMutation temporaryTableIdentityUpdate) {
    }
}

