/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateInteropXFilter2Test
extends TestCase {
    private XMLSignatureFactory fac;
    private KeyInfoFactory kifac;
    private DocumentBuilder db;
    private KeyStore ks;
    private Key signingKey;
    private PublicKey validatingKey;
    private Certificate signingCert;

    public CreateInteropXFilter2Test(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.fac = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        this.kifac = this.fac.getKeyInfoFactory();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        FileInputStream fileInputStream = new FileInputStream(string2 + string + "data" + string + "test.jks");
        this.ks = KeyStore.getInstance("JKS");
        this.ks.load(fileInputStream, "changeit".toCharArray());
        this.signingKey = this.ks.getKey("mullan", "changeit".toCharArray());
        this.signingCert = this.ks.getCertificate("mullan");
        this.validatingKey = this.signingCert.getPublicKey();
    }

    public void test_create_sign_spec() throws Exception {
        ArrayList<Reference> arrayList = new ArrayList<Reference>(2);
        ArrayList<XPathType> arrayList2 = new ArrayList<XPathType>(3);
        arrayList2.add(new XPathType(" //ToBeSigned ", XPathType.Filter.INTERSECT));
        arrayList2.add(new XPathType(" //NotToBeSigned ", XPathType.Filter.SUBTRACT));
        arrayList2.add(new XPathType(" //ReallyToBeSigned ", XPathType.Filter.UNION));
        XPathFilter2ParameterSpec xPathFilter2ParameterSpec = new XPathFilter2ParameterSpec(arrayList2);
        arrayList.add(this.fac.newReference("", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(this.fac.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xPathFilter2ParameterSpec)), null, null));
        ArrayList<Transform> arrayList3 = new ArrayList<Transform>(2);
        arrayList3.add(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        XPathFilter2ParameterSpec xPathFilter2ParameterSpec2 = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType(" / ", XPathType.Filter.UNION)));
        arrayList3.add(this.fac.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xPathFilter2ParameterSpec2));
        arrayList.add(this.fac.newReference("#signature-value", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), arrayList3, null, null));
        SignedInfo signedInfo = this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null), arrayList);
        ArrayList<XMLStructure> arrayList4 = new ArrayList<XMLStructure>(2);
        arrayList4.add(this.kifac.newKeyValue(this.validatingKey));
        ArrayList<Object> arrayList5 = new ArrayList<Object>(2);
        arrayList5.add("CN=Sean Mullan, DC=sun, DC=com");
        arrayList5.add(this.signingCert);
        arrayList4.add(this.kifac.newX509Data(arrayList5));
        KeyInfo keyInfo = this.kifac.newKeyInfo(arrayList4);
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, null, null, "signature-value");
        Document document = this.db.newDocument();
        Element element = document.createElementNS(null, "ToBeSigned");
        Comment comment = document.createComment(" comment ");
        Element element2 = document.createElementNS(null, "Data");
        Element element3 = document.createElementNS(null, "NotToBeSigned");
        Element element4 = document.createElementNS(null, "ReallyToBeSigned");
        Comment comment2 = document.createComment(" comment ");
        Element element5 = document.createElementNS(null, "Data");
        element4.appendChild(comment2);
        element4.appendChild(element5);
        element3.appendChild(element4);
        element.appendChild(comment);
        element.appendChild(element2);
        element.appendChild(element3);
        Element element6 = document.createElementNS(null, "ToBeSigned");
        Element element7 = document.createElementNS(null, "Data");
        Element element8 = document.createElementNS(null, "NotToBeSigned");
        Element element9 = document.createElementNS(null, "Data");
        element8.appendChild(element9);
        element6.appendChild(element7);
        element6.appendChild(element8);
        Element element10 = document.createElementNS(null, "Document");
        element10.appendChild(element);
        element10.appendChild(element6);
        document.appendChild(element10);
        DOMSignContext dOMSignContext = new DOMSignContext(this.signingKey, (Node)element10);
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeySelectors.KeyValueKeySelector(), element10.getLastChild());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateInteropXFilter2Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateInteropXFilter2Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

