'''OpenGL extension NV.mesh_shader

This module customises the behaviour of the 
OpenGL.raw.GL.NV.mesh_shader to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new mechanism allowing applications to use two
	new programmable shader types -- the task and mesh shader -- to generate
	collections of geometric primitives to be processed by fixed-function
	primitive assembly and rasterization logic.  When the task and mesh
	shaders are drawn, they replace the standard programmable vertex
	processing pipeline, including vertex array attribute fetching, vertex
	shader processing, tessellation, and the geometry shader processing.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/mesh_shader.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.mesh_shader import *
from OpenGL.raw.GL.NV.mesh_shader import _EXTENSION_NAME

def glInitMeshShaderNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION