/*
 * Decompiled with CFR 0.152.
 */
package scala.util.hashing;

import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.Hashing;
import scala.util.hashing.MurmurHash3$;

public class MurmurHash3 {
    public static Hashing<IterableOnce<Object>> unorderedHashing() {
        return MurmurHash3$.MODULE$.unorderedHashing();
    }

    public static Hashing<String> stringHashing() {
        return MurmurHash3$.MODULE$.stringHashing();
    }

    public static Hashing<Product> caseClassHashing() {
        return MurmurHash3$.MODULE$.caseClassHashing();
    }

    public static Hashing<Product> productHashing() {
        return MurmurHash3$.MODULE$.productHashing();
    }

    public static Hashing<IterableOnce<Object>> orderedHashing() {
        return MurmurHash3$.MODULE$.orderedHashing();
    }

    public static Hashing<byte[]> bytesHashing() {
        return MurmurHash3$.MODULE$.bytesHashing();
    }

    public static <T> ArrayHashing<T> arrayHashing() {
        return MurmurHash3$.MODULE$.arrayHashing();
    }

    public static int setHash(Set<?> xs) {
        return MurmurHash3$.MODULE$.setHash(xs);
    }

    public static int mapHash(Map<?, ?> xs) {
        return MurmurHash3$.MODULE$.mapHash(xs);
    }

    public static int seqHash(Seq<?> xs) {
        return MurmurHash3$.MODULE$.seqHash(xs);
    }

    public static String caseClassHash$default$2() {
        return MurmurHash3$.MODULE$.caseClassHash$default$2();
    }

    public static int setSeed() {
        return MurmurHash3$.MODULE$.setSeed();
    }

    public static int mapSeed() {
        return MurmurHash3$.MODULE$.mapSeed();
    }

    public static int seqSeed() {
        return MurmurHash3$.MODULE$.seqSeed();
    }

    public static int traversableSeed() {
        return MurmurHash3$.MODULE$.traversableSeed();
    }

    public static int symmetricSeed() {
        return MurmurHash3$.MODULE$.symmetricSeed();
    }

    public static int productSeed() {
        return MurmurHash3$.MODULE$.productSeed();
    }

    public static int stringSeed() {
        return MurmurHash3$.MODULE$.stringSeed();
    }

    public static int arraySeed() {
        return MurmurHash3$.MODULE$.arraySeed();
    }

    public final int mix(int hash, int data) {
        return Integer.rotateLeft(this.mixLast(hash, data), 13) * 5 + -430675100;
    }

    public final int mixLast(int hash, int data) {
        int k = data * -862048943;
        k = Integer.rotateLeft(k, 15);
        return hash ^ (k *= 461845907);
    }

    public final int finalizeHash(int hash, int length) {
        return this.scala$util$hashing$MurmurHash3$$avalanche(hash ^ length);
    }

    public final int scala$util$hashing$MurmurHash3$$avalanche(int hash) {
        int h = hash ^ hash >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    public int tuple2Hash(int x, int y, int seed) {
        int h = this.mix(seed, "Tuple2".hashCode());
        h = this.mix(h, x);
        h = this.mix(h, y);
        return this.finalizeHash(h, 2);
    }

    public final int productHash(Product x, int seed, boolean ignorePrefix) {
        int arr = x.productArity();
        if (arr == 0) {
            if (!ignorePrefix) {
                return x.productPrefix().hashCode();
            }
            return seed;
        }
        int h = seed;
        if (!ignorePrefix) {
            h = this.mix(seed, x.productPrefix().hashCode());
        }
        for (int i = 0; i < arr; ++i) {
            h = this.mix(h, Statics.anyHash(x.productElement(i)));
        }
        return this.finalizeHash(h, arr);
    }

    public final boolean productHash$default$3() {
        return false;
    }

    public final int caseClassHash(Product x, int seed, String caseClassName) {
        int arr = x.productArity();
        int aye = (caseClassName != null ? caseClassName : x.productPrefix()).hashCode();
        if (arr == 0) {
            return aye;
        }
        int h = this.mix(seed, aye);
        for (int i = 0; i < arr; ++i) {
            h = this.mix(h, Statics.anyHash(x.productElement(i)));
        }
        return this.finalizeHash(h, arr);
    }

    public final int stringHash(String str, int seed) {
        int h = seed;
        int i = 0;
        while (i + 1 < str.length()) {
            int data = (str.charAt(i) << 16) + str.charAt(i + 1);
            h = this.mix(h, data);
            i += 2;
        }
        if (i < str.length()) {
            h = this.mixLast(h, str.charAt(i));
        }
        return this.finalizeHash(h, str.length());
    }

    public final int unorderedHash(IterableOnce<Object> xs, int seed) {
        int a = 0;
        int b = 0;
        int n = 0;
        int c = 1;
        Iterator<Object> iterator = xs.iterator();
        while (iterator.hasNext()) {
            int h = Statics.anyHash(iterator.next());
            a += h;
            b ^= h;
            c *= h | 1;
            ++n;
        }
        int h = this.mix(seed, a);
        h = this.mix(h, b);
        h = this.mixLast(h, c);
        return this.finalizeHash(h, n);
    }

    public final int orderedHash(IterableOnce<Object> xs, int seed) {
        int h;
        Iterator<Object> it = xs.iterator();
        if (!it.hasNext()) {
            return this.finalizeHash(seed, 0);
        }
        Object x0 = it.next();
        if (!it.hasNext()) {
            return this.finalizeHash(this.mix(seed, Statics.anyHash(x0)), 1);
        }
        Object x1 = it.next();
        int initial = Statics.anyHash(x0);
        int h0 = h = this.mix(seed, initial);
        int prev = Statics.anyHash(x1);
        int rangeDiff = prev - initial;
        int i = 2;
        while (it.hasNext()) {
            h = this.mix(h, prev);
            int hash = Statics.anyHash(it.next());
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (it.hasNext()) {
                    h = this.mix(h, Statics.anyHash(it.next()));
                    ++i;
                }
                return this.finalizeHash(h, i);
            }
            prev = hash;
            ++i;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final <T> int arrayHash(Object a, int seed) {
        int h;
        int l = ScalaRunTime$.MODULE$.array_length(a);
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, 0))), 1);
            }
        }
        int initial = Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, 0));
        int h0 = h = this.mix(seed, initial);
        int prev = Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, 1));
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, i));
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, i)));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int rangeHash(int start, int step, int last, int seed) {
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(this.mix(seed, start), step), last));
    }

    public final int bytesHash(byte[] data, int seed) {
        int len;
        int h = seed;
        int i = 0;
        for (len = data.length; len >= 4; len -= 4) {
            int k = data[i + 0] & 0xFF;
            k |= (data[i + 1] & 0xFF) << 8;
            k |= (data[i + 2] & 0xFF) << 16;
            h = this.mix(h, k |= (data[i + 3] & 0xFF) << 24);
            i += 4;
        }
        int k = 0;
        if (len == 3) {
            k ^= (data[i + 2] & 0xFF) << 16;
        }
        if (len >= 2) {
            k ^= (data[i + 1] & 0xFF) << 8;
        }
        if (len >= 1) {
            h = this.mixLast(h, k ^= data[i + 0] & 0xFF);
        }
        return this.finalizeHash(h, data.length);
    }

    public final int indexedSeqHash(IndexedSeq<Object> a, int seed) {
        int h;
        int l = a.length();
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, Statics.anyHash(a.apply(false))), 1);
            }
        }
        int initial = Statics.anyHash(a.apply(false));
        int h0 = h = this.mix(seed, initial);
        int prev = Statics.anyHash(a.apply(true));
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.anyHash(a.apply(i));
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.anyHash(a.apply(i)));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int listHash(List<?> xs, int seed) {
        int n = 0;
        int h = seed;
        int rangeState = 0;
        int rangeDiff = 0;
        int prev = 0;
        int initial = 0;
        List elems = xs;
        while (!elems.isEmpty()) {
            Object head = elems.head();
            List tail = (List)elems.tail();
            int hash = Statics.anyHash(head);
            h = this.mix(h, hash);
            switch (rangeState) {
                case 0: {
                    initial = hash;
                    rangeState = 1;
                    break;
                }
                case 1: {
                    rangeDiff = hash - prev;
                    rangeState = 2;
                    break;
                }
                case 2: {
                    if (rangeDiff == hash - prev && rangeDiff != 0) break;
                    rangeState = 3;
                }
            }
            prev = hash;
            ++n;
            elems = tail;
        }
        if (rangeState == 2) {
            return this.rangeHash(initial, rangeDiff, prev, seed);
        }
        return this.finalizeHash(h, n);
    }

    public final int arrayHash$mZc$sp(boolean[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, a[0] ? 1231 : 1237), 1);
            }
        }
        int initial = a[0] ? 1231 : 1237;
        int h0 = h = this.mix(seed, initial);
        int prev = a[1] ? 1231 : 1237;
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            int hash;
            h = this.mix(h, prev);
            int n = hash = a[i] ? 1231 : 1237;
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, a[i] ? 1231 : 1237);
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mBc$sp(byte[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, a[0]), 1);
            }
        }
        byte initial = a[0];
        int h0 = h = this.mix(seed, initial);
        byte prev = a[1];
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            byte hash = a[i];
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, a[i]);
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mCc$sp(char[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, a[0]), 1);
            }
        }
        char initial = a[0];
        int h0 = h = this.mix(seed, initial);
        char prev = a[1];
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            char hash = a[i];
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, a[i]);
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mDc$sp(double[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, Statics.doubleHash(a[0])), 1);
            }
        }
        int initial = Statics.doubleHash(a[0]);
        int h0 = h = this.mix(seed, initial);
        int prev = Statics.doubleHash(a[1]);
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.doubleHash(a[i]);
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.doubleHash(a[i]));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mFc$sp(float[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, Statics.floatHash(a[0])), 1);
            }
        }
        int initial = Statics.floatHash(a[0]);
        int h0 = h = this.mix(seed, initial);
        int prev = Statics.floatHash(a[1]);
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.floatHash(a[i]);
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.floatHash(a[i]));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mIc$sp(int[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, a[0]), 1);
            }
        }
        int initial = a[0];
        int h0 = h = this.mix(seed, initial);
        int prev = a[1];
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = a[i];
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, a[i]);
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mJc$sp(long[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, Statics.longHash(a[0])), 1);
            }
        }
        int initial = Statics.longHash(a[0]);
        int h0 = h = this.mix(seed, initial);
        int prev = Statics.longHash(a[1]);
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.longHash(a[i]);
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.longHash(a[i]));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mSc$sp(short[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, a[0]), 1);
            }
        }
        short initial = a[0];
        int h0 = h = this.mix(seed, initial);
        short prev = a[1];
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            short hash = a[i];
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, a[i]);
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int arrayHash$mVc$sp(BoxedUnit[] a, int seed) {
        int h;
        int l = a.length;
        switch (l) {
            case 0: {
                return this.finalizeHash(seed, 0);
            }
            case 1: {
                return this.finalizeHash(this.mix(seed, 0), 1);
            }
        }
        int initial = 0;
        int h0 = h = this.mix(seed, initial);
        int prev = 0;
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = 0;
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, 0);
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.scala$util$hashing$MurmurHash3$$avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public static class ArrayHashing<T>
    implements Hashing<Object> {
        @Override
        public int hash(Object a) {
            return MurmurHash3$.MODULE$.arrayHash(a);
        }

        public int hash$mcZ$sp(boolean[] a) {
            return this.hash(a);
        }

        public int hash$mcB$sp(byte[] a) {
            return this.hash(a);
        }

        public int hash$mcC$sp(char[] a) {
            return this.hash(a);
        }

        public int hash$mcD$sp(double[] a) {
            return this.hash(a);
        }

        public int hash$mcF$sp(float[] a) {
            return this.hash(a);
        }

        public int hash$mcI$sp(int[] a) {
            return this.hash(a);
        }

        public int hash$mcJ$sp(long[] a) {
            return this.hash(a);
        }

        public int hash$mcS$sp(short[] a) {
            return this.hash(a);
        }

        public int hash$mcV$sp(BoxedUnit[] a) {
            return this.hash(a);
        }
    }
}

