/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.caps.unsafe$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.IterableOps$SizeCompareOps$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory$;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.util.Either;

public interface IterableOps<A, CC, C>
extends IterableOnce<A>,
IterableOnceOps<A, CC, C> {
    public static void $init$(IterableOps $this) {
    }

    public Iterable<A> toIterable();

    public static Iterable toTraversable$(IterableOps $this) {
        return $this.toTraversable();
    }

    default public Iterable<A> toTraversable() {
        return this.toIterable();
    }

    public static boolean isTraversableAgain$(IterableOps $this) {
        return $this.isTraversableAgain();
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    public C coll();

    public static Object repr$(IterableOps $this) {
        return $this.repr();
    }

    default public C repr() {
        return this.coll();
    }

    public C fromSpecific(IterableOnce<A> var1);

    public IterableFactory<CC> iterableFactory();

    public static IterableFactory companion$(IterableOps $this) {
        return $this.companion();
    }

    default public IterableFactory<CC> companion() {
        return this.iterableFactory();
    }

    public Builder<A, C> newSpecificBuilder();

    public static Object empty$(IterableOps $this) {
        return $this.empty();
    }

    default public C empty() {
        return this.fromSpecific(package$.MODULE$.Nil());
    }

    public static Object head$(IterableOps $this) {
        return $this.head();
    }

    default public A head() {
        return this.iterator().next();
    }

    public static Option headOption$(IterableOps $this) {
        return $this.headOption();
    }

    default public Option<A> headOption() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            return Some$.MODULE$.apply(it.next());
        }
        return None$.MODULE$;
    }

    public static Object last$(IterableOps $this) {
        return $this.last();
    }

    default public A last() {
        Iterator it = this.iterator();
        Object lst = it.next();
        while (it.hasNext()) {
            lst = it.next();
        }
        return lst;
    }

    public static Option lastOption$(IterableOps $this) {
        return $this.lastOption();
    }

    default public Option<A> lastOption() {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.last());
    }

    public static View view$(IterableOps $this) {
        return $this.view();
    }

    default public View<A> view() {
        return View$.MODULE$.fromIteratorProvider((Function0<Iterator> & Serializable)() -> this.iterator());
    }

    public static int sizeCompare$(IterableOps $this, int otherSize) {
        return $this.sizeCompare(otherSize);
    }

    default public int sizeCompare(int otherSize) {
        if (otherSize < 0) {
            return 1;
        }
        int known = this.knownSize();
        if (known >= 0) {
            return Integer.compare(known, otherSize);
        }
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (i == otherSize) {
                return 1;
            }
            it.next();
            ++i;
        }
        return i - otherSize;
    }

    public static IterableOps sizeIs$(IterableOps $this) {
        return $this.sizeIs();
    }

    default public IterableOps sizeIs() {
        return unsafe$.MODULE$.unsafeAssumePure(this);
    }

    public static int sizeCompare$(IterableOps $this, Iterable that) {
        return $this.sizeCompare(that);
    }

    default public int sizeCompare(Iterable<?> that) {
        int thatKnownSize = that.knownSize();
        if (thatKnownSize >= 0) {
            return this.sizeCompare(thatKnownSize);
        }
        int thisKnownSize = this.knownSize();
        if (thisKnownSize >= 0) {
            int res = that.sizeCompare(thisKnownSize);
            if (res == Integer.MIN_VALUE) {
                return 1;
            }
            return -res;
        }
        Iterator thisIt = this.iterator();
        Iterator thatIt = that.iterator();
        while (thisIt.hasNext() && thatIt.hasNext()) {
            thisIt.next();
            thatIt.next();
        }
        return Boolean.compare(thisIt.hasNext(), thatIt.hasNext());
    }

    public static View view$(IterableOps $this, int from, int until) {
        return $this.view(from, until);
    }

    default public View<A> view(int from, int until) {
        return (View)this.view().slice(from, until);
    }

    public static Object transpose$(IterableOps $this, Function1 asIterable) {
        return $this.transpose(asIterable);
    }

    default public <B> CC transpose(Function1<A, Iterable<B>> asIterable) {
        if (this.isEmpty()) {
            return this.iterableFactory().empty();
        }
        int headSize = ((IterableOnceOps)asIterable.apply(this.head())).size();
        IndexedSeq bs = (IndexedSeq)IndexedSeq$.MODULE$.fill(headSize, this::$anonfun$1);
        this.iterator().foreach(xs -> {
            IntRef i = IntRef.create(0);
            ((IterableOnceOps)asIterable.apply(xs)).foreach(x -> {
                if (i$1.elem >= headSize) {
                    throw IterableOps.fail$1();
                }
                ((Growable)bs.apply(i$1.elem)).$plus$eq(x);
                ++i$1.elem;
            });
            if (i.elem != headSize) {
                throw IterableOps.fail$1();
            }
        });
        return this.iterableFactory().from((IterableOnce)bs.map((Function1<Builder, Object> & Serializable)_$2 -> _$2.result()));
    }

    public static Object filter$(IterableOps $this, Function1 pred) {
        return $this.filter(pred);
    }

    @Override
    default public C filter(Function1<A, Object> pred) {
        return this.fromSpecific(new View.Filter<A>(this, pred, false));
    }

    public static Object filterNot$(IterableOps $this, Function1 pred) {
        return $this.filterNot(pred);
    }

    @Override
    default public C filterNot(Function1<A, Object> pred) {
        return this.fromSpecific(new View.Filter<A>(this, pred, true));
    }

    public static scala.collection.WithFilter withFilter$(IterableOps $this, Function1 p) {
        return $this.withFilter(p);
    }

    default public scala.collection.WithFilter<A, CC> withFilter(Function1<A, Object> p) {
        return new WithFilter(this, p);
    }

    public static Tuple2 partition$(IterableOps $this, Function1 p) {
        return $this.partition(p);
    }

    default public Tuple2<C, C> partition(Function1<A, Object> p) {
        View.Filter<A> first = new View.Filter<A>(this, p, false);
        View.Filter<A> second = new View.Filter<A>(this, p, true);
        return Tuple2$.MODULE$.apply(this.fromSpecific(first), this.fromSpecific(second));
    }

    public static Tuple2 splitAt$(IterableOps $this, int n) {
        return $this.splitAt(n);
    }

    @Override
    default public Tuple2<C, C> splitAt(int n) {
        return Tuple2$.MODULE$.apply(this.take(n), this.drop(n));
    }

    public static Object take$(IterableOps $this, int n) {
        return $this.take(n);
    }

    @Override
    default public C take(int n) {
        return this.fromSpecific(new View.Take(this, n));
    }

    public static Object takeRight$(IterableOps $this, int n) {
        return $this.takeRight(n);
    }

    default public C takeRight(int n) {
        return this.fromSpecific(new View.TakeRight(this, n));
    }

    public static Object takeWhile$(IterableOps $this, Function1 p) {
        return $this.takeWhile(p);
    }

    @Override
    default public C takeWhile(Function1<A, Object> p) {
        return this.fromSpecific(new View.TakeWhile<A>(this, p));
    }

    public static Tuple2 span$(IterableOps $this, Function1 p) {
        return $this.span(p);
    }

    @Override
    default public Tuple2<C, C> span(Function1<A, Object> p) {
        return Tuple2$.MODULE$.apply(this.takeWhile(p), this.dropWhile(p));
    }

    public static Object drop$(IterableOps $this, int n) {
        return $this.drop(n);
    }

    @Override
    default public C drop(int n) {
        return this.fromSpecific(new View.Drop(this, n));
    }

    public static Object dropRight$(IterableOps $this, int n) {
        return $this.dropRight(n);
    }

    default public C dropRight(int n) {
        return this.fromSpecific(new View.DropRight(this, n));
    }

    public static Object dropWhile$(IterableOps $this, Function1 p) {
        return $this.dropWhile(p);
    }

    @Override
    default public C dropWhile(Function1<A, Object> p) {
        return this.fromSpecific(new View.DropWhile<A>(this, p));
    }

    public static Iterator grouped$(IterableOps $this, int size) {
        return $this.grouped(size);
    }

    default public Iterator<C> grouped(int size) {
        return this.iterator().grouped(size).map((Function1<IterableOnce, Object> & Serializable)(T1 coll) -> this.fromSpecific((IterableOnce<A>)coll));
    }

    public static Iterator sliding$(IterableOps $this, int size) {
        return $this.sliding(size);
    }

    default public Iterator<C> sliding(int size) {
        return this.sliding(size, 1);
    }

    public static Iterator sliding$(IterableOps $this, int size, int step) {
        return $this.sliding(size, step);
    }

    default public Iterator<C> sliding(int size, int step) {
        return this.iterator().sliding(size, step).map((Function1<IterableOnce, Object> & Serializable)(T1 coll) -> this.fromSpecific((IterableOnce<A>)coll));
    }

    public static Object tail$(IterableOps $this) {
        return $this.tail();
    }

    default public C tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.drop(1);
    }

    public static Object init$(IterableOps $this) {
        return $this.init();
    }

    default public C init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.dropRight(1);
    }

    public static Object slice$(IterableOps $this, int from, int until) {
        return $this.slice(from, until);
    }

    @Override
    default public C slice(int from, int until) {
        return this.fromSpecific(new View.Drop(new View.Take(this, until), from));
    }

    public static Map groupBy$(IterableOps $this, Function1 f) {
        return $this.groupBy(f);
    }

    default public <K> Map<K, C> groupBy(Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            K key = f.apply(elem);
            Builder bldr = (Builder)m.getOrElseUpdate(key, this::$anonfun$2);
            bldr.$plus$eq(elem);
        }
        Object result = HashMap$.MODULE$.empty();
        Iterator mapIt = m.iterator();
        while (mapIt.hasNext()) {
            Tuple2 tuple2;
            Tuple2 $1$;
            Tuple2 tuple22 = $1$ = (tuple2 = (Tuple2)mapIt.next());
            Object k = tuple22._1();
            Builder v = (Builder)tuple22._2();
            result = ((HashMap)result).updated(k, v.result());
        }
        return result;
    }

    public static Map groupMap$(IterableOps $this, Function1 key, Function1 f) {
        return $this.groupMap(key, f);
    }

    default public <K, B> Map<K, CC> groupMap(Function1<A, K> key, Function1<A, B> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.foreach((Function1<Object, Builder> & Serializable)elem -> {
            Object k = key.apply(elem);
            Builder bldr = (Builder)m.getOrElseUpdate(k, this::$anonfun$3);
            return (Builder)bldr.$plus$eq(f.apply(elem));
        });
        public class Scala_collection_IterableOps$Result$1
        extends AbstractFunction1<Tuple2<K, Builder<B, CC>>, BoxedUnit> {
            private Map built;

            public Scala_collection_IterableOps$Result$1() {
                this.built = scala.collection.immutable.Map$.MODULE$.empty();
            }

            public Map built() {
                return this.built;
            }

            public void built_$eq(Map x$1) {
                this.built = x$1;
            }

            public void apply(Tuple2 kv) {
                this.built_$eq((Map)this.built().updated(kv._1(), ((Builder)kv._2()).result()));
            }
        }
        Scala_collection_IterableOps$Result$1 result = new Scala_collection_IterableOps$Result$1();
        m.foreach(result);
        return result.built();
    }

    public static Map groupMapReduce$(IterableOps $this, Function1 key, Function1 f, Function2 reduce) {
        return $this.groupMapReduce(key, f, reduce);
    }

    default public <K, B> Map<K, B> groupMapReduce(Function1<A, K> key, Function1<A, B> f, Function2<B, B, B> reduce) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.foreach((Function1<Object, Option> & Serializable)elem -> {
            Object r;
            Object k = key.apply(elem);
            Option option = m.get(k);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object b = some.value();
                r = reduce.apply(b, f.apply(elem));
            } else if (None$.MODULE$.equals(option)) {
                r = f.apply(elem);
            } else {
                throw new MatchError(option);
            }
            Object v = r;
            return m.put(k, v);
        });
        return (Map)m.to(MapFactory$.MODULE$.toFactory(scala.collection.immutable.Map$.MODULE$));
    }

    public static Object scan$(IterableOps $this, Object z, Function2 op) {
        return $this.scan(z, op);
    }

    default public <B> CC scan(B z, Function2<B, B, B> op) {
        return this.scanLeft(z, op);
    }

    public static Object scanLeft$(IterableOps $this, Object z, Function2 op) {
        return $this.scanLeft(z, op);
    }

    @Override
    default public <B> CC scanLeft(B z, Function2<B, A, B> op) {
        return this.iterableFactory().from(new View.ScanLeft<A, B>(this, z, op));
    }

    public static Object scanRight$(IterableOps $this, Object z, Function2 op) {
        return $this.scanRight(z, op);
    }

    default public <B> CC scanRight(B z, Function2<A, B, B> op) {
        public class Scala_collection_IterableOps$Scanner$1
        extends AbstractFunction1<A, BoxedUnit> {
            private final Function2 op$2;
            private Object acc;
            private List scanned;

            public Scala_collection_IterableOps$Scanner$1(Object z$1, Function2 op$1) {
                this.op$2 = op$1;
                this.acc = z$1;
                Object object = this.acc();
                this.scanned = Nil$.MODULE$.$colon$colon(object);
            }

            public Object acc() {
                return this.acc;
            }

            public void acc_$eq(Object x$1) {
                this.acc = x$1;
            }

            public List scanned() {
                return this.scanned;
            }

            public void scanned_$eq(List x$1) {
                this.scanned = x$1;
            }

            public void apply(Object x) {
                this.acc_$eq(this.op$2.apply(x, this.acc()));
                this.scanned_$eq(this.scanned().$colon$colon(this.acc()));
            }
        }
        Scala_collection_IterableOps$Scanner$1 scanner = new Scala_collection_IterableOps$Scanner$1(z, op);
        this.reversed().foreach(scanner);
        return this.iterableFactory().from(scanner.scanned());
    }

    public static Object map$(IterableOps $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public <B> CC map(Function1<A, B> f) {
        return this.iterableFactory().from(new View.Map<A, B>(this, f));
    }

    public static Object flatMap$(IterableOps $this, Function1 f) {
        return $this.flatMap(f);
    }

    @Override
    default public <B> CC flatMap(Function1<A, IterableOnce<B>> f) {
        return this.iterableFactory().from(new View.FlatMap<A, B>(this, f));
    }

    public static Object flatten$(IterableOps $this, Function1 asIterable) {
        return $this.flatten(asIterable);
    }

    @Override
    default public <B> CC flatten(Function1<A, IterableOnce<B>> asIterable) {
        return this.flatMap(asIterable);
    }

    public static Object collect$(IterableOps $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    @Override
    default public <B> CC collect(PartialFunction<A, B> pf) {
        return this.iterableFactory().from(new View.Collect<A, B>(this, pf));
    }

    public static Tuple2 partitionMap$(IterableOps $this, Function1 f) {
        return $this.partitionMap(f);
    }

    default public <A1, A2> Tuple2<CC, CC> partitionMap(Function1<A, Either<A1, A2>> f) {
        View.LeftPartitionMapped<A, A1, A2> left = new View.LeftPartitionMapped<A, A1, A2>(this, f);
        View.RightPartitionMapped<A, A1, A2> right = new View.RightPartitionMapped<A, A1, A2>(this, f);
        return Tuple2$.MODULE$.apply(this.iterableFactory().from(left), this.iterableFactory().from(right));
    }

    public static Object concat$(IterableOps $this, IterableOnce suffix) {
        return $this.concat(suffix);
    }

    default public <B> CC concat(IterableOnce<B> suffix) {
        IterableOnce<Object> iterableOnce;
        IterableFactory<CC> iterableFactory = this.iterableFactory();
        IterableOnce<B> iterableOnce2 = suffix;
        if (iterableOnce2 instanceof Iterable) {
            Iterable iterable;
            Iterable suffix2 = iterable = (Iterable)iterableOnce2;
            iterableOnce = new View.Concat(this, suffix2);
        } else {
            IterableOnce<B> suffix3 = iterableOnce2;
            iterableOnce = this.iterator().$plus$plus(() -> IterableOps.concat$$anonfun$1(suffix3));
        }
        return iterableFactory.from(iterableOnce);
    }

    public static Object $plus$plus$(IterableOps $this, IterableOnce suffix) {
        return $this.$plus$plus(suffix);
    }

    default public <B> CC $plus$plus(IterableOnce<B> suffix) {
        return this.concat(suffix);
    }

    public static Object zip$(IterableOps $this, IterableOnce that) {
        return $this.zip(that);
    }

    default public <B> CC zip(IterableOnce<B> that) {
        IterableOnce<Tuple2<Object, Object>> iterableOnce;
        IterableFactory<CC> iterableFactory = this.iterableFactory();
        IterableOnce<B> iterableOnce2 = that;
        if (iterableOnce2 instanceof Iterable) {
            Iterable iterable;
            Iterable that2 = iterable = (Iterable)iterableOnce2;
            iterableOnce = new View.Zip(this, that2);
        } else {
            iterableOnce = this.iterator().zip(that);
        }
        return iterableFactory.from(iterableOnce);
    }

    public static Object zipWithIndex$(IterableOps $this) {
        return $this.zipWithIndex();
    }

    @Override
    default public CC zipWithIndex() {
        return this.iterableFactory().from(new View.ZipWithIndex(this));
    }

    public static Object zipAll$(IterableOps $this, Iterable that, Object thisElem, Object thatElem) {
        return $this.zipAll(that, thisElem, thatElem);
    }

    default public <A1, B> CC zipAll(Iterable<B> that, A1 thisElem, B thatElem) {
        return this.iterableFactory().from(new View.ZipAll<A1, B>(this, that, thisElem, thatElem));
    }

    public static Tuple2 unzip$(IterableOps $this, Function1 asPair) {
        return $this.unzip(asPair);
    }

    default public <A1, A2> Tuple2<CC, CC> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        View.Map first = new View.Map(this, (Function1<Object, Object> & Serializable)_$3 -> ((Tuple2)asPair.apply(_$3))._1());
        View.Map second = new View.Map(this, (Function1<Object, Object> & Serializable)_$4 -> ((Tuple2)asPair.apply(_$4))._2());
        return Tuple2$.MODULE$.apply(this.iterableFactory().from(first), this.iterableFactory().from(second));
    }

    public static Tuple3 unzip3$(IterableOps $this, Function1 asTriple) {
        return $this.unzip3(asTriple);
    }

    default public <A1, A2, A3> Tuple3<CC, CC, CC> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        View.Map first = new View.Map(this, (Function1<Object, Object> & Serializable)_$5 -> ((Tuple3)asTriple.apply(_$5))._1());
        View.Map second = new View.Map(this, (Function1<Object, Object> & Serializable)_$6 -> ((Tuple3)asTriple.apply(_$6))._2());
        View.Map third = new View.Map(this, (Function1<Object, Object> & Serializable)_$7 -> ((Tuple3)asTriple.apply(_$7))._3());
        return Tuple3$.MODULE$.apply(this.iterableFactory().from(first), this.iterableFactory().from(second), this.iterableFactory().from(third));
    }

    public static Iterator tails$(IterableOps $this) {
        return $this.tails();
    }

    default public Iterator<C> tails() {
        return this.iterateUntilEmpty((Function1<Iterable, Iterable> & Serializable)_$8 -> (Iterable)_$8.tail());
    }

    public static Iterator inits$(IterableOps $this) {
        return $this.inits();
    }

    default public Iterator<C> inits() {
        return this.iterateUntilEmpty((Function1<Iterable, Iterable> & Serializable)_$9 -> (Iterable)_$9.init());
    }

    public static Object tapEach$(IterableOps $this, Function1 f) {
        return $this.tapEach(f);
    }

    @Override
    default public <U> C tapEach(Function1<A, U> f) {
        return this.fromSpecific(new View.Map(this, (Function1<Object, Object> & Serializable)a -> {
            f.apply(a);
            return a;
        }));
    }

    private Iterator<C> iterateUntilEmpty(Function1<Iterable<A>, Iterable<A>> f) {
        Iterator<Iterable<A>> it = Iterator$.MODULE$.iterate(this.toIterable(), f).takeWhile((Function1<Iterable, Boolean> & Serializable)_$10 -> _$10.nonEmpty());
        return it.$plus$plus(IterableOps::iterateUntilEmpty$$anonfun$1).map((Function1<IterableOnce, Object> & Serializable)coll -> this.fromSpecific((IterableOnce<A>)coll));
    }

    public static Object $plus$plus$colon$(IterableOps $this, IterableOnce that) {
        return $this.$plus$plus$colon(that);
    }

    default public <B> CC $plus$plus$colon(IterableOnce<B> that) {
        IterableOnce<Object> iterableOnce;
        IterableFactory<CC> iterableFactory = this.iterableFactory();
        IterableOnce<B> iterableOnce2 = that;
        if (iterableOnce2 instanceof Iterable) {
            Iterable iterable;
            Iterable xs = iterable = (Iterable)iterableOnce2;
            iterableOnce = new View.Concat(xs, this);
        } else {
            iterableOnce = that.iterator().$plus$plus(this::$plus$plus$colon$$anonfun$1);
        }
        return iterableFactory.from(iterableOnce);
    }

    private static Nothing$ fail$1() {
        throw new IllegalArgumentException("transpose requires all collections have the same size");
    }

    private Builder $anonfun$1() {
        return this.iterableFactory().newBuilder();
    }

    private Builder $anonfun$2() {
        return this.newSpecificBuilder();
    }

    private Builder $anonfun$3() {
        return this.iterableFactory().newBuilder();
    }

    private static IterableOnce concat$$anonfun$1(IterableOnce suffix$1) {
        return suffix$1.iterator();
    }

    private static IterableOnce iterateUntilEmpty$$anonfun$1() {
        return Iterator$.MODULE$.single(Iterable$.MODULE$.empty());
    }

    private IterableOnce $plus$plus$colon$$anonfun$1() {
        return this.iterator();
    }

    public static final class SizeCompareOps {
        private final IterableOps<?, Object, ?> it;

        public static boolean $bang$eq$extension(IterableOps iterableOps, int n) {
            return IterableOps$SizeCompareOps$.MODULE$.$bang$eq$extension(iterableOps, n);
        }

        public static boolean $less$extension(IterableOps iterableOps, int n) {
            return IterableOps$SizeCompareOps$.MODULE$.$less$extension(iterableOps, n);
        }

        public static boolean $less$eq$extension(IterableOps iterableOps, int n) {
            return IterableOps$SizeCompareOps$.MODULE$.$less$eq$extension(iterableOps, n);
        }

        public static boolean $eq$eq$extension(IterableOps iterableOps, int n) {
            return IterableOps$SizeCompareOps$.MODULE$.$eq$eq$extension(iterableOps, n);
        }

        public static boolean $greater$extension(IterableOps iterableOps, int n) {
            return IterableOps$SizeCompareOps$.MODULE$.$greater$extension(iterableOps, n);
        }

        public static boolean $greater$eq$extension(IterableOps iterableOps, int n) {
            return IterableOps$SizeCompareOps$.MODULE$.$greater$eq$extension(iterableOps, n);
        }

        public static boolean equals$extension(IterableOps iterableOps, Object object) {
            return IterableOps$SizeCompareOps$.MODULE$.equals$extension(iterableOps, object);
        }

        public static int hashCode$extension(IterableOps iterableOps) {
            return IterableOps$SizeCompareOps$.MODULE$.hashCode$extension(iterableOps);
        }

        public SizeCompareOps(IterableOps<?, Object, ?> it) {
            this.it = it;
        }

        public int hashCode() {
            return IterableOps$SizeCompareOps$.MODULE$.hashCode$extension(this.it());
        }

        public boolean equals(Object x$0) {
            return IterableOps$SizeCompareOps$.MODULE$.equals$extension(this.it(), x$0);
        }

        public IterableOps<?, Object, ?> it() {
            return this.it;
        }

        public boolean $less(int size) {
            return IterableOps$SizeCompareOps$.MODULE$.$less$extension(this.it(), size);
        }

        public boolean $less$eq(int size) {
            return IterableOps$SizeCompareOps$.MODULE$.$less$eq$extension(this.it(), size);
        }

        public boolean $eq$eq(int size) {
            return IterableOps$SizeCompareOps$.MODULE$.$eq$eq$extension(this.it(), size);
        }

        public boolean $bang$eq(int size) {
            return IterableOps$SizeCompareOps$.MODULE$.$bang$eq$extension(this.it(), size);
        }

        public boolean $greater$eq(int size) {
            return IterableOps$SizeCompareOps$.MODULE$.$greater$eq$extension(this.it(), size);
        }

        public boolean $greater(int size) {
            return IterableOps$SizeCompareOps$.MODULE$.$greater$extension(this.it(), size);
        }
    }

    public static class WithFilter<A, CC>
    extends scala.collection.WithFilter<A, CC> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, CC, ?> self;
        private final Function1<A, Object> p;

        public WithFilter(IterableOps<A, CC, ?> self, Function1<A, Object> p) {
            this.self = self;
            this.p = p;
        }

        public Iterable<A> filtered() {
            return new View.Filter<A>(this.self, this.p, false);
        }

        @Override
        public <B> CC map(Function1<A, B> f) {
            return this.self.iterableFactory().from(new View.Map<A, B>(this.filtered(), f));
        }

        @Override
        public <B> CC flatMap(Function1<A, IterableOnce<B>> f) {
            return this.self.iterableFactory().from(new View.FlatMap<A, B>(this.filtered(), f));
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.filtered().foreach(f);
        }

        @Override
        public WithFilter<A, CC> withFilter(Function1<A, Object> q) {
            return new WithFilter<A, CC>(this.self, (Function1<Object, Boolean> & Serializable)a -> BoxesRunTime.unboxToBoolean(this.p.apply(a)) && BoxesRunTime.unboxToBoolean(q.apply(a)));
        }
    }
}

