/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.PyImportCollectorFactory;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import org.jetbrains.annotations.Nullable;

public final class PythonImportUtils {
    private PythonImportUtils() {
    }

    @Nullable
    public static AutoImportQuickFix proposeImportFix(PyElement node, PsiReference reference) {
        String text = reference.getElement().getText();
        String refText = reference.getRangeInElement().substring(text);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
        if (module != null && PythonSdkUtil.findPythonSdk((Module)module) == null) {
            return null;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class);
        if (scopeOwner != null && ControlFlowCache.getScope(scopeOwner).containsDeclaration(refText)) {
            return null;
        }
        return PythonImportUtils.addCandidates(node, reference, refText);
    }

    @Nullable
    private static AutoImportQuickFix addCandidates(PyElement node, PsiReference reference, String refText) {
        return PyImportCollectorFactory.getInstance().create(node, reference, refText).addCandidates();
    }

    public static boolean isImportable(PsiElement refElement) {
        PyStatement parentStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)refElement, PyStatement.class);
        if (parentStatement instanceof PyGlobalStatement || parentStatement instanceof PyNonlocalStatement || parentStatement instanceof PyImportStatementBase) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)refElement, PyPlainStringElement.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) == null;
    }
}

