/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - u64vec3(167ul, 66ul, 187ul)) => u64vec3(1333333333333333092ul, 19ul, 18446744073709551523ul)
 * (u64vec3(167ul, 66ul, 187ul) - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410740376218524ul, 18446744073709551597ul, 93ul)
 * (u64vec3(167ul, 66ul, 187ul) - u64vec3(167ul, 66ul, 187ul)) => u64vec3(0ul, 0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - u64vec3(167ul, 66ul, 187ul)), u64vec3(1333333333333333092ul, 19ul, 18446744073709551523ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410740376218524ul, 18446744073709551597ul, 93ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - u64vec3(167ul, 66ul, 187ul)), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
