/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.ReliabilityLayer;
import org.eclipse.californium.core.network.stack.ReliabilityLayerParameters;
import org.eclipse.californium.core.network.stack.RemoteEndpoint;
import org.eclipse.californium.core.network.stack.congestioncontrol.BasicRto;
import org.eclipse.californium.core.network.stack.congestioncontrol.Cocoa;
import org.eclipse.californium.core.network.stack.congestioncontrol.CongestionStatisticLogger;
import org.eclipse.californium.core.network.stack.congestioncontrol.LinuxRto;
import org.eclipse.californium.core.network.stack.congestioncontrol.PeakhopperRto;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CongestionControlLayer
extends ReliabilityLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CongestionControlLayer.class);
    private static final int EXCHANGELIMIT = 50;
    private static final int MIN_RTO = 500;
    private static final int MAX_RTO = 60000;
    private LeastRecentlyUpdatedCache<Object, RemoteEndpoint> remoteEndpoints;
    protected final Configuration config;
    protected final String tag;
    private final boolean useInetSocketAddress;
    private boolean appliesDithering;
    private volatile CongestionStatisticLogger statistic;

    public CongestionControlLayer(String tag, Configuration config) {
        super(config);
        this.tag = tag;
        this.config = config;
        this.remoteEndpoints = new LeastRecentlyUpdatedCache(((Integer)config.get((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS)).intValue(), config.get(CoapConfig.MAX_PEER_INACTIVITY_PERIOD, TimeUnit.SECONDS).longValue(), TimeUnit.SECONDS);
        this.remoteEndpoints.setHideStaleValues(true);
        this.useInetSocketAddress = (Boolean)config.get((BasicDefinition)CoapConfig.CONGESTION_CONTROL_USE_INET_ADDRESS);
        this.setDithering(false);
    }

    public CounterStatisticManager enableStatistic() {
        CongestionStatisticLogger statistic = this.statistic;
        if (statistic == null) {
            this.statistic = new CongestionStatisticLogger(this.tag);
        }
        return this.statistic;
    }

    public void disableStatistic() {
        CongestionStatisticLogger statistic = this.statistic;
        if (statistic != null) {
            statistic.dump();
            this.statistic = null;
        }
    }

    protected abstract RemoteEndpoint createRemoteEndpoint(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteEndpoint getRemoteEndpoint(Exchange exchange) {
        Object peersIdentity = this.useInetSocketAddress ? exchange.getRemoteSocketAddress() : exchange.getPeersIdentity();
        this.remoteEndpoints.removeExpiredEntries(32);
        ReentrantReadWriteLock.WriteLock lock = this.remoteEndpoints.writeLock();
        lock.lock();
        try {
            RemoteEndpoint remoteEndpoint = (RemoteEndpoint)this.remoteEndpoints.update(peersIdentity);
            if (remoteEndpoint == null) {
                remoteEndpoint = this.createRemoteEndpoint(peersIdentity);
                this.remoteEndpoints.put(peersIdentity, (Object)remoteEndpoint);
            }
            RemoteEndpoint remoteEndpoint2 = remoteEndpoint;
            return remoteEndpoint2;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean appliesDithering() {
        return this.appliesDithering;
    }

    public void setDithering(boolean mode) {
        this.appliesDithering = mode;
    }

    public RemoteEndpoint.RtoType getExchangeEstimatorState(Exchange exchange) {
        int failed = exchange.getFailedTransmissionCount();
        switch (failed) {
            case 0: {
                return RemoteEndpoint.RtoType.STRONG;
            }
            case 1: 
            case 2: {
                return RemoteEndpoint.RtoType.WEAK;
            }
        }
        return RemoteEndpoint.RtoType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processResponse(RemoteEndpoint endpoint, Exchange exchange, Response response) {
        int size;
        exchange.setCurrentResponse(response);
        if (!response.isNotification()) {
            if (response.isConfirmable()) {
                return this.checkNSTART(endpoint, exchange);
            }
            return true;
        }
        boolean start = false;
        Queue<PostponedExchange> queue = endpoint.getNotifyQueue();
        RemoteEndpoint remoteEndpoint = endpoint;
        synchronized (remoteEndpoint) {
            PostponedExchange postponedExchange = new PostponedExchange(exchange, response);
            queue.remove(postponedExchange);
            size = queue.size();
            if (size < 50) {
                queue.add(postponedExchange);
                start = endpoint.startProcessingNotifies();
            }
        }
        if (size >= 50) {
            LOGGER.debug("{}drop outgoing notify, queue full {}", (Object)this.tag, (Object)size);
        } else if (start) {
            this.executor.execute(new BucketTask(endpoint));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNSTART(RemoteEndpoint endpoint, Exchange exchange) {
        CongestionStatisticLogger statistic;
        int size;
        Queue<Exchange> queue;
        Message message;
        String messageType;
        boolean send = false;
        boolean queued = false;
        if (exchange.isOfLocalOrigin()) {
            messageType = "req.-";
            message = exchange.getCurrentRequest();
            queue = endpoint.getRequestQueue();
        } else {
            messageType = "resp.-";
            message = exchange.getCurrentResponse();
            queue = endpoint.getResponseQueue();
        }
        RemoteEndpoint remoteEndpoint = endpoint;
        synchronized (remoteEndpoint) {
            size = queue.size();
            if (endpoint.registerExchange(exchange)) {
                send = true;
            } else if (size < 50) {
                queue.add(exchange);
                queued = true;
            }
        }
        if (send) {
            message.addMessageObserver(new TimeoutTask(endpoint, exchange));
            LOGGER.trace("{}send {}{}", new Object[]{this.tag, messageType, message.getType()});
            statistic = this.statistic;
            if (statistic != null) {
                statistic.sendRequest();
            }
            return true;
        }
        if (queued) {
            statistic = this.statistic;
            if (statistic != null) {
                statistic.queueRequest();
            }
        } else {
            LOGGER.debug("{}drop {}{}, queue full {}", new Object[]{this.tag, messageType, message.getType(), size});
        }
        return false;
    }

    private void processRttMeasurement(Exchange exchange) {
        RemoteEndpoint.RtoType rtoType;
        Long rttNanos;
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        Response response = exchange.getCurrentResponse();
        if (response != null && (rttNanos = response.getTransmissionRttNanos()) != null && (rtoType = this.getExchangeEstimatorState(exchange)) != RemoteEndpoint.RtoType.NONE) {
            long measuredRTT = Math.max(TimeUnit.NANOSECONDS.toMillis(rttNanos), 1L);
            endpoint.processRttMeasurement(rtoType, measuredRTT);
        }
        this.nextQueuedExchange(endpoint, exchange);
    }

    protected float calculateVBF(long rto, float scale) {
        return scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextQueuedExchange(final RemoteEndpoint endpoint, Exchange removeExchange) {
        Exchange nextExchange = null;
        RemoteEndpoint remoteEndpoint = endpoint;
        synchronized (remoteEndpoint) {
            if (endpoint.removeExchange(removeExchange)) {
                nextExchange = endpoint.getResponseQueue().poll();
                if (nextExchange == null) {
                    nextExchange = endpoint.getRequestQueue().poll();
                }
                if (nextExchange != null) {
                    endpoint.registerExchange(nextExchange);
                }
            }
        }
        if (nextExchange != null) {
            int size;
            CoAP.Type type;
            String messageType;
            Exchange exchange;
            CongestionStatisticLogger statistic = this.statistic;
            if (statistic != null) {
                statistic.dequeueRequest();
            }
            if ((exchange = nextExchange).isOfLocalOrigin()) {
                messageType = "req.-";
                type = exchange.getCurrentRequest().getType();
                size = endpoint.getRequestQueue().size();
            } else {
                messageType = "resp.-";
                type = exchange.getCurrentResponse().getType();
                size = endpoint.getResponseQueue().size();
            }
            LOGGER.trace("{}send from queue {}{}, queue left {}", new Object[]{this.tag, messageType, type, size});
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    if (exchange.isComplete()) {
                        CongestionControlLayer.this.nextQueuedExchange(endpoint, exchange);
                        return;
                    }
                    if (exchange.isOfLocalOrigin()) {
                        CongestionControlLayer.this.sendRequest(exchange, exchange.getCurrentRequest());
                    } else {
                        CongestionControlLayer.this.sendResponse(exchange, exchange.getCurrentResponse());
                    }
                }
            });
        }
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (exchange.getFailedTransmissionCount() > 0) {
            LOGGER.warn("{}retransmission in sendRequest", (Object)this.tag, (Object)new Throwable("retransmission"));
            return;
        }
        this.prepareRequest(exchange, request);
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        exchange.setCurrentRequest(request);
        if (this.checkNSTART(endpoint, exchange)) {
            endpoint.checkAging();
            LOGGER.debug("{}send request", (Object)this.tag);
            if (!endpoint.inFlightExchange(exchange)) {
                LOGGER.warn("{}unregistered request", (Object)this.tag, (Object)new Throwable("unregistered request"));
            }
            this.lower().sendRequest(exchange, request);
        }
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        RemoteEndpoint endpoint = this.getRemoteEndpoint(exchange);
        this.prepareResponse(exchange, response);
        if (exchange.getFailedTransmissionCount() > 0) {
            if (response.isNotification()) {
                this.lower().sendResponse(exchange, response);
            } else {
                LOGGER.warn("{}retransmission in sendResponse", (Object)this.tag, (Object)new Throwable("retransmission"));
            }
        } else if (this.processResponse(endpoint, exchange, response)) {
            endpoint.checkAging();
            this.lower().sendResponse(exchange, response);
        }
    }

    @Override
    protected void updateRetransmissionTimeout(Exchange exchange, ReliabilityLayerParameters reliabilityLayerParameters) {
        int timeout;
        int maxTimeout = Math.min(reliabilityLayerParameters.getMaxAckTimeout(), 60000);
        RemoteEndpoint remoteEndpoint = this.getRemoteEndpoint(exchange);
        if (exchange.getFailedTransmissionCount() == 0) {
            timeout = this.defaultReliabilityLayerParameters == reliabilityLayerParameters ? (int)remoteEndpoint.getRTO() : reliabilityLayerParameters.getAckTimeout();
            if (this.appliesDithering()) {
                timeout = this.getRandomTimeout(timeout, reliabilityLayerParameters.getAckRandomFactor());
            }
            timeout = Math.max(500, timeout);
            timeout = Math.min(maxTimeout, timeout);
            float scale = this.calculateVBF(timeout, reliabilityLayerParameters.getAckTimeoutScale());
            exchange.setTimeoutScale(scale);
        } else {
            timeout = (int)(exchange.getTimeoutScale() * (float)exchange.getCurrentTimeout());
            timeout = Math.min(maxTimeout, timeout);
        }
        exchange.setCurrentTimeout(timeout);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        LOGGER.debug("{}receive response", (Object)this.tag);
        if (this.processResponse(exchange, response)) {
            this.processRttMeasurement(exchange);
            CongestionStatisticLogger statistic = this.statistic;
            if (statistic != null) {
                statistic.receiveResponse(response);
            }
            this.upper().receiveResponse(exchange, response);
        }
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (this.processEmptyMessage(exchange, message)) {
            this.processRttMeasurement(exchange);
            this.upper().receiveEmptyMessage(exchange, message);
        }
    }

    public static ReliabilityLayer newImplementation(String tag, Configuration config) {
        ReliabilityLayer layer = null;
        CoapConfig.CongestionControlMode mode = (CoapConfig.CongestionControlMode)((Object)config.get(CoapConfig.CONGESTION_CONTROL_ALGORITHM));
        switch (mode) {
            case COCOA: {
                layer = new Cocoa(tag, config, false);
                break;
            }
            case COCOA_STRONG: {
                layer = new Cocoa(tag, config, true);
                break;
            }
            case BASIC_RTO: {
                layer = new BasicRto(tag, config);
                break;
            }
            case LINUX_RTO: {
                layer = new LinuxRto(tag, config);
                break;
            }
            case PEAKHOPPER_RTO: {
                layer = new PeakhopperRto(tag, config);
                break;
            }
            case NULL: {
                layer = new ReliabilityLayer(config);
            }
        }
        if (layer != null) {
            if (mode != CoapConfig.CongestionControlMode.NULL) {
                LOGGER.info("Enabling congestion control: {}", (Object)layer.getClass().getSimpleName());
            }
            return layer;
        }
        throw new IllegalArgumentException("Unsupported " + CoapConfig.CONGESTION_CONTROL_ALGORITHM.getKey());
    }

    public static class PostponedExchange {
        private final Exchange exchange;
        private final Message message;

        PostponedExchange(Exchange exchange, Message message) {
            this.exchange = exchange;
            this.message = message;
        }

        public int hashCode() {
            return this.exchange.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PostponedExchange) {
                return this.exchange.equals(((PostponedExchange)obj).exchange);
            }
            return false;
        }
    }

    private class BucketTask
    implements Runnable {
        final AtomicInteger count = new AtomicInteger();
        final RemoteEndpoint endpoint;

        public BucketTask(RemoteEndpoint queue) {
            this.endpoint = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PostponedExchange exchange;
            int size = 0;
            RemoteEndpoint remoteEndpoint = this.endpoint;
            synchronized (remoteEndpoint) {
                exchange = this.endpoint.getNotifyQueue().peek();
                if (exchange == null) {
                    this.endpoint.stopProcessingNotifies();
                } else {
                    this.count.incrementAndGet();
                    size = this.endpoint.getNotifyQueue().size();
                }
            }
            if (exchange != null) {
                final long rto = this.endpoint.getRTO();
                LOGGER.trace("{}send notify from queue, left {}, next {} ms", new Object[]{CongestionControlLayer.this.tag, size, rto});
                exchange.exchange.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long time = 0L;
                        try {
                            RemoteEndpoint remoteEndpoint = BucketTask.this.endpoint;
                            synchronized (remoteEndpoint) {
                                block16: {
                                    if (BucketTask.this.endpoint.getNotifyQueue().peek() == exchange) break block16;
                                    return;
                                }
                                BucketTask.this.endpoint.getNotifyQueue().remove();
                            }
                            ObserveRelation relation = exchange.exchange.getRelation();
                            if (relation != null && !relation.isCanceled()) {
                                Response response = exchange.exchange.getCurrentResponse();
                                if (exchange.message != response) {
                                    if (response.isNotification()) {
                                        LOGGER.warn("{} notify changed!", (Object)CongestionControlLayer.this.tag);
                                    } else {
                                        LOGGER.warn("{} notification finished!", (Object)CongestionControlLayer.this.tag);
                                    }
                                    return;
                                }
                                if (!exchange.exchange.isComplete() && !response.isCanceled()) {
                                    CongestionControlLayer.super.sendResponse(exchange.exchange, response);
                                    time = rto;
                                }
                            }
                        }
                        finally {
                            if (time > 0L) {
                                CongestionControlLayer.this.executor.schedule(BucketTask.this, time, TimeUnit.MILLISECONDS);
                            } else {
                                CongestionControlLayer.this.executor.execute(BucketTask.this);
                            }
                        }
                    }
                });
            } else {
                int jobs = this.count.getAndSet(0);
                LOGGER.debug("{}queue for outgoing notify stopped after {} jobs!", (Object)CongestionControlLayer.this.tag, (Object)jobs);
            }
        }
    }

    private class TimeoutTask
    extends MessageObserverAdapter {
        final RemoteEndpoint endpoint;
        final Exchange exchange;

        public TimeoutTask(RemoteEndpoint endpoint, Exchange exchange) {
            this.endpoint = endpoint;
            this.exchange = exchange;
        }

        @Override
        public void onTimeout() {
            CongestionControlLayer.this.nextQueuedExchange(this.endpoint, this.exchange);
        }
    }
}

