/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.californium.elements.util.StringUtil;

public class ServerName {
    public static final Charset CHARSET = StandardCharsets.US_ASCII;
    private final NameType type;
    private final byte[] name;
    private final int hashCode;

    private ServerName(NameType type, byte[] name) {
        this.type = type;
        this.name = name;
        this.hashCode = 31 * Arrays.hashCode(name) + type.hashCode();
    }

    public static ServerName from(NameType type, byte[] name) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (type == NameType.HOST_NAME) {
            return ServerName.fromHostName(new String(name, CHARSET));
        }
        return new ServerName(type, name);
    }

    public static ServerName fromHostName(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("host name must not be null");
        }
        if (StringUtil.isValidHostName((String)hostName)) {
            return new ServerName(NameType.HOST_NAME, hostName.toLowerCase().getBytes(CHARSET));
        }
        throw new IllegalArgumentException("not a valid host name");
    }

    public int getLength() {
        return this.name.length;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return new String(this.name, CHARSET);
    }

    public NameType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerName other = (ServerName)obj;
        if (this.type != other.type) {
            return false;
        }
        return Arrays.equals(this.name, other.name);
    }

    public static enum NameType {
        HOST_NAME(0),
        UNDEFINED(-1);

        private final byte code;

        private NameType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static NameType fromCode(byte code) {
            for (NameType type : NameType.values()) {
                if (type.code != code) continue;
                return type;
            }
            return UNDEFINED;
        }
    }
}

