/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentBody
implements Container,
InstructionInfo {
    protected Expression body;
    private String systemId;
    private int lineNumber;
    private SlotManager stackFrameMap;
    private int hostLanguage;
    private PackageData packageData;
    private Component declaringComponent;

    public void setPackageData(PackageData packageData) {
        this.packageData = packageData;
    }

    @Override
    public PackageData getPackageData() {
        return this.packageData;
    }

    @Override
    public int getContainerGranularity() {
        return 2;
    }

    public void makeDeclaringComponent(Visibility visibility, StylesheetPackage declaringPackage) {
        if (this.declaringComponent == null) {
            this.declaringComponent = new Component(this, visibility, declaringPackage, declaringPackage);
        }
    }

    public Component getDeclaringComponent() {
        return this.declaringComponent;
    }

    public void allocateAllBindingSlots(StylesheetPackage pack) {
        if (this.getBody() != null) {
            ComponentBody.allocateBindingSlotsRecursive(pack, this, this.getBody());
        }
    }

    protected static void allocateBindingSlotsRecursive(StylesheetPackage pack, ComponentBody p, Expression exp) {
        if (exp instanceof ComponentInvocation) {
            ComponentInvocation invocation = (ComponentInvocation)((Object)exp);
            SymbolicName name = invocation.getSymbolicName();
            Component target = pack.getComponent(name);
            if (target == null) {
                throw new AssertionError((Object)("Target of component reference " + name + " is undefined"));
            }
            int slot = p.allocateBindingSlot(name, target);
            invocation.setBindingSlot(slot);
        }
        for (Operand o : exp.operands()) {
            ComponentBody.allocateBindingSlotsRecursive(pack, p, o.getExpression());
        }
    }

    private int allocateBindingSlot(SymbolicName name, Component target) {
        List<ComponentBinding> bindings = this.declaringComponent.getComponentBindings();
        int slot = bindings.size();
        ComponentBinding cb = new ComponentBinding(name);
        cb.setTarget(target, target.getVisibility() == Visibility.PRIVATE || target.getVisibility() == Visibility.FINAL);
        bindings.add(cb);
        return slot;
    }

    @Override
    public Configuration getConfiguration() {
        return this.packageData.getConfiguration();
    }

    public void setBody(Expression body) {
        this.body = body;
        if (body != null) {
            body.setContainer(this);
        }
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    @Override
    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public final Expression getBody() {
        return this.body;
    }

    public void setStackFrameMap(SlotManager map) {
        this.stackFrameMap = map;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public LocationProvider getLocationProvider() {
        return this.getPackageData().getLocationMap();
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    public abstract int getComponentKind();
}

