/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.XATransactionState;
import org.apache.derby.shared.common.error.StandardException;

public class ResourceAdapterImpl
implements ResourceAdapter,
ModuleControl {
    private boolean active;
    private XAResourceManager rm;
    private Hashtable<XAXactId, XATransactionState> connectionTable;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        this.connectionTable = new Hashtable();
        AccessFactory af = (AccessFactory)ResourceAdapterImpl.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.rm = (XAResourceManager)af.getXAResourceManager();
        this.active = true;
    }

    @Override
    public void stop() {
        this.active = false;
        Enumeration<XATransactionState> e = this.connectionTable.elements();
        while (e.hasMoreElements()) {
            XATransactionState tranState = e.nextElement();
            try {
                tranState.conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.active = false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized Object findConnection(XAXactId xid) {
        return this.connectionTable.get(xid);
    }

    @Override
    public synchronized boolean addConnection(XAXactId xid, Object conn) {
        if (this.connectionTable.get(xid) != null) {
            return false;
        }
        this.connectionTable.put(xid, (XATransactionState)conn);
        return true;
    }

    @Override
    public synchronized Object removeConnection(XAXactId xid) {
        return this.connectionTable.remove(xid);
    }

    @Override
    public void cancelXATransaction(XAXactId xid, String messageId) throws XAException {
        XATransactionState xaState = (XATransactionState)this.findConnection(xid);
        if (xaState != null) {
            xaState.cancel(messageId);
        }
    }

    @Override
    public XAResourceManager getXAResourceManager() {
        return this.rm;
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

