/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.impl.jdbc.ClobAsciiStream;
import org.apache.derby.impl.jdbc.ClobUpdatableReader;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.StoreStreamClob;
import org.apache.derby.impl.jdbc.TemporaryClob;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class EmbedClob
extends ConnectionChild
implements Clob,
EngineLOB {
    private InternalClob clob;
    private boolean isValid = true;
    private int locator;

    EmbedClob(EmbedConnection con) throws SQLException {
        super(con);
        this.clob = new TemporaryClob(this);
        con.addLOBReference(this);
    }

    protected EmbedClob(EmbedConnection con, StringDataValue dvd) throws StandardException, SQLException {
        super(con);
        SanityManager.ASSERT((!dvd.isNull() ? 1 : 0) != 0, (String)"clob is created on top of a null column");
        if (dvd.hasStream()) {
            CharacterStreamDescriptor csd = dvd.getStreamWithDescriptor();
            SanityManager.ASSERT((boolean)(csd.getStream() instanceof Resetable));
            try {
                this.clob = new StoreStreamClob(csd, this);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("40XD0")) {
                    throw StandardException.newException((String)"XJ073.S", (Object[])new Object[0]);
                }
                throw se;
            }
        }
        try {
            this.clob = new TemporaryClob(dvd.getString(), this);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        con.addLOBReference(this);
    }

    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            return this.clob.getCharLength();
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String result;
        this.checkValidity();
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", pos);
        }
        if (length < 0) {
            throw Util.generateCsSQLException("XJ071.S", length);
        }
        try {
            int charsRead;
            int read;
            Reader reader;
            try {
                reader = this.clob.getInternalReader(pos);
            }
            catch (EOFException eofe) {
                throw Util.generateCsSQLException("XJ076.S", eofe, pos);
            }
            char[] chars = new char[length];
            for (charsRead = 0; charsRead < length && (read = reader.read(chars, charsRead, length - charsRead)) != -1; charsRead += read) {
            }
            reader.close();
            result = charsRead == 0 ? "" : String.copyValueOf(chars, 0, charsRead);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
        return result;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            return new ClobUpdatableReader(this);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(String searchStr, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(Clob searchClob, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkValidity();
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", pos);
        }
        if (pos > this.length() + 1L) {
            throw Util.generateCsSQLException("XJ076.S", new Object[0]);
        }
        if (str == null) {
            throw Util.generateCsSQLException("XJ072.S", new Object[0]);
        }
        if (str.length() == 0) {
            return 0;
        }
        if (offset < 0 || offset >= str.length()) {
            throw Util.generateCsSQLException("XJ078.S", new Object[0]);
        }
        if (len < 0) {
            throw Util.generateCsSQLException("XJ071.S", new Object[0]);
        }
        if (len + offset > str.length()) {
            throw Util.generateCsSQLException("22011.S.1", offset, len, str);
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            this.clob.insertString(str.substring(offset, offset + len), pos);
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", pos);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        return str.length();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            return new ClobAsciiStream(this.clob.getWriter(pos));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            return this.clob.getWriter(pos);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkValidity();
        if (len < 0L) {
            throw Util.generateCsSQLException("XJ071.S", len);
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone(len);
            } else {
                this.clob.truncate(len);
            }
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ079.S", eofe, len);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.isValid) {
            this.isValid = false;
            try {
                this.clob.release();
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
            finally {
                this.localConn.removeLOBMapping(this.locator);
                this.clob = null;
            }
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidity();
        if (pos <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", pos);
        }
        if (length < 0L) {
            throw Util.generateCsSQLException("XJ071.S", length);
        }
        if (length > this.length() - (pos - 1L)) {
            throw Util.generateCsSQLException("XJ087.S", pos, length);
        }
        try {
            return new ClobUpdatableReader(this, pos, length);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    private void checkValidity() throws SQLException {
        this.localConn.checkIfClosed();
        if (!this.isValid) {
            throw EmbedClob.newSQLException("XJ215.S", new Object[0]);
        }
    }

    private void makeWritableClobClone() throws IOException, SQLException {
        InternalClob toBeAbandoned = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, toBeAbandoned);
        toBeAbandoned.release();
    }

    private void makeWritableClobClone(long len) throws IOException, SQLException {
        InternalClob toBeAbandoned = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, toBeAbandoned, len);
        toBeAbandoned.release();
    }

    InternalClob getInternalClob() {
        return this.clob;
    }

    @Override
    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

