/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.trustworthiness.self;

import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.SelfAttestationProhibitedException;
import org.jetbrains.annotations.NotNull;

public class DefaultSelfAttestationTrustworthinessVerifier
implements SelfAttestationTrustworthinessVerifier {
    private boolean isSelfAttestationAllowed = true;

    @Override
    public void verify(@NotNull CertificateBaseAttestationStatement attestationStatement) {
        AssertUtil.notNull(attestationStatement, "attestationStatement must not be null");
        if (!this.isSelfAttestationAllowed()) {
            throw new SelfAttestationProhibitedException("SELF attestations is prohibited by configuration");
        }
        if (attestationStatement.getX5c() != null) {
            throw new BadAttestationStatementException("SELF attestation must not have x5c.");
        }
    }

    public boolean isSelfAttestationAllowed() {
        return this.isSelfAttestationAllowed;
    }

    public void setSelfAttestationAllowed(boolean selfAttestationAllowed) {
        this.isSelfAttestationAllowed = selfAttestationAllowed;
    }
}

