/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jetty;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServerThreadPoolMetrics
implements MeterBinder,
AutoCloseable {
    private static final String MIN = "jetty.threads.config.min";
    private static final String MAX = "jetty.threads.config.max";
    private static final String BUSY = "jetty.threads.busy";
    private static final String JOBS = "jetty.threads.jobs";
    private static final String CURRENT = "jetty.threads.current";
    private static final String IDLE = "jetty.threads.idle";
    private final ThreadPool threadPool;
    private final Iterable<Tag> tags;
    private final Set<Meter.Id> registeredMeterIds = ConcurrentHashMap.newKeySet();
    @Nullable
    private MeterRegistry registry;

    public JettyServerThreadPoolMetrics(ThreadPool threadPool, Iterable<Tag> tags) {
        this.threadPool = threadPool;
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
        if (this.threadPool instanceof ThreadPool.SizedThreadPool) {
            ThreadPool.SizedThreadPool sizedThreadPool = (ThreadPool.SizedThreadPool)this.threadPool;
            Gauge minGauge = Gauge.builder(MIN, sizedThreadPool, ThreadPool.SizedThreadPool::getMinThreads).description("The minimum number of threads in the pool").tags(this.tags).register(registry);
            this.registeredMeterIds.add(minGauge.getId());
            Gauge maxGauge = Gauge.builder(MAX, sizedThreadPool, ThreadPool.SizedThreadPool::getMaxThreads).description("The maximum number of threads in the pool").tags(this.tags).register(registry);
            this.registeredMeterIds.add(maxGauge.getId());
            if (this.threadPool instanceof QueuedThreadPool) {
                QueuedThreadPool queuedThreadPool = (QueuedThreadPool)this.threadPool;
                Gauge busyGauge = Gauge.builder(BUSY, queuedThreadPool, QueuedThreadPool::getBusyThreads).description("The number of busy threads in the pool").tags(this.tags).register(registry);
                this.registeredMeterIds.add(busyGauge.getId());
                Gauge jobsGauge = Gauge.builder(JOBS, queuedThreadPool, QueuedThreadPool::getQueueSize).description("Number of jobs queued waiting for a thread").tags(this.tags).register(registry);
                this.registeredMeterIds.add(jobsGauge.getId());
            }
        }
        Gauge currentGauge = Gauge.builder(CURRENT, this.threadPool, ThreadPool::getThreads).description("The total number of threads in the pool").tags(this.tags).register(registry);
        this.registeredMeterIds.add(currentGauge.getId());
        Gauge idleGauge = Gauge.builder(IDLE, this.threadPool, ThreadPool::getIdleThreads).description("The number of idle threads in the pool").tags(this.tags).register(registry);
        this.registeredMeterIds.add(idleGauge.getId());
    }

    @Override
    public void close() throws Exception {
        if (this.registry != null) {
            this.registeredMeterIds.forEach(this.registry::remove);
            this.registeredMeterIds.clear();
        }
    }
}

