/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ne extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0928\u093e\u0909\u0930\u0942";
        final String metaValue_WS = "\u0938\u093e\u092e\u094b\u0906";
        final String metaValue_ar = "\u0905\u0930\u092c\u0940";
        final String metaValue_hy = "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940";
        final String metaValue_ban = "\u092c\u093e\u0932\u0940";
        final String metaValue_chr = "\u091a\u0947\u0930\u094b\u0915\u0940";
        final String metaValue_ka = "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0932\u0940";
        final String metaValue_got = "\u0917\u094b\u0925\u093f\u0915";
        final String metaValue_el = "\u0917\u094d\u0930\u0940\u0915";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_he = "\u0939\u093f\u092c\u094d\u0930\u0941";
        final String metaValue_jv = "\u091c\u093e\u092d\u093e\u0928\u0940";
        final String metaValue_ja = "\u091c\u093e\u092a\u093e\u0928\u0940";
        final String metaValue_km = "\u0916\u092e\u0947\u0930";
        final String metaValue_lo = "\u0932\u093e\u0913";
        final String metaValue_la = "\u0932\u094d\u092f\u093e\u091f\u093f\u0928";
        final String metaValue_syr = "\u0938\u093f\u0930\u093f\u092f\u093e\u0915";
        final String metaValue_ta = "\u0924\u093e\u092e\u093f\u0932";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0941";
        final String metaValue_th = "\u0925\u093e\u0908";
        final String metaValue_bo = "\u0924\u093f\u092c\u094d\u092c\u0924\u0940";
        final String metaValue_vai = "\u092d\u093e\u0907";
        final String metaValue_Hans = "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901";
        final String metaValue_Deva = "\u0926\u0947\u0935\u093e\u0928\u093e\u0917\u0930\u0940";
        final String metaValue_type_ca_islamic = "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u092a\u093e\u0924\u094d\u0930\u094b";
        final Object[][] data = new Object[][] {
            { "001", "\u0935\u093f\u0936\u094d\u0935" },
            { "002", "\u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "003", "\u0909\u0924\u094d\u0924\u0930 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "005", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "009", "\u0913\u0938\u0928\u093f\u092f\u093e" },
            { "011", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "013", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "014", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "015", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "017", "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "018", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "019", "\u0905\u092e\u0947\u0930\u093f\u0915\u093e\u0938" },
            { "021", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "029", "\u0915\u094d\u092f\u093e\u0930\u093f\u092c\u093f\u092f\u0928" },
            { "030", "\u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "034", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "035", "\u0926\u0915\u094d\u0937\u093f\u0923 \u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "039", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "053", "\u0905\u0937\u094d\u091f\u094d\u0930\u093e\u0932\u093e\u0938\u093f\u092f\u093e" },
            { "054", "\u092e\u0947\u0932\u093e\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "057", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0938\u093f\u092f\u093e\u0932\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "061", "\u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "142", "\u090f\u0936\u093f\u092f\u093e" },
            { "143", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u090f\u0936\u093f\u092f\u093e" },
            { "145", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "150", "\u092f\u0941\u0930\u094b\u092a" },
            { "151", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "154", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "155", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "202", "\u0909\u092a-\u0938\u093e\u0939\u093e\u0930\u093e \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "419", "\u0932\u094d\u092f\u093e\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "AC", "\u0905\u0938\u0947\u0928\u094d\u0938\u0928 \u091f\u093e\u092a\u0941" },
            { "AD", "\u0905\u0928\u094d\u0921\u094b\u0930\u094d\u0930\u093e" },
            { "AE", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0907\u092e\u093f\u0930\u093e\u091f\u094d\u0938" },
            { "AF", "\u0905\u092b\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0928\u094d\u091f\u093f\u0917\u0941\u0906 \u0930 \u092c\u093e\u0930\u092c\u0941\u0921\u093e" },
            { "AI", "\u0906\u0919\u094d\u0917\u0941\u0907\u0932\u093e" },
            { "AL", "\u0905\u0932\u094d\u092c\u0947\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "AO", "\u0905\u0919\u094d\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0928\u094d\u091f\u093e\u0930\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0928\u094d\u091f\u093f\u0928\u093e" },
            { "AS", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u092e\u094b\u0906" },
            { "AT", "\u0905\u0937\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0905\u0930\u0941\u092c\u093e" },
            { "AX", "\u0905\u0932\u093e\u0928\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "AZ", "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928" },
            { "BA", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u090f\u0923\u094d\u0921 \u0939\u0930\u094d\u091c\u0917\u094b\u092d\u093f\u0928\u093f\u092f\u093e" },
            { "BB", "\u092c\u093e\u0930\u094d\u092c\u093e\u0921\u094b\u0938" },
            { "BD", "\u092c\u0919\u094d\u0917\u0932\u093e\u0926\u0947\u0936" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093e\u0938\u094b" },
            { "BG", "\u092c\u0941\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u0939\u0930\u093e\u0907\u0928" },
            { "BI", "\u092c\u0941\u0930\u0942\u0923\u094d\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u093f\u0928" },
            { "BL", "\u0938\u0947\u0928\u094d\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u0930\u094d\u092e\u0941\u0921\u093e" },
            { "BN", "\u092c\u094d\u0930\u0941\u0928\u093e\u0907" },
            { "BO", "\u092c\u094b\u0932\u093f\u092d\u093f\u092f\u093e" },
            { "BQ", "\u0915\u094d\u092f\u093e\u0930\u093f\u0935\u093f\u092f\u0928 \u0928\u0947\u0926\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921\u094d\u0938" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u093f\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e\u0938" },
            { "BT", "\u092d\u0941\u091f\u093e\u0928" },
            { "BV", "\u092c\u0941\u092d\u0947\u091f \u091f\u093e\u092a\u0941" },
            { "BW", "\u092c\u094b\u091f\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u093f\u091c" },
            { "CA", "\u0915\u094d\u092f\u093e\u0928\u093e\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 (\u0915\u093f\u0932\u093f\u0902\u0917) \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "CD", "\u0915\u0919\u094d\u0917\u094b - \u0915\u093f\u0928\u094d\u0936\u093e\u0938\u093e" },
            { "CF", "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930" },
            { "CG", "\u0915\u0919\u094d\u0917\u094b \u092c\u094d\u0930\u093e\u091c\u093e\u092d\u093f\u0932" },
            { "CH", "\u0938\u094d\u0935\u093f\u091c\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "CI", "\u0915\u094b\u091f \u0926\u093f\u092d\u094b\u0930" },
            { "CK", "\u0915\u0941\u0915 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "CM", "\u0915\u094d\u092f\u093e\u092e\u0930\u0942\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u094b\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "CP", "\u0915\u094d\u0932\u093f\u092a\u094d\u092a\u0947\u0930\u094d\u091f\u0928 \u091f\u093e\u092a\u0941" },
            { "CR", "\u0915\u094b\u0937\u094d\u091f\u093e\u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0941\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u092d\u0930\u094d\u0921\u0947" },
            { "CW", "\u0915\u0941\u0930\u093e\u0915\u093e\u0913" },
            { "CX", "\u0915\u094d\u0930\u093f\u0937\u094d\u091f\u092e\u0938 \u091f\u093e\u092a\u0941" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915\u093f\u092f\u093e" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "DG", "\u0921\u093f\u092f\u0917\u094b \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "DJ", "\u0921\u093f\u091c\u093f\u092c\u0941\u091f\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "EA", "\u0938\u093f\u0909\u091f\u093e \u0930 \u092e\u0947\u0932\u093f\u0932\u093e" },
            { "EC", "\u0907\u0915\u094d\u0935\u0947\u0921\u094b\u0930" },
            { "EE", "\u0907\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "EG", "\u0907\u091c\u093f\u092a\u094d\u091f" },
            { "EH", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u093e\u0939\u093e\u0930\u093e" },
            { "ER", "\u090f\u0930\u093f\u091f\u094d\u0930\u0940\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0941\u0930\u094b\u092a\u093f\u092f\u0928 \u092f\u0941\u0928\u093f\u092f\u0928" },
            { "EZ", "\u092f\u0941\u0930\u094b\u091c\u094b\u0928" },
            { "FI", "\u092b\u093f\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "FJ", "\u092b\u093f\u091c\u0940" },
            { "FK", "\u092b\u0915\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "FO", "\u092b\u093e\u0930\u094b \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "FR", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938" },
            { "GA", "\u0917\u093e\u0935\u094b\u0928" },
            { "GB", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0927\u093f\u0930\u093e\u091c\u094d\u092f" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e" },
            { "GE", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u0917\u093e\u092f\u0928\u093e" },
            { "GG", "\u0917\u094d\u092f\u0942\u0930\u094d\u0928\u094d\u0938\u0940" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u093e\u0930" },
            { "GL", "\u0917\u094d\u0930\u093f\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "GM", "\u0917\u093e\u092e\u094d\u0935\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940" },
            { "GP", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0941\u092a" },
            { "GQ", "\u092d\u0942-\u092e\u0927\u094d\u092f\u0940\u092f \u0917\u093f\u0928\u0940" },
            { "GR", "\u0917\u094d\u0930\u0940\u0938" },
            { "GS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0930 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u094d\u092f\u093e\u0928\u094d\u0921\u0935\u0940\u091a \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "GT", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0935\u093e\u092e" },
            { "GW", "\u0917\u093f\u0928\u0940-\u092c\u093f\u0938\u093e\u0909" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "HK", "\u0939\u0919\u0915\u0919 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "HM", "\u0939\u0930\u094d\u0921 \u091f\u093e\u092a\u0941 \u0930 \u092e\u094d\u092f\u093e\u0915\u0921\u094b\u0928\u093e\u0932\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "HN", "\u0939\u0928\u094d\u0921\u0941\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e" },
            { "HT", "\u0939\u0948\u091f\u0940" },
            { "HU", "\u0939\u0919\u094d\u0917\u0947\u0930\u0940" },
            { "IC", "\u0915\u094d\u092f\u093e\u0928\u093e\u0930\u0940 \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "ID", "\u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "IE", "\u0906\u092f\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "IL", "\u0907\u091c\u0930\u093e\u092f\u0932" },
            { "IM", "\u0906\u0907\u0932 \u0905\u092b \u092e\u094d\u092f\u093e\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "IO", "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u0939\u093f\u0928\u094d\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "IQ", "\u0907\u0930\u093e\u0915" },
            { "IR", "\u0907\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u094d\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "IT", "\u0907\u091f\u0932\u0940" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "JM", "\u091c\u092e\u0948\u0915\u093e" },
            { "JO", "\u091c\u094b\u0930\u094d\u0921\u0928" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "KE", "\u0915\u0947\u0928\u094d\u092f\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u092e\u094d\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u091f\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u0938" },
            { "KN", "\u0938\u0947\u0928\u094d\u091f \u0915\u093f\u091f\u094d\u0938 \u0930 \u0928\u0947\u092d\u093f\u0938" },
            { "KP", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KW", "\u0915\u0941\u0935\u0947\u0924" },
            { "KY", "\u0915\u0947\u092f\u092e\u093e\u0928 \u091f\u093e\u092a\u0941" },
            { "KZ", "\u0915\u093e\u091c\u093e\u0915\u0938\u094d\u0924\u093e\u0928" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u0928" },
            { "LC", "\u0938\u0947\u0928\u094d\u091f \u0932\u0941\u0938\u093f\u092f\u093e" },
            { "LI", "\u0932\u093f\u0915\u091f\u0947\u0928\u094d\u0938\u091f\u093e\u0907\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940\u0932\u0919\u094d\u0915\u093e" },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "LS", "\u0932\u0947\u0938\u094b\u0925\u094b" },
            { "LT", "\u0932\u093f\u0925\u0941\u090f\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0915\u094d\u091c\u0947\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u091f\u094d\u092d\u093f\u092f\u093e" },
            { "LY", "\u0932\u093f\u092c\u093f\u092f\u093e" },
            { "MA", "\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u093e\u0915\u094b" },
            { "MD", "\u092e\u093e\u0932\u094d\u0921\u094b\u092d\u093e" },
            { "ME", "\u092e\u094b\u0928\u094d\u091f\u0947\u0928\u093f\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0947\u0928\u094d\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "MG", "\u092e\u093e\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0932 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "MK", "\u0909\u0924\u094d\u0924\u0930 \u092e\u094d\u092f\u093e\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)" },
            { "MN", "\u092e\u0919\u094d\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "MO", "\u092e\u0915\u093e\u0909 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "MP", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u0906\u0928\u093e \u091f\u093e\u092a\u0941" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u093f\u0928\u093f\u0915" },
            { "MR", "\u092e\u093e\u0909\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u094b\u0928\u094d\u091f\u0938\u0947\u0930\u094d\u0930\u093e\u091f" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "MU", "\u092e\u094c\u0930\u093f\u0938\u093f\u092f\u0938" },
            { "MV", "\u092e\u093e\u0932\u094d\u0926\u093f\u092d\u094d\u0938" },
            { "MW", "\u092e\u093e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "MY", "\u092e\u0932\u0947\u0938\u093f\u092f\u093e" },
            { "MZ", "\u092e\u094b\u091c\u093e\u092e\u094d\u092c\u093f\u0915" },
            { "NA", "\u0928\u093e\u092e\u093f\u092c\u093f\u092f\u093e" },
            { "NC", "\u0928\u094d\u092f\u0941 \u0915\u094d\u092f\u093e\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0930" },
            { "NF", "\u0928\u094b\u0930\u092b\u094b\u0932\u094d\u0915 \u091f\u093e\u092a\u0941" },
            { "NG", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0935\u093e" },
            { "NL", "\u0928\u0947\u0926\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "NO", "\u0928\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", metaValue_NR },
            { "NU", "\u0928\u093f\u092f\u0941\u0907" },
            { "NZ", "\u0928\u094d\u092f\u0941\u091c\u093f\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "OM", "\u0913\u092e\u0928" },
            { "PA", "\u092a\u094d\u092f\u093e\u0928\u093e\u092e\u093e" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u092a\u094b\u0932\u093f\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "PG", "\u092a\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093e\u0907\u0928\u093f\u092f\u093e" },
            { "PH", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u094d\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "PM", "\u0938\u0947\u0928\u094d\u091f \u092a\u093f\u0930\u094d\u0930\u0947 \u0930 \u092e\u093f\u0915\u094d\u0915\u0947\u0932\u094b\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u093e\u0907\u0930\u094d\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "PR", "\u092a\u0941\u090f\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "PS", "\u092a\u094d\u092f\u093e\u0932\u0947\u0938\u094d\u091f\u093f\u0928\u0940 \u092d\u0942-\u092d\u093e\u0917\u0939\u0930\u0942" },
            { "PT", "\u092a\u094b\u0930\u094d\u091a\u0941\u0917\u0932" },
            { "PW", "\u092a\u0932\u093e\u0909" },
            { "PY", "\u092a\u094d\u092f\u093e\u0930\u093e\u0917\u094d\u0935\u0947" },
            { "QA", "\u0915\u0924\u093e\u0930" },
            { "QO", "\u092c\u093e\u0939\u094d\u092f \u0913\u0938\u0928\u093f\u092f\u093e" },
            { "RE", "\u0930\u093f\u092f\u0941\u0928\u093f\u092f\u0928" },
            { "RO", "\u0930\u094b\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u0935\u093e\u0923\u094d\u0921\u093e" },
            { "SA", "\u0938\u093e\u0909\u0926\u0940 \u0905\u0930\u092c" },
            { "SB", "\u0938\u094b\u0932\u094b\u092e\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "SC", "\u0938\u0947\u091a\u0947\u0932\u0947\u0938" },
            { "SD", "\u0938\u0941\u0921\u093e\u0928" },
            { "SE", "\u0938\u094d\u0935\u093f\u0921\u0947\u0928" },
            { "SG", "\u0938\u093f\u0919\u094d\u0917\u093e\u092a\u0941\u0930" },
            { "SH", "\u0938\u0947\u0928\u094d\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u092d\u0947\u0928\u093f\u092f\u093e" },
            { "SJ", "\u0938\u092d\u093e\u0932\u094d\u092c\u093e\u0930\u094d\u0921 \u0930 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "SK", "\u0938\u094d\u0932\u094b\u092d\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u090f\u0930\u094d\u0930\u093e \u0932\u093f\u0913\u0928" },
            { "SM", "\u0938\u093e\u0928\u094d \u092e\u093e\u0930\u093f\u0928\u094b" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "SR", "\u0938\u0941\u0930\u093f\u0928\u0947\u092e" },
            { "SS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0941\u0921\u093e\u0928" },
            { "ST", "\u0938\u093e\u0913 \u091f\u094b\u092e\u0947 \u0930 \u092a\u094d\u0930\u093f\u0928\u094d\u0938\u093f\u092a" },
            { "SV", "\u090f\u0932\u094d \u0938\u093e\u0932\u094d\u092d\u093e\u0921\u094b\u0930" },
            { "SX", "\u0938\u093f\u0928\u094d\u091f \u092e\u093e\u0930\u094d\u091f\u0947\u0928" },
            { "SY", "\u0938\u093f\u0930\u093f\u092f\u093e" },
            { "SZ", "\u0938\u094d\u0935\u093e\u091c\u093f\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "TA", "\u091f\u094d\u0930\u093f\u0938\u094d\u091f\u093e\u0928 \u0921\u093e \u0915\u0941\u0928\u094d\u0939\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915 \u0930 \u0915\u093e\u0907\u0915\u094b\u0938 \u091f\u093e\u092a\u0941" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0930\u093e\u091c\u094d\u092f\u0939\u0930\u0942" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0925\u093e\u0907\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "TJ", "\u0924\u093e\u091c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TK", "\u0924\u094b\u0915\u0947\u0932\u093e\u0909" },
            { "TL", "\u091f\u093f\u092e\u094b\u0930-\u0932\u0947\u0938\u094d\u091f\u0947" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u091f\u094d\u092f\u0941\u0928\u093f\u0938\u093f\u092f\u093e" },
            { "TO", "\u091f\u094b\u0902\u0917\u093e" },
            { "TR", "\u0924\u0941\u0930\u094d\u0915\u093f\u092f\u0947" },
            { "TT", "\u0924\u094d\u0930\u093f\u0928\u093f\u0921\u093e\u0921 \u090f\u0923\u094d\u0921 \u091f\u094b\u092c\u093e\u0917\u094b" },
            { "TV", "\u0924\u0941\u092d\u093e\u0932\u0941" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "TZ", "\u0924\u093e\u0928\u094d\u091c\u093e\u0928\u093f\u092f\u093e" },
            { "UA", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928" },
            { "UG", "\u092f\u0941\u0917\u093e\u0923\u094d\u0921\u093e" },
            { "UM", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f\u0915\u093e \u092c\u093e\u0939\u094d\u092f \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "UN", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u0937\u094d\u091f\u094d\u0930 \u0938\u0902\u0918" },
            { "US", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f" },
            { "UY", "\u0909\u0930\u0942\u0917\u094d\u0935\u0947" },
            { "UZ", "\u0909\u091c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "VA", "\u092d\u0947\u091f\u093f\u0915\u0928 \u0938\u093f\u091f\u0940" },
            { "VC", "\u0938\u0947\u0928\u094d\u091f \u092d\u093f\u0928\u094d\u0938\u0947\u0928\u094d\u091f \u0930 \u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093f\u0928\u094d\u0938" },
            { "VE", "\u092d\u0947\u0928\u0947\u091c\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u092d\u0930\u094d\u091c\u093f\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "VI", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f \u092d\u0930\u094d\u091c\u093f\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "VN", "\u092d\u093f\u090f\u0924\u0928\u093e\u092e" },
            { "VU", "\u092d\u093e\u0928\u0941\u0906\u0924\u0941" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0930 \u092b\u0941\u091f\u0941\u0928\u093e" },
            { "WS", metaValue_WS },
            { "XA", "\u0938\u093f\u0909\u0921\u094b-\u090f\u0915\u094d\u0938\u0947\u0928\u094d\u091f\u094d\u0938" },
            { "XB", "\u0938\u093f\u0909\u0921\u094b-\u092c\u093f\u0921\u0940" },
            { "XK", "\u0915\u094b\u0938\u094b\u092d\u094b" },
            { "YE", "\u092f\u0947\u092e\u0947\u0928" },
            { "YT", "\u092e\u093e\u092f\u094b\u091f\u094d\u091f" },
            { "ZA", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "ZM", "\u091c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093f\u092e\u094d\u092c\u093e\u092c\u0935\u0947" },
            { "ZZ", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "aa", "\u0905\u092b\u093e\u0930" },
            { "ab", "\u0905\u092c\u094d\u0916\u093e\u091c\u093f\u092f\u093e\u0932\u0940" },
            { "ae", "\u0905\u0935\u0947\u0938\u094d\u0924\u093e\u0928" },
            { "af", "\u0905\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u094d\u0938" },
            { "ak", "\u0906\u0915\u093e\u0928" },
            { "am", "\u0905\u092e\u094d\u0939\u093e\u0930\u093f\u0915" },
            { "an", "\u0905\u0930\u093e\u0917\u094b\u0928\u0940" },
            { "ar", metaValue_ar },
            { "as", "\u0906\u0938\u093e\u092e\u0940" },
            { "av", "\u0905\u0935\u093e\u0930\u093f\u0915" },
            { "ay", "\u0910\u092e\u093e\u0930\u093e" },
            { "az", "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928\u0940" },
            { "ba", "\u092c\u093e\u0938\u094d\u0915\u093f\u0930" },
            { "be", "\u092c\u0947\u0932\u093e\u0930\u0941\u0938\u0940" },
            { "bg", "\u092c\u0941\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "bi", "\u092c\u093f\u0938\u094d\u0932\u093e\u092e" },
            { "bm", "\u092c\u093e\u092e\u094d\u092c\u093e\u0930\u093e" },
            { "bn", "\u092c\u0902\u0917\u093e\u0932\u0940" },
            { "bo", metaValue_bo },
            { "br", "\u092c\u094d\u0930\u0947\u091f\u0928" },
            { "bs", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "ca", "\u0915\u094d\u092f\u093e\u091f\u093e\u0932\u0928" },
            { "ce", "\u091a\u0947\u091a\u0947\u0928" },
            { "ch", "\u091a\u093e\u092e\u094b\u0930\u094d\u0930\u094b" },
            { "co", "\u0915\u094b\u0930\u094d\u0938\u093f\u0915\u0928" },
            { "cr", "\u0915\u094d\u0930\u0940" },
            { "cs", "\u091a\u0947\u0915" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u094d\u0932\u093e\u092d\u093f\u0915" },
            { "cv", "\u091a\u0941\u092d\u093e\u0938" },
            { "cy", "\u0935\u0947\u0932\u094d\u0936" },
            { "da", "\u0921\u0947\u0928\u093f\u0938" },
            { "de", "\u091c\u0930\u094d\u092e\u0928" },
            { "dv", "\u0926\u093f\u092c\u0947\u0939\u0940" },
            { "dz", "\u091c\u094b\u0919\u094d\u0916\u093e" },
            { "ee", "\u0907\u0935\u0940" },
            { "el", metaValue_el },
            { "en", "\u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "eo", "\u090f\u0938\u094d\u092a\u0947\u0930\u093e\u0928\u094d\u0924\u094b" },
            { "es", "\u0938\u094d\u092a\u0947\u0928\u0940" },
            { "et", "\u0907\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u0928" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "fa", "\u092b\u093e\u0930\u0938\u0940" },
            { "ff", "\u092b\u0941\u0932\u093e\u0939" },
            { "fi", "\u092b\u093f\u0928\u093f\u0938" },
            { "fj", "\u092b\u093f\u091c\u093f\u092f\u0928" },
            { "fo", "\u092b\u093e\u0930\u094b\u091c" },
            { "fr", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "fy", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092b\u094d\u0930\u093f\u0938\u093f\u092f\u0928" },
            { "ga", "\u0906\u0907\u0930\u093f\u0938" },
            { "gd", "\u0938\u094d\u0915\u091f\u093f\u0938 \u0917\u093e\u090f\u0932\u093f\u0915" },
            { "gl", "\u0917\u0932\u093f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "gn", "\u0917\u0941\u0935\u093e\u0930\u093e\u0928\u0940" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u093e\u0928\u094d\u0915\u094d\u0938" },
            { "ha", "\u0939\u093e\u0909\u0938\u093e" },
            { "he", metaValue_he },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "ho", "\u0939\u093f\u0930\u0940 \u092e\u094b\u091f\u0941" },
            { "hr", "\u0915\u094d\u0930\u094b\u092f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "ht", "\u0939\u0948\u091f\u093f\u092f\u093e\u0932\u0940 \u0915\u094d\u0930\u093f\u092f\u094b\u0932" },
            { "hu", "\u0939\u0919\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "hy", metaValue_hy },
            { "hz", "\u0939\u0947\u0930\u0947\u0930\u094b" },
            { "ia", "\u0907\u0928\u094d\u091f\u0930\u094d\u0932\u093f\u0919\u094d\u0917\u0941\u0906" },
            { "id", "\u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "ie", "\u0907\u0928\u094d\u091f\u0930\u0932\u093f\u0919\u094d\u0917\u094d\u0935\u0947" },
            { "ig", "\u0907\u0917\u094d\u092c\u094b" },
            { "ii", "\u0938\u093f\u091a\u0941\u0906\u0928 \u092f\u093f" },
            { "ik", "\u0907\u0928\u0941\u092a\u093f\u0906\u0915\u094d" },
            { "io", "\u0907\u0921\u094b" },
            { "is", "\u0906\u0907\u0938\u0932\u094d\u092f\u093e\u0928\u094d\u0921\u093f\u092f\u093e\u0932\u0940" },
            { "it", "\u0907\u091f\u093e\u0932\u0947\u0932\u0940" },
            { "iu", "\u0907\u0928\u0941\u0915\u094d\u091f\u093f\u091f\u0941\u091f" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "\u0915\u094b\u0919\u094d\u0917\u094b" },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0941" },
            { "kj", "\u0915\u0941\u0906\u0928\u094d\u092f\u093e\u092e\u093e" },
            { "kk", "\u0915\u093e\u091c\u093e\u0916" },
            { "kl", "\u0915\u093e\u0932\u093e\u0932\u093f\u0938\u0941\u091f" },
            { "km", metaValue_km },
            { "kn", "\u0915\u0928\u094d\u0928\u093e\u0921\u093e" },
            { "ko", "\u0915\u094b\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "kr", "\u0915\u093e\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u093e\u0938\u094d\u092e\u093f\u0930\u0940" },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u0940" },
            { "kv", "\u0915\u094b\u092e\u0940" },
            { "kw", "\u0915\u094b\u0930\u094d\u0928\u093f\u0938" },
            { "ky", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c" },
            { "la", metaValue_la },
            { "lb", "\u0932\u0915\u094d\u091c\u0947\u092e\u094d\u092c\u0930\u094d\u0917\u0940" },
            { "lg", "\u0917\u093e\u0928\u094d\u0921\u093e" },
            { "li", "\u0932\u093f\u092e\u094d\u092c\u0941\u0930\u094d\u0917\u0940" },
            { "ln", "\u0932\u093f\u0919\u094d\u0917\u093e\u0932\u093e" },
            { "lo", metaValue_lo },
            { "lt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "lu", "\u0932\u0941\u092c\u093e-\u0915\u093e\u0924\u093e\u0919\u094d\u0917\u093e" },
            { "lv", "\u0932\u093e\u0924\u094d\u092d\u093f\u092f\u093e\u0932\u0940" },
            { "mg", "\u092e\u0932\u093e\u0917\u093e\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0938\u093e\u0932\u0940" },
            { "mi", "\u092e\u093e\u0913\u0930\u0940" },
            { "mk", "\u092e\u094d\u092f\u093e\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u0928" },
            { "ml", "\u092e\u0932\u092f\u093e\u0932\u092e" },
            { "mn", "\u092e\u0919\u094d\u0917\u094b\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u093e\u092f" },
            { "mt", "\u092e\u093e\u0932\u094d\u091f\u093f\u091c" },
            { "my", "\u092c\u0930\u094d\u092e\u0947\u0932\u0940" },
            { "na", metaValue_NR },
            { "nb", "\u0928\u0930\u094d\u0935\u0947\u0932\u0940 \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "nd", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0928\u094d\u0921\u0947\u092c\u0947\u0932\u0947" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "ng", "\u0928\u094d\u0926\u094b\u0928\u094d\u0917\u093e" },
            { "nl", "\u0921\u091a" },
            { "nn", "\u0928\u0930\u094d\u0935\u0947\u0932\u0940 \u0928\u093e\u0907\u0928\u094b\u0930\u094d\u0938\u094d\u0915" },
            { "no", "\u0928\u0930\u094d\u0935\u0947\u0932\u0940" },
            { "nr", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0928\u094d\u0926\u0947\u092c\u0947\u0932\u0947" },
            { "nv", "\u0928\u093e\u092d\u093e\u091c\u094b" },
            { "ny", "\u0928\u094d\u092f\u093e\u0928\u094d\u091c\u093e" },
            { "oc", "\u0905\u0915\u094d\u0938\u093f\u091f\u0928" },
            { "oj", "\u0913\u091c\u093f\u092c\u094d\u0935\u093e" },
            { "om", "\u0913\u0930\u094b\u092e\u094b" },
            { "or", "\u0909\u0921\u093f\u092f\u093e" },
            { "os", "\u0913\u0938\u094d\u0938\u0947\u091f\u093f\u0915" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "pi", "\u092a\u093e\u0932\u0940" },
            { "pl", "\u092a\u094b\u0932\u093f\u0938" },
            { "ps", "\u092a\u093e\u0938\u094d\u0924\u094b" },
            { "pt", "\u092a\u094b\u0930\u094d\u0924\u0941\u0917\u0940" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u0941\u0935\u093e" },
            { "rm", "\u0930\u094b\u092e\u093e\u0928\u093f\u0938" },
            { "rn", "\u0930\u0941\u0928\u094d\u0921\u0940" },
            { "ro", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "ru", "\u0930\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u0935\u093e\u0928\u094d\u0921\u093e" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sc", "\u0938\u093e\u0930\u094d\u0921\u093f\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sd", "\u0938\u093f\u0928\u094d\u0927\u0940" },
            { "se", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "sg", "\u0938\u093e\u0919\u094d\u0917\u094b" },
            { "si", "\u0938\u093f\u0928\u094d\u0939\u093e\u0932\u0940" },
            { "sk", "\u0938\u094d\u0932\u094b\u092d\u093e\u0915\u093f\u092f\u093e\u0932\u0940" },
            { "sl", "\u0938\u094d\u0932\u094b\u092d\u0947\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sm", metaValue_WS },
            { "sn", "\u0936\u094b\u0928\u093e" },
            { "so", "\u0938\u094b\u092e\u093e\u0932\u0940" },
            { "sq", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0932\u0940" },
            { "ss", "\u0938\u094d\u0935\u093e\u0924\u0940" },
            { "st", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u094b\u0925\u094b" },
            { "su", "\u0938\u0941\u0921\u093e\u0928\u0940" },
            { "sv", "\u0938\u094d\u0935\u093f\u0921\u093f\u0938" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0924\u093e\u091c\u093f\u0915" },
            { "th", metaValue_th },
            { "ti", "\u091f\u093f\u0917\u094d\u0930\u093f\u0928\u094d\u092f\u093e" },
            { "tk", "\u091f\u0930\u094d\u0915\u092e\u0947\u0928" },
            { "tn", "\u091f\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", "\u091f\u094b\u0919\u094d\u0917\u0928" },
            { "tr", "\u091f\u0930\u094d\u0915\u093f\u0936" },
            { "ts", "\u091f\u094d\u0938\u094b\u0919\u094d\u0917\u093e" },
            { "tt", "\u0924\u093e\u0924\u093e\u0930" },
            { "ty", "\u091f\u093e\u0939\u093f\u091f\u093f\u092f\u0928" },
            { "ug", "\u0909\u0907\u0918\u0941\u0930" },
            { "uk", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928\u0940" },
            { "ur", "\u0909\u0930\u094d\u0926\u0941" },
            { "uz", "\u0909\u091c\u094d\u092c\u0947\u0915\u0940" },
            { "ve", "\u092d\u0947\u0928\u094d\u0921\u093e" },
            { "vi", "\u092d\u093f\u092f\u0924\u0928\u093e\u092e\u0940" },
            { "vo", "\u092d\u094b\u0932\u093e\u092a\u093f\u0915" },
            { "wa", "\u0935\u093e\u0932\u094d\u0932\u0941\u0928" },
            { "wo", "\u0935\u0941\u0932\u0941\u092b" },
            { "xh", "\u0916\u094b\u0938\u093e" },
            { "yi", "\u092f\u093f\u0926\u094d\u0926\u093f\u0938" },
            { "yo", "\u092f\u094b\u0930\u0942\u0935\u093e" },
            { "zh", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "zu", "\u091c\u0941\u0932\u0941" },
            { "ace", "\u0905\u091a\u093e\u0907\u0928\u093f\u091c" },
            { "ach", "\u0905\u0915\u094b\u0932\u0940" },
            { "ada", "\u0905\u0926\u093e\u0919\u092e\u0947" },
            { "ady", "\u0905\u0926\u093f\u0918\u0947" },
            { "afh", "\u0905\u092b\u094d\u0930\u093f\u0939\u093f\u0932\u0940" },
            { "agq", "\u0906\u0918\u0947\u092e" },
            { "ain", "\u0905\u0907\u0928\u0941" },
            { "akk", "\u0905\u0915\u094d\u0915\u093e\u0926\u093f\u092f\u093e\u0932\u0940" },
            { "akz", "\u0905\u0932\u093e\u092c\u093e\u092e\u093e" },
            { "ale", "\u0905\u0932\u0947\u0909\u091f" },
            { "aln", "\u0918\u0947\u0917 \u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "alt", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0906\u0932\u094d\u091f\u093e\u0907" },
            { "ang", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "ann", "\u0913\u092c\u094b\u0932\u094b" },
            { "anp", "\u0905\u0919\u094d\u0917\u093f\u0915\u093e" },
            { "arc", "\u0905\u0930\u093e\u092e\u093e\u0907\u0915" },
            { "arn", "\u092e\u093e\u092a\u0941\u091a\u0947" },
            { "aro", "\u0905\u0930\u093e\u0913\u0928\u093e" },
            { "arp", "\u0905\u0930\u093e\u092a\u093e\u0939\u094b" },
            { "arq", "\u0905\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e\u0932\u0940 \u0905\u0930\u092c\u0940" },
            { "ars", "\u0928\u093e\u091c\u094d\u0926\u0940 \u0905\u0930\u0935\u093f\u0915" },
            { "arw", "\u0905\u0930\u093e\u0935\u093e\u0915" },
            { "ary", "\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b\u0932\u0940 \u0905\u0930\u092c\u0940" },
            { "arz", "\u0907\u091c\u093f\u092a\u094d\u091f \u0905\u0930\u092c\u0940" },
            { "asa", "\u0906\u0938\u0941" },
            { "ase", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u093e\u0919\u094d\u0915\u0947\u0924\u093f\u0915 \u092d\u093e\u0937\u093e" },
            { "ast", "\u0905\u0938\u094d\u091f\u0941\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "atj", "\u0906\u0924\u093f\u0915\u093e\u092e\u093f\u0915\u094b" },
            { "avk", "\u0915\u094b\u091f\u093e\u0935\u093e" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "bal", "\u092c\u093e\u0932\u0941\u091a\u0940" },
            { "ban", metaValue_ban },
            { "bar", "\u092c\u093e\u092d\u093e\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "bas", "\u092c\u093e\u0938\u093e" },
            { "bax", "\u092c\u093e\u092e\u0941\u0928" },
            { "bbc", "\u092c\u093e\u0924\u093e\u0915 \u0924\u094b\u092c\u093e" },
            { "bbj", "\u0918\u094b\u092e\u093e\u0932\u093e" },
            { "bej", "\u092c\u0947\u091c\u093e" },
            { "bem", "\u092c\u0947\u092e\u094d\u092c\u093e" },
            { "bew", "\u092c\u0947\u091f\u093e\u0935\u0940" },
            { "bez", "\u092c\u0947\u0928\u093e" },
            { "bfd", "\u092c\u093e\u092b\u0941\u091f" },
            { "bfq", "\u092c\u0921\u093e\u0917\u093e" },
            { "bgn", "\u092a\u0936\u094d\u091a\u093f\u092e \u092c\u093e\u0932\u094b\u091a\u0940" },
            { "bho", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940" },
            { "bik", "\u092c\u093f\u0915\u094b\u0932" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "bjn", "\u092c\u0928\u094d\u091c\u093e\u0930" },
            { "bkm", "\u0915\u094b\u092e" },
            { "bla", "\u0938\u093f\u0915\u094d\u0938\u093f\u0915\u093e" },
            { "bpy", "\u0935\u093f\u0937\u094d\u0923\u0941\u092a\u094d\u0930\u093f\u092f\u093e" },
            { "bqi", "\u092c\u093e\u0916\u094d\u0924\u093f\u0906\u0930\u0940" },
            { "bra", "\u092c\u094d\u0930\u091c" },
            { "brh", "\u092c\u094d\u0930\u093e\u0939\u0941\u0907" },
            { "brx", "\u092c\u094b\u0921\u094b" },
            { "bss", "\u0905\u0915\u0941\u091c" },
            { "bua", "\u092c\u0941\u0930\u093f\u0906\u0924" },
            { "bug", "\u092c\u0941\u0917\u093f\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "bum", "\u092c\u0941\u0932\u0941" },
            { "byn", "\u092c\u094d\u0932\u093f\u0928" },
            { "byv", "\u092e\u0947\u0921\u0941\u092e\u094d\u092c\u093e" },
            { "cad", "\u0915\u093e\u0921\u094d\u0921\u094b" },
            { "car", "\u0915\u094d\u092f\u093e\u0930\u093f\u092c" },
            { "cay", "\u0915\u093e\u092f\u0941\u0917\u093e" },
            { "cch", "\u0905\u091f\u094d\u0938\u093e\u092e" },
            { "ccp", "\u091a\u093e\u0915\u094d\u092e\u093e" },
            { "ceb", "\u0938\u0947\u092c\u0941\u0906\u0928\u094b" },
            { "cgg", "\u091a\u093f\u0917\u093e" },
            { "chb", "\u091a\u093f\u092c\u094d\u091a\u093e" },
            { "chg", "\u091a\u093e\u0917\u093e\u091f\u093e\u0908" },
            { "chk", "\u091a\u0941\u0915\u0947\u0938\u0947" },
            { "chm", "\u092e\u093e\u0930\u0940" },
            { "chn", "\u091a\u093f\u0928\u0941\u0915 \u091c\u093e\u0930\u094d\u0917\u0928" },
            { "cho", "\u091a\u094b\u0915\u094d\u091f\u093e\u0935" },
            { "chp", "\u091a\u093f\u092a\u0947\u0935\u094d\u092f\u093e\u0928" },
            { "chr", metaValue_chr },
            { "chy", "\u091a\u0947\u092f\u0947\u0928\u094d\u0928\u0947" },
            { "ckb", "\u092e\u0927\u094d\u092f\u0935\u0930\u094d\u0924\u0940 \u0915\u0941\u0930\u094d\u0926\u093f\u0938" },
            { "clc", "\u091a\u093f\u0932\u0915\u094b\u091f\u093f\u0928" },
            { "cop", "\u0915\u094b\u092a\u094d\u091f\u093f\u0915" },
            { "cps", "\u0915\u093e\u092a\u093f\u091c\u094d\u0928\u094b\u0928" },
            { "crg", "\u092e\u093f\u091a\u093f\u092b" },
            { "crh", "\u0915\u094d\u0930\u093f\u092e\u093f\u092f\u093e\u0932\u0940 \u0924\u0941\u0930\u094d\u0915" },
            { "crj", "\u0926\u0915\u094d\u0937\u093f\u0923 \u092a\u0942\u0930\u094d\u0935\u0940 \u0915\u094d\u0930\u0940" },
            { "crk", "\u092a\u094d\u0932\u0947\u0928\u094d\u0938 \u0915\u094d\u0930\u0940" },
            { "crl", "\u0909\u0924\u094d\u0924\u0930 \u092a\u0942\u0930\u094d\u0935\u0940 \u0915\u094d\u0930\u0940" },
            { "crm", "\u092e\u0941\u091c \u0915\u094d\u0930\u0940" },
            { "crr", "\u0915\u094d\u092f\u093e\u0930\u094b\u0932\u093f\u0928\u093e \u090f\u0932\u094d\u0917\u094b\u0928\u0915\u094d\u0935\u093f\u092f\u0928" },
            { "crs", "\u0938\u0947\u0938\u0947\u0932\u094d\u0935\u093e \u0915\u094d\u0930\u093f\u0913\u0932 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "csb", "\u0915\u093e\u0938\u0941\u0935\u093f\u092f\u0928" },
            { "csw", "\u0938\u094d\u0935\u093e\u092e\u094d\u092a\u0940 \u0915\u094d\u0930\u0940" },
            { "dak", "\u0921\u093e\u0915\u094b\u091f\u093e" },
            { "dar", "\u0926\u093e\u0930\u094d\u0917\u094d\u0935\u093e" },
            { "dav", "\u0924\u093e\u0907\u0924\u093e" },
            { "del", "\u0926\u0947\u0932\u093e\u0935\u0930" },
            { "dgr", "\u0926\u094b\u0917\u094d\u0930\u093f\u092c" },
            { "din", "\u0926\u093f\u0928\u094d\u0915\u093e" },
            { "dje", "\u091c\u0930\u094d\u092e\u093e" },
            { "doi", "\u0921\u094b\u0917\u0930\u0940" },
            { "dsb", "\u0924\u0932\u094d\u0932\u094b \u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "dtp", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0926\u0941\u0938\u0941\u0928" },
            { "dua", "\u0926\u0941\u0935\u093e\u0932\u093e" },
            { "dum", "\u092e\u0927\u094d\u092f \u0921\u091a" },
            { "dyo", "\u091c\u094b\u0932\u093e-\u092b\u094b\u0928\u093f\u0932" },
            { "dyu", "\u0926\u094d\u092f\u0941\u0932\u093e" },
            { "dzg", "\u0926\u093e\u091c\u093e\u0917\u093e" },
            { "ebu", "\u090f\u092e\u094d\u092c\u0941" },
            { "efi", "\u090f\u092b\u093f\u0915" },
            { "egl", "\u090f\u092e\u093f\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "egy", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0907\u091c\u093f\u092a\u094d\u091f\u0940" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "elx", "\u090f\u0932\u093e\u092e\u093e\u0907\u091f" },
            { "enm", "\u092e\u0927\u094d\u092f \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "esu", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092f\u0941\u092a\u093f\u0915" },
            { "ewo", "\u0907\u0935\u094b\u0928\u094d\u0921\u094b" },
            { "ext", "\u090f\u0915\u094d\u0938\u091f\u094d\u0930\u0947\u092e\u093e\u0926\u0941\u0930\u093e\u0932\u0940" },
            { "fan", "\u092b\u093e\u0919" },
            { "fat", "\u092b\u093e\u0928\u094d\u091f\u0940" },
            { "fil", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940" },
            { "fon", "\u092b\u094b\u0928" },
            { "frc", "\u0915\u093e\u0939\u0941\u0928 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "frm", "\u092e\u0927\u094d\u092f \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "fro", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "frp", "\u0905\u0930\u094d\u092a\u093f\u0924\u093e\u0928" },
            { "frr", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092b\u094d\u0930\u093f\u091c\u0940" },
            { "frs", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092b\u094d\u0930\u093f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "fur", "\u092b\u094d\u0930\u093f\u0909\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "gaa", "\u0917\u093e" },
            { "gag", "\u0917\u0917\u093e\u0909\u091c" },
            { "gan", "\u0917\u093e\u0928 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "gay", "\u0917\u093e\u092f\u094b" },
            { "gba", "\u0917\u094d\u092c\u093e\u092f\u093e" },
            { "gez", "\u0917\u093f\u091c" },
            { "gil", "\u0917\u093f\u0932\u094d\u092c\u0930\u094d\u091f\u0940" },
            { "glk", "\u0917\u093f\u0932\u093e\u0915\u0940" },
            { "gmh", "\u092e\u0927\u094d\u092f \u0909\u091a\u094d\u091a \u091c\u0930\u094d\u092e\u0928" },
            { "goh", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0909\u091a\u094d\u091a \u091c\u0930\u094d\u092e\u0928" },
            { "gom", "\u0917\u094b\u0935\u093e \u0915\u094b\u0928\u094d\u0915\u093e\u0928\u0940" },
            { "gon", "\u0917\u094b\u0928\u094d\u0921\u0940" },
            { "gor", "\u0917\u094b\u0930\u094b\u0928\u094d\u091f\u093e\u0932\u094b" },
            { "got", metaValue_got },
            { "grb", "\u0917\u094d\u0930\u0947\u092c\u094b" },
            { "grc", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0917\u094d\u0930\u093f\u0915" },
            { "gsw", "\u0938\u094d\u0935\u0940\u0938 \u091c\u0930\u094d\u092e\u0928" },
            { "gur", "\u092b\u094d\u0930\u093e\u092b\u094d\u0930\u093e" },
            { "guz", "\u0917\u0941\u0938\u0940" },
            { "gwi", "\u0917\u0941\u0907\u091a\u093f\u0928" },
            { "hai", "\u0939\u093e\u0907\u0926\u093e" },
            { "hak", "\u0939\u0915\u094d\u0915\u093e \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "haw", "\u0939\u0935\u093e\u0907\u092f\u0928" },
            { "hax", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0939\u0948\u0921\u093e" },
            { "hif", "\u092b\u093f\u091c\u0940 \u0939\u093f\u0928\u094d\u0926\u0940" },
            { "hil", "\u0939\u093f\u0932\u093f\u0917\u093e\u092f\u0928\u094b\u0928" },
            { "hit", "\u0939\u093f\u091f\u094d\u091f\u093f\u091f\u0947" },
            { "hmn", "\u0939\u092e\u094b\u0919" },
            { "hsb", "\u092e\u093e\u0925\u093f\u0932\u094d\u0932\u094b \u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "hsn", "\u091c\u093f\u092f\u093e\u0919 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "hup", "\u0939\u0941\u092a\u093e" },
            { "hur", "\u0939\u093e\u0932\u094d\u0915\u094b\u092e\u0947\u0932\u0947\u092e" },
            { "iba", "\u0907\u092c\u093e\u0928" },
            { "ibb", "\u0907\u092c\u093f\u092c\u093f\u092f\u094b" },
            { "ikt", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0915\u094d\u092f\u093e\u0928\u0947\u0921\u0947\u0932\u0940 \u0907\u0928\u0941\u0915\u094d\u091f\u093f\u091f\u0941\u091f" },
            { "ilo", "\u0907\u092f\u094b\u0915\u094b" },
            { "inh", "\u0907\u0928\u094d\u0917\u0938" },
            { "izh", "\u0907\u0928\u094d\u0917\u094d\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "jam", "\u091c\u092e\u0948\u0915\u093e\u0932\u0940 \u0915\u094d\u0930\u0947\u0913\u0932\u0947 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "jbo", "\u0932\u094b\u091c\u094d\u092c\u093e\u0928" },
            { "jgo", "\u0928\u094d\u0917\u094b\u092e\u094d\u092c\u093e" },
            { "jmc", "\u092e\u093e\u091a\u093e\u092e\u0947" },
            { "jpr", "\u091c\u0941\u0921\u093f\u092f\u094b-\u092b\u093e\u0930\u0938\u0940" },
            { "jrb", "\u091c\u0941\u0921\u093f\u092f\u094b-\u0905\u0930\u092c\u0940" },
            { "jut", "\u091c\u0941\u091f\u093f\u0938" },
            { "kaa", "\u0915\u093e\u0930\u093e-\u0915\u093e\u0932\u094d\u092a\u093e\u0915" },
            { "kab", "\u0915\u093e\u092c\u093f\u0932" },
            { "kac", "\u0915\u093e\u091a\u093f\u0928" },
            { "kaj", "\u091c\u094d\u091c\u0941" },
            { "kam", "\u0915\u093e\u092e\u094d\u092c\u093e" },
            { "kaw", "\u0915\u093e\u0935\u0940" },
            { "kbd", "\u0915\u093e\u092c\u093e\u0930\u094d\u0926\u093f\u092f\u093e\u0932\u0940" },
            { "kbl", "\u0915\u093e\u0928\u0947\u092e\u094d\u092c\u0941" },
            { "kcg", "\u091f\u0941\u0906\u092a" },
            { "kde", "\u092e\u093e\u0915\u094b\u0928\u094d\u0921\u0947" },
            { "kea", "\u0915\u093e\u092c\u0941\u092d\u0947\u0930\u094d\u0921\u093f\u092f\u093e\u0928\u0941" },
            { "ken", "\u0915\u0947\u0928\u092f\u093e\u0919" },
            { "kfo", "\u0915\u094b\u0930\u094b" },
            { "kgp", "\u0915\u093e\u0907\u0928\u0917\u093e\u0919" },
            { "kha", "\u0916\u093e\u0938\u0940" },
            { "kho", "\u0916\u094b\u091f\u093e\u0928\u0940" },
            { "khq", "\u0915\u094b\u092f\u0930\u093e \u091a\u093f\u0928\u0940" },
            { "khw", "\u0916\u094b\u0935\u093e\u0930" },
            { "kiu", "\u0915\u093f\u0930\u094d\u092e\u093e\u0928\u094d\u091c\u0915\u0940" },
            { "kkj", "\u0915\u093e\u0915\u094b" },
            { "kln", "\u0915\u093e\u0932\u0947\u0928\u094d\u091c\u093f\u0928" },
            { "kmb", "\u0915\u093f\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0941" },
            { "koi", "\u0915\u094b\u092e\u0940-\u092a\u0930\u094d\u092e\u094d\u092f\u093e\u0915" },
            { "kok", "\u0915\u094b\u0928\u094d\u0915\u093e\u0928\u0940" },
            { "kos", "\u0915\u094b\u0938\u094d\u0930\u093e\u0932\u0940" },
            { "kpe", "\u0915\u094d\u092a\u0947\u0932\u094d\u0932\u0947" },
            { "krc", "\u0915\u093e\u0930\u093e\u091a\u093e\u092f-\u092c\u093e\u0932\u094d\u0915\u0930" },
            { "kri", "\u0915\u094d\u0930\u093f\u0913" },
            { "krj", "\u0915\u093f\u0928\u093e\u0930\u093e\u092f-\u090f" },
            { "krl", "\u0915\u0930\u0947\u0932\u093f\u092f\u0928" },
            { "kru", "\u0915\u0941\u0930\u0941\u0916" },
            { "ksb", "\u0936\u093e\u092e\u094d\u092c\u093e\u0932\u093e" },
            { "ksf", "\u092c\u093e\u092b\u093f\u092f\u093e" },
            { "ksh", "\u0915\u094b\u0932\u094b\u0917\u094d\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "kum", "\u0915\u0941\u092e\u093f\u0915" },
            { "kut", "\u0915\u0941\u0924\u0947\u0928\u093e\u0907" },
            { "kwk", "\u0915\u094d\u0935\u093e\u0915\u0935\u093e\u0932\u093e" },
            { "lad", "\u0932\u093e\u0921\u093f\u0928\u094b" },
            { "lag", "\u0932\u093e\u0919\u094d\u0917\u0940" },
            { "lah", "\u0932\u093e\u0939\u0928\u094d\u0921\u093e" },
            { "lam", "\u0932\u093e\u092e\u094d\u092c\u093e" },
            { "lez", "\u0932\u093e\u091c\u094d\u0918\u093f\u092f\u093e\u0932\u0940" },
            { "lfn", "\u0932\u093f\u0919\u094d\u0917\u0941\u0935\u093e \u092b\u094d\u0930\u093e\u0919\u094d\u0915\u093e \u0928\u094b\u092d\u093e" },
            { "lij", "\u0932\u093f\u0917\u0941\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "lil", "\u0932\u093f\u0932\u0941\u090f\u091f" },
            { "liv", "\u0932\u093f\u092d\u094b\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "lkt", "\u0932\u093e\u0915\u094b\u0924\u093e" },
            { "lmo", "\u0932\u094b\u092e\u094d\u092c\u093e\u0930\u094d\u0921" },
            { "lol", "\u092e\u094b\u0919\u094d\u0917\u094b" },
            { "lou", "\u0932\u0941\u0938\u093f\u092f\u093e\u0928\u093e \u0915\u094d\u0930\u093f\u092f\u094b\u0932" },
            { "loz", "\u0932\u094b\u091c\u0940" },
            { "lrc", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0932\u0941\u0930\u0940" },
            { "lsm", "\u0938\u093e\u092e\u093f\u092f\u093e" },
            { "ltg", "\u0932\u093e\u091f\u094d\u0917\u093e\u0932\u0940" },
            { "lua", "\u0932\u0941\u092c\u093e-\u0932\u0941\u0932\u0941\u0906" },
            { "lui", "\u0932\u0941\u0907\u0938\u0947\u0928\u094b" },
            { "lun", "\u0932\u0941\u0928\u094d\u0921\u093e" },
            { "luo", "\u0932\u0941\u0913" },
            { "lus", "\u092e\u093f\u091c\u094b" },
            { "luy", "\u0932\u0941\u0907\u092f\u093e" },
            { "lzh", "\u0938\u093e\u0939\u093f\u0924\u094d\u092f\u093f\u0915 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "lzz", "\u0932\u093e\u091c" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0947\u0938\u0947" },
            { "maf", "\u092e\u093e\u092b\u093e" },
            { "mag", "\u092e\u0917\u0927\u0940" },
            { "mai", "\u092e\u0948\u0925\u093f\u0932\u0940" },
            { "mak", "\u092e\u093e\u0915\u093e\u0938\u093e\u0930" },
            { "man", "\u092e\u093e\u0928\u094d\u0926\u093f\u0919\u094b" },
            { "mas", "\u092e\u0938\u093e\u0908" },
            { "mde", "\u092e\u093e\u092c\u093e" },
            { "mdf", "\u092e\u094b\u0915\u094d\u0937" },
            { "mdr", "\u092e\u0928\u094d\u0926\u0930" },
            { "men", "\u092e\u0947\u0928\u094d\u0921\u0947" },
            { "mer", "\u092e\u0947\u0930\u0942" },
            { "mfe", "\u092e\u094b\u0930\u093f\u0938\u0947\u0928" },
            { "mga", "\u092e\u0927\u094d\u092f \u0906\u092f\u0930\u093f\u0938" },
            { "mgh", "\u092e\u093e\u0916\u0941\u0935\u093e-\u092e\u093f\u091f\u094d\u091f\u094b" },
            { "mgo", "\u092e\u0947\u091f\u093e" },
            { "mic", "\u092e\u093f\u0915\u092e\u093e\u0915" },
            { "min", "\u092e\u093f\u0928\u093e\u0919\u0915\u093e\u092c\u093e\u0909" },
            { "mnc", "\u092e\u093e\u0928\u094d\u091a\u0941" },
            { "mni", "\u092e\u0928\u093f\u092a\u0941\u0930\u0940" },
            { "moe", "\u0907\u0928\u094d\u0928\u0941-\u0910\u092e\u0928" },
            { "moh", "\u092e\u094b\u0939\u0915" },
            { "mos", "\u092e\u094b\u0938\u094d\u0938\u0940" },
            { "mua", "\u092e\u0941\u0928\u094d\u0921\u093e\u0919" },
            { "mul", "\u092c\u0939\u0941\u092d\u093e\u0937\u093e" },
            { "mus", "\u0915\u094d\u0930\u093f\u0915" },
            { "mwl", "\u092e\u093f\u0930\u093e\u0928\u094d\u0921\u0940" },
            { "mwr", "\u092e\u093e\u0921\u0935\u093e\u0930\u0940" },
            { "mwv", "\u092e\u0947\u0928\u094d\u091f\u093e\u0935\u093e\u0908" },
            { "mye", "\u092e\u094d\u092f\u0947\u0928\u0947" },
            { "myv", "\u0907\u0930\u094d\u091c\u094d\u092f\u093e" },
            { "mzn", "\u092e\u091c\u093e\u0928\u0921\u0947\u0930\u093e\u0928\u0940" },
            { "nan", "\u092e\u093f\u0928 \u0928\u093e\u0928 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "nap", "\u0928\u0947\u092a\u094b\u0932\u093f\u091f\u093e\u0928" },
            { "naq", "\u0928\u093e\u092e\u093e" },
            { "nds", "\u0924\u0932\u094d\u0932\u094b \u091c\u0930\u094d\u092e\u0928" },
            { "new", "\u0928\u0947\u0935\u093e\u0930\u0940" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "niu", "\u0928\u093f\u0909\u090f\u0928" },
            { "njo", "\u0905\u0913 \u0928\u093e\u0917\u093e" },
            { "nmg", "\u0915\u094d\u0935\u093e\u0938\u093f\u092f\u094b" },
            { "nnh", "\u0928\u094d\u0917\u093f\u090f\u092e\u094d\u092c\u0941\u0928" },
            { "nog", "\u0928\u094b\u0917\u093e\u0907" },
            { "non", "\u092a\u0941\u0930\u093e\u0928\u094b \u0928\u094b\u0930\u094d\u0938\u0947" },
            { "nov", "\u0928\u094b\u092d\u093f\u092f\u0932" },
            { "nqo", "\u0928\u0915\u094b" },
            { "nso", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u094b\u0925\u094b" },
            { "nus", "\u0928\u0941\u090f\u0930" },
            { "nwc", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0928\u0947\u0935\u093e\u0930\u0940" },
            { "nym", "\u0928\u094d\u092f\u093e\u092e\u0935\u0947\u091c\u0940" },
            { "nyn", "\u0928\u094d\u092f\u093e\u0928\u094d\u0915\u094b\u0932" },
            { "nyo", "\u0928\u094d\u092f\u094b\u0930\u094b" },
            { "nzi", "\u0928\u091c\u093f\u092e\u093e" },
            { "ojb", "\u0909\u0924\u094d\u0924\u0930\u092a\u0936\u094d\u091a\u093f\u092e \u0913\u091c\u093f\u092c\u094d\u092c\u093e" },
            { "ojc", "\u0938\u0947\u0928\u094d\u091f\u094d\u0930\u0932 \u0905\u091c\u093f\u092c\u094d\u092c\u093e" },
            { "ojs", "\u0913\u091c\u0940 \u0915\u094d\u0930\u0940" },
            { "ojw", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0913\u091c\u093f\u092c\u093e" },
            { "oka", "\u0913\u0915\u093e\u0928\u093e\u0917\u093e\u0928" },
            { "osa", "\u0913\u0938\u093e\u0917\u0947" },
            { "ota", "\u0905\u091f\u094b\u092e\u0928 \u0924\u0941\u0930\u094d\u0915\u0940" },
            { "pag", "\u092a\u093e\u0919\u094d\u0917\u093e\u0938\u093f\u0928\u093e\u0928" },
            { "pal", "\u092a\u093e\u0939\u0932\u093e\u0935\u0940" },
            { "pam", "\u092a\u093e\u092e\u092a\u093e\u0919\u094d\u0917\u093e" },
            { "pap", "\u092a\u093e\u092a\u093f\u092f\u093e\u092e\u0947\u0928\u094d\u0924\u094b" },
            { "pau", "\u092a\u093e\u0932\u093e\u0909\u0935\u093e\u0932\u0940" },
            { "pcd", "\u092a\u093f\u0915\u093e\u0930\u094d\u0921" },
            { "pcm", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e\u0932\u0940 \u092a\u093f\u0921\u094d\u091c\u093f\u0928" },
            { "pdc", "\u092a\u0947\u0928\u094d\u0938\u093f\u0932\u092d\u093e\u0928\u093f\u092f\u093e\u0932\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "peo", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092b\u093e\u0930\u0938\u0940" },
            { "pfl", "\u092a\u093e\u0932\u093e\u091f\u093f\u0928 \u091c\u0930\u094d\u092e\u0928" },
            { "phn", "\u092b\u094b\u0928\u093f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "pis", "\u092a\u093f\u091c\u093f\u0928" },
            { "pms", "\u092a\u093f\u090f\u0921\u092e\u094b\u0928\u094d\u0924\u0947\u0938\u0947" },
            { "pnt", "\u092a\u094b\u0928\u094d\u091f\u093f\u0915" },
            { "pqm", "\u092e\u093e\u0932\u093f\u0938\u0940\u091f \u092a\u093e\u0938\u093e\u092e\u093e\u0915\u094d\u0935\u0947\u0921\u0940" },
            { "prg", "\u092a\u094d\u0930\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "pro", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092a\u094d\u0930\u094b\u092d\u0947\u0928\u094d\u0915\u093e\u0932" },
            { "quc", "\u0915\u093f\u091a\u0947" },
            { "qug", "\u091a\u093f\u092e\u094d\u092c\u094b\u0930\u093e\u091c\u094b \u0909\u091a\u094d\u091a\u0938\u094d\u0925\u093e\u0928 \u0915\u093f\u091a\u0941\u0906" },
            { "raj", "\u0930\u093e\u091c\u0938\u094d\u0925\u093e\u0928\u0940" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u0941\u0908" },
            { "rar", "\u0930\u093e\u0930\u094b\u091f\u094b\u0919\u094d\u0917\u093e\u0928" },
            { "rhg", "\u0930\u094b\u0939\u093f\u0919\u094d\u0917\u094d\u092f\u093e" },
            { "rof", "\u0930\u094b\u092e\u094d\u092c\u094b" },
            { "rup", "\u0905\u0930\u094b\u092e\u093e\u0928\u0940\u092f\u093e\u0932\u0940" },
            { "rwk", "\u0930\u094d\u200c\u0935\u093e" },
            { "sad", "\u0938\u093e\u0928\u094d\u0921\u0947\u0905" },
            { "sah", "\u0938\u093e\u0916\u093e" },
            { "saq", "\u0938\u093e\u092e\u094d\u092c\u0941\u0930\u0942" },
            { "sat", "\u0938\u093e\u0928\u094d\u0924\u093e\u0932\u0940" },
            { "sba", "\u0928\u094d\u0917\u093e\u092e\u092c\u093e\u092f" },
            { "sbp", "\u0938\u093e\u0919\u094d\u0917\u0941" },
            { "scn", "\u0938\u093f\u0938\u093f\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "sco", "\u0938\u094d\u0915\u091f\u094d\u0938" },
            { "sdh", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0915\u0941\u0930\u094d\u0926\u093f\u0936" },
            { "seh", "\u0938\u0947\u0928\u093e" },
            { "ses", "\u0915\u094b\u092f\u0930\u093e\u092c\u094b\u0930\u094b \u0938\u0947\u0928\u094d\u0928\u0940" },
            { "sga", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0906\u092f\u0930\u0940\u0938" },
            { "shi", "\u091f\u093e\u091a\u0947\u0932\u094d\u0939\u093f\u091f" },
            { "shn", "\u0936\u093e\u0928" },
            { "shu", "\u091a\u093e\u0921 \u0905\u0930\u092c\u0940" },
            { "slh", "\u0926\u0915\u094d\u0937\u093f\u0928\u0940 \u0932\u0941\u0938\u094d\u0939\u094b\u0938\u094d\u091f\u0947\u0921" },
            { "sli", "\u0924\u0932\u094d\u0932\u094b \u0938\u093f\u0932\u0947\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "sma", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u093e\u092e\u0940" },
            { "smj", "\u0932\u0941\u0932\u0947 \u0938\u093e\u092e\u0940" },
            { "smn", "\u0907\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "sms", "\u0938\u094d\u0915\u094b\u0907\u091f \u0938\u093e\u092e\u0940" },
            { "snk", "\u0938\u094b\u0928\u093f\u0928\u094d\u0915\u0947" },
            { "srn", "\u0938\u094d\u0930\u093e\u0928\u093e\u0928 \u091f\u094b\u0919\u094d\u0917\u094b" },
            { "ssy", "\u0938\u093e\u0939\u094b" },
            { "str", "\u0938\u094d\u091f\u094d\u0930\u0947\u091f \u0938\u094d\u092f\u093e\u0932\u093f\u0938" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "sus", "\u0938\u0941\u0938\u0942" },
            { "sux", "\u0938\u0941\u092e\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "swb", "\u0915\u094b\u092e\u094b\u0930\u0940" },
            { "syc", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "syr", metaValue_syr },
            { "tce", "\u0926\u0915\u094d\u0937\u093f\u0928\u0940 \u091f\u0941\u091f\u094d\u091a\u094b\u0928" },
            { "tem", "\u091f\u093f\u092e\u094d\u0928\u0947" },
            { "teo", "\u091f\u0947\u0938\u094b" },
            { "tet", "\u091f\u0947\u091f\u0941\u092e" },
            { "tgx", "\u091f\u093e\u0917\u093f\u0938" },
            { "tht", "\u091f\u093e\u0939\u0932\u094d\u091f\u0928" },
            { "tig", "\u091f\u093f\u0917\u094d\u0930\u0947" },
            { "tlh", "\u0915\u094d\u0932\u093f\u0919\u094d\u0917\u0928" },
            { "tli", "\u091f\u094d\u0932\u093f\u0919\u094d\u0917\u093f\u091f" },
            { "tog", "\u0928\u094d\u092f\u093e\u0938 \u091f\u094b\u0919\u094d\u0917\u093e" },
            { "tok", "\u091f\u094b\u0915\u0940 \u092a\u094b\u0928\u093e" },
            { "tpi", "\u091f\u094b\u0915 \u092a\u093f\u0938\u093f\u0928" },
            { "trv", "\u091f\u093e\u0930\u094b\u0915\u094b" },
            { "ttm", "\u0909\u0924\u094d\u0924\u0930\u0940 \u091f\u0941\u091a\u094b\u0928" },
            { "ttt", "\u092e\u0941\u0938\u094d\u0932\u093f\u092e \u091f\u093e\u091f" },
            { "tum", "\u091f\u0941\u092e\u094d\u092c\u0941\u0915\u093e" },
            { "tvl", "\u091f\u0941\u092d\u093e\u0932\u0941" },
            { "twq", "\u0924\u093e\u0938\u093e\u0935\u093e\u0915" },
            { "tyv", "\u091f\u0941\u092d\u093f\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "tzm", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u090f\u091f\u094d\u0932\u093e\u0938 \u091f\u093e\u092e\u093e\u091c\u093f\u0918\u091f" },
            { "udm", "\u0909\u0921\u094d\u092e\u0941\u0930\u094d\u091f" },
            { "umb", "\u0909\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0940" },
            { "und", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092d\u093e\u0937\u093e" },
            { "vai", metaValue_vai },
            { "vmf", "\u092e\u0941\u0916\u094d\u092f-\u092b\u094d\u0930\u093e\u0919\u094d\u0915\u094b\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "vun", "\u092d\u0941\u0928\u094d\u091c\u094b" },
            { "wae", "\u0935\u093e\u0932\u094d\u0938\u0930" },
            { "wal", "\u0935\u094b\u0932\u0947\u091f\u094d\u091f\u093e" },
            { "war", "\u0935\u093e\u0930\u0947" },
            { "wbp", "\u0935\u093e\u0930\u094d\u0932\u094d\u092a\u093f\u0930\u0940" },
            { "wuu", "\u090a \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "xal", "\u0915\u093e\u0932\u094d\u092e\u093f\u0915" },
            { "xmf", "\u092e\u093f\u0928\u0917\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "xog", "\u0938\u094b\u0917\u093e" },
            { "yav", "\u092f\u093e\u0919\u094d\u092c\u0947\u0928" },
            { "ybb", "\u092f\u0947\u092e\u094d\u092c\u093e" },
            { "yrl", "\u0928\u094d\u0939\u093f\u0928\u0917\u093e\u0924\u0941" },
            { "yue", "\u0915\u094d\u092f\u093e\u0928\u094d\u091f\u094b\u0928\u093f\u091c" },
            { "zbl", "\u092c\u094d\u0932\u093f\u0938\u0938\u093f\u092e\u094d\u092c\u094b\u0932\u094d\u0938" },
            { "zgh", "\u092e\u093e\u0928\u0915 \u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b\u0928 \u0924\u093e\u092e\u093e\u091c\u093f\u0918\u091f" },
            { "zun", "\u091c\u0941\u0928\u0940" },
            { "zxx", "\u092d\u093e\u0937\u093f\u0915 \u0938\u093e\u092e\u0917\u094d\u0930\u0940 \u091b\u0948\u0928" },
            { "zza", "\u091c\u093e\u091c\u093e" },
            { "Adlm", "\u090f\u0921\u0932\u093e\u092e" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0928\u093e\u0938\u094d\u091f\u093e\u0932\u093f\u0915" },
            { "Armi", "\u0906\u0930\u094d\u092e\u0940" },
            { "Armn", metaValue_hy },
            { "Avst", "\u0906\u092d\u0947\u0938\u094d\u091f\u093e\u0928" },
            { "Bali", metaValue_ban },
            { "Batk", "\u092c\u093e\u091f\u0915" },
            { "Beng", "\u092c\u0919\u094d\u0917\u093e\u0932\u0940" },
            { "Blis", "\u092c\u094d\u0932\u093f\u091c\u0938\u093f\u092e\u094d\u092c\u094b\u0932\u094d\u0938" },
            { "Bopo", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u094b" },
            { "Brah", "\u092c\u094d\u0930\u093e\u0939\u094d\u092e\u0940" },
            { "Brai", "\u092c\u094d\u0930\u0947\u0932" },
            { "Bugi", "\u092c\u0941\u0917\u093f\u0928\u093f\u091c" },
            { "Buhd", "\u092c\u0941\u0939\u093f\u0926" },
            { "Cakm", "\u0915\u093e\u0915\u094d\u092e\u094d" },
            { "Cans", "\u090f\u0915\u0940\u0915\u0943\u0924 \u0915\u094d\u092f\u093e\u0928\u0947\u0921\u093e\u0932\u0940 \u0906\u0926\u093f\u0935\u093e\u0926\u0940\u0915\u094b \u0938\u093f\u0932\u093e\u092c\u093f\u0915\u094d\u0938" },
            { "Cari", "\u0915\u093e\u0930\u093f\u092f\u0928" },
            { "Cham", "\u091a\u093e\u092e" },
            { "Cher", metaValue_chr },
            { "Cirt", "\u0915\u093f\u0930\u094d\u0925" },
            { "Copt", "\u0915\u092a\u094d\u091f\u093f\u0915" },
            { "Cprt", "\u0915\u092a\u094d\u0930\u093f\u092f\u091f" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "Deva", metaValue_Deva },
            { "Dsrt", "\u0921\u0947\u0938\u0947\u0930\u0947\u091f" },
            { "Egyd", "\u0907\u091c\u093f\u092a\u094d\u091f\u093f\u092f\u0928 \u0921\u0947\u092e\u094b\u091f\u093f\u0915" },
            { "Egyh", "\u0907\u091c\u093f\u092a\u094d\u091f\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u091f\u093f\u0915" },
            { "Egyp", "\u0907\u091c\u093f\u092a\u094d\u091f\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "Ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915" },
            { "Geok", "\u0917\u094d\u0930\u0941\u091c\u093f\u092f\u093e\u0932\u0940 \u0916\u0941\u091f\u094d\u0938\u0941\u0930\u0940" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0917\u094d\u0932\u093e\u0917\u094b\u0932\u093f\u091f\u093f\u0915" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0917\u0941\u0930\u0942\u092e\u0941\u0916\u0940" },
            { "Hanb", "\u0939\u093e\u0928\u094d\u092c" },
            { "Hang", "\u0939\u093e\u0928\u094d\u0917\u0941\u0932" },
            { "Hani", "\u0939\u093e\u0928" },
            { "Hano", "\u0939\u093e\u0928\u0941\u0928\u0941" },
            { "Hans", metaValue_Hans },
            { "Hant", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0939\u093f\u0930\u093e\u0917\u0928\u093e" },
            { "Hmng", "\u092a\u0939\u093e\u0935\u0939 \u0939\u092e\u094b\u0919\u094d\u0917" },
            { "Hrkt", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e \u0935\u093e \u0939\u093f\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "Hung", "\u092a\u0941\u0930\u093e\u0928\u094b \u0939\u0919\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "Inds", "\u0907\u0928\u094d\u0926\u0941\u0938" },
            { "Ital", "\u092a\u0941\u0930\u093e\u0928\u094b \u0907\u091f\u093e\u0932\u093f\u0915" },
            { "Jamo", "\u091c\u093e\u092e\u094b" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "\u0915\u093e\u092f\u093e\u0939\u0932\u0940" },
            { "Kana", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e" },
            { "Khar", "\u0916\u093e\u0930\u094b\u0938\u094d\u0925\u093f\u0924\u093f" },
            { "Khmr", metaValue_km },
            { "Knda", "\u0915\u093e\u0928\u094d\u0928\u093e\u0921\u093e" },
            { "Kore", "\u0915\u094b\u0930\u093f\u092f\u0928" },
            { "Kthi", "\u0915\u094d\u0925\u0940" },
            { "Lana", "\u0932\u093e\u0928\u094d\u0928\u093e" },
            { "Laoo", metaValue_lo },
            { "Latf", "\u092b\u094d\u0930\u093e\u0915\u094d\u091f\u0941\u0930 \u0932\u094d\u092f\u093e\u091f\u093f\u0928" },
            { "Latg", "\u0917\u094d\u092f\u093e\u0932\u093f\u0915 \u0932\u094d\u092f\u093e\u091f\u093f\u0928" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0932\u0947\u092a\u094d\u091a\u093e" },
            { "Limb", "\u0932\u093f\u092e\u094d\u092c\u0941" },
            { "Lyci", "\u0932\u093e\u0907\u0938\u093f\u092f\u0928" },
            { "Lydi", "\u0932\u093e\u0907\u0921\u093f\u092f\u0928" },
            { "Mand", "\u092e\u093e\u0928\u094d\u0921\u093e\u090f\u0928" },
            { "Mani", "\u092e\u093e\u0928\u093f\u0915\u093e\u090f\u0928" },
            { "Maya", "\u092e\u093e\u092f\u093e \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "Mero", "\u092e\u0947\u0930\u093f\u092f\u094b\u091f\u093f\u0915" },
            { "Mlym", "\u092e\u0932\u093e\u092f\u093e\u0932\u092e" },
            { "Mong", "\u092e\u0919\u094d\u0917\u094b\u0932" },
            { "Moon", "\u091c\u0942\u0928" },
            { "Mtei", "\u092e\u093e\u0907\u091f\u0947\u0907 \u092e\u093e\u092f\u0947\u0915" },
            { "Mymr", "\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930" },
            { "Nkoo", "\u090f\u0928\u094d\u0915\u094b" },
            { "Ogam", "\u0913\u0918\u093e\u092e" },
            { "Olck", "\u0913\u0932\u091a\u093f\u0915\u0940" },
            { "Orkh", "\u0913\u0930\u094d\u0916\u094b\u0928" },
            { "Orya", "\u0913\u0921\u093f\u092f\u093e" },
            { "Osma", "\u0913\u0938\u094d\u092e\u093e\u0928\u094d\u092f\u093e" },
            { "Perm", "\u092a\u0941\u0930\u093e\u0928\u094b \u092a\u0930\u094d\u092e\u093f\u0915" },
            { "Phag", "\u092b\u093e\u0917\u094d\u0938-\u092a\u093e" },
            { "Phli", "\u092b\u094d\u0932\u093f" },
            { "Phlp", "\u092b\u094d\u0932\u094d\u092a" },
            { "Phlv", "\u092c\u0941\u0915 \u092a\u0939\u0932\u094d\u092d\u0940" },
            { "Phnx", "\u092b\u094b\u0928\u093f\u0938\u093f\u092f\u0928" },
            { "Plrd", "\u092a\u094b\u0932\u094d\u0932\u093e\u0930\u094d\u0921 \u092b\u094b\u0928\u0947\u091f\u093f\u0915" },
            { "Prti", "\u092a\u093f\u0906\u0930\u091f\u0940" },
            { "Rjng", "\u0930\u0947\u091c\u093e\u0919" },
            { "Rohg", "\u0939\u093e\u0928\u093f\u092b\u0940" },
            { "Roro", "\u0930\u094b\u0919\u094d\u0917\u094b\u0930\u094b\u0919\u094d\u0917\u094b" },
            { "Runr", "\u0930\u0942\u0928\u093f\u0915" },
            { "Samr", "\u0938\u092e\u093e\u0930\u093f\u091f\u0928" },
            { "Sara", "\u0938\u093e\u0930\u0924\u0940" },
            { "Saur", "\u0938\u094c\u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "Sgnw", "\u0938\u093e\u0907\u0928\u0930\u093e\u0907\u091f\u093f\u0919" },
            { "Shaw", "\u0936\u093e\u092d\u093f\u092f\u0928" },
            { "Sinh", "\u0938\u093f\u0928\u094d\u0939\u093e\u0932\u093e" },
            { "Sund", "\u0938\u0941\u0928\u094d\u0921\u093e\u0928\u0947\u0932\u0940" },
            { "Sylo", "\u0938\u094d\u0932\u094d\u092f\u094b\u091f\u0940 \u0928\u093e\u0917\u094d\u0930\u0940" },
            { "Syrc", metaValue_syr },
            { "Syre", "\u0907\u0938\u094d\u091f\u094d\u0930\u0947\u0928\u091c\u0947\u0932\u094b \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "Syrj", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "Syrn", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "Tagb", "\u091f\u093e\u0917\u094d\u0935\u093e\u0928\u094d\u0935\u093e" },
            { "Tale", "\u091f\u093e\u0907\u0932\u0947" },
            { "Talu", "\u0928\u094d\u092f\u0942 \u091f\u093e\u0907 \u0932\u0941\u0907" },
            { "Taml", metaValue_ta },
            { "Tavt", "\u091f\u093e\u092d\u094d\u091f" },
            { "Telu", metaValue_te },
            { "Teng", "\u091f\u0947\u0919\u094d\u0935\u093e\u0930" },
            { "Tfng", "\u091f\u093f\u092b\u093f\u0928\u093e\u0918" },
            { "Tglg", "\u091f\u093e\u0917\u093e\u0932\u094b\u0917" },
            { "Thaa", "\u0925\u093e\u0928\u093e" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "\u092f\u0941\u0917\u093e\u0930\u093f\u091f\u093f\u0915" },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0926\u0943\u0936\u094d\u092f\u092e\u092f \u0935\u093e\u0923\u0940" },
            { "Xpeo", "\u092a\u0941\u0930\u093e\u0928\u094b \u092a\u0930\u094d\u0938\u093f\u092f\u0928" },
            { "Yiii", "\u092f\u0940" },
            { "Zinh", "\u0907\u0928\u094d\u0939\u0947\u0930\u093f\u091f\u0947\u0921" },
            { "Zmth", "\u0917\u0923\u093f\u0924\u0940\u092f \u091a\u093f\u0928\u094d\u0939" },
            { "Zsye", "\u0907\u092e\u094b\u091c\u0940" },
            { "Zsym", "\u092a\u094d\u0930\u0924\u0940\u0915\u0939\u0930\u0942" },
            { "Zxxx", "\u0928\u0932\u0947\u0916\u093f\u090f\u0915\u094b" },
            { "Zyyy", "\u0938\u093e\u091d\u093e" },
            { "Zzzz", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0932\u093f\u092a\u093f" },
            { "de_AT", "\u0905\u0938\u094d\u091f\u094d\u0930\u093f\u090f\u0928 \u091c\u0930\u094d\u092e\u0928" },
            { "de_CH", "\u0938\u094d\u0935\u0940\u0938 \u0939\u093e\u0908 \u091c\u0930\u094d\u092e\u0928" },
            { "en_AU", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0932\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "en_CA", "\u0915\u094d\u092f\u093e\u0928\u093e\u0921\u0947\u0932\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "en_GB", "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "en_US", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "es_ES", "\u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0938\u094d\u092a\u0947\u0928\u0940" },
            { "es_MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u0938\u094d\u092a\u0947\u0928\u0940" },
            { "fa_AF", "\u0926\u093e\u0930\u0940" },
            { "fr_CA", "\u0915\u094d\u092f\u093e\u0928\u0947\u0921\u093e\u0932\u0940 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "fr_CH", "\u0938\u094d\u0935\u093f\u0938 \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "nl_BE", "\u092b\u094d\u0932\u0947\u092e\u093f\u0938" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u0940 \u092a\u094b\u0930\u094d\u0924\u0941\u0917\u0940" },
            { "pt_PT", "\u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u092a\u094b\u0930\u094d\u0924\u0941\u0917\u0940" },
            { "ro_MD", "\u092e\u094b\u0932\u094d\u0921\u093e\u092d\u093f\u092f\u093e\u0932\u0940" },
            { "sw_CD", "\u0915\u0919\u094d\u0917\u094b \u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "ar_001", "\u0906\u0927\u0941\u0928\u093f\u0915 \u092e\u093e\u0928\u0915 \u0905\u0930\u092c\u0940" },
            { "es_419", "\u0932\u094d\u092f\u093e\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u094d\u092a\u0947\u0928\u0940" },
            { "key.ca", "\u092a\u093e\u0924\u094d\u0930\u094b" },
            { "key.cf", "\u092e\u0941\u0926\u094d\u0930\u093e\u0915\u094b \u0922\u093e\u0901\u091a\u093e" },
            { "key.co", "\u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927 \u0938\u0941\u091a\u0940" },
            { "key.cu", "\u092e\u0941\u0926\u094d\u0930\u093e" },
            { "key.hc", "\u0938\u092e\u092f \u091a\u0915\u094d\u0930 (12 \u0924\u0925\u093e 24)" },
            { "key.lb", "\u092a\u0919\u094d\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926\u0915\u094b \u0936\u0948\u0932\u0940" },
            { "key.ms", "\u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "key.nu", "\u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "nds_NL", "\u0924\u0932\u094d\u0932\u094b \u0938\u093e\u0915\u094d\u0938\u0928" },
            { "%%POSIX", "\u0915\u092e\u094d\u092a\u094d\u092f\u0941\u091f\u0930" },
            { "hi_Latn", "\u0939\u093f\u0928\u094d\u0926\u0940 (\u0932\u094d\u092f\u093e\u091f\u093f\u0928)" },
            { "zh_Hans", metaValue_Hans },
            { "zh_Hant", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "%%AREVELA", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "type.ca.roc", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930\u0915\u094b \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.hc.h11", "\u0967\u0968 \u0918\u0923\u094d\u091f\u0947 \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (\u0966\u2013\u0967\u0967)" },
            { "type.hc.h12", "\u0967\u0968 \u0918\u0928\u094d\u091f\u093e\u0915\u094b \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (\u0967\u2013\u0967\u0968)" },
            { "type.hc.h23", "\u0968\u096a \u0918\u0928\u094d\u091f\u093e\u0915\u094b \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (\u0966\u2013\u0968\u0969)" },
            { "type.hc.h24", "\u0968\u096a \u0918\u0928\u094d\u091f\u093e\u0915\u094b \u092a\u094d\u0930\u0923\u093e\u0932\u0940 (\u0967\u2013\u0968\u096a)" },
            { "type.nu.arab", "\u0905\u0930\u092c\u0940 \u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.armn", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.beng", "\u092c\u0919\u094d\u0917\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.cakm", "\u091a\u093e\u0915\u094d\u092e\u093e \u0905\u0919\u094d\u0915" },
            { "type.nu.deva", metaValue_Deva },
            { "type.nu.ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.geor", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.grek", "\u0917\u094d\u0930\u0940\u0915 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.guru", "\u0917\u0941\u0930\u0942\u092e\u0941\u0916\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hans", "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hant", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hebr", "\u0939\u093f\u092c\u094d\u0930\u0941 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.java", "\u091c\u093e\u092d\u093e\u0928\u0940 \u0905\u0919\u094d\u0915" },
            { "type.nu.jpan", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.khmr", "\u0916\u092e\u0947\u0930 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.knda", "\u0915\u0928\u094d\u0928\u093e\u0921\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.laoo", "\u0932\u093e\u0913 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.latn", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.mlym", "\u092e\u0932\u093e\u092f\u0932\u092e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.mtei", "\u092e\u093f\u091f\u0948 \u092e\u0947\u090f\u0915 \u0905\u0919\u094d\u0915" },
            { "type.nu.mymr", "\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930\u0915\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.olck", "\u0913\u0907 \u091a\u093f\u0915\u0940 \u0905\u0919\u094d\u0915" },
            { "type.nu.orya", "\u0913\u0930\u093f\u092f\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.taml", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0924\u093e\u092e\u093f\u0932 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0947\u0917\u0941 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.thai", "\u0925\u093e\u0908 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.tibt", "\u0924\u093f\u092c\u094d\u092c\u0924\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.vaii", "\u092d\u093e\u0908 \u0905\u0919\u094d\u0915" },
            { "type.ca.dangi", "\u0921\u093e\u0919\u094d\u0917\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.co.ducet", "\u092a\u0942\u0930\u094d\u0935\u0928\u093f\u0930\u094d\u0927\u093e\u0930\u093f\u0924 \u092f\u0941\u0928\u093f\u0915\u094b\u0921\u0915\u094b \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u0938\u0942\u091a\u0940" },
            { "type.lb.loose", "\u092a\u0919\u094d\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926\u0915\u094b \u0916\u0941\u0932\u093e \u0936\u0948\u0932\u0940" },
            { "type.nu.roman", "\u0930\u094b\u092e\u0928 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.ca.coptic", "\u0915\u094b\u092a\u094d\u091f\u093f\u0915 \u092a\u093e\u0924\u094d\u0930" },
            { "type.ca.hebrew", "\u0939\u093f\u092c\u094d\u0930\u0941 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.ca.indian", "\u092d\u093e\u0930\u0924\u0940\u092f \u0930\u093e\u0937\u094d\u091f\u094d\u0930\u093f\u092f \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.co.pinyin", "\u092a\u093f\u0928\u092f\u093f\u0928 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f" },
            { "type.co.search", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f \u0909\u0926\u094d\u0926\u0947\u0936\u0940\u092f \u0916\u094b\u091c\u0940" },
            { "type.co.stroke", "\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f" },
            { "type.lb.normal", "\u092a\u0919\u094d\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926\u0915\u094b \u0938\u093e\u092e\u093e\u0928\u094d\u092f \u0936\u0948\u0932\u0940" },
            { "type.lb.strict", "\u092a\u0919\u094d\u0915\u094d\u0924\u093f \u0935\u093f\u091a\u094d\u091b\u0947\u0926\u0915\u094b \u0915\u0921\u093e \u0936\u0948\u0932\u0940" },
            { "type.ms.metric", "\u092e\u0947\u091f\u094d\u0930\u093f\u0915 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ca.chinese", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.ca.islamic", metaValue_type_ca_islamic },
            { "type.ca.iso8601", "ISO-8601 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.ca.persian", "\u092b\u093e\u0930\u0938\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.cf.account", "\u0932\u0947\u0916\u093e\u0938\u092e\u094d\u092c\u0928\u094d\u0927\u0940 \u092e\u0941\u0926\u094d\u0930\u093e\u0915\u094b \u0922\u093e\u0901\u091a\u093e" },
            { "type.co.big5han", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u0901\u092f\u093e \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f - \u092c\u093f\u0917 \u092b\u093e\u0907\u092d" },
            { "type.nu.arabext", "\u0935\u093f\u0938\u094d\u0924\u0943\u0924 \u0905\u0930\u092c\u0940 \u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.armnlow", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940 \u0938\u093e\u0928\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.greklow", "\u0917\u094d\u0930\u0940\u0915 \u0938\u093e\u0928\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hanidec", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0926\u0936\u092e\u0932\u0935 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hansfin", "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hantfin", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.jpanfin", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.tamldec", "\u0924\u093e\u092e\u093f\u0932 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.ca.buddhist", "\u092c\u0941\u0926\u094d\u0927\u093f\u0937\u094d\u091f \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.ca.ethiopic", "\u0907\u0925\u093f\u0913\u092a\u093f\u0915 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.ca.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.cf.standard", "\u092e\u093e\u0928\u0915 \u092e\u0941\u0926\u094d\u0930\u093e\u0915\u094b \u0922\u093e\u0901\u091a\u093e" },
            { "type.co.standard", "\u092e\u093e\u0928\u0915 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e" },
            { "type.ms.uksystem", "\u0907\u092e\u094d\u092a\u0947\u0930\u093f\u092f\u0932 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ms.ussystem", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.nu.fullwide", "\u092a\u0942\u0930\u093e \u091a\u094c\u0902\u0921\u093e\u0907\u0915\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.romanlow", "\u0930\u094b\u092e\u0928 \u0938\u093e\u0928\u093e \u0915\u0947\u0938\u0915\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.co.gb2312han", "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f-\u0917\u0940\u092c\u0940\u091f\u0941\u0925\u094d\u0930\u0940\u0935\u093e\u0928\u091f\u0941" },
            { "type.co.phonebook", "\u091f\u0947\u0932\u093f\u092b\u094b\u0928 \u092a\u0941\u0938\u094d\u0924\u093f\u0915\u093e \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e\u092a\u0926\u094d\u0926\u0924\u093f" },
            { "type.co.traditional", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f" },
            { "type.ca.islamic-civil", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u0928\u093e\u0917\u0930\u093f\u0915 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.ca.islamic-umalqura", metaValue_type_ca_islamic },
            { "type.ca.ethiopic-amete-alem", "\u0907\u0925\u093f\u092f\u093f\u092a\u093f\u092f\u093e\u0932\u0940 \u0906\u092e\u0947\u091f \u0906\u0932\u0947\u092e \u092a\u093e\u0924\u094d\u0930" },
        };
        return data;
    }
}
