/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiFile;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016J6\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0014H\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "<init>", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "isApplicable", "", "extensionEquals", "extension", "requiresAllDocumentsToBeCommitted", "formatGradleDependency", "groupId", "artifactId", "version", "scope", "classifier", "isKotlinDsl", "toGradleDependency", "mavenDependency", "extractGradleDependency", "document", "Lorg/w3c/dom/Document;", "getScope", "getVersion", "getArtifactId", "getGroupId", "getClassifier", "firstOrEmpty", "list", "Lorg/w3c/dom/NodeList;", "isMvnDependency", "trimLeadingComment", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nPasteMvnDependencyPreProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasteMvnDependencyPreProcessor.kt\norg/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,150:1\n106#2:151\n78#2,22:152\n106#2:174\n78#2,22:175\n*S KotlinDebug\n*F\n+ 1 PasteMvnDependencyPreProcessor.kt\norg/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor\n*L\n132#1:151\n132#1:152,22\n143#1:174\n143#1:175,22\n*E\n"})
public final class PasteMvnDependencyPreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@Nullable PsiFile file, @Nullable int[] startOffsets, @Nullable int[] endOffsets, @Nullable String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(@Nullable Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull String text, @Nullable RawText rawText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.isApplicable(file) && this.isMvnDependency(text)) {
            GradleActionsUsagesCollector.trigger(project, GradleActionsUsagesCollector.PASTE_MAVEN_DEPENDENCY);
            boolean isKotlinDsl = this.extensionEquals(file, "gradle.kts");
            return this.toGradleDependency(text, isKotlinDsl);
        }
        return text;
    }

    private final boolean isApplicable(PsiFile file) {
        return this.extensionEquals(file, "gradle") || this.extensionEquals(file, "gradle.kts");
    }

    private final boolean extensionEquals(PsiFile $this$extensionEquals, String extension) {
        return FileUtilRt.extensionEquals((String)$this$extensionEquals.getName(), (String)extension);
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    private final String formatGradleDependency(String groupId, String artifactId, String version, String scope, String classifier, boolean isKotlinDsl) {
        Object gradleClassifier = ((CharSequence)classifier).length() == 0 ? "" : ":" + classifier;
        Object gradleVersion = ((CharSequence)version).length() == 0 ? "" : ":" + version;
        StringBuilder dependency = new StringBuilder().append(scope).append(isKotlinDsl ? "(\"" : " '").append(groupId).append(':').append(artifactId).append((String)gradleVersion).append((String)gradleClassifier).append(isKotlinDsl ? "\")" : "'");
        String string = dependency.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public final String toGradleDependency(@NotNull String mavenDependency, boolean isKotlinDsl) {
        Intrinsics.checkNotNullParameter((Object)mavenDependency, (String)"mavenDependency");
        try {
            DocumentBuilder builder = JavaXmlDocumentKt.createDocumentBuilder$default((boolean)false, (int)1, null);
            Document document = builder.parse(new InputSource(new StringReader(mavenDependency)));
            Intrinsics.checkNotNull((Object)document);
            String gradleDependency = this.extractGradleDependency(document, isKotlinDsl);
            String string = gradleDependency;
            if (string == null) {
                string = mavenDependency;
            }
            return string;
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mavenDependency;
    }

    private final String extractGradleDependency(Document document, boolean isKotlinDsl) {
        String groupId = this.getGroupId(document);
        String artifactId = this.getArtifactId(document);
        String version = this.getVersion(document);
        String scope = this.getScope(document);
        String classifier = this.getClassifier(document);
        if (((CharSequence)groupId).length() == 0 || ((CharSequence)artifactId).length() == 0) {
            return null;
        }
        return this.formatGradleDependency(groupId, artifactId, version, scope, classifier, isKotlinDsl);
    }

    private final String getScope(Document document) {
        String scope;
        NodeList nodeList = document.getElementsByTagName("scope");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        return switch (scope = this.firstOrEmpty(nodeList)) {
            case "test" -> "testImplementation";
            case "provided" -> "compileOnly";
            case "runtime" -> "runtime";
            case "compile" -> "implementation";
            default -> "implementation";
        };
    }

    private final String getVersion(Document document) {
        NodeList nodeList = document.getElementsByTagName("version");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        return this.firstOrEmpty(nodeList);
    }

    private final String getArtifactId(Document document) {
        NodeList nodeList = document.getElementsByTagName("artifactId");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        return this.firstOrEmpty(nodeList);
    }

    private final String getGroupId(Document document) {
        NodeList nodeList = document.getElementsByTagName("groupId");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        return this.firstOrEmpty(nodeList);
    }

    private final String getClassifier(Document document) {
        NodeList nodeList = document.getElementsByTagName("classifier");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagName(...)");
        return this.firstOrEmpty(nodeList);
    }

    private final String firstOrEmpty(NodeList list) {
        String string;
        Node first;
        Node node = first = list.item(0);
        if (node != null) {
            String string2 = node.getTextContent();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextContent(...)");
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMvnDependency(String text) {
        String trimmed;
        void $this$trim$iv;
        String string = text;
        PasteMvnDependencyPreProcessor pasteMvnDependencyPreProcessor = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return StringsKt.startsWith$default((String)(trimmed = pasteMvnDependencyPreProcessor.trimLeadingComment(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())), (String)"<dependency>", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)trimmed, (String)"</dependency>", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String trimLeadingComment(String text) {
        int start2 = StringsKt.indexOf$default((CharSequence)text, (String)"<!--", (int)0, (boolean)false, (int)6, null);
        int end = StringsKt.indexOf$default((CharSequence)text, (String)"-->", (int)0, (boolean)false, (int)6, null);
        if (start2 == 0 && end > 0) {
            void $this$trim$iv;
            String string = text.substring(end + 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        return text;
    }
}

