/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.DirectByteBufferPool;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

final class DirectByteBufferBackedInputStream
extends InputStream {
    private ByteBuffer buffer;
    private final boolean isPooled;

    DirectByteBufferBackedInputStream(ByteBuffer buffer, boolean isPooled) {
        this.buffer = buffer;
        this.isPooled = isPooled;
    }

    @Override
    public int read() {
        return this.buffer.hasRemaining() ? this.buffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int actualLength = Math.min(length, this.buffer.remaining());
        this.buffer.get(bytes, offset, actualLength);
        return actualLength;
    }

    @Override
    public byte[] readNBytes(int length) {
        byte[] result = new byte[Math.min(length, this.buffer.remaining())];
        this.buffer.get(result);
        return result;
    }

    @Override
    public int readNBytes(byte[] bytes, int offset, int length) {
        int actualLength = Math.min(length, this.buffer.remaining());
        this.buffer.get(bytes, offset, actualLength);
        return actualLength;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public byte @NotNull [] readAllBytes() {
        byte[] result = new byte[this.buffer.remaining()];
        this.buffer.get(result);
        if (result == null) {
            DirectByteBufferBackedInputStream.$$$reportNull$$$0(0);
        }
        return result;
    }

    @Override
    public long skip(long length) {
        int actualLength = Math.min((int)length, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + actualLength);
        return actualLength;
    }

    @Override
    public void close() {
        ByteBuffer buffer = this.buffer;
        if (buffer == null) {
            return;
        }
        this.buffer = null;
        if (this.isPooled) {
            DirectByteBufferPool.DEFAULT_POOL.release(buffer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/DirectByteBufferBackedInputStream", "readAllBytes"));
    }
}

