/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class AnnotationBasedBlockingMethodChecker
implements BlockingMethodChecker {
    private final Collection<String> myBlockingAnnotations;
    private final Collection<String> myNonBlockingAnnotations;

    public AnnotationBasedBlockingMethodChecker(@NotNull Collection<String> blockingAnnotations, @NotNull Collection<String> nonBlockingAnnotations) {
        if (blockingAnnotations == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        if (nonBlockingAnnotations == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        this.myBlockingAnnotations = blockingAnnotations;
        this.myNonBlockingAnnotations = nonBlockingAnnotations;
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(2);
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)file.getProject());
        GlobalSearchScope fileResolveScope = file.getResolveScope();
        for (String annotation : this.myBlockingAnnotations) {
            if (javaPsi.findClass(annotation, fileResolveScope) == null) continue;
            return true;
        }
        for (String annotation : this.myNonBlockingAnnotations) {
            if (javaPsi.findClass(annotation, fileResolveScope) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        if (context == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(3);
        }
        return AnnotationBasedBlockingMethodChecker.isMethodOrClassAnnotated(context.getElement(), this.myBlockingAnnotations, this.myNonBlockingAnnotations);
    }

    public boolean isMethodNonBlocking(@NotNull MethodContext context) {
        if (context == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(4);
        }
        return AnnotationBasedBlockingMethodChecker.isMethodOrClassAnnotated(context.getElement(), this.myNonBlockingAnnotations, this.myBlockingAnnotations);
    }

    private static boolean isMethodOrClassAnnotated(@NotNull PsiMethod method, @NotNull Collection<String> annotations, @NotNull Collection<String> denyAnnotations) {
        if (method == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(5);
        }
        if (annotations == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(6);
        }
        if (denyAnnotations == null) {
            AnnotationBasedBlockingMethodChecker.$$$reportNull$$$0(7);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, annotations, (boolean)false) != null) {
            return true;
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, denyAnnotations, (boolean)false) != null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && AnnotationUtil.findAnnotation((PsiModifierListOwner)containingClass, annotations, (boolean)false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockingAnnotations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonBlockingAnnotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "denyAnnotations";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/AnnotationBasedBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodBlocking";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodNonBlocking";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodOrClassAnnotated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

