/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.tooltip;

import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.label.ProductionLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;

public class BuildingToolTip
extends JToolTip {
    public BuildingToolTip(FreeColClient freeColClient, Building building) {
        int breed;
        UnitLabel unitLabel;
        AbstractGoods consumption;
        ImageLibrary lib = freeColClient.getGUI().getFixedImageLibrary();
        Game game = building.getGame();
        int workplaces = building.getUnitCapacity();
        AbstractGoods output = CollectionUtils.first(building.getOutputs());
        GoodsType outputType = output == null ? null : output.getType();
        StringBuilder sb = new StringBuilder(64);
        sb.append("[align center]");
        for (int index = 0; index < workplaces; ++index) {
            sb.append("20[]5[]");
        }
        String columns = sb.toString();
        MigLayout layout = new MigLayout("fill, insets 20, wrap " + (2 * workplaces + 1), columns, "[][][align bottom]");
        this.setLayout(layout);
        JLabel buildingName = new JLabel(Messages.getName(building));
        Font font = FontLibrary.getScaledFont("simple-bold-smaller");
        buildingName.setFont(font);
        this.add((Component)buildingName, "span");
        ProductionInfo info = building.getProductionInfo();
        AbstractGoods production = info == null ? null : CollectionUtils.first(info.getProduction());
        AbstractGoods abstractGoods = consumption = info == null ? null : CollectionUtils.first(info.getConsumption());
        if (production == null || production.getAmount() <= 0) {
            this.add((Component)new JLabel(), "span");
        } else {
            Iterator<Unit> arrow = new JLabel(ResourceManager.getString("arrow.E"));
            ((JComponent)((Object)arrow)).setFont(FontLibrary.getScaledFont("simple-bold-small"));
            AbstractGoods maxProduction = info == null ? null : CollectionUtils.first(info.getMaximumProduction());
            ProductionLabel productionOutput = new ProductionLabel(freeColClient, production, (maxProduction == null ? production : maxProduction).getAmount());
            if (consumption == null) {
                this.add((Component)productionOutput, "span");
            } else if (consumption.getAmount() > 0) {
                AbstractGoods maxConsumption = info == null ? null : CollectionUtils.first(info.getMaximumConsumption());
                ProductionLabel productionInput = new ProductionLabel(freeColClient, consumption, (maxConsumption == null ? consumption : maxConsumption).getAmount());
                this.add((Component)productionInput, "span, split 3");
                this.add((Component)((Object)arrow));
                this.add(productionOutput);
            } else {
                this.add((Component)new JLabel(new ImageIcon(lib.getScaledGoodsTypeImage(consumption.getType()))), "span, split 3");
                this.add((Component)((Object)arrow));
                this.add(new JLabel(new ImageIcon(lib.getScaledGoodsTypeImage(production.getType()))));
            }
        }
        this.add(new JLabel(new ImageIcon(lib.getScaledBuildingImage(building))));
        if (outputType != null) {
            for (Unit unit : building.getUnitList()) {
                unitLabel = new UnitLabel(freeColClient, unit);
                int amount = building.getUnitProduction(unit, outputType);
                if (amount <= 0) continue;
                this.add(unitLabel);
                ProductionLabel pLabel = new ProductionLabel(freeColClient, new AbstractGoods(outputType, amount));
                this.add((Component)pLabel, "split 2");
                this.add(new JLabel());
            }
        } else if (building.canTeach()) {
            for (Unit unit : building.getUnitList()) {
                unitLabel = new UnitLabel(freeColClient, unit);
                if (unit.getStudent() != null) {
                    JLabel progress = new JLabel(unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
                    UnitLabel sLabel = new UnitLabel(freeColClient, unit.getStudent(), true, true);
                    this.add(unitLabel);
                    this.add((Component)progress, "split 2, flowy");
                    this.add(sLabel);
                    continue;
                }
                this.add((Component)unitLabel, "span 2");
            }
        }
        int diff = building.getUnitCapacity() - building.getUnitCount();
        for (int index = 0; index < diff; ++index) {
            this.add((Component)new JLabel(new ImageIcon(lib.getScaledImage("image.unit.placeholder"))), "span 2");
        }
        int n = breed = outputType == null || !outputType.isBreedable() ? -1 : outputType.getBreedingNumber();
        if (breed > building.getColony().getGoodsCount(outputType)) {
            this.add(Utility.localizedLabel(((StringTemplate)StringTemplate.template("buildingToolTip.breeding").addAmount("%number%", breed)).addNamed("%goods%", outputType)));
        }
        if (outputType != null && FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            List<Modifier> mods = CollectionUtils.sort(building.getProductionModifiers(outputType, null), Modifier.ascendingModifierIndexComparator);
            for (Modifier m : mods) {
                JLabel[] mLabels = ModifierFormat.getModifierLabels(m, null, game.getTurn());
                for (int i = 0; i < mLabels.length; ++i) {
                    if (mLabels[i] == null) continue;
                    if (i == 0) {
                        this.add((Component)mLabels[i], "newline");
                        continue;
                    }
                    this.add(mLabels[i]);
                }
            }
        }
        this.setPreferredSize(layout.preferredLayoutSize(this));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setLayout(null);
    }
}

