/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ExecutableRequest;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSWriter;

abstract class CancelableRequest
extends ExecutableRequest {
    private SQLServerStatement stmt;
    private TDSWriter tdsWriter;
    private static final int IDLE = 0;
    private static final int SENDING_REQUEST = 1;
    private static final int RECEIVING_RESPONSE = 2;
    private static final int CANCEL = 3;
    private volatile int state = 0;
    private boolean timedOut = false;

    abstract void executeStatement(TDSWriter var1) throws SQLServerException;

    CancelableRequest(SQLServerStatement sQLServerStatement) {
        super(sQLServerStatement);
        this.stmt = sQLServerStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(TDSWriter tDSWriter) throws SQLServerException {
        this.tdsWriter = tDSWriter;
        this.timedOut = false;
        this.stmt.currentRequest = this;
        this.changeState(1);
        try {
            this.executeStatement(tDSWriter);
        }
        finally {
            this.stmt.currentRequest = null;
        }
    }

    private synchronized int changeState(int n) {
        int n2 = this.state;
        this.state = n;
        return n2;
    }

    private synchronized int changeStateIf(int n, int n2) {
        int n3 = this.state;
        if (n3 == n) {
            this.state = n2;
        }
        return n3;
    }

    void cancel() throws SQLServerException {
        if (2 == this.changeState(3)) {
            this.tdsWriter.sendCancel();
        }
    }

    void timeout() throws SQLServerException {
        if (!this.timedOut) {
            this.timedOut = true;
            this.cancel();
        }
    }

    void flip() throws SQLServerException {
        if (3 == this.changeStateIf(1, 2)) {
            this.tdsWriter.sendCancel();
        }
    }

    void complete() throws SQLServerException {
        if (3 == this.changeState(0)) {
            StreamDone streamDone = null;
            do {
                this.stmt.packetRequestor[0].setType((byte)-3);
                StreamPacket streamPacket = this.stmt.processPackets(this.stmt.getSQLServerConnection(), this.stmt.packetRequestor, 1, "CancelableRequest.complete", true);
                if (null == streamPacket) {
                    this.stmt.getSQLServerConnection().getDbCom().receive(this.stmt);
                    streamDone = null;
                    continue;
                }
                if (!(streamPacket instanceof StreamDone)) continue;
                streamDone = (StreamDone)streamPacket;
            } while (null == streamDone || !streamDone.wasCanceled());
            SQLServerException.makeFromDriverError(this.stmt.getSQLServerConnection(), this.stmt, SQLServerException.getErrString(this.timedOut ? "R_queryTimedOut" : "R_queryCancelled"), null, false);
        }
    }
}

