/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelPropertiesFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VENDORID;
    public static final int MODELNAME;
    public static final int MODELKEY;
    public static final int MODELVERSION;
    public static final int FLAGS;

    public XrRenderModelPropertiesFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRenderModelPropertiesFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelPropertiesFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelPropertiesFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorId() {
        return XrRenderModelPropertiesFB.nvendorId(this.address());
    }

    @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
    public ByteBuffer modelName() {
        return XrRenderModelPropertiesFB.nmodelName(this.address());
    }

    @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
    public String modelNameString() {
        return XrRenderModelPropertiesFB.nmodelNameString(this.address());
    }

    @NativeType(value="XrRenderModelKeyFB")
    public long modelKey() {
        return XrRenderModelPropertiesFB.nmodelKey(this.address());
    }

    @NativeType(value="uint32_t")
    public int modelVersion() {
        return XrRenderModelPropertiesFB.nmodelVersion(this.address());
    }

    @NativeType(value="XrRenderModelFlagsFB")
    public long flags() {
        return XrRenderModelPropertiesFB.nflags(this.address());
    }

    public XrRenderModelPropertiesFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelPropertiesFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB type$Default() {
        return this.type(1000119001);
    }

    public XrRenderModelPropertiesFB next(@NativeType(value="void *") long value) {
        XrRenderModelPropertiesFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB vendorId(@NativeType(value="uint32_t") int value) {
        XrRenderModelPropertiesFB.nvendorId(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB modelName(@NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]") ByteBuffer value) {
        XrRenderModelPropertiesFB.nmodelName(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB modelKey(@NativeType(value="XrRenderModelKeyFB") long value) {
        XrRenderModelPropertiesFB.nmodelKey(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB modelVersion(@NativeType(value="uint32_t") int value) {
        XrRenderModelPropertiesFB.nmodelVersion(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB flags(@NativeType(value="XrRenderModelFlagsFB") long value) {
        XrRenderModelPropertiesFB.nflags(this.address(), value);
        return this;
    }

    public XrRenderModelPropertiesFB set(int type, long next, int vendorId, ByteBuffer modelName, long modelKey, int modelVersion, long flags) {
        this.type(type);
        this.next(next);
        this.vendorId(vendorId);
        this.modelName(modelName);
        this.modelKey(modelKey);
        this.modelVersion(modelVersion);
        this.flags(flags);
        return this;
    }

    public XrRenderModelPropertiesFB set(XrRenderModelPropertiesFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRenderModelPropertiesFB malloc() {
        return (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrRenderModelPropertiesFB calloc() {
        return (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrRenderModelPropertiesFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrRenderModelPropertiesFB create(long address) {
        return (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)address);
    }

    @Nullable
    public static XrRenderModelPropertiesFB createSafe(long address) {
        return address == 0L ? null : (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrRenderModelPropertiesFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelPropertiesFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrRenderModelPropertiesFB malloc(MemoryStack stack) {
        return (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRenderModelPropertiesFB calloc(MemoryStack stack) {
        return (XrRenderModelPropertiesFB)XrRenderModelPropertiesFB.wrap(XrRenderModelPropertiesFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrRenderModelPropertiesFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nvendorId(long struct) {
        return UNSAFE.getInt(null, struct + (long)VENDORID);
    }

    public static ByteBuffer nmodelName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)MODELNAME), (int)64);
    }

    public static String nmodelNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)MODELNAME));
    }

    public static long nmodelKey(long struct) {
        return UNSAFE.getLong(null, struct + (long)MODELKEY);
    }

    public static int nmodelVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODELVERSION);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nvendorId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VENDORID, value);
    }

    public static void nmodelName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)MODELNAME), (long)value.remaining());
    }

    public static void nmodelKey(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MODELKEY, value);
    }

    public static void nmodelVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MODELVERSION, value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrRenderModelPropertiesFB.__struct((Struct.Member[])new Struct.Member[]{XrRenderModelPropertiesFB.__member((int)4), XrRenderModelPropertiesFB.__member((int)POINTER_SIZE), XrRenderModelPropertiesFB.__member((int)4), XrRenderModelPropertiesFB.__array((int)1, (int)64), XrRenderModelPropertiesFB.__member((int)8), XrRenderModelPropertiesFB.__member((int)4), XrRenderModelPropertiesFB.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        MODELNAME = layout.offsetof(3);
        MODELKEY = layout.offsetof(4);
        MODELVERSION = layout.offsetof(5);
        FLAGS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelPropertiesFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelPropertiesFB ELEMENT_FACTORY = XrRenderModelPropertiesFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrRenderModelPropertiesFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelPropertiesFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelPropertiesFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorId() {
            return XrRenderModelPropertiesFB.nvendorId(this.address());
        }

        @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
        public ByteBuffer modelName() {
            return XrRenderModelPropertiesFB.nmodelName(this.address());
        }

        @NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]")
        public String modelNameString() {
            return XrRenderModelPropertiesFB.nmodelNameString(this.address());
        }

        @NativeType(value="XrRenderModelKeyFB")
        public long modelKey() {
            return XrRenderModelPropertiesFB.nmodelKey(this.address());
        }

        @NativeType(value="uint32_t")
        public int modelVersion() {
            return XrRenderModelPropertiesFB.nmodelVersion(this.address());
        }

        @NativeType(value="XrRenderModelFlagsFB")
        public long flags() {
            return XrRenderModelPropertiesFB.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelPropertiesFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelPropertiesFB.nnext(this.address(), value);
            return this;
        }

        public Buffer vendorId(@NativeType(value="uint32_t") int value) {
            XrRenderModelPropertiesFB.nvendorId(this.address(), value);
            return this;
        }

        public Buffer modelName(@NativeType(value="char[XR_MAX_RENDER_MODEL_NAME_SIZE_FB]") ByteBuffer value) {
            XrRenderModelPropertiesFB.nmodelName(this.address(), value);
            return this;
        }

        public Buffer modelKey(@NativeType(value="XrRenderModelKeyFB") long value) {
            XrRenderModelPropertiesFB.nmodelKey(this.address(), value);
            return this;
        }

        public Buffer modelVersion(@NativeType(value="uint32_t") int value) {
            XrRenderModelPropertiesFB.nmodelVersion(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrRenderModelFlagsFB") long value) {
            XrRenderModelPropertiesFB.nflags(this.address(), value);
            return this;
        }
    }
}

