/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.audio;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class AudioUtil {
    private AudioUtil() {
    }

    /*
     * Loose catch block
     */
    public static double getCalibratedDuration(File wavFile) {
        double d;
        Throwable throwable;
        AudioInputStream audioInputStream;
        block14: {
            block15: {
                audioInputStream = AudioSystem.getAudioInputStream(new URL("file:".concat(wavFile.getAbsolutePath())));
                throwable = null;
                AudioFormat audioFormat = audioInputStream.getFormat();
                long filesize = wavFile.length();
                double bytesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getFrameSize();
                double naturalLength = (double)filesize / bytesPerSecond;
                double calibration = Config.getPref().getDouble("audio.calibration", 1.0);
                d = naturalLength / calibration;
                if (audioInputStream == null) break block14;
                if (throwable == null) break block15;
                try {
                    audioInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block14;
            }
            audioInputStream.close();
        }
        return d;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (audioInputStream != null) {
                        if (throwable != null) {
                            try {
                                audioInputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            audioInputStream.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (IOException | UnsupportedAudioFileException e) {
                Logging.debug(e);
                return 0.0;
            }
        }
    }

    public static void audioMalfunction(Exception ex) {
        String msg = ex.getMessage();
        msg = msg == null ? I18n.tr("unspecified reason", new Object[0]) : I18n.tr(msg, new Object[0]);
        Logging.error(msg);
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), "<html><p>" + msg + "</p></html>", I18n.tr("Error playing sound", new Object[0]), 0);
        }
    }
}

