/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.transform;

import java.util.List;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.Position;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.DimensionNode;
import org.olap4j.mdx.HierarchyNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LevelNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParameterNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.WithSetNode;
import org.olap4j.metadata.Member;
import org.olap4j.transform.AxisTransform;
import org.olap4j.transform.TransformUtil;

public class DrillDownOnPositionTransform
extends AxisTransform {
    private final Position positionToDrill;
    private final Member memberToDrill;
    private final List<Member> pathToMember;

    public DrillDownOnPositionTransform(Axis axis, int positionOrdinalInAxis, int memberOrdinalInPosition, CellSet cellSet) {
        super(axis);
        this.positionToDrill = TransformUtil.getPositionFromCellSet(axis, positionOrdinalInAxis, cellSet);
        this.memberToDrill = TransformUtil.getMemberFromCellSet(axis, positionOrdinalInAxis, memberOrdinalInPosition, cellSet);
        this.pathToMember = TransformUtil.getPathToMember(this.positionToDrill, memberOrdinalInPosition);
    }

    public String getName() {
        return "Drill down a member on a specific position";
    }

    public String getDescription() {
        return "Expand a member on a position by adding its children";
    }

    protected ParseTreeNode processAxisExp(ParseTreeNode exp) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DrillDownOnPositionVisitor
    implements ParseTreeVisitor<ParseTreeNode> {
        DrillDownOnPositionVisitor() {
        }

        @Override
        public ParseTreeNode visit(SelectNode selectNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(AxisNode axis) {
            return null;
        }

        @Override
        public ParseTreeNode visit(WithMemberNode calcMemberNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(WithSetNode calcSetNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(CallNode call) {
            return null;
        }

        @Override
        public ParseTreeNode visit(IdentifierNode id) {
            return null;
        }

        @Override
        public ParseTreeNode visit(ParameterNode parameterNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(CubeNode cubeNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(DimensionNode dimensionNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(HierarchyNode hierarchyNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(LevelNode levelNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(MemberNode memberNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(LiteralNode literalNode) {
            return null;
        }

        @Override
        public ParseTreeNode visit(PropertyValueNode propertyValueNode) {
            return null;
        }
    }
}

