/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.Catalog;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.Messages;
import org.pentaho.di.core.database.Schema;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogWriter;

public class DatabaseMetaInformation {
    private String[] tables;
    private String[] views;
    private String[] synonyms;
    private Catalog[] catalogs;
    private Schema[] schemas;
    private DatabaseMeta dbInfo;

    public DatabaseMetaInformation(DatabaseMeta dbInfo) {
        this.dbInfo = dbInfo;
    }

    public Catalog[] getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(Catalog[] catalogs) {
        this.catalogs = catalogs;
    }

    public DatabaseMeta getDbInfo() {
        return this.dbInfo;
    }

    public void setDbInfo(DatabaseMeta dbInfo) {
        this.dbInfo = dbInfo;
    }

    public Schema[] getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Schema[] schemas) {
        this.schemas = schemas;
    }

    public String[] getTables() {
        return this.tables;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    public String[] getViews() {
        return this.views;
    }

    public void setViews(String[] views) {
        this.views = views;
    }

    public void setSynonyms(String[] synonyms) {
        this.synonyms = synonyms;
    }

    public String[] getSynonyms() {
        return this.synonyms;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getData(ProgressMonitorListener monitor) throws KettleDatabaseException {
        Database db;
        block73: {
            block72: {
                block71: {
                    block70: {
                        block69: {
                            block68: {
                                block66: {
                                    block67: {
                                        if (monitor != null) {
                                            monitor.beginTask(Messages.getString("DatabaseMeta.Info.GettingInfoFromDb"), 8);
                                        }
                                        db = new Database(this.dbInfo);
                                        try {
                                            try {
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.ConnectingDb"));
                                                }
                                                db.connect();
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    Object var12_3 = null;
                                                    if (monitor == null) break block66;
                                                    break block67;
                                                }
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.GettingMetaData"));
                                                }
                                                DatabaseMetaData dbmd = db.getDatabaseMetaData();
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    break block68;
                                                }
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.GettingInfo"));
                                                }
                                                if (this.dbInfo.supportsCatalogs() && dbmd.supportsCatalogsInTableDefinitions()) {
                                                    ArrayList<Catalog> catalogList = new ArrayList<Catalog>();
                                                    ResultSet catalogResultSet = dbmd.getCatalogs();
                                                    while (catalogResultSet != null && catalogResultSet.next()) {
                                                        String catalogName = catalogResultSet.getString(1);
                                                        catalogList.add(new Catalog(catalogName));
                                                    }
                                                    catalogResultSet.close();
                                                    for (Catalog catalog : catalogList) {
                                                        ArrayList<String> catalogTables = new ArrayList<String>();
                                                        try {
                                                            ResultSet catalogTablesResultSet = dbmd.getTables(catalog.getCatalogName(), null, null, null);
                                                            while (catalogTablesResultSet.next()) {
                                                                String tableName = catalogTablesResultSet.getString(3);
                                                                if (db.isSystemTable(tableName)) continue;
                                                                catalogTables.add(tableName);
                                                            }
                                                            catalogTablesResultSet.close();
                                                            Collections.sort(catalogTables);
                                                        }
                                                        catch (Exception e) {
                                                            LogWriter.getInstance().logError(this.getClass().getName(), Messages.getString("DatabaseMeta.Error.UnexpectedCatalogError"), (Throwable)e);
                                                        }
                                                        catalog.setItems(catalogTables.toArray(new String[catalogTables.size()]));
                                                    }
                                                    this.setCatalogs(catalogList.toArray(new Catalog[catalogList.size()]));
                                                }
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    break block69;
                                                }
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.GettingSchemaInfo"));
                                                }
                                                if (this.dbInfo.supportsSchemas() && dbmd.supportsSchemasInTableDefinitions()) {
                                                    ArrayList<Schema> schemaList = new ArrayList<Schema>();
                                                    try {
                                                        if (this.dbInfo.getDatabaseType() == 5) {
                                                            Statement schemaStatement = db.getConnection().createStatement();
                                                            ResultSet schemaResultSet = schemaStatement.executeQuery("select name from sys.schemas");
                                                            while (schemaResultSet != null && schemaResultSet.next()) {
                                                                String schemaName = schemaResultSet.getString("name");
                                                                schemaList.add(new Schema(schemaName));
                                                            }
                                                            schemaResultSet.close();
                                                            schemaStatement.close();
                                                        } else {
                                                            ResultSet schemaResultSet = dbmd.getSchemas();
                                                            while (schemaResultSet != null && schemaResultSet.next()) {
                                                                String schemaName = schemaResultSet.getString(1);
                                                                schemaList.add(new Schema(schemaName));
                                                            }
                                                            schemaResultSet.close();
                                                        }
                                                        for (Schema schema : schemaList) {
                                                            ArrayList<String> schemaTables = new ArrayList<String>();
                                                            try {
                                                                ResultSet schemaTablesResultSet = dbmd.getTables(null, schema.getSchemaName(), null, null);
                                                                while (schemaTablesResultSet.next()) {
                                                                    String tableName = schemaTablesResultSet.getString(3);
                                                                    if (db.isSystemTable(tableName)) continue;
                                                                    schemaTables.add(tableName);
                                                                }
                                                                schemaTablesResultSet.close();
                                                                Collections.sort(schemaTables);
                                                            }
                                                            catch (Exception e) {
                                                                // empty catch block
                                                            }
                                                            schema.setItems(schemaTables.toArray(new String[schemaTables.size()]));
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        LogWriter.getInstance().logError(this.getClass().getName(), Messages.getString("DatabaseMeta.Error.UnexpectedError"), (Throwable)e);
                                                    }
                                                    this.setSchemas(schemaList.toArray(new Schema[schemaList.size()]));
                                                }
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    break block70;
                                                }
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.GettingTables"));
                                                }
                                                if (this.dbInfo.getDatabaseType() == 5) {
                                                    this.setTables(db.getTablenames(true));
                                                } else {
                                                    this.setTables(db.getTablenames());
                                                }
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    break block71;
                                                }
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.GettingViews"));
                                                }
                                                if (this.dbInfo.supportsViews()) {
                                                    if (this.dbInfo.getDatabaseType() == 5) {
                                                        this.setViews(db.getViews(true));
                                                    } else {
                                                        this.setViews(db.getViews());
                                                    }
                                                }
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                if (monitor != null && monitor.isCanceled()) {
                                                    break block72;
                                                }
                                                if (monitor != null) {
                                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.GettingSynonyms"));
                                                }
                                                if (this.dbInfo.supportsSynonyms()) {
                                                    if (this.dbInfo.getDatabaseType() == 5) {
                                                        this.setSynonyms(db.getSynonyms(true));
                                                    } else {
                                                        this.setSynonyms(db.getSynonyms());
                                                    }
                                                }
                                                if (monitor != null) {
                                                    monitor.worked(1);
                                                }
                                                break block73;
                                            }
                                            catch (Exception e) {
                                                throw new KettleDatabaseException(Messages.getString("DatabaseMeta.Error.UnableRetrieveDbInfo"), (Throwable)e);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var12_10 = null;
                                            if (monitor != null) {
                                                monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
                                            }
                                            db.disconnect();
                                            if (monitor != null) {
                                                monitor.worked(1);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
                                }
                                db.disconnect();
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                return;
                            }
                            Object var12_4 = null;
                            if (monitor != null) {
                                monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
                            }
                            db.disconnect();
                            if (monitor != null) {
                                monitor.worked(1);
                            }
                            return;
                        }
                        Object var12_5 = null;
                        if (monitor != null) {
                            monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
                        }
                        db.disconnect();
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        return;
                    }
                    Object var12_6 = null;
                    if (monitor != null) {
                        monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
                    }
                    db.disconnect();
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    return;
                }
                Object var12_7 = null;
                if (monitor != null) {
                    monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
                }
                db.disconnect();
                if (monitor != null) {
                    monitor.worked(1);
                }
                return;
            }
            Object var12_8 = null;
            if (monitor != null) {
                monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
            }
            db.disconnect();
            if (monitor != null) {
                monitor.worked(1);
            }
            return;
        }
        Object var12_9 = null;
        if (monitor != null) {
            monitor.subTask(Messages.getString("DatabaseMeta.Info.ClosingDbConnection"));
        }
        db.disconnect();
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
    }
}

