/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.locks;

import java.awt.Font;
import java.time.Duration;
import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.locks.LocksNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.McsTimeRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

final class LocksRenderers {
    LocksRenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    private static class TimeRenderer
    extends McsTimeRenderer {
        private TimeRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof Duration) {
                long micros = ValuesConverter.durationToMicros((Duration)value);
                if (micros == 0L) {
                    this.setText("< 0.001 ms");
                } else {
                    super.setValue((Object)micros, row);
                }
            } else {
                this.setText("-");
            }
        }
    }

    static class TotalCountRenderer
    extends NumberRenderer {
        TotalCountRenderer() {
        }

        static String getDisplayName() {
            return "Total Count";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, LocksRenderers.getMinimumWidth(TotalCountRenderer.getDisplayName()));
        }
    }

    static class MaxTimeRenderer
    extends TimeRenderer {
        MaxTimeRenderer() {
        }

        static String getDisplayName() {
            return "Max Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, LocksRenderers.getMinimumWidth(MaxTimeRenderer.getDisplayName()));
        }
    }

    static class TotalTimeRenderer
    extends TimeRenderer {
        TotalTimeRenderer() {
        }

        static String getDisplayName() {
            return "Total Time";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, LocksRenderers.getMinimumWidth(TotalTimeRenderer.getDisplayName()));
        }
    }

    static class LocksNameRenderer
    extends MultiRenderer {
        private static Font regular;
        private static Font bold;
        private final LabelRenderer simpleRenderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                LocksNode node = value instanceof LocksNode ? (LocksNode)((Object)value) : null;
                LocksNode parent = node == null ? null : node.getParent();
                this.setVisible(node instanceof LocksNode.Label || parent != null && parent.getParent() != null && node.icon != null);
                if (this.isVisible()) {
                    if (node instanceof LocksNode.Thread) {
                        if (parent instanceof LocksNode.Thread) {
                            if ("<timed out>".equals(parent.name)) {
                                this.setText("in");
                            } else {
                                this.setText(((LocksNode.Thread)parent).blocking ? "blocked" : "blocked by");
                            }
                        } else {
                            this.setText(((LocksNode.Thread)node).blocking ? "held by" : "blocked");
                        }
                    } else if (parent instanceof LocksNode.Thread) {
                        if ("<timed out>".equals(parent.name)) {
                            this.setText("on");
                        } else {
                            this.setText(((LocksNode.Thread)parent).blocking ? "held" : "blocked on");
                        }
                    } else if (node instanceof LocksNode.Label) {
                        this.setText(node.name);
                    }
                }
            }
        };
        private final JavaNameRenderer javaRenderer = new JavaNameRenderer(){

            public void setValue(Object value, int row) {
                this.setVisible(value instanceof LocksNode.LockClass || value instanceof LocksNode.LockObject);
                if (this.isVisible()) {
                    LocksNode node = (LocksNode)((Object)value);
                    super.setValue((Object)node.name, row);
                    this.setIcon(node.icon);
                }
            }
        };
        private final LabelRenderer threadRenderer = new LabelRenderer(){

            public void setValue(Object value, int row) {
                this.setVisible(value instanceof LocksNode.Thread);
                if (this.isVisible()) {
                    LocksNode node = (LocksNode)((Object)value);
                    LocksNode parent = node.getParent();
                    boolean toplevel = parent == null || parent.getParent() == null;
                    this.setFont(toplevel ? LocksNameRenderer.bold() : LocksNameRenderer.regular());
                    super.setValue((Object)node.name, row);
                    this.setIcon("<timed out>".equals(node.name) ? (toplevel ? Icons.getIcon((String)"GeneralIcons.Empty") : null) : node.icon);
                }
            }
        };
        private final ProfilerRenderer[] renderers = new ProfilerRenderer[]{this.simpleRenderer, this.javaRenderer, this.threadRenderer};

        LocksNameRenderer() {
        }

        protected ProfilerRenderer[] valueRenderers() {
            return this.renderers;
        }

        public void setValue(Object value, int row) {
            for (ProfilerRenderer renderer : this.valueRenderers()) {
                renderer.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Name";
        }

        private static Font regular() {
            if (regular == null) {
                regular = new LabelRenderer().getFont();
            }
            return regular;
        }

        private static Font bold() {
            if (bold == null) {
                bold = new LabelRenderer().getFont().deriveFont(1);
            }
            return bold;
        }
    }
}

