/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import liqp.ParseSettings;
import liqp.ProtectionSettings;
import liqp.RenderSettings;
import liqp.TemplateContext;
import liqp.exceptions.LiquidException;
import liqp.filters.Filter;
import liqp.nodes.LNode;
import liqp.parser.Flavor;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;
import liqp.parser.v4.NodeVisitor;
import liqp.spi.BasicTypesSupport;
import liqp.spi.SPIHelper;
import liqp.tags.Tag;
import liquid.parser.v4.LiquidLexer;
import liquid.parser.v4.LiquidParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;

public class Template {
    private final ParseTree root;
    private final Map<String, Tag> tags;
    private final Map<String, Filter> filters;
    private final long templateSize;
    private ProtectionSettings protectionSettings = new ProtectionSettings.Builder().build();
    private RenderSettings renderSettings = new RenderSettings.Builder().build();
    private final ParseSettings parseSettings;
    private TemplateContext templateContext = null;
    private ContextHolder contextHolder;

    private Template(String input, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings) {
        this.tags = tags;
        this.filters = filters;
        this.parseSettings = parseSettings;
        CodePointCharStream stream = CharStreams.fromString((String)input);
        this.templateSize = stream.size();
        LiquidLexer lexer = new LiquidLexer((CharStream)stream, parseSettings.stripSpacesAroundTags, parseSettings.stripSingleLine);
        try {
            this.root = this.parse(lexer);
        }
        catch (LiquidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("could not parse input: " + input, e);
        }
    }

    private Template(InputStream input, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings) {
        this.tags = tags;
        this.filters = filters;
        this.parseSettings = parseSettings;
        try {
            CharStream stream = CharStreams.fromStream((InputStream)input);
            this.templateSize = stream.size();
            LiquidLexer lexer = new LiquidLexer(stream, parseSettings.stripSpacesAroundTags, parseSettings.stripSingleLine);
            this.root = this.parse(lexer);
        }
        catch (LiquidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("could not parse input: " + input, e);
        }
    }

    private Template(String input, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings, RenderSettings renderSettings) {
        this(input, tags, filters, parseSettings);
        this.renderSettings = renderSettings;
    }

    private Template(File file, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings) throws IOException {
        this.tags = tags;
        this.filters = filters;
        this.parseSettings = parseSettings;
        CharStream stream = CharStreams.fromFileName((String)file.getAbsolutePath());
        try {
            this.templateSize = stream.size();
            LiquidLexer lexer = new LiquidLexer(stream, parseSettings.stripSpacesAroundTags, parseSettings.stripSingleLine);
            this.root = this.parse(lexer);
        }
        catch (Exception e) {
            throw new RuntimeException("could not parse input from " + file, e);
        }
    }

    private Template(File file, Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings, RenderSettings renderSettings) throws IOException {
        this(file, tags, filters, parseSettings);
        this.renderSettings = renderSettings;
    }

    private ParseTree parse(LiquidLexer lexer) {
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new LiquidException(String.format("lexer error \"%s\" on line %s, index %s", msg, line, charPositionInLine), line, charPositionInLine, e);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        LiquidParser parser = new LiquidParser((TokenStream)tokens, this.parseSettings.flavor == Flavor.LIQUID);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new LiquidException(String.format("parser error \"%s\" on line %s, index %s", msg, line, charPositionInLine), line, charPositionInLine, e);
            }
        });
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        try {
            return parser.parse();
        }
        catch (Exception e) {
            tokens.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return parser.parse();
        }
    }

    public ParseTree getParseTree() {
        return this.root;
    }

    public static Template parse(String input) {
        return new Template(input, Tag.getTags(), Filter.getFilters(ParseSettings.DEFAULT_FLAVOR), new ParseSettings.Builder().build());
    }

    public static Template parse(File file) throws IOException {
        return new Template(file, Tag.getTags(), Filter.getFilters(ParseSettings.DEFAULT_FLAVOR), new ParseSettings.Builder().build());
    }

    public static Template parse(File file, ParseSettings settings) throws IOException {
        return new Template(file, Tag.getTags(), Filter.getFilters(settings.flavor), settings);
    }

    public static Template parse(String input, ParseSettings settings) {
        return new Template(input, Tag.getTags(), Filter.getFilters(settings.flavor), settings);
    }

    public static Template parse(File file, ParseSettings parseSettings, RenderSettings renderSettings) throws IOException {
        return new Template(file, Tag.getTags(), Filter.getFilters(parseSettings.flavor), parseSettings, renderSettings);
    }

    public static Template parse(String template, ParseSettings parseSettings, RenderSettings renderSettings) {
        return new Template(template, Tag.getTags(), Filter.getFilters(parseSettings.flavor), parseSettings, renderSettings);
    }

    public static Template parse(InputStream input) {
        return new Template(input, Tag.getTags(), Filter.getFilters(ParseSettings.DEFAULT_FLAVOR), new ParseSettings.Builder().build());
    }

    public static Template parse(InputStream input, ParseSettings settings) {
        return new Template(input, Tag.getTags(), Filter.getFilters(settings.flavor), settings);
    }

    @Deprecated
    public static Template parse(File file, Flavor flavor) throws IOException {
        ParseSettings settings = new ParseSettings.Builder().withFlavor(flavor).build();
        return Template.parse(file, settings);
    }

    @Deprecated
    public static Template parse(String input, Flavor flavor) throws IOException {
        ParseSettings settings = new ParseSettings.Builder().withFlavor(flavor).build();
        return Template.parse(input, settings);
    }

    public Template with(Tag tag) {
        this.tags.put(tag.name, tag);
        return this;
    }

    public Template with(Filter filter) {
        this.filters.put(filter.name, filter);
        return this;
    }

    public Template withProtectionSettings(ProtectionSettings protectionSettings) {
        this.protectionSettings = protectionSettings;
        return this;
    }

    public Template withRenderSettings(RenderSettings renderSettings) {
        this.renderSettings = renderSettings;
        return this;
    }

    public Template withContextHolder(ContextHolder holder) {
        this.contextHolder = holder;
        return this;
    }

    public List<RuntimeException> errors() {
        return this.templateContext == null ? new ArrayList() : this.templateContext.errors();
    }

    public String render(String jsonMap) {
        Map map;
        try {
            map = (Map)this.parseSettings.mapper.readValue(jsonMap, HashMap.class);
        }
        catch (Exception e) {
            throw new RuntimeException("invalid json map: '" + jsonMap + "'", e);
        }
        return this.render(map);
    }

    public String render() {
        return this.render(new HashMap<String, Object>());
    }

    public String render(Inspectable object) {
        return this.renderObject(object);
    }

    public String renderObject(Object obj) {
        LiquidSupport evaluated = this.renderSettings.evaluate(this.parseSettings.mapper, obj);
        Map<String, Object> map = evaluated.toLiquid();
        return this.render(map);
    }

    public String render(String key, Object value, Object ... keyValues) {
        return this.render(false, key, value, keyValues);
    }

    public String render(boolean convertValueToMap, String key, Object value, Object ... keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.putStringKey(convertValueToMap, key, value, map);
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            key = String.valueOf(keyValues[i]);
            value = keyValues[i + 1];
            this.putStringKey(convertValueToMap, key, value, map);
        }
        return this.render(map);
    }

    public String render(Map<String, Object> variables) {
        if (this.protectionSettings.isRenderTimeLimited().booleanValue()) {
            return this.render(variables, Executors.newSingleThreadExecutor(), true);
        }
        if (this.templateSize > this.protectionSettings.maxTemplateSizeBytes) {
            throw new RuntimeException("template exceeds " + this.protectionSettings.maxTemplateSizeBytes + " bytes");
        }
        return this.renderUnguarded(variables);
    }

    public String render(final Map<String, Object> variables, ExecutorService executorService, boolean shutdown) {
        if (this.templateSize > this.protectionSettings.maxTemplateSizeBytes) {
            throw new RuntimeException("template exceeds " + this.protectionSettings.maxTemplateSizeBytes + " bytes");
        }
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() {
                return Template.this.renderUnguarded(variables);
            }
        };
        try {
            Future<String> future = executorService.submit(task);
            String string = future.get(this.protectionSettings.maxRenderTimeMillis, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (TimeoutException e) {
            throw new RuntimeException("exceeded the max amount of time (" + this.protectionSettings.maxRenderTimeMillis + " ms.)");
        }
        catch (Throwable t) {
            throw new RuntimeException("Oops, something unexpected happened: ", t);
        }
        finally {
            if (shutdown) {
                executorService.shutdown();
            }
        }
    }

    public String renderUnguarded(Map<String, Object> variables) {
        return this.renderUnguarded(variables, null, true);
    }

    public String renderUnguarded(Map<String, Object> variables, TemplateContext parent, boolean doClearThreadLocal) {
        if (doClearThreadLocal) {
            BasicTypesSupport.clearReferences();
        }
        if (variables.containsKey("liqp@includes_directory")) {
            Object includeDirectory = variables.get("liqp@includes_directory");
            if (includeDirectory instanceof File) {
                variables.put("liqp@includes_directory", ((File)includeDirectory).getAbsolutePath());
            } else if (includeDirectory instanceof Path) {
                variables.put("liqp@includes_directory", ((Path)includeDirectory).toAbsolutePath().toString());
            }
        }
        variables = this.renderSettings.evaluate(this.parseSettings.mapper, variables);
        NodeVisitor visitor = new NodeVisitor(this.tags, this.filters, this.parseSettings);
        try {
            Object rendered;
            LNode node = (LNode)visitor.visit(this.root);
            this.templateContext = parent == null ? new TemplateContext(this.protectionSettings, this.renderSettings, this.parseSettings, variables) : new TemplateContext(parent, variables);
            if (this.contextHolder != null) {
                this.contextHolder.setContext(this.templateContext);
            }
            return (rendered = node.render(this.templateContext)) == null ? "" : String.valueOf(rendered);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new RuntimeException(e);
        }
    }

    public String renderUnguarded(TemplateContext parent) {
        return this.renderUnguarded(new HashMap<String, Object>(), parent, true);
    }

    @Deprecated
    public String toStringAST() {
        return this.toStringTree();
    }

    public String toStringTree() {
        StringBuilder builder = new StringBuilder();
        this.walk(this.root, builder);
        return builder.toString();
    }

    private void walk(ParseTree tree, StringBuilder builder) {
        ArrayList<ParseTree> firstStack = new ArrayList<ParseTree>();
        firstStack.add(tree);
        ArrayList<ArrayList<ParseTree>> childListStack = new ArrayList<ArrayList<ParseTree>>();
        childListStack.add(firstStack);
        while (!childListStack.isEmpty()) {
            List childStack = (List)childListStack.get(childListStack.size() - 1);
            if (childStack.isEmpty()) {
                childListStack.remove(childListStack.size() - 1);
                continue;
            }
            tree = (ParseTree)childStack.remove(0);
            String indent = "";
            for (int i = 0; i < childListStack.size() - 1; ++i) {
                indent = indent + (((List)childListStack.get(i)).size() > 0 ? "|  " : "   ");
            }
            String tokenName = tree.getClass().getSimpleName().replaceAll("Context$", "");
            String tokenText = tree.getText().replaceAll("\\s+", " ");
            builder.append(indent).append(childStack.isEmpty() ? "'- " : "|- ").append(tokenName).append(tree.getChildCount() == 0 ? "='" + tokenText + "'" : "").append("\n");
            if (tree.getChildCount() <= 0) continue;
            childListStack.add(new ArrayList<ParseTree>(Template.children(tree)));
        }
    }

    private static List<ParseTree> children(ParseTree parent) {
        ArrayList<ParseTree> children = new ArrayList<ParseTree>();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            children.add(parent.getChild(i));
        }
        return children;
    }

    private void putStringKey(boolean convertValueToMap, String key, Object value, Map<String, Object> map) {
        if (key == null) {
            throw new RuntimeException("key cannot be null");
        }
        if (convertValueToMap && value != null) {
            if ((value.getClass().isArray() || value instanceof List) && !(value instanceof Map)) {
                map.put(key, this.parseSettings.mapper.convertValue(value, List.class));
            } else {
                map.put(key, this.parseSettings.mapper.convertValue(value, Map.class));
            }
        } else {
            map.put(key, value);
        }
    }

    static {
        SPIHelper.applyCustomDateTypes();
    }

    public static class ContextHolder {
        private TemplateContext context;

        private void setContext(TemplateContext context) {
            this.context = context;
        }

        public TemplateContext getContext() {
            return this.context;
        }
    }
}

