/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class DTOUtil {
    private DTOUtil() {
    }

    static boolean isDTOType(Class<?> cls, boolean ignorePublicNoArgsCtor) {
        if (!ignorePublicNoArgsCtor) {
            try {
                cls.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return false;
            }
        }
        for (Method m : cls.getMethods()) {
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException snme) {
                return false;
            }
        }
        boolean foundField = false;
        for (Field f : cls.getFields()) {
            int modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            if (!Modifier.isPublic(modifiers)) {
                return false;
            }
            foundField = true;
        }
        return foundField;
    }
}

