/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class LinuxInstallationSupplier
implements InstallationSupplier {
    @VisibleForTesting
    final File[] roots;
    private final OperatingSystem os;

    @Inject
    public LinuxInstallationSupplier() {
        this(OperatingSystem.current(), new File("/usr/lib/jvm"), new File("/usr/lib64/jvm"), new File("/usr/java"), new File("/usr/local/java"), new File("/opt/java"));
    }

    @VisibleForTesting
    LinuxInstallationSupplier(OperatingSystem os, File ... roots) {
        this.roots = roots;
        this.os = os;
    }

    @Override
    public String getSourceName() {
        return "Common Linux Locations";
    }

    @Override
    public Set<InstallationLocation> get() {
        if (this.os.isLinux()) {
            return Arrays.stream(this.roots).map(root -> FileBasedInstallationFactory.fromDirectory(root, this.getSourceName(), InstallationLocation::autoDetected)).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

