/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.ButtonCellEditor;
import org.netbeans.modules.options.keymap.ButtonCellRenderer;
import org.netbeans.modules.options.keymap.ExportShortcutsAction;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.MutableShortcutsModel;
import org.netbeans.modules.options.keymap.Popupable;
import org.netbeans.modules.options.keymap.ProfilesPanel;
import org.netbeans.modules.options.keymap.ShortcutCellPanel;
import org.netbeans.modules.options.keymap.ShortcutListener;
import org.netbeans.modules.options.keymap.ShortcutPopupPanel;
import org.netbeans.modules.options.keymap.SpecialkeyPanel;
import org.netbeans.modules.options.keymap.TableSorter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;

public class KeymapPanel
extends JPanel
implements ActionListener,
Popupable,
ChangeListener {
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private volatile KeymapViewModel keymapModel;
    private TableSorter sorter;
    private JPopupMenu popup = new JPopupMenu();
    private boolean ignoreActionEvents;
    private Popup searchPopup;
    private SpecialkeyPanel specialkeyList;
    private ShortcutPopupPanel popupPanel;
    private JProgressBar actionProgress;
    private JTable actionsTable;
    private JPanel actionsView;
    private JButton btnPrintAsHTML;
    private JComboBox cbProfile;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lProfile;
    private JButton manageButton;
    private JButton moreButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JTextField searchSCField;
    private JLabel searchSCLabel;
    private JLabel waitLabel;

    public KeymapPanel() {
        this.sorter = new TableSorter(this.getModel());
        this.initComponents();
        this.specialkeyList = new SpecialkeyPanel(this, this.searchSCField);
        this.moreButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                KeymapPanel.this.hidePopup();
            }
        });
        this.sorter.setTableHeader(this.actionsTable.getTableHeader());
        this.sorter.getTableHeader().setReorderingAllowed(false);
        this.actionsTable.setSelectionMode(0);
        this.actionsTable.setAutoscrolls(true);
        ActionListener actionListener = actionEvent -> {
            this.getModel().setSearchText(this.searchField.getText());
            this.getModel().update();
        };
        final Timer timer = new Timer(300, actionListener);
        timer.setRepeats(false);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                KeymapPanel.this.searchSCField.setText("");
                ((ShortcutListener)KeymapPanel.this.searchSCField.getKeyListeners()[0]).clear();
                if (KeymapPanel.this.searchField.getText().length() > 3) {
                    timer.setInitialDelay(20);
                }
                timer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (KeymapPanel.this.searchField.getText().length() > 3) {
                    timer.setInitialDelay(300);
                }
                timer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                KeymapPanel.this.searchSCField.setText("");
                KeymapPanel.this.getModel().setSearchText(KeymapPanel.this.searchField.getText());
                KeymapPanel.this.getModel().update();
            }
        });
        this.searchSCField.addKeyListener(new ShortcutListener(false));
        ActionListener actionListener2 = actionEvent -> this.narrowByShortcut();
        final Timer timer2 = new Timer(20, actionListener2);
        timer2.setRepeats(false);
        this.searchSCField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                KeymapPanel.this.searchField.setText("");
                timer2.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                timer2.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                timer2.restart();
            }
        });
        this.actionsTable.addMouseListener(new ButtonCellMouseListener(this.actionsTable));
        this.actionsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 525 && keyEvent.getKeyCode() != 113) {
                    return;
                }
                int n = KeymapPanel.this.actionsTable.getSelectionModel().getLeadSelectionIndex();
                int n2 = KeymapPanel.this.actionsTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (n != -1 && n2 != -1 && !KeymapPanel.this.actionsTable.isEditing()) {
                    KeymapPanel.this.showPopupMenu(n, n2, -1, -1);
                    keyEvent.consume();
                }
            }
        });
        TableColumn tableColumn = this.actionsTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new ButtonCellEditor(this.getModel()));
        tableColumn.setCellRenderer(new ButtonCellRenderer(this.actionsTable.getDefaultRenderer(ButtonCellRenderer.class)));
        this.setColumnWidths();
        this.popupPanel = new ShortcutPopupPanel(this.actionsTable, this.popup);
        this.popup.add(this.popupPanel);
        this.cbProfile.addActionListener(this);
        this.manageButton.addActionListener(this);
        this.btnPrintAsHTML.setVisible(ExportShortcutsAction.getExportShortcutsToHTMLAction().isEnabled());
    }

    private void narrowByShortcut() {
        if (this.searchSCField.getText().length() != 0) {
            String string = this.searchSCField.getText();
            this.getModel().runWithoutEvents(() -> {
                this.getModel().getDataVector().removeAllElements();
                for (List<String> list : this.getModel().getCategories().values()) {
                    for (String string2 : list) {
                        for (Object object : this.getMutableModel().getItems(string2, false)) {
                            ShortcutAction shortcutAction = (ShortcutAction)object;
                            String[] stringArray = this.getMutableModel().getShortcuts(shortcutAction);
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string3 = stringArray[i];
                                if (!this.searched(string3, string)) continue;
                                this.getModel().addRow(new Object[]{new ActionHolder(shortcutAction, false), string3, string2, ""});
                            }
                        }
                    }
                }
            });
            this.getModel().fireTableDataChanged();
        } else {
            this.getModel().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeymapViewModel getModel() {
        if (this.keymapModel == null) {
            KeymapViewModel keymapViewModel = new KeymapViewModel();
            KeymapPanel keymapPanel = this;
            synchronized (keymapPanel) {
                if (this.keymapModel == null) {
                    this.keymapModel = keymapViewModel;
                    keymapViewModel.getMutableModel().addChangeListener(this);
                }
            }
        }
        return this.keymapModel;
    }

    MutableShortcutsModel getMutableModel() {
        return this.getModel().getMutableModel();
    }

    void applyChanges() {
        this.stopCurrentCellEditing();
        this.getMutableModel().apply();
    }

    void cancel() {
        this.stopCurrentCellEditing();
        if (this.keymapModel == null) {
            return;
        }
        this.getMutableModel().cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.getMutableModel().isChanged();
    }

    void update() {
        this.getModel().setSearchText("");
        this.searchSCField.setText("");
        ((ShortcutListener)this.searchSCField.getKeyListeners()[0]).clear();
        this.searchField.setText("");
        this.refreshProfileCombo();
        class I
        implements Runnable,
        TaskListener {
            int stage;

            I() {
            }

            @Override
            public void run() {
                if (this.stage > 0) {
                    ((CardLayout)KeymapPanel.this.actionsView.getLayout()).show(KeymapPanel.this.actionsView, "actions");
                } else {
                    KeymapPanel.this.getMutableModel().refreshActions();
                    Task task = KeymapPanel.this.getModel().postUpdate();
                    task.addTaskListener((TaskListener)this);
                }
            }

            public void taskFinished(Task task) {
                ++this.stage;
                SwingUtilities.invokeLater(this);
            }
        }
        KeymapModel.RP.post((Runnable)new I());
    }

    private void refreshProfileCombo() {
        this.ignoreActionEvents = true;
        String string = this.getMutableModel().getCurrentProfile();
        List<String> list = this.getMutableModel().getProfiles();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        string = this.getMutableModel().getProfileDisplayName(string);
        this.cbProfile.setModel(defaultComboBoxModel);
        this.cbProfile.setSelectedItem(string);
        this.ignoreActionEvents = false;
    }

    private void stopCurrentCellEditing() {
        int n = this.actionsTable.getEditingRow();
        int n2 = this.actionsTable.getEditingColumn();
        if (n != -1) {
            this.actionsTable.getCellEditor(n, n2).stopCellEditing();
        }
    }

    private boolean searched(String string, String string2) {
        return string2.length() == 0 || string.startsWith(string2) || string.contains(string2);
    }

    private void setColumnWidths() {
        TableColumn tableColumn = null;
        block6: for (int i = 0; i < this.actionsTable.getColumnCount(); ++i) {
            tableColumn = this.actionsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(250);
                    continue block6;
                }
                case 1: {
                    tableColumn.setPreferredWidth(175);
                    continue block6;
                }
                case 2: {
                    tableColumn.setPreferredWidth(60);
                    continue block6;
                }
                case 3: {
                    tableColumn.setPreferredWidth(60);
                }
            }
        }
    }

    private void initComponents() {
        this.lProfile = new JLabel();
        this.cbProfile = new JComboBox();
        this.manageButton = new JButton();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.searchSCLabel = new JLabel();
        this.searchSCField = new JTextField();
        this.moreButton = new JButton();
        this.actionsView = new JPanel();
        this.jPanel1 = new JPanel();
        this.actionProgress = new JProgressBar();
        this.waitLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.actionsTable = new KeymapTable();
        this.btnPrintAsHTML = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lProfile.setLabelFor(this.cbProfile);
        Mnemonics.setLocalizedText((JLabel)this.lProfile, (String)NbBundle.getMessage(KeymapPanel.class, (String)"CTL_Keymap_Name"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(KeymapPanel.class, (String)"CTL_Duplicate"));
        this.searchField.setText(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchField.text"));
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchLabel.text"));
        this.searchSCLabel.setLabelFor(this.searchSCField);
        Mnemonics.setLocalizedText((JLabel)this.searchSCLabel, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchSCLabel.text"));
        this.searchSCField.setText(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchSCField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.moreButton.text"));
        this.moreButton.setBorder(BorderFactory.createEtchedBorder());
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeymapPanel.this.moreButtonActionPerformed(actionEvent);
            }
        });
        this.actionsView.setLayout(new CardLayout());
        this.actionProgress.setIndeterminate(true);
        this.actionProgress.setString(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.actionProgress.string"));
        this.waitLabel.setFont(new Font("Dialog", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.waitLabel, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.waitLabel.text"));
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.waitLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(222, Short.MAX_VALUE).addComponent(this.actionProgress, -2, -1, -2).addContainerGap(221, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 65, Short.MAX_VALUE).addComponent(this.waitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionProgress, -2, -1, -2).addGap(0, 98, Short.MAX_VALUE)));
        this.actionsView.add((Component)this.jPanel1, "wait");
        this.jScrollPane1.setPreferredSize(new Dimension(453, 100));
        this.actionsTable.setModel(this.sorter);
        this.jScrollPane1.setViewportView(this.actionsTable);
        this.actionsView.add((Component)this.jScrollPane1, "actions");
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrintAsHTML, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.btnPrintAsHTML.text"));
        this.btnPrintAsHTML.setToolTipText(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.btnPrintAsHTML.toolTipText"));
        this.btnPrintAsHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeymapPanel.this.btnPrintAsHTMLActionPerformed(actionEvent);
            }
        });
        this.jSeparator1.setOrientation(1);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchSCLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchSCField, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreButton)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.lProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbProfile, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPrintAsHTML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageButton)).addComponent(this.actionsView, -1, -1, Short.MAX_VALUE)))).addGap(6, 6, 6)));
        groupLayout2.linkSize(0, this.searchField, this.searchSCField);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manageButton, GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, -2, 23, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lProfile).addComponent(this.cbProfile, -2, -1, -2).addComponent(this.btnPrintAsHTML))).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moreButton).addComponent(this.searchSCField, -2, -1, -2).addComponent(this.searchSCLabel).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.actionsView, -1, 188, Short.MAX_VALUE).addContainerGap()));
        this.searchField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchField.AccessibleContext.accessibleDescription"));
    }

    @Override
    public void hidePopup() {
        if (this.searchPopup != null) {
            this.searchPopup.hide();
            this.searchPopup = null;
        }
    }

    private void moreButtonActionPerformed(ActionEvent actionEvent) {
        if (this.searchPopup != null) {
            return;
        }
        JComponent jComponent = (JComponent)actionEvent.getSource();
        Point point = new Point(jComponent.getX(), jComponent.getY());
        SwingUtilities.convertPointToScreen(point, this);
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        if (point.x + this.specialkeyList.getWidth() > rectangle.width) {
            point.x = rectangle.width - this.specialkeyList.getWidth();
        }
        if (point.y + this.specialkeyList.getHeight() > rectangle.height) {
            point.y = rectangle.height - this.specialkeyList.getHeight();
        }
        this.searchPopup = PopupFactory.getSharedInstance().getPopup(this, this.specialkeyList, point.x, point.y);
        this.searchPopup.show();
    }

    private void btnPrintAsHTMLActionPerformed(ActionEvent actionEvent) {
        if (this.getMutableModel().getCurrentProfile() != null) {
            ExportShortcutsAction.exportShortcutsOfProfileToHTML(this.getMutableModel().getCurrentProfile());
        }
    }

    @Override
    public Popup getPopup() {
        return this.searchPopup;
    }

    private boolean showPopupMenu(int n, int n2, int n3, int n4) {
        JTable jTable = this.actionsTable;
        if (n2 != 1) {
            return false;
        }
        Object object = jTable.getValueAt(n, n2);
        ShortcutCellPanel shortcutCellPanel = (ShortcutCellPanel)jTable.getCellRenderer(n, n2).getTableCellRendererComponent(jTable, object, true, true, n, n2);
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        JButton jButton = shortcutCellPanel.getButton();
        if (n3 < 0 || n3 > rectangle.x + rectangle.width - jButton.getWidth()) {
            boolean bl = shortcutCellPanel.getTextField().getText().length() != 0;
            ShortcutPopupPanel shortcutPopupPanel = (ShortcutPopupPanel)this.popup.getComponents()[0];
            shortcutPopupPanel.setDisplayAddAlternative(bl);
            shortcutPopupPanel.setRow(n);
            if (n3 == -1 || n4 == -1) {
                n3 = jButton.getX() + 1;
                n4 = jButton.getY() + 1;
            }
            shortcutPopupPanel.setCustomProfile(this.keymapModel.getMutableModel().isCustomProfile(this.keymapModel.getMutableModel().getCurrentProfile()));
            this.popup.show(jTable, n3, n4);
            SwingUtilities.invokeLater(shortcutPopupPanel::requestFocus);
            this.popup.requestFocus();
            return true;
        }
        return false;
    }

    static String loc(String string) {
        return NbBundle.getMessage(KeymapPanel.class, (String)string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.ignoreActionEvents) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.cbProfile) {
            String string = (String)this.cbProfile.getSelectedItem();
            if (string != null) {
                this.getMutableModel().setCurrentProfile(string);
            }
            this.getModel().update();
        } else if (object == this.manageButton) {
            Map<String, Map<ShortcutAction, Set<String>>> map = this.getMutableModel().getModifiedProfiles();
            Set<String> set = this.getMutableModel().getDeletedProfiles();
            ProfilesPanel profilesPanel = new ProfilesPanel(this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)profilesPanel, NbBundle.getMessage(KeymapPanel.class, (String)"CTL_Manage_Keymap_Profiles"), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, new HelpCtx("org.netbeans.modules.options.keymap.ProfilesPanel"), null);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            String string = profilesPanel.getSelectedProfile();
            this.getMutableModel().setCurrentProfile(string);
            this.refreshProfileCombo();
            this.keymapModel.update();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getMutableModel()) {
            this.firePropertyChange("changed", Boolean.FALSE, Boolean.TRUE);
        }
    }

    class ButtonCellMouseListener
    implements MouseListener {
        private JTable table;

        public ButtonCellMouseListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.forwardEvent(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void forwardEvent(MouseEvent mouseEvent) {
            int n;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n2 = this.table.rowAtPoint(point);
            if (KeymapPanel.this.showPopupMenu(n2, n = this.table.columnAtPoint(point), mouseEvent.getX(), mouseEvent.getY())) {
                mouseEvent.consume();
            }
        }
    }

    private class KeymapTable
    extends JTable {
        int lastRow;
        int lastColumn;
        private String selectedActionId;

        private KeymapTable() {
        }

        @Override
        public boolean editCellAt(int n, int n2) {
            this.lastRow = n;
            this.lastColumn = n2;
            boolean bl = super.editCellAt(n, n2);
            ((DefaultCellEditor)this.getCellEditor(this.lastRow, this.lastColumn)).getComponent().requestFocus();
            return bl;
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (!this.isEditing()) {
                super.processKeyEvent(keyEvent);
            } else {
                Component component = ((DefaultCellEditor)this.getCellEditor(this.lastRow, this.lastColumn)).getComponent();
                component.requestFocus();
                component.dispatchEvent(new KeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = this.getSelectedRow();
                this.selectedActionId = this.getActionId(n);
            }
        }

        @Override
        public void sorterChanged(RowSorterEvent rowSorterEvent) {
            String string = this.selectedActionId;
            int n = this.getSelectedColumn();
            super.sorterChanged(rowSorterEvent);
            this.restoreSelection(string, n);
        }

        private void restoreSelection(String string, int n) {
            if (string == null) {
                this.clearSelection();
                return;
            }
            TableModel tableModel = this.getModel();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                ActionHolder actionHolder = (ActionHolder)tableModel.getValueAt(i, 0);
                if (actionHolder == null || !string.equals(actionHolder.getAction().getId())) continue;
                this.changeSelection(i, n, false, false);
                break;
            }
        }

        private String getActionId(int n) {
            ActionHolder actionHolder;
            if (n >= 0 && n < this.getModel().getRowCount() && (actionHolder = (ActionHolder)this.getModel().getValueAt(n, 0)) != null) {
                ShortcutAction shortcutAction = actionHolder.getAction();
                return shortcutAction.getId();
            }
            return null;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            String string = this.selectedActionId;
            int n = this.getSelectedColumn();
            super.tableChanged(tableModelEvent);
            this.restoreSelection(string, n);
        }
    }
}

