/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.mutable.MutableLeafRel;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MutableScan
extends MutableLeafRel {
    private MutableScan(TableScan rel) {
        super(MutableRelType.TABLE_SCAN, rel);
    }

    public static MutableScan of(TableScan scan) {
        return new MutableScan(scan);
    }

    private @Nullable List<String> tableQualifiedName() {
        RelOptTable table = this.rel.getTable();
        return table == null ? null : table.getQualifiedName();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof MutableScan)) {
            return false;
        }
        MutableScan other = (MutableScan)obj;
        return obj == this || Objects.equals(this.tableQualifiedName(), other.tableQualifiedName());
    }

    public int hashCode() {
        return Objects.hashCode(this.tableQualifiedName());
    }

    @Override
    public StringBuilder digest(StringBuilder buf) {
        return buf.append("Scan(table: ").append(this.tableQualifiedName()).append(")");
    }

    @Override
    public MutableRel clone() {
        return MutableScan.of((TableScan)this.rel);
    }
}

