/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class DescribeConfigsResponse
extends AbstractResponse {
    private final DescribeConfigsResponseData data;

    public Map<ConfigResource, DescribeConfigsResponseData.DescribeConfigsResult> resultMap() {
        return this.data().results().stream().collect(Collectors.toMap(configsResult -> new ConfigResource(ConfigResource.Type.forId(configsResult.resourceType()), configsResult.resourceName()), Function.identity()));
    }

    public DescribeConfigsResponse(DescribeConfigsResponseData data) {
        super(ApiKeys.DESCRIBE_CONFIGS);
        this.data = data;
    }

    private DescribeConfigsResponse(DescribeConfigsResponseData data, short version) {
        super(ApiKeys.DESCRIBE_CONFIGS);
        this.data = data;
        if (version == 0) {
            for (DescribeConfigsResponseData.DescribeConfigsResult result : data.results()) {
                for (DescribeConfigsResponseData.DescribeConfigsResourceResult config : result.configs()) {
                    if (config.isDefault()) {
                        config.setConfigSource(ConfigSource.DEFAULT_CONFIG.id);
                        continue;
                    }
                    if (result.resourceType() == ConfigResource.Type.BROKER.id()) {
                        config.setConfigSource(ConfigSource.STATIC_BROKER_CONFIG.id);
                        continue;
                    }
                    if (result.resourceType() == ConfigResource.Type.TOPIC.id()) {
                        config.setConfigSource(ConfigSource.TOPIC_CONFIG.id);
                        continue;
                    }
                    config.setConfigSource(ConfigSource.UNKNOWN.id);
                }
            }
        }
    }

    @Override
    public DescribeConfigsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.results().forEach(response -> this.updateErrorCounts(errorCounts, Errors.forCode(response.errorCode())));
        return errorCounts;
    }

    public static DescribeConfigsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsResponse(new DescribeConfigsResponseData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public static class ConfigSynonym {
        private final String name;
        private final String value;
        private final ConfigSource source;

        public ConfigSynonym(String name, String value, ConfigSource source) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = value;
            this.source = Objects.requireNonNull(source, "source");
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public ConfigSource source() {
            return this.source;
        }
    }

    public static enum ConfigType {
        UNKNOWN(0, ConfigEntry.ConfigType.UNKNOWN),
        BOOLEAN(1, ConfigEntry.ConfigType.BOOLEAN),
        STRING(2, ConfigEntry.ConfigType.STRING),
        INT(3, ConfigEntry.ConfigType.INT),
        SHORT(4, ConfigEntry.ConfigType.SHORT),
        LONG(5, ConfigEntry.ConfigType.LONG),
        DOUBLE(6, ConfigEntry.ConfigType.DOUBLE),
        LIST(7, ConfigEntry.ConfigType.LIST),
        CLASS(8, ConfigEntry.ConfigType.CLASS),
        PASSWORD(9, ConfigEntry.ConfigType.PASSWORD);

        final byte id;
        final ConfigEntry.ConfigType type;
        private static final ConfigType[] VALUES;

        private ConfigType(byte id, ConfigEntry.ConfigType type) {
            this.id = id;
            this.type = type;
        }

        public byte id() {
            return this.id;
        }

        public static ConfigType forId(byte id) {
            if (id < 0) {
                throw new IllegalArgumentException("id should be positive, id: " + id);
            }
            if (id >= VALUES.length) {
                return UNKNOWN;
            }
            return VALUES[id];
        }

        public ConfigEntry.ConfigType type() {
            return this.type;
        }

        static {
            VALUES = ConfigType.values();
        }
    }

    public static enum ConfigSource {
        UNKNOWN(0, ConfigEntry.ConfigSource.UNKNOWN),
        TOPIC_CONFIG(1, ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG),
        DYNAMIC_BROKER_CONFIG(2, ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG),
        DYNAMIC_DEFAULT_BROKER_CONFIG(3, ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG),
        STATIC_BROKER_CONFIG(4, ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG),
        DEFAULT_CONFIG(5, ConfigEntry.ConfigSource.DEFAULT_CONFIG),
        DYNAMIC_BROKER_LOGGER_CONFIG(6, ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG),
        CLIENT_METRICS_CONFIG(7, ConfigEntry.ConfigSource.DYNAMIC_CLIENT_METRICS_CONFIG);

        final byte id;
        private final ConfigEntry.ConfigSource source;
        private static final ConfigSource[] VALUES;

        private ConfigSource(byte id, ConfigEntry.ConfigSource source) {
            this.id = id;
            this.source = source;
        }

        public byte id() {
            return this.id;
        }

        public static ConfigSource forId(byte id) {
            if (id < 0) {
                throw new IllegalArgumentException("id should be positive, id: " + id);
            }
            if (id >= VALUES.length) {
                return UNKNOWN;
            }
            return VALUES[id];
        }

        public ConfigEntry.ConfigSource source() {
            return this.source;
        }

        static {
            VALUES = ConfigSource.values();
        }
    }

    public static class ConfigEntry {
        private final String name;
        private final String value;
        private final boolean isSensitive;
        private final ConfigSource source;
        private final boolean readOnly;
        private final Collection<ConfigSynonym> synonyms;
        private final ConfigType type;
        private final String documentation;

        public ConfigEntry(String name, String value, ConfigSource source, boolean isSensitive, boolean readOnly, Collection<ConfigSynonym> synonyms) {
            this(name, value, source, isSensitive, readOnly, synonyms, ConfigType.UNKNOWN, null);
        }

        public ConfigEntry(String name, String value, ConfigSource source, boolean isSensitive, boolean readOnly, Collection<ConfigSynonym> synonyms, ConfigType type, String documentation) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = value;
            this.source = Objects.requireNonNull(source, "source");
            this.isSensitive = isSensitive;
            this.readOnly = readOnly;
            this.synonyms = Objects.requireNonNull(synonyms, "synonyms");
            this.type = type;
            this.documentation = documentation;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public boolean isSensitive() {
            return this.isSensitive;
        }

        public ConfigSource source() {
            return this.source;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public Collection<ConfigSynonym> synonyms() {
            return this.synonyms;
        }

        public ConfigType type() {
            return this.type;
        }

        public String documentation() {
            return this.documentation;
        }
    }

    public static class Config {
        private final ApiError error;
        private final Collection<ConfigEntry> entries;

        public Config(ApiError error, Collection<ConfigEntry> entries) {
            this.error = Objects.requireNonNull(error, "error");
            this.entries = Objects.requireNonNull(entries, "entries");
        }

        public ApiError error() {
            return this.error;
        }

        public Collection<ConfigEntry> entries() {
            return this.entries;
        }
    }
}

