/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.unpack.ppm;

import com.github.junrar.rarfile.MainHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeHeapDump {
    private static final Logger logger = LoggerFactory.getLogger(MainHeader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        long jlen;
        File cfile = new File("P:\\test\\heapdumpc");
        File jfile = new File("P:\\test\\heapdumpj");
        if (!cfile.exists()) {
            logger.error("File not found: {}", (Object)cfile.getAbsolutePath());
            return;
        }
        if (!jfile.exists()) {
            logger.error("File not found: {}", (Object)jfile.getAbsolutePath());
            return;
        }
        long clen = cfile.length();
        if (clen != (jlen = jfile.length())) {
            logger.info("File size mismatch");
            logger.info("clen = {}", (Object)clen);
            logger.info("jlen = {}", (Object)jlen);
        }
        long len = Math.min(clen, jlen);
        InputStream cin = null;
        InputStream jin = null;
        int bufferLen = 262144;
        try {
            long off;
            cin = new BufferedInputStream(new FileInputStream(cfile), bufferLen);
            jin = new BufferedInputStream(new FileInputStream(jfile), bufferLen);
            boolean matching = true;
            boolean mismatchFound = false;
            long startOff = 0L;
            for (off = 0L; off < len; ++off) {
                if (cin.read() != jin.read()) {
                    if (!matching) continue;
                    startOff = off;
                    matching = false;
                    mismatchFound = true;
                    continue;
                }
                if (matching) continue;
                AnalyzeHeapDump.printMismatch(startOff, off);
                matching = true;
            }
            if (!matching) {
                AnalyzeHeapDump.printMismatch(startOff, off);
            }
            if (!mismatchFound) {
                logger.info("Files are identical");
            }
            logger.info("Done");
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                cin.close();
                jin.close();
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    private static void printMismatch(long startOff, long bytesRead) {
        if (logger.isInfoEnabled()) {
            logger.info("Mismatch: off={}(0x{}), len={}", new Object[]{startOff, Long.toHexString(startOff), bytesRead - startOff});
        }
    }
}

