/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;

public final class FillValues {
    public final Object asPrimitiveArray;
    public final boolean isFullyZero;

    public FillValues(SampleModel sampleModel, Number[] numberArray, boolean bl) {
        long l;
        int n;
        int n2 = sampleModel.getDataType();
        int n3 = sampleModel.getNumBands();
        int n4 = n = numberArray != null ? Math.min(numberArray.length, n3) : 0;
        if (ImageUtilities.isIntegerType(n2)) {
            int[] nArray = new int[n3];
            this.asPrimitiveArray = nArray;
            l = 0L;
            for (int i = 0; i < n; ++i) {
                Number number = numberArray[i];
                if (number == null) continue;
                nArray[i] = number.intValue();
                l |= (long)nArray[i];
            }
        } else if (bl && n2 == 4) {
            float[] fArray = new float[n3];
            Arrays.fill(fArray, Float.NaN);
            this.asPrimitiveArray = fArray;
            l = n ^ n3;
            for (int i = 0; i < n; ++i) {
                Number number = numberArray[i];
                if (number != null) {
                    fArray[i] = number.floatValue();
                    l |= (long)Float.floatToRawIntBits(fArray[i]);
                    continue;
                }
                l = -1L;
            }
        } else {
            double[] dArray = new double[n3];
            Arrays.fill(dArray, Double.NaN);
            this.asPrimitiveArray = dArray;
            l = n ^ n3;
            for (int i = 0; i < n; ++i) {
                Number number = numberArray[i];
                if (number != null) {
                    dArray[i] = number.doubleValue();
                    l |= Double.doubleToRawLongBits(dArray[i]);
                    continue;
                }
                l = -1L;
            }
        }
        this.isFullyZero = l == 0L;
    }

    public void fill(WritableRaster writableRaster) {
        int n;
        int n2;
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getWidth();
        int n5 = writableRaster.getNumBands();
        int n6 = Integer.highestOneBit(Math.max(Math.min(n4 * n5, 256) / n5, 1));
        Object object = Array.newInstance(this.asPrimitiveArray.getClass().getComponentType(), n6 * n5);
        System.arraycopy(this.asPrimitiveArray, 0, object, 0, Math.min(n5, Array.getLength(this.asPrimitiveArray)));
        for (n2 = 1; n2 < n6; n2 <<= 1) {
            n = n2 * n5;
            System.arraycopy(object, 0, object, n, n);
        }
        n2 = writableRaster.getMinY();
        if (object instanceof int[]) {
            writableRaster.setPixels(n3, n2, n6, 1, (int[])object);
        } else if (object instanceof float[]) {
            writableRaster.setPixels(n3, n2, n6, 1, (float[])object);
        } else {
            writableRaster.setPixels(n3, n2, n6, 1, (double[])object);
        }
        object = writableRaster.getDataElements(n3, n2, n6, 1, null);
        n = n2 + writableRaster.getHeight();
        int n7 = n3 + n4;
        int n8 = n3 + n6;
        while (true) {
            int n9;
            if ((n9 = n7 - n8) > 0) {
                writableRaster.setDataElements(n8, n2, Math.min(n6, n9), 1, object);
                n8 += n6;
                continue;
            }
            n8 = n3;
            if (++n2 >= n) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(WritableRenderedImage writableRenderedImage) {
        int n = writableRenderedImage.getMinTileY();
        int n2 = writableRenderedImage.getNumYTiles();
        while (--n2 >= 0) {
            int n3 = writableRenderedImage.getMinTileX();
            int n4 = writableRenderedImage.getNumXTiles();
            while (--n4 >= 0) {
                WritableRaster writableRaster = writableRenderedImage.getWritableTile(n3, n);
                try {
                    this.fill(writableRaster);
                }
                finally {
                    writableRenderedImage.releaseWritableTile(n3, n);
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        return object instanceof FillValues && Objects.deepEquals(this.asPrimitiveArray, ((FillValues)object).asPrimitiveArray);
    }

    public int hashCode() {
        return ~Arrays.deepHashCode(new Object[]{this.asPrimitiveArray});
    }
}

