/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class LockTableNode
extends MiscellaneousStatementNode {
    private TableName tableName;
    private boolean exclusiveMode;
    private long conglomerateNumber;
    private TableDescriptor lockTableDescriptor;

    LockTableNode(TableName tableName, boolean exclusiveMode, ContextManager cm) {
        super(cm);
        this.tableName = tableName;
        this.exclusiveMode = exclusiveMode;
    }

    @Override
    public String toString() {
        return "tableName: " + String.valueOf(this.tableName) + "\nexclusiveMode: " + this.exclusiveMode + "\nconglomerateNumber: " + this.conglomerateNumber + "\n" + super.toString();
    }

    @Override
    String statementToString() {
        return "LOCK TABLE";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        String schemaName = this.tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        if (sd.isSystemSchema()) {
            throw StandardException.newException((String)"42X62", (Object[])new Object[]{this.statementToString(), schemaName});
        }
        this.lockTableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), sd);
        if (this.lockTableDescriptor == null) {
            TableName synonymTab = this.resolveTableToSynonym(this.tableName);
            if (synonymTab == null) {
                throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.tableName});
            }
            this.tableName = synonymTab;
            sd = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.lockTableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sd);
            if (this.lockTableDescriptor == null) {
                throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.tableName});
            }
        }
        if (this.lockTableDescriptor.getTableType() == 3) {
            throw StandardException.newException((String)"42995", (Object[])new Object[0]);
        }
        this.conglomerateNumber = this.lockTableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.lockTableDescriptor.getConglomerateDescriptor(this.conglomerateNumber);
        cc.createDependency(this.lockTableDescriptor);
        cc.createDependency(cd);
        if (this.isPrivilegeCollectionRequired()) {
            cc.pushCurrentPrivType(0);
            cc.addRequiredTablePriv(this.lockTableDescriptor);
            cc.popCurrentPrivType();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return LockTableNode.isSessionSchema(this.lockTableDescriptor.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getLockTableConstantAction(this.tableName.getFullTableName(), this.conglomerateNumber, this.exclusiveMode);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(v);
        }
    }
}

