/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;

public class ImageCache {
    private static final Logger logger = Logger.getLogger(ImageCache.class.getName());
    private static final boolean DEBUG_PRINT_CACHE_SIZES_TO_STDOUT = false;
    public static final String REPLACEMENT_IMAGE = "image.miscicon.delete";
    private final Map<Long, BufferedImage> cache = new HashMap<Long, BufferedImage>();
    private final Map<Long, BufferedImage> lowPriorityCache = new HashMap<Long, BufferedImage>();
    private long cacheSize = 0L;
    private long lowPriorityCacheSize = 0L;

    public static ImageResource getImageResource(String key) {
        ImageResource r = ResourceManager.getImageResource(key, false);
        if (r == null && (r = ResourceManager.getImageResource(REPLACEMENT_IMAGE, false)) == null) {
            FreeCol.fatal(logger, "Replacement image not found: image.miscicon.delete");
        }
        return r;
    }

    public static long imageHash(String key, Dimension size, boolean grayscale, int variation) {
        if (variation >= 64) {
            throw new IllegalStateException("Update formula below in order to support more variations.");
        }
        if (size.width >= 4096) {
            throw new IllegalStateException("Update formula below in order to support larger image width.");
        }
        if (size.height >= 4096) {
            throw new IllegalStateException("Update formula below in order to support larger image heights.");
        }
        return (long)key.hashCode() & 0xFFFFFFFFL ^ ((long)size.width & 0x7FFFL) << 32 ^ ((long)size.height & 0x7FFFL) << 44 ^ (long)(variation << 56) ^ (grayscale ? 0x4000000000000000L : 0L) + (long)variation;
    }

    public BufferedImage getCachedImage(ImageResource ir, Dimension size, boolean grayscale, int variation) {
        long cacheKey = ImageCache.imageHash(ir.getCachingKey(), size, grayscale, variation);
        BufferedImage cached = this.searchCaches(cacheKey);
        if (cached != null) {
            return cached;
        }
        BufferedImage image = ir.getImage(variation, size, grayscale);
        this.placeImageInCache(cacheKey, image);
        return image;
    }

    public BufferedImage getCachedImageOrGenerate(String key, Dimension size, boolean grayscale, int variation, Callable<BufferedImage> imageCreator) {
        long cacheKey = ImageCache.imageHash(key, size, grayscale, variation);
        BufferedImage cached = this.searchCaches(cacheKey);
        if (cached != null) {
            return cached;
        }
        try {
            BufferedImage image = imageCreator.call();
            this.placeImageInLowPriorityCache(cacheKey, image);
            return image;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while producing image", e);
            return null;
        }
    }

    private BufferedImage searchCaches(long cacheKey) {
        BufferedImage image = this.cache.get(cacheKey);
        if (image != null) {
            return image;
        }
        image = this.lowPriorityCache.get(cacheKey);
        if (image != null) {
            return image;
        }
        return null;
    }

    private void placeImageInCache(long hashKey, BufferedImage image) {
        if (image != null) {
            this.cache.put(hashKey, image);
            this.cacheSize += (long)(image.getWidth() * image.getHeight() * 4);
            this.debugPrintCacheSizes();
        }
    }

    private void placeImageInLowPriorityCache(long hashKey, BufferedImage image) {
        if (image != null) {
            this.lowPriorityCache.put(hashKey, image);
            this.lowPriorityCacheSize += (long)(image.getWidth() * image.getHeight() * 4);
            this.debugPrintCacheSizes();
        }
    }

    private void debugPrintCacheSizes() {
    }

    public BufferedImage getScaledImage(String key, float scale, boolean grayscale) {
        ImageResource ir = ImageCache.getImageResource(key);
        BufferedImage image = ir.getImage();
        if (image == null) {
            return null;
        }
        Dimension d = new Dimension(Math.round((float)image.getWidth() * scale), Math.round((float)image.getHeight() * scale));
        return this.getCachedImage(ir, d, grayscale, 0);
    }

    public BufferedImage getSizedImage(String key, Dimension size, boolean grayscale) {
        return this.getSizedImage(key, size, grayscale, 0);
    }

    public BufferedImage getSizedImage(String key, Dimension size, boolean grayscale, int seed) {
        ImageResource ir = ImageCache.getImageResource(key);
        return this.getCachedImage(ir, size, grayscale, ir.getVariationNumberForSeed(seed));
    }

    public void clear() {
        this.cache.clear();
        this.cacheSize = 0L;
        this.clearLowPriorityCache();
    }

    public void clearLowPriorityCache() {
        this.lowPriorityCache.clear();
        this.lowPriorityCacheSize = 0L;
    }
}

