/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.advanced.interceptor.MqttClientInterceptors;
import com.hivemq.client.internal.mqtt.handler.MqttSessionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishService;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttStatefulPublishWithFlows;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.puback.MqttPubAck;
import com.hivemq.client.internal.mqtt.message.publish.puback.MqttPubAckBuilder;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubComp;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubCompBuilder;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRecBuilder;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.internal.util.collections.IntIndex;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos1.Mqtt5IncomingQos1Interceptor;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos2.Mqtt5IncomingQos2Interceptor;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubcomp.Mqtt5PubCompReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrec.Mqtt5PubRecReasonCode;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ClientScope
public class MqttIncomingQosHandler
extends MqttSessionAwareHandler {
    @NotNull
    public static final String NAME = "qos.incoming";
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttIncomingQosHandler.class);
    private static final @NotNull IntIndex.Spec<Object> INDEX_SPEC = new IntIndex.Spec<Object>(value -> {
        if (value instanceof MqttStatefulPublishWithFlows) {
            return ((MqttStatefulPublishWithFlows)value).publish.getPacketIdentifier();
        }
        return ((MqttPubRec)value).getPacketIdentifier();
    });
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    final MqttIncomingPublishService incomingPublishService;
    @NotNull
    private final IntIndex<Object> messages = new IntIndex<Object>(INDEX_SPEC);
    private int receiveMaximum;
    private long connectionIndex;

    @Inject
    MqttIncomingQosHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttIncomingPublishFlows incomingPublishFlows) {
        this.clientConfig = clientConfig;
        this.incomingPublishService = new MqttIncomingPublishService(this, incomingPublishFlows);
    }

    @Override
    public void onSessionStartOrResume(@NotNull MqttClientConnectionConfig connectionConfig, @NotNull EventLoop eventLoop) {
        this.receiveMaximum = connectionConfig.getReceiveMaximum();
        ++this.connectionIndex;
        super.onSessionStartOrResume(connectionConfig, eventLoop);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttStatefulPublish) {
            this.readPublish(ctx, (MqttStatefulPublish)msg);
        } else if (msg instanceof MqttPubRel) {
            this.readPubRel(ctx, (MqttPubRel)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readPublish(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        switch (((MqttPublish)publish.stateless()).getQos()) {
            case AT_MOST_ONCE: {
                this.readPublishQos0(publish);
                break;
            }
            case AT_LEAST_ONCE: {
                this.readPublishQos1(ctx, publish);
                break;
            }
            case EXACTLY_ONCE: {
                this.readPublishQos2(ctx, publish);
            }
        }
    }

    private void readPublishQos0(@NotNull MqttStatefulPublish publish) {
        this.incomingPublishService.onPublishQos0(new MqttStatefulPublishWithFlows(publish), this.receiveMaximum);
    }

    private void readPublishQos1(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        MqttStatefulPublishWithFlows publishWithFlows = new MqttStatefulPublishWithFlows(publish);
        publishWithFlows.connectionIndex = this.connectionIndex;
        Object prevMessage = this.messages.putIfAbsent(publishWithFlows);
        if (prevMessage == null) {
            if (!this.readNewPublishQos1Or2(ctx, publishWithFlows)) {
                this.messages.remove(publish.getPacketIdentifier());
            }
        } else if (prevMessage instanceof MqttStatefulPublishWithFlows) {
            MqttStatefulPublishWithFlows prevPublishWithFlows = (MqttStatefulPublishWithFlows)prevMessage;
            if (((MqttPublish)prevPublishWithFlows.publish.stateless()).getQos() == MqttQos.AT_LEAST_ONCE) {
                if (prevPublishWithFlows.connectionIndex == this.connectionIndex) {
                    if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0) {
                        LOGGER.error("QoS 1 PUBLISH ({}) must not be resent ({}) during the same connection", prevPublishWithFlows.publish, publish);
                        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 1 PUBLISH must not be resent during the same connection");
                    } else {
                        this.checkDupFlagSet(ctx, publish);
                    }
                } else {
                    this.messages.put(publishWithFlows);
                    if (!this.readNewPublishQos1Or2(ctx, publishWithFlows)) {
                        this.messages.put(prevMessage);
                    }
                }
            } else {
                LOGGER.error("QoS 1 PUBLISH ({}) must not carry the same packet identifier as a QoS 2 PUBLISH ({})", publish, prevPublishWithFlows.publish);
                MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 1 PUBLISH must not carry the same packet identifier as a QoS 2 PUBLISH");
            }
        } else {
            LOGGER.error("QoS 1 PUBLISH ({}) must not carry the same packet identifier as a QoS 2 PUBLISH ({})", publish, prevMessage);
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 1 PUBLISH must not carry the same packet identifier as a QoS 2 PUBLISH");
        }
    }

    private void readPublishQos2(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        MqttStatefulPublishWithFlows publishWithFlows = new MqttStatefulPublishWithFlows(publish);
        publishWithFlows.connectionIndex = this.connectionIndex;
        Object prevMessage = this.messages.putIfAbsent(publishWithFlows);
        if (prevMessage == null) {
            if (!this.readNewPublishQos1Or2(ctx, publishWithFlows)) {
                this.messages.remove(publish.getPacketIdentifier());
            }
        } else if (prevMessage instanceof MqttStatefulPublishWithFlows) {
            MqttStatefulPublishWithFlows prevPublishWithFlows = (MqttStatefulPublishWithFlows)prevMessage;
            if (((MqttPublish)prevPublishWithFlows.publish.stateless()).getQos() == MqttQos.EXACTLY_ONCE) {
                if (prevPublishWithFlows.connectionIndex == this.connectionIndex) {
                    if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0) {
                        LOGGER.error("QoS 2 PUBLISH ({}) must not be resent ({}) during the same connection", prevPublishWithFlows.publish, publish);
                        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 2 PUBLISH must not be resent during the same connection");
                    } else {
                        this.checkDupFlagSet(ctx, publish);
                    }
                } else {
                    prevPublishWithFlows.connectionIndex = this.connectionIndex;
                    this.checkDupFlagSet(ctx, publish);
                }
            } else if (prevPublishWithFlows.connectionIndex == this.connectionIndex) {
                LOGGER.error("QoS 2 PUBLISH ({}) must not carry the same packet identifier as a QoS 1 PUBLISH ({})", publish, prevPublishWithFlows.publish);
                MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 2 PUBLISH must not carry the same packet identifier as a QoS 1 PUBLISH");
            } else {
                this.messages.put(publishWithFlows);
                if (!this.readNewPublishQos1Or2(ctx, publishWithFlows)) {
                    this.messages.put(prevMessage);
                }
            }
        } else if (this.checkDupFlagSet(ctx, publish)) {
            this.writePubRec(ctx, (MqttPubRec)prevMessage);
        }
    }

    private boolean readNewPublishQos1Or2(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        if (this.incomingPublishService.onPublishQos1Or2(publishWithFlows, this.receiveMaximum)) {
            return true;
        }
        LOGGER.error("Received more QoS 1 and/or 2 PUBLISH messages ({}) than allowed by receive maximum ({})", publishWithFlows.publish, this.receiveMaximum);
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.RECEIVE_MAXIMUM_EXCEEDED, "Received more QoS 1 and/or 2 PUBLISH messages than allowed by receive maximum");
        return false;
    }

    private boolean checkDupFlagSet(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        if (publish.isDup()) {
            return true;
        }
        LOGGER.error("DUP flag must be set for a resent PUBLISH ({})", publish);
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "DUP flag must be set for a resent QoS " + ((MqttPublish)publish.stateless()).getQos().getCode() + " PUBLISH");
        return false;
    }

    @CallByThread(value="Netty EventLoop")
    void ack(@NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        switch (((MqttPublish)publishWithFlows.publish.stateless()).getQos()) {
            case AT_LEAST_ONCE: {
                MqttPubAck pubAck = this.buildPubAck(new MqttPubAckBuilder(publishWithFlows.publish));
                Object prevMessage = this.messages.remove(pubAck.getPacketIdentifier());
                if (!this.ack(prevMessage, publishWithFlows) || this.ctx == null) break;
                this.writePubAck(this.ctx, pubAck);
                break;
            }
            case EXACTLY_ONCE: {
                Object prevMessage;
                MqttPubRec pubRec = this.buildPubRec(new MqttPubRecBuilder(publishWithFlows.publish));
                Object object = prevMessage = !((Mqtt5PubRecReasonCode)pubRec.getReasonCode()).isError() ? this.messages.put(pubRec) : this.messages.remove(pubRec.getPacketIdentifier());
                if (!this.ack(prevMessage, publishWithFlows) || this.ctx == null) break;
                this.writePubRec(this.ctx, pubRec);
                break;
            }
        }
    }

    private boolean ack(@Nullable Object prevMessage, @NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        if (prevMessage != publishWithFlows) {
            if (prevMessage == null) {
                this.messages.remove(publishWithFlows.publish.getPacketIdentifier());
            } else {
                this.messages.put(prevMessage);
            }
            return false;
        }
        return publishWithFlows.connectionIndex == this.connectionIndex;
    }

    private void writePubAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubAck pubAck) {
        ctx.writeAndFlush((Object)pubAck, ctx.voidPromise());
    }

    private void writePubRec(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubRec pubRec) {
        ctx.writeAndFlush((Object)pubRec, ctx.voidPromise());
    }

    private void readPubRel(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubRel pubRel) {
        Object prevMessage = this.messages.remove(pubRel.getPacketIdentifier());
        if (prevMessage instanceof MqttPubRec) {
            this.writePubComp(ctx, this.buildPubComp(new MqttPubCompBuilder(pubRel)));
        } else if (prevMessage == null) {
            this.writePubComp(ctx, this.buildPubComp(new MqttPubCompBuilder(pubRel).reasonCode(Mqtt5PubCompReasonCode.PACKET_IDENTIFIER_NOT_FOUND)));
        } else {
            MqttStatefulPublishWithFlows publishWithFlows = (MqttStatefulPublishWithFlows)prevMessage;
            this.messages.put(prevMessage);
            if (((MqttPublish)publishWithFlows.publish.stateless()).getQos() == MqttQos.EXACTLY_ONCE) {
                LOGGER.error("PUBREL ({}) must not carry the same packet identifier as an unacknowledged QoS 2 PUBLISH ({})", pubRel, publishWithFlows.publish);
                MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBREL must not carry the same packet identifier as an unacknowledged QoS 2 PUBLISH");
            } else {
                LOGGER.error("PUBREL ({}) must not carry the same packet identifier as a QoS 1 PUBLISH ({})", pubRel, publishWithFlows.publish);
                MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBREL must not carry the same packet identifier as a QoS 1 PUBLISH");
            }
        }
    }

    private void writePubComp(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubComp pubComp) {
        ctx.writeAndFlush((Object)pubComp, ctx.voidPromise());
    }

    @Override
    public void onSessionEnd(@NotNull Throwable cause) {
        super.onSessionEnd(cause);
        this.messages.clear();
    }

    @NotNull
    private MqttPubAck buildPubAck(@NotNull MqttPubAckBuilder pubAckBuilder) {
        Mqtt5IncomingQos1Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getIncomingQos1Interceptor()) != null) {
            interceptor.onPublish(this.clientConfig, (Mqtt5Publish)pubAckBuilder.getPublish().stateless(), pubAckBuilder);
        }
        return pubAckBuilder.build();
    }

    @NotNull
    private MqttPubRec buildPubRec(@NotNull MqttPubRecBuilder pubRecBuilder) {
        Mqtt5IncomingQos2Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getIncomingQos2Interceptor()) != null) {
            interceptor.onPublish(this.clientConfig, (Mqtt5Publish)pubRecBuilder.getPublish().stateless(), pubRecBuilder);
        }
        return pubRecBuilder.build();
    }

    @NotNull
    private MqttPubComp buildPubComp(@NotNull MqttPubCompBuilder pubCompBuilder) {
        Mqtt5IncomingQos2Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getIncomingQos2Interceptor()) != null) {
            interceptor.onPubRel(this.clientConfig, pubCompBuilder.getPubRel(), pubCompBuilder);
        }
        return pubCompBuilder.build();
    }
}

