package #
Date::Manip::TZ::amsant01;
# Copyright (c) 2008-2019 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Thu Feb 28 13:05:01 EST 2019
#    Data version: tzdata2018i
#    Code version: tzcode2018i

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.76';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,19,17,14],'-04:42:46',[-4,-42,-46],
          'LMT',0,[1890,1,1,4,42,45],[1889,12,31,23,59,59],
          '0001010200:00:00','0001010119:17:14','1890010104:42:45','1889123123:59:59' ],
     ],
   1890 =>
     [
        [ [1890,1,1,4,42,46],[1890,1,1,0,0,0],'-04:42:46',[-4,-42,-46],
          'SMT',0,[1910,1,10,4,42,45],[1910,1,9,23,59,59],
          '1890010104:42:46','1890010100:00:00','1910011004:42:45','1910010923:59:59' ],
     ],
   1910 =>
     [
        [ [1910,1,10,4,42,46],[1910,1,9,23,42,46],'-05:00:00',[-5,0,0],
          '-05',0,[1916,7,1,4,59,59],[1916,6,30,23,59,59],
          '1910011004:42:46','1910010923:42:46','1916070104:59:59','1916063023:59:59' ],
     ],
   1916 =>
     [
        [ [1916,7,1,5,0,0],[1916,7,1,0,17,14],'-04:42:46',[-4,-42,-46],
          'SMT',0,[1918,9,10,4,42,45],[1918,9,9,23,59,59],
          '1916070105:00:00','1916070100:17:14','1918091004:42:45','1918090923:59:59' ],
     ],
   1918 =>
     [
        [ [1918,9,10,4,42,46],[1918,9,10,0,42,46],'-04:00:00',[-4,0,0],
          '-04',0,[1919,7,1,3,59,59],[1919,6,30,23,59,59],
          '1918091004:42:46','1918091000:42:46','1919070103:59:59','1919063023:59:59' ],
     ],
   1919 =>
     [
        [ [1919,7,1,4,0,0],[1919,6,30,23,17,14],'-04:42:46',[-4,-42,-46],
          'SMT',0,[1927,9,1,4,42,45],[1927,8,31,23,59,59],
          '1919070104:00:00','1919063023:17:14','1927090104:42:45','1927083123:59:59' ],
     ],
   1927 =>
     [
        [ [1927,9,1,4,42,46],[1927,9,1,0,42,46],'-04:00:00',[-4,0,0],
          '-04',1,[1928,4,1,3,59,59],[1928,3,31,23,59,59],
          '1927090104:42:46','1927090100:42:46','1928040103:59:59','1928033123:59:59' ],
     ],
   1928 =>
     [
        [ [1928,4,1,4,0,0],[1928,3,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1928,9,1,4,59,59],[1928,8,31,23,59,59],
          '1928040104:00:00','1928033123:00:00','1928090104:59:59','1928083123:59:59' ],
        [ [1928,9,1,5,0,0],[1928,9,1,1,0,0],'-04:00:00',[-4,0,0],
          '-04',1,[1929,4,1,3,59,59],[1929,3,31,23,59,59],
          '1928090105:00:00','1928090101:00:00','1929040103:59:59','1929033123:59:59' ],
     ],
   1929 =>
     [
        [ [1929,4,1,4,0,0],[1929,3,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1929,9,1,4,59,59],[1929,8,31,23,59,59],
          '1929040104:00:00','1929033123:00:00','1929090104:59:59','1929083123:59:59' ],
        [ [1929,9,1,5,0,0],[1929,9,1,1,0,0],'-04:00:00',[-4,0,0],
          '-04',1,[1930,4,1,3,59,59],[1930,3,31,23,59,59],
          '1929090105:00:00','1929090101:00:00','1930040103:59:59','1930033123:59:59' ],
     ],
   1930 =>
     [
        [ [1930,4,1,4,0,0],[1930,3,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1930,9,1,4,59,59],[1930,8,31,23,59,59],
          '1930040104:00:00','1930033123:00:00','1930090104:59:59','1930083123:59:59' ],
        [ [1930,9,1,5,0,0],[1930,9,1,1,0,0],'-04:00:00',[-4,0,0],
          '-04',1,[1931,4,1,3,59,59],[1931,3,31,23,59,59],
          '1930090105:00:00','1930090101:00:00','1931040103:59:59','1931033123:59:59' ],
     ],
   1931 =>
     [
        [ [1931,4,1,4,0,0],[1931,3,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1931,9,1,4,59,59],[1931,8,31,23,59,59],
          '1931040104:00:00','1931033123:00:00','1931090104:59:59','1931083123:59:59' ],
        [ [1931,9,1,5,0,0],[1931,9,1,1,0,0],'-04:00:00',[-4,0,0],
          '-04',1,[1932,4,1,3,59,59],[1932,3,31,23,59,59],
          '1931090105:00:00','1931090101:00:00','1932040103:59:59','1932033123:59:59' ],
     ],
   1932 =>
     [
        [ [1932,4,1,4,0,0],[1932,3,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1932,9,1,4,59,59],[1932,8,31,23,59,59],
          '1932040104:00:00','1932033123:00:00','1932090104:59:59','1932083123:59:59' ],
        [ [1932,9,1,5,0,0],[1932,9,1,1,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1942,6,1,3,59,59],[1942,5,31,23,59,59],
          '1932090105:00:00','1932090101:00:00','1942060103:59:59','1942053123:59:59' ],
     ],
   1942 =>
     [
        [ [1942,6,1,4,0,0],[1942,5,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1942,8,1,4,59,59],[1942,7,31,23,59,59],
          '1942060104:00:00','1942053123:00:00','1942080104:59:59','1942073123:59:59' ],
        [ [1942,8,1,5,0,0],[1942,8,1,1,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1946,7,15,3,59,59],[1946,7,14,23,59,59],
          '1942080105:00:00','1942080101:00:00','1946071503:59:59','1946071423:59:59' ],
     ],
   1946 =>
     [
        [ [1946,7,15,4,0,0],[1946,7,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1946,9,1,2,59,59],[1946,8,31,23,59,59],
          '1946071504:00:00','1946071501:00:00','1946090102:59:59','1946083123:59:59' ],
        [ [1946,9,1,3,0,0],[1946,8,31,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1947,4,1,3,59,59],[1947,3,31,23,59,59],
          '1946090103:00:00','1946083123:00:00','1947040103:59:59','1947033123:59:59' ],
     ],
   1947 =>
     [
        [ [1947,4,1,4,0,0],[1947,3,31,23,0,0],'-05:00:00',[-5,0,0],
          '-05',0,[1947,5,22,3,59,59],[1947,5,21,22,59,59],
          '1947040104:00:00','1947033123:00:00','1947052203:59:59','1947052122:59:59' ],
        [ [1947,5,22,4,0,0],[1947,5,22,0,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1968,11,3,3,59,59],[1968,11,2,23,59,59],
          '1947052204:00:00','1947052200:00:00','1968110303:59:59','1968110223:59:59' ],
     ],
   1968 =>
     [
        [ [1968,11,3,4,0,0],[1968,11,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1969,3,30,2,59,59],[1969,3,29,23,59,59],
          '1968110304:00:00','1968110301:00:00','1969033002:59:59','1969032923:59:59' ],
     ],
   1969 =>
     [
        [ [1969,3,30,3,0,0],[1969,3,29,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1969,11,23,3,59,59],[1969,11,22,23,59,59],
          '1969033003:00:00','1969032923:00:00','1969112303:59:59','1969112223:59:59' ],
        [ [1969,11,23,4,0,0],[1969,11,23,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1970,3,29,2,59,59],[1970,3,28,23,59,59],
          '1969112304:00:00','1969112301:00:00','1970032902:59:59','1970032823:59:59' ],
     ],
   1970 =>
     [
        [ [1970,3,29,3,0,0],[1970,3,28,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1970,10,11,3,59,59],[1970,10,10,23,59,59],
          '1970032903:00:00','1970032823:00:00','1970101103:59:59','1970101023:59:59' ],
        [ [1970,10,11,4,0,0],[1970,10,11,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1971,3,14,2,59,59],[1971,3,13,23,59,59],
          '1970101104:00:00','1970101101:00:00','1971031402:59:59','1971031323:59:59' ],
     ],
   1971 =>
     [
        [ [1971,3,14,3,0,0],[1971,3,13,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1971,10,10,3,59,59],[1971,10,9,23,59,59],
          '1971031403:00:00','1971031323:00:00','1971101003:59:59','1971100923:59:59' ],
        [ [1971,10,10,4,0,0],[1971,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1972,3,12,2,59,59],[1972,3,11,23,59,59],
          '1971101004:00:00','1971101001:00:00','1972031202:59:59','1972031123:59:59' ],
     ],
   1972 =>
     [
        [ [1972,3,12,3,0,0],[1972,3,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1972,10,15,3,59,59],[1972,10,14,23,59,59],
          '1972031203:00:00','1972031123:00:00','1972101503:59:59','1972101423:59:59' ],
        [ [1972,10,15,4,0,0],[1972,10,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1973,3,11,2,59,59],[1973,3,10,23,59,59],
          '1972101504:00:00','1972101501:00:00','1973031102:59:59','1973031023:59:59' ],
     ],
   1973 =>
     [
        [ [1973,3,11,3,0,0],[1973,3,10,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1973,9,30,3,59,59],[1973,9,29,23,59,59],
          '1973031103:00:00','1973031023:00:00','1973093003:59:59','1973092923:59:59' ],
        [ [1973,9,30,4,0,0],[1973,9,30,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1974,3,10,2,59,59],[1974,3,9,23,59,59],
          '1973093004:00:00','1973093001:00:00','1974031002:59:59','1974030923:59:59' ],
     ],
   1974 =>
     [
        [ [1974,3,10,3,0,0],[1974,3,9,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1974,10,13,3,59,59],[1974,10,12,23,59,59],
          '1974031003:00:00','1974030923:00:00','1974101303:59:59','1974101223:59:59' ],
        [ [1974,10,13,4,0,0],[1974,10,13,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1975,3,9,2,59,59],[1975,3,8,23,59,59],
          '1974101304:00:00','1974101301:00:00','1975030902:59:59','1975030823:59:59' ],
     ],
   1975 =>
     [
        [ [1975,3,9,3,0,0],[1975,3,8,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1975,10,12,3,59,59],[1975,10,11,23,59,59],
          '1975030903:00:00','1975030823:00:00','1975101203:59:59','1975101123:59:59' ],
        [ [1975,10,12,4,0,0],[1975,10,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1976,3,14,2,59,59],[1976,3,13,23,59,59],
          '1975101204:00:00','1975101201:00:00','1976031402:59:59','1976031323:59:59' ],
     ],
   1976 =>
     [
        [ [1976,3,14,3,0,0],[1976,3,13,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1976,10,10,3,59,59],[1976,10,9,23,59,59],
          '1976031403:00:00','1976031323:00:00','1976101003:59:59','1976100923:59:59' ],
        [ [1976,10,10,4,0,0],[1976,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1977,3,13,2,59,59],[1977,3,12,23,59,59],
          '1976101004:00:00','1976101001:00:00','1977031302:59:59','1977031223:59:59' ],
     ],
   1977 =>
     [
        [ [1977,3,13,3,0,0],[1977,3,12,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1977,10,9,3,59,59],[1977,10,8,23,59,59],
          '1977031303:00:00','1977031223:00:00','1977100903:59:59','1977100823:59:59' ],
        [ [1977,10,9,4,0,0],[1977,10,9,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1978,3,12,2,59,59],[1978,3,11,23,59,59],
          '1977100904:00:00','1977100901:00:00','1978031202:59:59','1978031123:59:59' ],
     ],
   1978 =>
     [
        [ [1978,3,12,3,0,0],[1978,3,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1978,10,15,3,59,59],[1978,10,14,23,59,59],
          '1978031203:00:00','1978031123:00:00','1978101503:59:59','1978101423:59:59' ],
        [ [1978,10,15,4,0,0],[1978,10,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1979,3,11,2,59,59],[1979,3,10,23,59,59],
          '1978101504:00:00','1978101501:00:00','1979031102:59:59','1979031023:59:59' ],
     ],
   1979 =>
     [
        [ [1979,3,11,3,0,0],[1979,3,10,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1979,10,14,3,59,59],[1979,10,13,23,59,59],
          '1979031103:00:00','1979031023:00:00','1979101403:59:59','1979101323:59:59' ],
        [ [1979,10,14,4,0,0],[1979,10,14,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1980,3,9,2,59,59],[1980,3,8,23,59,59],
          '1979101404:00:00','1979101401:00:00','1980030902:59:59','1980030823:59:59' ],
     ],
   1980 =>
     [
        [ [1980,3,9,3,0,0],[1980,3,8,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1980,10,12,3,59,59],[1980,10,11,23,59,59],
          '1980030903:00:00','1980030823:00:00','1980101203:59:59','1980101123:59:59' ],
        [ [1980,10,12,4,0,0],[1980,10,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1981,3,15,2,59,59],[1981,3,14,23,59,59],
          '1980101204:00:00','1980101201:00:00','1981031502:59:59','1981031423:59:59' ],
     ],
   1981 =>
     [
        [ [1981,3,15,3,0,0],[1981,3,14,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1981,10,11,3,59,59],[1981,10,10,23,59,59],
          '1981031503:00:00','1981031423:00:00','1981101103:59:59','1981101023:59:59' ],
        [ [1981,10,11,4,0,0],[1981,10,11,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1982,3,14,2,59,59],[1982,3,13,23,59,59],
          '1981101104:00:00','1981101101:00:00','1982031402:59:59','1982031323:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,14,3,0,0],[1982,3,13,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1982,10,10,3,59,59],[1982,10,9,23,59,59],
          '1982031403:00:00','1982031323:00:00','1982101003:59:59','1982100923:59:59' ],
        [ [1982,10,10,4,0,0],[1982,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1983,3,13,2,59,59],[1983,3,12,23,59,59],
          '1982101004:00:00','1982101001:00:00','1983031302:59:59','1983031223:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,13,3,0,0],[1983,3,12,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1983,10,9,3,59,59],[1983,10,8,23,59,59],
          '1983031303:00:00','1983031223:00:00','1983100903:59:59','1983100823:59:59' ],
        [ [1983,10,9,4,0,0],[1983,10,9,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1984,3,11,2,59,59],[1984,3,10,23,59,59],
          '1983100904:00:00','1983100901:00:00','1984031102:59:59','1984031023:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,11,3,0,0],[1984,3,10,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1984,10,14,3,59,59],[1984,10,13,23,59,59],
          '1984031103:00:00','1984031023:00:00','1984101403:59:59','1984101323:59:59' ],
        [ [1984,10,14,4,0,0],[1984,10,14,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1985,3,10,2,59,59],[1985,3,9,23,59,59],
          '1984101404:00:00','1984101401:00:00','1985031002:59:59','1985030923:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,10,3,0,0],[1985,3,9,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1985,10,13,3,59,59],[1985,10,12,23,59,59],
          '1985031003:00:00','1985030923:00:00','1985101303:59:59','1985101223:59:59' ],
        [ [1985,10,13,4,0,0],[1985,10,13,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1986,3,9,2,59,59],[1986,3,8,23,59,59],
          '1985101304:00:00','1985101301:00:00','1986030902:59:59','1986030823:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,9,3,0,0],[1986,3,8,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1986,10,12,3,59,59],[1986,10,11,23,59,59],
          '1986030903:00:00','1986030823:00:00','1986101203:59:59','1986101123:59:59' ],
        [ [1986,10,12,4,0,0],[1986,10,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1987,4,12,2,59,59],[1987,4,11,23,59,59],
          '1986101204:00:00','1986101201:00:00','1987041202:59:59','1987041123:59:59' ],
     ],
   1987 =>
     [
        [ [1987,4,12,3,0,0],[1987,4,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1987,10,11,3,59,59],[1987,10,10,23,59,59],
          '1987041203:00:00','1987041123:00:00','1987101103:59:59','1987101023:59:59' ],
        [ [1987,10,11,4,0,0],[1987,10,11,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1988,3,13,2,59,59],[1988,3,12,23,59,59],
          '1987101104:00:00','1987101101:00:00','1988031302:59:59','1988031223:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,13,3,0,0],[1988,3,12,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1988,10,9,3,59,59],[1988,10,8,23,59,59],
          '1988031303:00:00','1988031223:00:00','1988100903:59:59','1988100823:59:59' ],
        [ [1988,10,9,4,0,0],[1988,10,9,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1989,3,12,2,59,59],[1989,3,11,23,59,59],
          '1988100904:00:00','1988100901:00:00','1989031202:59:59','1989031123:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,12,3,0,0],[1989,3,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1989,10,15,3,59,59],[1989,10,14,23,59,59],
          '1989031203:00:00','1989031123:00:00','1989101503:59:59','1989101423:59:59' ],
        [ [1989,10,15,4,0,0],[1989,10,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1990,3,11,2,59,59],[1990,3,10,23,59,59],
          '1989101504:00:00','1989101501:00:00','1990031102:59:59','1990031023:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,11,3,0,0],[1990,3,10,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1990,9,16,3,59,59],[1990,9,15,23,59,59],
          '1990031103:00:00','1990031023:00:00','1990091603:59:59','1990091523:59:59' ],
        [ [1990,9,16,4,0,0],[1990,9,16,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1991,3,10,2,59,59],[1991,3,9,23,59,59],
          '1990091604:00:00','1990091601:00:00','1991031002:59:59','1991030923:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,10,3,0,0],[1991,3,9,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1991,10,13,3,59,59],[1991,10,12,23,59,59],
          '1991031003:00:00','1991030923:00:00','1991101303:59:59','1991101223:59:59' ],
        [ [1991,10,13,4,0,0],[1991,10,13,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1992,3,15,2,59,59],[1992,3,14,23,59,59],
          '1991101304:00:00','1991101301:00:00','1992031502:59:59','1992031423:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,15,3,0,0],[1992,3,14,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1992,10,11,3,59,59],[1992,10,10,23,59,59],
          '1992031503:00:00','1992031423:00:00','1992101103:59:59','1992101023:59:59' ],
        [ [1992,10,11,4,0,0],[1992,10,11,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1993,3,14,2,59,59],[1993,3,13,23,59,59],
          '1992101104:00:00','1992101101:00:00','1993031402:59:59','1993031323:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,14,3,0,0],[1993,3,13,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1993,10,10,3,59,59],[1993,10,9,23,59,59],
          '1993031403:00:00','1993031323:00:00','1993101003:59:59','1993100923:59:59' ],
        [ [1993,10,10,4,0,0],[1993,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1994,3,13,2,59,59],[1994,3,12,23,59,59],
          '1993101004:00:00','1993101001:00:00','1994031302:59:59','1994031223:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,13,3,0,0],[1994,3,12,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1994,10,9,3,59,59],[1994,10,8,23,59,59],
          '1994031303:00:00','1994031223:00:00','1994100903:59:59','1994100823:59:59' ],
        [ [1994,10,9,4,0,0],[1994,10,9,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1995,3,12,2,59,59],[1995,3,11,23,59,59],
          '1994100904:00:00','1994100901:00:00','1995031202:59:59','1995031123:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,12,3,0,0],[1995,3,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1995,10,15,3,59,59],[1995,10,14,23,59,59],
          '1995031203:00:00','1995031123:00:00','1995101503:59:59','1995101423:59:59' ],
        [ [1995,10,15,4,0,0],[1995,10,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1996,3,10,2,59,59],[1996,3,9,23,59,59],
          '1995101504:00:00','1995101501:00:00','1996031002:59:59','1996030923:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,10,3,0,0],[1996,3,9,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1996,10,13,3,59,59],[1996,10,12,23,59,59],
          '1996031003:00:00','1996030923:00:00','1996101303:59:59','1996101223:59:59' ],
        [ [1996,10,13,4,0,0],[1996,10,13,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1997,3,30,2,59,59],[1997,3,29,23,59,59],
          '1996101304:00:00','1996101301:00:00','1997033002:59:59','1997032923:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,30,3,0,0],[1997,3,29,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1997,10,12,3,59,59],[1997,10,11,23,59,59],
          '1997033003:00:00','1997032923:00:00','1997101203:59:59','1997101123:59:59' ],
        [ [1997,10,12,4,0,0],[1997,10,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1998,3,15,2,59,59],[1998,3,14,23,59,59],
          '1997101204:00:00','1997101201:00:00','1998031502:59:59','1998031423:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,15,3,0,0],[1998,3,14,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1998,9,27,3,59,59],[1998,9,26,23,59,59],
          '1998031503:00:00','1998031423:00:00','1998092703:59:59','1998092623:59:59' ],
        [ [1998,9,27,4,0,0],[1998,9,27,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[1999,4,4,2,59,59],[1999,4,3,23,59,59],
          '1998092704:00:00','1998092701:00:00','1999040402:59:59','1999040323:59:59' ],
     ],
   1999 =>
     [
        [ [1999,4,4,3,0,0],[1999,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[1999,10,10,3,59,59],[1999,10,9,23,59,59],
          '1999040403:00:00','1999040323:00:00','1999101003:59:59','1999100923:59:59' ],
        [ [1999,10,10,4,0,0],[1999,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2000,3,12,2,59,59],[2000,3,11,23,59,59],
          '1999101004:00:00','1999101001:00:00','2000031202:59:59','2000031123:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,12,3,0,0],[2000,3,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2000,10,15,3,59,59],[2000,10,14,23,59,59],
          '2000031203:00:00','2000031123:00:00','2000101503:59:59','2000101423:59:59' ],
        [ [2000,10,15,4,0,0],[2000,10,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2001,3,11,2,59,59],[2001,3,10,23,59,59],
          '2000101504:00:00','2000101501:00:00','2001031102:59:59','2001031023:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,11,3,0,0],[2001,3,10,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2001,10,14,3,59,59],[2001,10,13,23,59,59],
          '2001031103:00:00','2001031023:00:00','2001101403:59:59','2001101323:59:59' ],
        [ [2001,10,14,4,0,0],[2001,10,14,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2002,3,10,2,59,59],[2002,3,9,23,59,59],
          '2001101404:00:00','2001101401:00:00','2002031002:59:59','2002030923:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,10,3,0,0],[2002,3,9,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2002,10,13,3,59,59],[2002,10,12,23,59,59],
          '2002031003:00:00','2002030923:00:00','2002101303:59:59','2002101223:59:59' ],
        [ [2002,10,13,4,0,0],[2002,10,13,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2003,3,9,2,59,59],[2003,3,8,23,59,59],
          '2002101304:00:00','2002101301:00:00','2003030902:59:59','2003030823:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,9,3,0,0],[2003,3,8,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2003,10,12,3,59,59],[2003,10,11,23,59,59],
          '2003030903:00:00','2003030823:00:00','2003101203:59:59','2003101123:59:59' ],
        [ [2003,10,12,4,0,0],[2003,10,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2004,3,14,2,59,59],[2004,3,13,23,59,59],
          '2003101204:00:00','2003101201:00:00','2004031402:59:59','2004031323:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,14,3,0,0],[2004,3,13,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2004,10,10,3,59,59],[2004,10,9,23,59,59],
          '2004031403:00:00','2004031323:00:00','2004101003:59:59','2004100923:59:59' ],
        [ [2004,10,10,4,0,0],[2004,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2005,3,13,2,59,59],[2005,3,12,23,59,59],
          '2004101004:00:00','2004101001:00:00','2005031302:59:59','2005031223:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,13,3,0,0],[2005,3,12,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2005,10,9,3,59,59],[2005,10,8,23,59,59],
          '2005031303:00:00','2005031223:00:00','2005100903:59:59','2005100823:59:59' ],
        [ [2005,10,9,4,0,0],[2005,10,9,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2006,3,12,2,59,59],[2006,3,11,23,59,59],
          '2005100904:00:00','2005100901:00:00','2006031202:59:59','2006031123:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,12,3,0,0],[2006,3,11,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2006,10,15,3,59,59],[2006,10,14,23,59,59],
          '2006031203:00:00','2006031123:00:00','2006101503:59:59','2006101423:59:59' ],
        [ [2006,10,15,4,0,0],[2006,10,15,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2007,3,11,2,59,59],[2007,3,10,23,59,59],
          '2006101504:00:00','2006101501:00:00','2007031102:59:59','2007031023:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,3,0,0],[2007,3,10,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2007,10,14,3,59,59],[2007,10,13,23,59,59],
          '2007031103:00:00','2007031023:00:00','2007101403:59:59','2007101323:59:59' ],
        [ [2007,10,14,4,0,0],[2007,10,14,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2008,3,30,2,59,59],[2008,3,29,23,59,59],
          '2007101404:00:00','2007101401:00:00','2008033002:59:59','2008032923:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,30,3,0,0],[2008,3,29,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2008,10,12,3,59,59],[2008,10,11,23,59,59],
          '2008033003:00:00','2008032923:00:00','2008101203:59:59','2008101123:59:59' ],
        [ [2008,10,12,4,0,0],[2008,10,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2009,3,15,2,59,59],[2009,3,14,23,59,59],
          '2008101204:00:00','2008101201:00:00','2009031502:59:59','2009031423:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,15,3,0,0],[2009,3,14,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2009,10,11,3,59,59],[2009,10,10,23,59,59],
          '2009031503:00:00','2009031423:00:00','2009101103:59:59','2009101023:59:59' ],
        [ [2009,10,11,4,0,0],[2009,10,11,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2010,4,4,2,59,59],[2010,4,3,23,59,59],
          '2009101104:00:00','2009101101:00:00','2010040402:59:59','2010040323:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,4,3,0,0],[2010,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2010,10,10,3,59,59],[2010,10,9,23,59,59],
          '2010040403:00:00','2010040323:00:00','2010101003:59:59','2010100923:59:59' ],
        [ [2010,10,10,4,0,0],[2010,10,10,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2011,5,8,2,59,59],[2011,5,7,23,59,59],
          '2010101004:00:00','2010101001:00:00','2011050802:59:59','2011050723:59:59' ],
     ],
   2011 =>
     [
        [ [2011,5,8,3,0,0],[2011,5,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2011,8,21,3,59,59],[2011,8,20,23,59,59],
          '2011050803:00:00','2011050723:00:00','2011082103:59:59','2011082023:59:59' ],
        [ [2011,8,21,4,0,0],[2011,8,21,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2012,4,29,2,59,59],[2012,4,28,23,59,59],
          '2011082104:00:00','2011082101:00:00','2012042902:59:59','2012042823:59:59' ],
     ],
   2012 =>
     [
        [ [2012,4,29,3,0,0],[2012,4,28,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2012,9,2,3,59,59],[2012,9,1,23,59,59],
          '2012042903:00:00','2012042823:00:00','2012090203:59:59','2012090123:59:59' ],
        [ [2012,9,2,4,0,0],[2012,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2013,4,28,2,59,59],[2013,4,27,23,59,59],
          '2012090204:00:00','2012090201:00:00','2013042802:59:59','2013042723:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,28,3,0,0],[2013,4,27,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2013,9,8,3,59,59],[2013,9,7,23,59,59],
          '2013042803:00:00','2013042723:00:00','2013090803:59:59','2013090723:59:59' ],
        [ [2013,9,8,4,0,0],[2013,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2014,4,27,2,59,59],[2014,4,26,23,59,59],
          '2013090804:00:00','2013090801:00:00','2014042702:59:59','2014042623:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,27,3,0,0],[2014,4,26,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2014,9,7,3,59,59],[2014,9,6,23,59,59],
          '2014042703:00:00','2014042623:00:00','2014090703:59:59','2014090623:59:59' ],
        [ [2014,9,7,4,0,0],[2014,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2016,5,15,2,59,59],[2016,5,14,23,59,59],
          '2014090704:00:00','2014090701:00:00','2016051502:59:59','2016051423:59:59' ],
     ],
   2016 =>
     [
        [ [2016,5,15,3,0,0],[2016,5,14,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2016,8,14,3,59,59],[2016,8,13,23,59,59],
          '2016051503:00:00','2016051423:00:00','2016081403:59:59','2016081323:59:59' ],
        [ [2016,8,14,4,0,0],[2016,8,14,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2017,5,14,2,59,59],[2017,5,13,23,59,59],
          '2016081404:00:00','2016081401:00:00','2017051402:59:59','2017051323:59:59' ],
     ],
   2017 =>
     [
        [ [2017,5,14,3,0,0],[2017,5,13,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2017,8,13,3,59,59],[2017,8,12,23,59,59],
          '2017051403:00:00','2017051323:00:00','2017081303:59:59','2017081223:59:59' ],
        [ [2017,8,13,4,0,0],[2017,8,13,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2018,5,13,2,59,59],[2018,5,12,23,59,59],
          '2017081304:00:00','2017081301:00:00','2018051302:59:59','2018051223:59:59' ],
     ],
   2018 =>
     [
        [ [2018,5,13,3,0,0],[2018,5,12,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2018,8,12,3,59,59],[2018,8,11,23,59,59],
          '2018051303:00:00','2018051223:00:00','2018081203:59:59','2018081123:59:59' ],
        [ [2018,8,12,4,0,0],[2018,8,12,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2019,4,7,2,59,59],[2019,4,6,23,59,59],
          '2018081204:00:00','2018081201:00:00','2019040702:59:59','2019040623:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,7,3,0,0],[2019,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2019,9,8,3,59,59],[2019,9,7,23,59,59],
          '2019040703:00:00','2019040623:00:00','2019090803:59:59','2019090723:59:59' ],
        [ [2019,9,8,4,0,0],[2019,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2020,4,5,2,59,59],[2020,4,4,23,59,59],
          '2019090804:00:00','2019090801:00:00','2020040502:59:59','2020040423:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,5,3,0,0],[2020,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2020,9,6,3,59,59],[2020,9,5,23,59,59],
          '2020040503:00:00','2020040423:00:00','2020090603:59:59','2020090523:59:59' ],
        [ [2020,9,6,4,0,0],[2020,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2021,4,4,2,59,59],[2021,4,3,23,59,59],
          '2020090604:00:00','2020090601:00:00','2021040402:59:59','2021040323:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,4,3,0,0],[2021,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2021,9,5,3,59,59],[2021,9,4,23,59,59],
          '2021040403:00:00','2021040323:00:00','2021090503:59:59','2021090423:59:59' ],
        [ [2021,9,5,4,0,0],[2021,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2022,4,3,2,59,59],[2022,4,2,23,59,59],
          '2021090504:00:00','2021090501:00:00','2022040302:59:59','2022040223:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,3,3,0,0],[2022,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2022,9,4,3,59,59],[2022,9,3,23,59,59],
          '2022040303:00:00','2022040223:00:00','2022090403:59:59','2022090323:59:59' ],
        [ [2022,9,4,4,0,0],[2022,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2023,4,2,2,59,59],[2023,4,1,23,59,59],
          '2022090404:00:00','2022090401:00:00','2023040202:59:59','2023040123:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,2,3,0,0],[2023,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2023,9,3,3,59,59],[2023,9,2,23,59,59],
          '2023040203:00:00','2023040123:00:00','2023090303:59:59','2023090223:59:59' ],
        [ [2023,9,3,4,0,0],[2023,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2024,4,7,2,59,59],[2024,4,6,23,59,59],
          '2023090304:00:00','2023090301:00:00','2024040702:59:59','2024040623:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,7,3,0,0],[2024,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2024,9,8,3,59,59],[2024,9,7,23,59,59],
          '2024040703:00:00','2024040623:00:00','2024090803:59:59','2024090723:59:59' ],
        [ [2024,9,8,4,0,0],[2024,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2025,4,6,2,59,59],[2025,4,5,23,59,59],
          '2024090804:00:00','2024090801:00:00','2025040602:59:59','2025040523:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,6,3,0,0],[2025,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2025,9,7,3,59,59],[2025,9,6,23,59,59],
          '2025040603:00:00','2025040523:00:00','2025090703:59:59','2025090623:59:59' ],
        [ [2025,9,7,4,0,0],[2025,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2026,4,5,2,59,59],[2026,4,4,23,59,59],
          '2025090704:00:00','2025090701:00:00','2026040502:59:59','2026040423:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,5,3,0,0],[2026,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2026,9,6,3,59,59],[2026,9,5,23,59,59],
          '2026040503:00:00','2026040423:00:00','2026090603:59:59','2026090523:59:59' ],
        [ [2026,9,6,4,0,0],[2026,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2027,4,4,2,59,59],[2027,4,3,23,59,59],
          '2026090604:00:00','2026090601:00:00','2027040402:59:59','2027040323:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,4,3,0,0],[2027,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2027,9,5,3,59,59],[2027,9,4,23,59,59],
          '2027040403:00:00','2027040323:00:00','2027090503:59:59','2027090423:59:59' ],
        [ [2027,9,5,4,0,0],[2027,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2028,4,2,2,59,59],[2028,4,1,23,59,59],
          '2027090504:00:00','2027090501:00:00','2028040202:59:59','2028040123:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,2,3,0,0],[2028,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2028,9,3,3,59,59],[2028,9,2,23,59,59],
          '2028040203:00:00','2028040123:00:00','2028090303:59:59','2028090223:59:59' ],
        [ [2028,9,3,4,0,0],[2028,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2029,4,8,2,59,59],[2029,4,7,23,59,59],
          '2028090304:00:00','2028090301:00:00','2029040802:59:59','2029040723:59:59' ],
     ],
   2029 =>
     [
        [ [2029,4,8,3,0,0],[2029,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2029,9,2,3,59,59],[2029,9,1,23,59,59],
          '2029040803:00:00','2029040723:00:00','2029090203:59:59','2029090123:59:59' ],
        [ [2029,9,2,4,0,0],[2029,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2030,4,7,2,59,59],[2030,4,6,23,59,59],
          '2029090204:00:00','2029090201:00:00','2030040702:59:59','2030040623:59:59' ],
     ],
   2030 =>
     [
        [ [2030,4,7,3,0,0],[2030,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2030,9,8,3,59,59],[2030,9,7,23,59,59],
          '2030040703:00:00','2030040623:00:00','2030090803:59:59','2030090723:59:59' ],
        [ [2030,9,8,4,0,0],[2030,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2031,4,6,2,59,59],[2031,4,5,23,59,59],
          '2030090804:00:00','2030090801:00:00','2031040602:59:59','2031040523:59:59' ],
     ],
   2031 =>
     [
        [ [2031,4,6,3,0,0],[2031,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2031,9,7,3,59,59],[2031,9,6,23,59,59],
          '2031040603:00:00','2031040523:00:00','2031090703:59:59','2031090623:59:59' ],
        [ [2031,9,7,4,0,0],[2031,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2032,4,4,2,59,59],[2032,4,3,23,59,59],
          '2031090704:00:00','2031090701:00:00','2032040402:59:59','2032040323:59:59' ],
     ],
   2032 =>
     [
        [ [2032,4,4,3,0,0],[2032,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2032,9,5,3,59,59],[2032,9,4,23,59,59],
          '2032040403:00:00','2032040323:00:00','2032090503:59:59','2032090423:59:59' ],
        [ [2032,9,5,4,0,0],[2032,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2033,4,3,2,59,59],[2033,4,2,23,59,59],
          '2032090504:00:00','2032090501:00:00','2033040302:59:59','2033040223:59:59' ],
     ],
   2033 =>
     [
        [ [2033,4,3,3,0,0],[2033,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2033,9,4,3,59,59],[2033,9,3,23,59,59],
          '2033040303:00:00','2033040223:00:00','2033090403:59:59','2033090323:59:59' ],
        [ [2033,9,4,4,0,0],[2033,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2034,4,2,2,59,59],[2034,4,1,23,59,59],
          '2033090404:00:00','2033090401:00:00','2034040202:59:59','2034040123:59:59' ],
     ],
   2034 =>
     [
        [ [2034,4,2,3,0,0],[2034,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2034,9,3,3,59,59],[2034,9,2,23,59,59],
          '2034040203:00:00','2034040123:00:00','2034090303:59:59','2034090223:59:59' ],
        [ [2034,9,3,4,0,0],[2034,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2035,4,8,2,59,59],[2035,4,7,23,59,59],
          '2034090304:00:00','2034090301:00:00','2035040802:59:59','2035040723:59:59' ],
     ],
   2035 =>
     [
        [ [2035,4,8,3,0,0],[2035,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2035,9,2,3,59,59],[2035,9,1,23,59,59],
          '2035040803:00:00','2035040723:00:00','2035090203:59:59','2035090123:59:59' ],
        [ [2035,9,2,4,0,0],[2035,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2036,4,6,2,59,59],[2036,4,5,23,59,59],
          '2035090204:00:00','2035090201:00:00','2036040602:59:59','2036040523:59:59' ],
     ],
   2036 =>
     [
        [ [2036,4,6,3,0,0],[2036,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2036,9,7,3,59,59],[2036,9,6,23,59,59],
          '2036040603:00:00','2036040523:00:00','2036090703:59:59','2036090623:59:59' ],
        [ [2036,9,7,4,0,0],[2036,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2037,4,5,2,59,59],[2037,4,4,23,59,59],
          '2036090704:00:00','2036090701:00:00','2037040502:59:59','2037040423:59:59' ],
     ],
   2037 =>
     [
        [ [2037,4,5,3,0,0],[2037,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2037,9,6,3,59,59],[2037,9,5,23,59,59],
          '2037040503:00:00','2037040423:00:00','2037090603:59:59','2037090523:59:59' ],
        [ [2037,9,6,4,0,0],[2037,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2038,4,4,2,59,59],[2038,4,3,23,59,59],
          '2037090604:00:00','2037090601:00:00','2038040402:59:59','2038040323:59:59' ],
     ],
   2038 =>
     [
        [ [2038,4,4,3,0,0],[2038,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2038,9,5,3,59,59],[2038,9,4,23,59,59],
          '2038040403:00:00','2038040323:00:00','2038090503:59:59','2038090423:59:59' ],
        [ [2038,9,5,4,0,0],[2038,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2039,4,3,2,59,59],[2039,4,2,23,59,59],
          '2038090504:00:00','2038090501:00:00','2039040302:59:59','2039040223:59:59' ],
     ],
   2039 =>
     [
        [ [2039,4,3,3,0,0],[2039,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2039,9,4,3,59,59],[2039,9,3,23,59,59],
          '2039040303:00:00','2039040223:00:00','2039090403:59:59','2039090323:59:59' ],
        [ [2039,9,4,4,0,0],[2039,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2040,4,8,2,59,59],[2040,4,7,23,59,59],
          '2039090404:00:00','2039090401:00:00','2040040802:59:59','2040040723:59:59' ],
     ],
   2040 =>
     [
        [ [2040,4,8,3,0,0],[2040,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2040,9,2,3,59,59],[2040,9,1,23,59,59],
          '2040040803:00:00','2040040723:00:00','2040090203:59:59','2040090123:59:59' ],
        [ [2040,9,2,4,0,0],[2040,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2041,4,7,2,59,59],[2041,4,6,23,59,59],
          '2040090204:00:00','2040090201:00:00','2041040702:59:59','2041040623:59:59' ],
     ],
   2041 =>
     [
        [ [2041,4,7,3,0,0],[2041,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2041,9,8,3,59,59],[2041,9,7,23,59,59],
          '2041040703:00:00','2041040623:00:00','2041090803:59:59','2041090723:59:59' ],
        [ [2041,9,8,4,0,0],[2041,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2042,4,6,2,59,59],[2042,4,5,23,59,59],
          '2041090804:00:00','2041090801:00:00','2042040602:59:59','2042040523:59:59' ],
     ],
   2042 =>
     [
        [ [2042,4,6,3,0,0],[2042,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2042,9,7,3,59,59],[2042,9,6,23,59,59],
          '2042040603:00:00','2042040523:00:00','2042090703:59:59','2042090623:59:59' ],
        [ [2042,9,7,4,0,0],[2042,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2043,4,5,2,59,59],[2043,4,4,23,59,59],
          '2042090704:00:00','2042090701:00:00','2043040502:59:59','2043040423:59:59' ],
     ],
   2043 =>
     [
        [ [2043,4,5,3,0,0],[2043,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2043,9,6,3,59,59],[2043,9,5,23,59,59],
          '2043040503:00:00','2043040423:00:00','2043090603:59:59','2043090523:59:59' ],
        [ [2043,9,6,4,0,0],[2043,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2044,4,3,2,59,59],[2044,4,2,23,59,59],
          '2043090604:00:00','2043090601:00:00','2044040302:59:59','2044040223:59:59' ],
     ],
   2044 =>
     [
        [ [2044,4,3,3,0,0],[2044,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2044,9,4,3,59,59],[2044,9,3,23,59,59],
          '2044040303:00:00','2044040223:00:00','2044090403:59:59','2044090323:59:59' ],
        [ [2044,9,4,4,0,0],[2044,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2045,4,2,2,59,59],[2045,4,1,23,59,59],
          '2044090404:00:00','2044090401:00:00','2045040202:59:59','2045040123:59:59' ],
     ],
   2045 =>
     [
        [ [2045,4,2,3,0,0],[2045,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2045,9,3,3,59,59],[2045,9,2,23,59,59],
          '2045040203:00:00','2045040123:00:00','2045090303:59:59','2045090223:59:59' ],
        [ [2045,9,3,4,0,0],[2045,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2046,4,8,2,59,59],[2046,4,7,23,59,59],
          '2045090304:00:00','2045090301:00:00','2046040802:59:59','2046040723:59:59' ],
     ],
   2046 =>
     [
        [ [2046,4,8,3,0,0],[2046,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2046,9,2,3,59,59],[2046,9,1,23,59,59],
          '2046040803:00:00','2046040723:00:00','2046090203:59:59','2046090123:59:59' ],
        [ [2046,9,2,4,0,0],[2046,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2047,4,7,2,59,59],[2047,4,6,23,59,59],
          '2046090204:00:00','2046090201:00:00','2047040702:59:59','2047040623:59:59' ],
     ],
   2047 =>
     [
        [ [2047,4,7,3,0,0],[2047,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2047,9,8,3,59,59],[2047,9,7,23,59,59],
          '2047040703:00:00','2047040623:00:00','2047090803:59:59','2047090723:59:59' ],
        [ [2047,9,8,4,0,0],[2047,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2048,4,5,2,59,59],[2048,4,4,23,59,59],
          '2047090804:00:00','2047090801:00:00','2048040502:59:59','2048040423:59:59' ],
     ],
   2048 =>
     [
        [ [2048,4,5,3,0,0],[2048,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2048,9,6,3,59,59],[2048,9,5,23,59,59],
          '2048040503:00:00','2048040423:00:00','2048090603:59:59','2048090523:59:59' ],
        [ [2048,9,6,4,0,0],[2048,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2049,4,4,2,59,59],[2049,4,3,23,59,59],
          '2048090604:00:00','2048090601:00:00','2049040402:59:59','2049040323:59:59' ],
     ],
   2049 =>
     [
        [ [2049,4,4,3,0,0],[2049,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2049,9,5,3,59,59],[2049,9,4,23,59,59],
          '2049040403:00:00','2049040323:00:00','2049090503:59:59','2049090423:59:59' ],
        [ [2049,9,5,4,0,0],[2049,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2050,4,3,2,59,59],[2050,4,2,23,59,59],
          '2049090504:00:00','2049090501:00:00','2050040302:59:59','2050040223:59:59' ],
     ],
   2050 =>
     [
        [ [2050,4,3,3,0,0],[2050,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2050,9,4,3,59,59],[2050,9,3,23,59,59],
          '2050040303:00:00','2050040223:00:00','2050090403:59:59','2050090323:59:59' ],
        [ [2050,9,4,4,0,0],[2050,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2051,4,2,2,59,59],[2051,4,1,23,59,59],
          '2050090404:00:00','2050090401:00:00','2051040202:59:59','2051040123:59:59' ],
     ],
   2051 =>
     [
        [ [2051,4,2,3,0,0],[2051,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2051,9,3,3,59,59],[2051,9,2,23,59,59],
          '2051040203:00:00','2051040123:00:00','2051090303:59:59','2051090223:59:59' ],
        [ [2051,9,3,4,0,0],[2051,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2052,4,7,2,59,59],[2052,4,6,23,59,59],
          '2051090304:00:00','2051090301:00:00','2052040702:59:59','2052040623:59:59' ],
     ],
   2052 =>
     [
        [ [2052,4,7,3,0,0],[2052,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2052,9,8,3,59,59],[2052,9,7,23,59,59],
          '2052040703:00:00','2052040623:00:00','2052090803:59:59','2052090723:59:59' ],
        [ [2052,9,8,4,0,0],[2052,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2053,4,6,2,59,59],[2053,4,5,23,59,59],
          '2052090804:00:00','2052090801:00:00','2053040602:59:59','2053040523:59:59' ],
     ],
   2053 =>
     [
        [ [2053,4,6,3,0,0],[2053,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2053,9,7,3,59,59],[2053,9,6,23,59,59],
          '2053040603:00:00','2053040523:00:00','2053090703:59:59','2053090623:59:59' ],
        [ [2053,9,7,4,0,0],[2053,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2054,4,5,2,59,59],[2054,4,4,23,59,59],
          '2053090704:00:00','2053090701:00:00','2054040502:59:59','2054040423:59:59' ],
     ],
   2054 =>
     [
        [ [2054,4,5,3,0,0],[2054,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2054,9,6,3,59,59],[2054,9,5,23,59,59],
          '2054040503:00:00','2054040423:00:00','2054090603:59:59','2054090523:59:59' ],
        [ [2054,9,6,4,0,0],[2054,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2055,4,4,2,59,59],[2055,4,3,23,59,59],
          '2054090604:00:00','2054090601:00:00','2055040402:59:59','2055040323:59:59' ],
     ],
   2055 =>
     [
        [ [2055,4,4,3,0,0],[2055,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2055,9,5,3,59,59],[2055,9,4,23,59,59],
          '2055040403:00:00','2055040323:00:00','2055090503:59:59','2055090423:59:59' ],
        [ [2055,9,5,4,0,0],[2055,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2056,4,2,2,59,59],[2056,4,1,23,59,59],
          '2055090504:00:00','2055090501:00:00','2056040202:59:59','2056040123:59:59' ],
     ],
   2056 =>
     [
        [ [2056,4,2,3,0,0],[2056,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2056,9,3,3,59,59],[2056,9,2,23,59,59],
          '2056040203:00:00','2056040123:00:00','2056090303:59:59','2056090223:59:59' ],
        [ [2056,9,3,4,0,0],[2056,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2057,4,8,2,59,59],[2057,4,7,23,59,59],
          '2056090304:00:00','2056090301:00:00','2057040802:59:59','2057040723:59:59' ],
     ],
   2057 =>
     [
        [ [2057,4,8,3,0,0],[2057,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2057,9,2,3,59,59],[2057,9,1,23,59,59],
          '2057040803:00:00','2057040723:00:00','2057090203:59:59','2057090123:59:59' ],
        [ [2057,9,2,4,0,0],[2057,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2058,4,7,2,59,59],[2058,4,6,23,59,59],
          '2057090204:00:00','2057090201:00:00','2058040702:59:59','2058040623:59:59' ],
     ],
   2058 =>
     [
        [ [2058,4,7,3,0,0],[2058,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2058,9,8,3,59,59],[2058,9,7,23,59,59],
          '2058040703:00:00','2058040623:00:00','2058090803:59:59','2058090723:59:59' ],
        [ [2058,9,8,4,0,0],[2058,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2059,4,6,2,59,59],[2059,4,5,23,59,59],
          '2058090804:00:00','2058090801:00:00','2059040602:59:59','2059040523:59:59' ],
     ],
   2059 =>
     [
        [ [2059,4,6,3,0,0],[2059,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2059,9,7,3,59,59],[2059,9,6,23,59,59],
          '2059040603:00:00','2059040523:00:00','2059090703:59:59','2059090623:59:59' ],
        [ [2059,9,7,4,0,0],[2059,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2060,4,4,2,59,59],[2060,4,3,23,59,59],
          '2059090704:00:00','2059090701:00:00','2060040402:59:59','2060040323:59:59' ],
     ],
   2060 =>
     [
        [ [2060,4,4,3,0,0],[2060,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2060,9,5,3,59,59],[2060,9,4,23,59,59],
          '2060040403:00:00','2060040323:00:00','2060090503:59:59','2060090423:59:59' ],
        [ [2060,9,5,4,0,0],[2060,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2061,4,3,2,59,59],[2061,4,2,23,59,59],
          '2060090504:00:00','2060090501:00:00','2061040302:59:59','2061040223:59:59' ],
     ],
   2061 =>
     [
        [ [2061,4,3,3,0,0],[2061,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2061,9,4,3,59,59],[2061,9,3,23,59,59],
          '2061040303:00:00','2061040223:00:00','2061090403:59:59','2061090323:59:59' ],
        [ [2061,9,4,4,0,0],[2061,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2062,4,2,2,59,59],[2062,4,1,23,59,59],
          '2061090404:00:00','2061090401:00:00','2062040202:59:59','2062040123:59:59' ],
     ],
   2062 =>
     [
        [ [2062,4,2,3,0,0],[2062,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2062,9,3,3,59,59],[2062,9,2,23,59,59],
          '2062040203:00:00','2062040123:00:00','2062090303:59:59','2062090223:59:59' ],
        [ [2062,9,3,4,0,0],[2062,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2063,4,8,2,59,59],[2063,4,7,23,59,59],
          '2062090304:00:00','2062090301:00:00','2063040802:59:59','2063040723:59:59' ],
     ],
   2063 =>
     [
        [ [2063,4,8,3,0,0],[2063,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2063,9,2,3,59,59],[2063,9,1,23,59,59],
          '2063040803:00:00','2063040723:00:00','2063090203:59:59','2063090123:59:59' ],
        [ [2063,9,2,4,0,0],[2063,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2064,4,6,2,59,59],[2064,4,5,23,59,59],
          '2063090204:00:00','2063090201:00:00','2064040602:59:59','2064040523:59:59' ],
     ],
   2064 =>
     [
        [ [2064,4,6,3,0,0],[2064,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2064,9,7,3,59,59],[2064,9,6,23,59,59],
          '2064040603:00:00','2064040523:00:00','2064090703:59:59','2064090623:59:59' ],
        [ [2064,9,7,4,0,0],[2064,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2065,4,5,2,59,59],[2065,4,4,23,59,59],
          '2064090704:00:00','2064090701:00:00','2065040502:59:59','2065040423:59:59' ],
     ],
   2065 =>
     [
        [ [2065,4,5,3,0,0],[2065,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2065,9,6,3,59,59],[2065,9,5,23,59,59],
          '2065040503:00:00','2065040423:00:00','2065090603:59:59','2065090523:59:59' ],
        [ [2065,9,6,4,0,0],[2065,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2066,4,4,2,59,59],[2066,4,3,23,59,59],
          '2065090604:00:00','2065090601:00:00','2066040402:59:59','2066040323:59:59' ],
     ],
   2066 =>
     [
        [ [2066,4,4,3,0,0],[2066,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2066,9,5,3,59,59],[2066,9,4,23,59,59],
          '2066040403:00:00','2066040323:00:00','2066090503:59:59','2066090423:59:59' ],
        [ [2066,9,5,4,0,0],[2066,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2067,4,3,2,59,59],[2067,4,2,23,59,59],
          '2066090504:00:00','2066090501:00:00','2067040302:59:59','2067040223:59:59' ],
     ],
   2067 =>
     [
        [ [2067,4,3,3,0,0],[2067,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2067,9,4,3,59,59],[2067,9,3,23,59,59],
          '2067040303:00:00','2067040223:00:00','2067090403:59:59','2067090323:59:59' ],
        [ [2067,9,4,4,0,0],[2067,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2068,4,8,2,59,59],[2068,4,7,23,59,59],
          '2067090404:00:00','2067090401:00:00','2068040802:59:59','2068040723:59:59' ],
     ],
   2068 =>
     [
        [ [2068,4,8,3,0,0],[2068,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2068,9,2,3,59,59],[2068,9,1,23,59,59],
          '2068040803:00:00','2068040723:00:00','2068090203:59:59','2068090123:59:59' ],
        [ [2068,9,2,4,0,0],[2068,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2069,4,7,2,59,59],[2069,4,6,23,59,59],
          '2068090204:00:00','2068090201:00:00','2069040702:59:59','2069040623:59:59' ],
     ],
   2069 =>
     [
        [ [2069,4,7,3,0,0],[2069,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2069,9,8,3,59,59],[2069,9,7,23,59,59],
          '2069040703:00:00','2069040623:00:00','2069090803:59:59','2069090723:59:59' ],
        [ [2069,9,8,4,0,0],[2069,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2070,4,6,2,59,59],[2070,4,5,23,59,59],
          '2069090804:00:00','2069090801:00:00','2070040602:59:59','2070040523:59:59' ],
     ],
   2070 =>
     [
        [ [2070,4,6,3,0,0],[2070,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2070,9,7,3,59,59],[2070,9,6,23,59,59],
          '2070040603:00:00','2070040523:00:00','2070090703:59:59','2070090623:59:59' ],
        [ [2070,9,7,4,0,0],[2070,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2071,4,5,2,59,59],[2071,4,4,23,59,59],
          '2070090704:00:00','2070090701:00:00','2071040502:59:59','2071040423:59:59' ],
     ],
   2071 =>
     [
        [ [2071,4,5,3,0,0],[2071,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2071,9,6,3,59,59],[2071,9,5,23,59,59],
          '2071040503:00:00','2071040423:00:00','2071090603:59:59','2071090523:59:59' ],
        [ [2071,9,6,4,0,0],[2071,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2072,4,3,2,59,59],[2072,4,2,23,59,59],
          '2071090604:00:00','2071090601:00:00','2072040302:59:59','2072040223:59:59' ],
     ],
   2072 =>
     [
        [ [2072,4,3,3,0,0],[2072,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2072,9,4,3,59,59],[2072,9,3,23,59,59],
          '2072040303:00:00','2072040223:00:00','2072090403:59:59','2072090323:59:59' ],
        [ [2072,9,4,4,0,0],[2072,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2073,4,2,2,59,59],[2073,4,1,23,59,59],
          '2072090404:00:00','2072090401:00:00','2073040202:59:59','2073040123:59:59' ],
     ],
   2073 =>
     [
        [ [2073,4,2,3,0,0],[2073,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2073,9,3,3,59,59],[2073,9,2,23,59,59],
          '2073040203:00:00','2073040123:00:00','2073090303:59:59','2073090223:59:59' ],
        [ [2073,9,3,4,0,0],[2073,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2074,4,8,2,59,59],[2074,4,7,23,59,59],
          '2073090304:00:00','2073090301:00:00','2074040802:59:59','2074040723:59:59' ],
     ],
   2074 =>
     [
        [ [2074,4,8,3,0,0],[2074,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2074,9,2,3,59,59],[2074,9,1,23,59,59],
          '2074040803:00:00','2074040723:00:00','2074090203:59:59','2074090123:59:59' ],
        [ [2074,9,2,4,0,0],[2074,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2075,4,7,2,59,59],[2075,4,6,23,59,59],
          '2074090204:00:00','2074090201:00:00','2075040702:59:59','2075040623:59:59' ],
     ],
   2075 =>
     [
        [ [2075,4,7,3,0,0],[2075,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2075,9,8,3,59,59],[2075,9,7,23,59,59],
          '2075040703:00:00','2075040623:00:00','2075090803:59:59','2075090723:59:59' ],
        [ [2075,9,8,4,0,0],[2075,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2076,4,5,2,59,59],[2076,4,4,23,59,59],
          '2075090804:00:00','2075090801:00:00','2076040502:59:59','2076040423:59:59' ],
     ],
   2076 =>
     [
        [ [2076,4,5,3,0,0],[2076,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2076,9,6,3,59,59],[2076,9,5,23,59,59],
          '2076040503:00:00','2076040423:00:00','2076090603:59:59','2076090523:59:59' ],
        [ [2076,9,6,4,0,0],[2076,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2077,4,4,2,59,59],[2077,4,3,23,59,59],
          '2076090604:00:00','2076090601:00:00','2077040402:59:59','2077040323:59:59' ],
     ],
   2077 =>
     [
        [ [2077,4,4,3,0,0],[2077,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2077,9,5,3,59,59],[2077,9,4,23,59,59],
          '2077040403:00:00','2077040323:00:00','2077090503:59:59','2077090423:59:59' ],
        [ [2077,9,5,4,0,0],[2077,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2078,4,3,2,59,59],[2078,4,2,23,59,59],
          '2077090504:00:00','2077090501:00:00','2078040302:59:59','2078040223:59:59' ],
     ],
   2078 =>
     [
        [ [2078,4,3,3,0,0],[2078,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2078,9,4,3,59,59],[2078,9,3,23,59,59],
          '2078040303:00:00','2078040223:00:00','2078090403:59:59','2078090323:59:59' ],
        [ [2078,9,4,4,0,0],[2078,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2079,4,2,2,59,59],[2079,4,1,23,59,59],
          '2078090404:00:00','2078090401:00:00','2079040202:59:59','2079040123:59:59' ],
     ],
   2079 =>
     [
        [ [2079,4,2,3,0,0],[2079,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2079,9,3,3,59,59],[2079,9,2,23,59,59],
          '2079040203:00:00','2079040123:00:00','2079090303:59:59','2079090223:59:59' ],
        [ [2079,9,3,4,0,0],[2079,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2080,4,7,2,59,59],[2080,4,6,23,59,59],
          '2079090304:00:00','2079090301:00:00','2080040702:59:59','2080040623:59:59' ],
     ],
   2080 =>
     [
        [ [2080,4,7,3,0,0],[2080,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2080,9,8,3,59,59],[2080,9,7,23,59,59],
          '2080040703:00:00','2080040623:00:00','2080090803:59:59','2080090723:59:59' ],
        [ [2080,9,8,4,0,0],[2080,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2081,4,6,2,59,59],[2081,4,5,23,59,59],
          '2080090804:00:00','2080090801:00:00','2081040602:59:59','2081040523:59:59' ],
     ],
   2081 =>
     [
        [ [2081,4,6,3,0,0],[2081,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2081,9,7,3,59,59],[2081,9,6,23,59,59],
          '2081040603:00:00','2081040523:00:00','2081090703:59:59','2081090623:59:59' ],
        [ [2081,9,7,4,0,0],[2081,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2082,4,5,2,59,59],[2082,4,4,23,59,59],
          '2081090704:00:00','2081090701:00:00','2082040502:59:59','2082040423:59:59' ],
     ],
   2082 =>
     [
        [ [2082,4,5,3,0,0],[2082,4,4,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2082,9,6,3,59,59],[2082,9,5,23,59,59],
          '2082040503:00:00','2082040423:00:00','2082090603:59:59','2082090523:59:59' ],
        [ [2082,9,6,4,0,0],[2082,9,6,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2083,4,4,2,59,59],[2083,4,3,23,59,59],
          '2082090604:00:00','2082090601:00:00','2083040402:59:59','2083040323:59:59' ],
     ],
   2083 =>
     [
        [ [2083,4,4,3,0,0],[2083,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2083,9,5,3,59,59],[2083,9,4,23,59,59],
          '2083040403:00:00','2083040323:00:00','2083090503:59:59','2083090423:59:59' ],
        [ [2083,9,5,4,0,0],[2083,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2084,4,2,2,59,59],[2084,4,1,23,59,59],
          '2083090504:00:00','2083090501:00:00','2084040202:59:59','2084040123:59:59' ],
     ],
   2084 =>
     [
        [ [2084,4,2,3,0,0],[2084,4,1,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2084,9,3,3,59,59],[2084,9,2,23,59,59],
          '2084040203:00:00','2084040123:00:00','2084090303:59:59','2084090223:59:59' ],
        [ [2084,9,3,4,0,0],[2084,9,3,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2085,4,8,2,59,59],[2085,4,7,23,59,59],
          '2084090304:00:00','2084090301:00:00','2085040802:59:59','2085040723:59:59' ],
     ],
   2085 =>
     [
        [ [2085,4,8,3,0,0],[2085,4,7,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2085,9,2,3,59,59],[2085,9,1,23,59,59],
          '2085040803:00:00','2085040723:00:00','2085090203:59:59','2085090123:59:59' ],
        [ [2085,9,2,4,0,0],[2085,9,2,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2086,4,7,2,59,59],[2086,4,6,23,59,59],
          '2085090204:00:00','2085090201:00:00','2086040702:59:59','2086040623:59:59' ],
     ],
   2086 =>
     [
        [ [2086,4,7,3,0,0],[2086,4,6,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2086,9,8,3,59,59],[2086,9,7,23,59,59],
          '2086040703:00:00','2086040623:00:00','2086090803:59:59','2086090723:59:59' ],
        [ [2086,9,8,4,0,0],[2086,9,8,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2087,4,6,2,59,59],[2087,4,5,23,59,59],
          '2086090804:00:00','2086090801:00:00','2087040602:59:59','2087040523:59:59' ],
     ],
   2087 =>
     [
        [ [2087,4,6,3,0,0],[2087,4,5,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2087,9,7,3,59,59],[2087,9,6,23,59,59],
          '2087040603:00:00','2087040523:00:00','2087090703:59:59','2087090623:59:59' ],
        [ [2087,9,7,4,0,0],[2087,9,7,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2088,4,4,2,59,59],[2088,4,3,23,59,59],
          '2087090704:00:00','2087090701:00:00','2088040402:59:59','2088040323:59:59' ],
     ],
   2088 =>
     [
        [ [2088,4,4,3,0,0],[2088,4,3,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2088,9,5,3,59,59],[2088,9,4,23,59,59],
          '2088040403:00:00','2088040323:00:00','2088090503:59:59','2088090423:59:59' ],
        [ [2088,9,5,4,0,0],[2088,9,5,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2089,4,3,2,59,59],[2089,4,2,23,59,59],
          '2088090504:00:00','2088090501:00:00','2089040302:59:59','2089040223:59:59' ],
     ],
   2089 =>
     [
        [ [2089,4,3,3,0,0],[2089,4,2,23,0,0],'-04:00:00',[-4,0,0],
          '-04',0,[2089,9,4,3,59,59],[2089,9,3,23,59,59],
          '2089040303:00:00','2089040223:00:00','2089090403:59:59','2089090323:59:59' ],
        [ [2089,9,4,4,0,0],[2089,9,4,1,0,0],'-03:00:00',[-3,0,0],
          '-03',1,[2090,4,2,2,59,59],[2090,4,1,23,59,59],
          '2089090404:00:00','2089090401:00:00','2090040202:59:59','2090040123:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-03:00:00',
                'stdoff' => '-04:00:00',
               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '2',
                         'type'    => 'u',
                         'time'    => '03:00:00',
                         'isdst'   => '0',
                         'abb'     => '-04',
                        },
                '09' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '2',
                         'type'    => 'u',
                         'time'    => '04:00:00',
                         'isdst'   => '1',
                         'abb'     => '-03',
                        },
               },
);

1;
