/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public abstract class AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpointBase.class);
    public static final String APP_INITIATED_FLOW = "APP_INITIATED_FLOW";
    protected final RealmModel realm;
    protected final EventBuilder event;
    protected AuthenticationManager authManager;
    protected final HttpHeaders headers;
    protected final HttpRequest httpRequest;
    protected final KeycloakSession session;
    protected final ClientConnection clientConnection;

    public AuthorizationEndpointBase(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.event = event;
        this.httpRequest = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    protected AuthenticationProcessor createProcessor(AuthenticationSessionModel authSession, String flowId, String flowPath) {
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowPath(flowPath).setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.httpRequest);
        authSession.setAuthNote("current.flow.path", flowPath);
        return processor;
    }

    protected Response handleBrowserAuthenticationRequest(AuthenticationSessionModel authSession, LoginProtocol protocol, boolean isPassive, boolean redirectToAuthentication) {
        AuthenticationFlowModel flow = this.getAuthenticationFlow(authSession);
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(authSession, flowId, "authenticate");
        this.event.detail("code_id", authSession.getParentSession().getId());
        if (isPassive) {
            try {
                Response challenge = processor.authenticateOnly();
                if (challenge != null) {
                    if ("true".equals(authSession.getAuthNote("forwarded.passive.login"))) {
                        RestartLoginCookie.setRestartCookie(this.session, authSession);
                        if (redirectToAuthentication) {
                            return processor.redirectToFlow();
                        }
                        return challenge;
                    }
                    return protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED, null);
                }
                AuthenticationManager.setClientScopesInSession(this.session, authSession);
                if (processor.nextRequiredAction() != null) {
                    return protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED, null);
                }
            }
            catch (Exception e) {
                return processor.handleBrowserException(e);
            }
            return processor.finishAuthentication(protocol);
        }
        try {
            RestartLoginCookie.setRestartCookie(this.session, authSession);
            if (redirectToAuthentication) {
                return processor.redirectToFlow();
            }
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    protected AuthenticationFlowModel getAuthenticationFlow(AuthenticationSessionModel authSession) {
        return AuthenticationFlowResolver.resolveBrowserFlow((AuthenticationSessionModel)authSession);
    }

    protected void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            this.event.error("ssl_required");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "httpsRequiredMessage", new Object[0]);
        }
    }

    protected void checkRealm() {
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "realmNotEnabledMessage", new Object[0]);
        }
    }

    protected AuthenticationSessionModel createAuthenticationSession(ClientModel client, String requestState) {
        AuthenticationSessionModel authSession;
        AuthenticationSessionManager manager = new AuthenticationSessionManager(this.session);
        RootAuthenticationSessionModel rootAuthSession = manager.getCurrentRootAuthenticationSession(this.realm);
        if (rootAuthSession != null) {
            authSession = rootAuthSession.createAuthenticationSession(client);
            logger.debugf("Sent request to authz endpoint. Root authentication session with ID '%s' exists. Client is '%s' . Created new authentication session with tab ID: %s", (Object)rootAuthSession.getId(), (Object)client.getClientId(), (Object)authSession.getTabId());
        } else {
            UserSessionModel userSession = manager.getUserSessionFromAuthenticationCookie(this.realm);
            if (userSession != null) {
                UserModel user = userSession.getUser();
                if (user != null && !user.isEnabled()) {
                    authSession = this.createNewAuthenticationSession(manager, client);
                    AuthenticationManager.backchannelLogout(this.session, userSession, true);
                } else {
                    String userSessionId = userSession.getId();
                    rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(this.realm, userSessionId);
                    if (rootAuthSession == null) {
                        rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(this.realm, userSessionId);
                    }
                    authSession = rootAuthSession.createAuthenticationSession(client);
                    manager.setAuthSessionCookie(rootAuthSession.getId());
                    manager.setAuthSessionIdHashCookie(rootAuthSession.getId());
                    logger.debugf("Sent request to authz endpoint. We don't have root authentication session with ID '%s' but we have userSession.Re-created root authentication session with same ID. Client is: %s . New authentication session tab ID: %s", (Object)userSessionId, (Object)client.getClientId(), (Object)authSession.getTabId());
                }
            } else {
                authSession = this.createNewAuthenticationSession(manager, client);
            }
        }
        this.session.getContext().setAuthenticationSession(authSession);
        ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession);
        return authSession;
    }

    private AuthenticationSessionModel createNewAuthenticationSession(AuthenticationSessionManager manager, ClientModel client) {
        RootAuthenticationSessionModel rootAuthSession = manager.createAuthenticationSession(this.realm, true);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        logger.debugf("Sent request to authz endpoint. Created new root authentication session with ID '%s' . Client: %s . New authentication session tab ID: %s", (Object)rootAuthSession.getId(), (Object)client.getClientId(), (Object)authSession.getTabId());
        return authSession;
    }
}

