/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

public class StringTokenIterator {
    private String text;
    private String dlms;
    private char delimiterChar;
    private String token;
    private int start;
    private int end;
    private boolean done;

    public StringTokenIterator(String string, String string2) {
        this.text = string;
        if (string2.length() == 1) {
            this.delimiterChar = string2.charAt(0);
        } else {
            this.dlms = string2;
        }
        this.setStart(0);
    }

    public String first() {
        this.setStart(0);
        return this.token;
    }

    public String current() {
        return this.token;
    }

    public int currentStart() {
        return this.start;
    }

    public int currentEnd() {
        return this.end;
    }

    public boolean isDone() {
        return this.done;
    }

    public String next() {
        if (this.hasNext()) {
            this.start = this.end + 1;
            this.end = this.nextDelimiter(this.start);
            this.token = this.text.substring(this.start, this.end);
        } else {
            this.start = this.end;
            this.token = null;
            this.done = true;
        }
        return this.token;
    }

    public boolean hasNext() {
        return this.end < this.text.length();
    }

    public StringTokenIterator setStart(int n) {
        if (n > this.text.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.start = n;
        this.end = this.nextDelimiter(this.start);
        this.token = this.text.substring(this.start, this.end);
        this.done = false;
        return this;
    }

    public StringTokenIterator setText(String string) {
        this.text = string;
        this.setStart(0);
        return this;
    }

    private int nextDelimiter(int n) {
        int n2 = this.text.length();
        if (this.dlms == null) {
            for (int i = n; i < n2; ++i) {
                if (this.text.charAt(i) != this.delimiterChar) continue;
                return i;
            }
        } else {
            int n3 = this.dlms.length();
            for (int i = n; i < n2; ++i) {
                char c = this.text.charAt(i);
                for (int j = 0; j < n3; ++j) {
                    if (c != this.dlms.charAt(j)) continue;
                    return i;
                }
            }
        }
        return n2;
    }
}

